/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.util;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.api.DatastoreMirrorsInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StretchedStorageResolver {
    private static final Log LOGGER = LogFactory.getLog(StretchedStorageResolver.class);
    private static final String LAYOUT_DATASTORES_RELATION = "layoutDatastores";
    private static final String DATASTORE_URL_PROPERTY = "summary.url";
    private static final String SYSTEM_DS_PROPERTY = "isSystemDatastore";
    private static final PropertyValue[] dummy = new PropertyValue[0];
    private static final ManagedObjectReference[] EMPTY_MORS = new ManagedObjectReference[0];
    private final DataService _dataService;

    public StretchedStorageResolver(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("Unable to instantiate " + StretchedStorageResolver.class.getName());
        }
        this._dataService = dataService;
    }

    public DatastoreMirrorsInfo[] getDatastoresInfoByVm(ManagedObjectReference vmRef) throws Exception {
        ArrayList<DatastoreMirrorsInfo> datastoresInfo = new ArrayList<DatastoreMirrorsInfo>();
        PropertyValue[] values = this.getVmDatastoreUrls(vmRef);
        if (values == null) {
            LOGGER.warn((Object)("Received no datastore urls for '" + vmRef.getValue() + "'."));
            return new DatastoreMirrorsInfo[0];
        }
        for (PropertyValue pv : values) {
            if (!(pv.value instanceof String) || !(pv.resourceObject instanceof ManagedObjectReference)) {
                LOGGER.warn((Object)("Bad data results - " + pv.value + ", " + pv.resourceObject));
                continue;
            }
            DatastoreMirrorsInfo datastoreInfo = new DatastoreMirrorsInfo();
            datastoreInfo.ref = (ManagedObjectReference)pv.resourceObject;
            datastoreInfo.url = (String)pv.value;
            datastoresInfo.add(datastoreInfo);
        }
        this.updateDatastoreMirrors(datastoresInfo);
        return datastoresInfo.toArray(new DatastoreMirrorsInfo[datastoresInfo.size()]);
    }

    void updateDatastoreMirrors(List<DatastoreMirrorsInfo> datastoreInfos) throws Exception {
        ResultItem[] datastores = this.getAllDatastores();
        for (DatastoreMirrorsInfo datastore : datastoreInfos) {
            Object[] mirrors = StretchedStorageResolver.extractMirrors(datastore, datastores);
            if (ArrayUtils.isEmpty((Object[])mirrors)) continue;
            datastore.mirrors = mirrors;
        }
    }

    ResultItem[] getAllDatastores() throws Exception {
        Constraint constraint = new Constraint();
        constraint.targetType = Datastore.class.getSimpleName();
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{DATASTORE_URL_PROPERTY});
        query.name = "retrieveAllDatastoresGlobally";
        ResultItem[] datastores = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query).items;
        return datastores;
    }

    PropertyValue[] getVmDatastoreUrls(ManagedObjectReference vmRef) throws Exception {
        ResultItem[] items;
        String[] props = new String[]{DATASTORE_URL_PROPERTY};
        PropertyConstraint pc = QueryUtil.createPropertyConstraint((String)Datastore.class.getSimpleName(), (String)SYSTEM_DS_PROPERTY, (Comparator)Comparator.EQUALS, (Object)false);
        Constraint c = QueryUtil.createConstraintForRelationship((Object)vmRef, (String)LAYOUT_DATASTORES_RELATION, (String)Datastore.class.getSimpleName());
        CompositeConstraint cc = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{c, pc}, (Conjoiner)Conjoiner.AND);
        QuerySpec spec = QueryUtil.buildQuerySpec((Constraint)cc, (String[])props);
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)spec);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        return result.toArray(new PropertyValue[result.size()]);
    }

    static ManagedObjectReference[] extractMirrors(DatastoreMirrorsInfo datastore, ResultItem[] candidateMirrors) {
        Object[] mirrors = EMPTY_MORS;
        if (datastore == null || datastore.ref == null) {
            LOGGER.warn((Object)"DatastoreRef is null! Return an empty array.");
            return mirrors;
        }
        if (ArrayUtils.isEmpty((Object[])candidateMirrors)) {
            LOGGER.warn((Object)"No candidate mirrors provided! Return an empty array.");
            return mirrors;
        }
        for (ResultItem datastoreData : candidateMirrors) {
            if (ArrayUtils.isEmpty((Object[])datastoreData.properties)) {
                LOGGER.warn((Object)("Empty datastore props array - " + Arrays.toString(datastoreData.properties)));
                continue;
            }
            PropertyValue pv = datastoreData.properties[0];
            if (!(pv.resourceObject instanceof ManagedObjectReference) || !(pv.value instanceof String)) {
                LOGGER.warn((Object)("Bad datastore data - " + pv.value + ", " + pv.resourceObject));
                continue;
            }
            ManagedObjectReference mirrorRef = (ManagedObjectReference)pv.resourceObject;
            String mirrorUrl = (String)pv.value;
            if (!datastore.url.equals(mirrorUrl) || ManagedObjectUtil.areEqual((ManagedObjectReference)datastore.ref, (ManagedObjectReference)mirrorRef).booleanValue()) continue;
            mirrors = (ManagedObjectReference[])ArrayUtils.add((Object[])mirrors, (Object)mirrorRef);
        }
        return mirrors;
    }
}

