/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.util.dataservice;

import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.QueryUtil;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class QuerySpecSplitProcessor<T> {
    public abstract QuerySpec[] buildSpecs() throws Exception;

    public abstract T processResults(ResultSet[] var1) throws Exception;

    public static ResultSet[] getQueryResults(DataService dataService, QuerySpec[] querySpecs) throws Exception {
        if (querySpecs == null || querySpecs.length == 0) {
            return new ResultSet[0];
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs;
        Response response = dataService.getData(requestSpec);
        ResultSet[] queryResults = response.resultSet;
        if (queryResults == null || queryResults.length == 0 || queryResults.length != querySpecs.length || Arrays.asList(queryResults).contains(null)) {
            throw new Exception(Utils.getLocalizedString((String)"error.emptyResult"));
        }
        return queryResults;
    }

    public static QuerySpec getQuerySpecForProperties(Object obj, String[] properties) throws Exception {
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Object[])new Object[]{obj}, (String[])properties, null);
        querySpec.name = QueryUtil.getReferenceUid((Object)obj) + ".properties";
        return querySpec;
    }

    public static PropertyValue[] getPropertiesFromResultSet(ResultSet resultSet) throws Exception {
        ResultItem[] items;
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet != null && resultSet.error != null) {
            throw resultSet.error;
        }
        return result.toArray(new PropertyValue[result.size()]);
    }
}

