/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.google.common.html.HtmlEscapers;
import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.impl.EntityEventArgumentWrapper;
import com.vmware.opsmgmt.client.event.impl.EventWrapper;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParser;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vim.event.VmBeingClonedEvent;
import com.vmware.vim.binding.vim.event.VmBeingRelocatedEvent;
import com.vmware.vim.binding.vim.event.VmClonedEvent;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vise.core.model.event.ClientEventDetailInfo;
import com.vmware.vise.core.model.event.ClientEventEntityInfo;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class EventBuilder {
    protected static final String CATEGORY_FORMAT = "%s.category";
    protected static final String DESCRIPTION_FORMAT = "%s.description";
    protected static final String COMPUTE_RESOURCE_FORMAT = "%s.formatOnComputeResource";
    protected static final String DATACENTER_FORMAT = "%s.formatOnDatacenter";
    protected static final String HOST_FORMAT = "%s.formatOnHost";
    protected static final String VM_FORMAT = "%s.formatOnVm";
    protected static final String FULL_FORMAT = "%s.fullFormat";
    protected static final String COMPUTERESOURCE_ENTITY_KEY = "computeResource";
    protected static final String DC_ENTITY_KEY = "datacenter";
    protected static final String DS_ENTITY_KEY = "ds";
    protected static final String DVS_ENTITY_KEY = "dvs";
    protected static final String HOST_ENTITY_KEY = "host";
    protected static final String DEST_HOST_ENTITY_KEY = "destHost";
    protected static final String DEST_DATACENTER_ENTITY_KEY = "destDatacenter";
    protected static final String DEST_DATASTORE_ENTITY_KEY = "destDatastore";
    protected static final String SOURCE_VM_ENTITY_KEY = "sourceVm";
    protected static final String NET_ENTITY_KEY = "net";
    protected static final String VM_ENTITY_KEY = "vm";
    protected static final Set<String> REMOVAL_EVENT_TYPES = new HashSet<String>();
    private final ManagedEntityParentLocator _locator;
    private final Set<ManagedObjectReference> _existingMoRefs;
    private final Set<ManagedObjectReference> _removedMoRefs = new HashSet<ManagedObjectReference>();
    private final Map<ManagedObjectReference, ManagedObjectReference> _dvsMap;
    private ClientEventInfo _clientEvent;
    private Map<ManagedObjectReference, OperationResult> _parentInfos;
    private List<MethodFault> _allFaults;
    private Set<ManagedObjectReference> _uniqueTargetSet;

    public EventBuilder(ManagedEntityParentLocator locator, Map<ManagedObjectReference, OperationResult> parentInfos, Map<ManagedObjectReference, ManagedObjectReference> dvsMap, List<MethodFault> allFaults) {
        this._locator = locator;
        this._parentInfos = parentInfos;
        this._allFaults = allFaults;
        this._dvsMap = dvsMap;
        this._existingMoRefs = new HashSet<ManagedObjectReference>();
        this._uniqueTargetSet = new HashSet<ManagedObjectReference>();
    }

    public ClientEventInfo build(EventWrapper eventWrapper, String serverGuid) {
        VmClonedEvent clonedEvent;
        OperationResult postProcessTargetResult;
        this._clientEvent = new ClientEventInfo();
        this._clientEvent.serverGuid = serverGuid;
        this._clientEvent.serverEvent = eventWrapper.getServerEvent();
        Event serverEvent = eventWrapper.getServerEvent();
        this._clientEvent.serverEvent = serverEvent;
        this._clientEvent.chainId = serverEvent.chainId;
        this._clientEvent.isTaskEvent = serverEvent instanceof TaskEvent;
        this._clientEvent.createdTime = serverEvent.createdTime.getTime();
        this._clientEvent.userName = serverEvent.userName;
        this._clientEvent.fullFormattedMessage = serverEvent.fullFormattedMessage != null ? HtmlEscapers.htmlEscaper().escape(serverEvent.fullFormattedMessage) : null;
        this._clientEvent.categoryKey = EventDescription.EventCategory.error.name();
        this._clientEvent.eventType = this.getEventType(serverEvent);
        this._clientEvent.key = serverEvent.key;
        EventDetailDescription eventDetailDesc = eventWrapper.getEventDescription();
        this._clientEvent.eventDetail = eventDetailDesc != null ? new ClientEventDetailInfo(eventDetailDesc.eventDetail) : new ClientEventDetailInfo();
        this._clientEvent.eventTypeId = eventWrapper.getEventTypeId();
        this._clientEvent.longDescription = eventWrapper.getLongDescription();
        this._clientEvent.targetEntityMor = eventWrapper.getTargetMor();
        if (this._dvsMap.containsKey(this._clientEvent.targetEntityMor)) {
            this._clientEvent.targetEntityMor = this._dvsMap.get(this._clientEvent.targetEntityMor);
        }
        ManagedObjectReference targetEntityMor = (ManagedObjectReference)this._clientEvent.targetEntityMor;
        if (REMOVAL_EVENT_TYPES.contains(this._clientEvent.eventType)) {
            this._removedMoRefs.add(targetEntityMor);
        }
        if ((postProcessTargetResult = this.postProcessMor(this._parentInfos, targetEntityMor, this._allFaults)) != null) {
            this._clientEvent.targetEntityName = (String)postProcessTargetResult.result;
            this._clientEvent.targetEntityMor = (ManagedObjectReference)postProcessTargetResult.entity;
        } else {
            this._clientEvent.targetEntityName = eventWrapper.getTargetMorName();
        }
        if (this._clientEvent.targetEntityMor != null && this._clientEvent.targetEntityMor instanceof ManagedObjectReference) {
            this._uniqueTargetSet.add((ManagedObjectReference)this._clientEvent.targetEntityMor);
        }
        for (EntityEventArgumentWrapper argumentWrapper : eventWrapper.getEventArguments()) {
            OperationResult postProcessArgumentResult;
            ManagedObjectReference moRef = argumentWrapper.getMoref();
            if (this._dvsMap.containsKey(moRef)) {
                argumentWrapper.setMoRef(this._dvsMap.get(moRef));
                moRef = argumentWrapper.getMoref();
            }
            if ((postProcessArgumentResult = this.postProcessMor(this._parentInfos, moRef, this._allFaults)) == null) continue;
            argumentWrapper.getArguments().name = (String)postProcessArgumentResult.result;
            argumentWrapper.setMoRef((ManagedObjectReference)postProcessArgumentResult.entity);
        }
        if (this.isStoragePodRelated(serverEvent)) {
            EventEx event = (EventEx)serverEvent;
            event.setObjectName(MixedUtil.unescapeVimEntityNameSpecialChars((String)event.getObjectName()));
        }
        this._clientEvent.existingEntities = this._existingMoRefs.toArray(ManagedObjectUtil.EMPTY_MANAGED_OBJECT_ARR);
        this._clientEvent.associatedEntities = new HashMap();
        if (serverEvent.computeResource != null) {
            this._clientEvent.associatedEntities.put(COMPUTERESOURCE_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.computeResource));
        }
        if (serverEvent.datacenter != null) {
            this._clientEvent.associatedEntities.put(DC_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.datacenter));
        }
        if (serverEvent.ds != null) {
            this._clientEvent.associatedEntities.put(DS_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.ds));
        }
        if (serverEvent.dvs != null) {
            this._clientEvent.associatedEntities.put(DVS_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.dvs));
        }
        if (serverEvent.host != null) {
            this._clientEvent.associatedEntities.put(HOST_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.host));
        }
        if (serverEvent.net != null) {
            this._clientEvent.associatedEntities.put(NET_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.net));
        }
        if (serverEvent.vm != null) {
            this._clientEvent.associatedEntities.put(VM_ENTITY_KEY, new ClientEventEntityInfo(serverEvent.vm));
        }
        if (serverEvent instanceof VmBeingRelocatedEvent) {
            this.updateAssociatedEntitiesForRelocatedEvents((VmBeingRelocatedEvent)serverEvent);
        }
        if (serverEvent instanceof VmClonedEvent && (clonedEvent = (VmClonedEvent)serverEvent).getSourceVm() != null) {
            this._clientEvent.associatedEntities.put(SOURCE_VM_ENTITY_KEY, new ClientEventEntityInfo(clonedEvent.getSourceVm()));
        }
        if (serverEvent instanceof VmBeingClonedEvent && (clonedEvent = (VmBeingClonedEvent)serverEvent).getDestHost() != null) {
            this._clientEvent.associatedEntities.put(DEST_HOST_ENTITY_KEY, new ClientEventEntityInfo(clonedEvent.getDestHost()));
        }
        MessageParser parser = new MessageParser(serverEvent);
        this.localizeEventDetail(this._clientEvent);
        this._clientEvent.categoryKey = eventWrapper.getCategoryKey();
        this._clientEvent.categoryName = eventWrapper.getCategoryName();
        this.formatArguments(parser, this._clientEvent);
        if (StringUtils.isNotEmpty((CharSequence)this._clientEvent.targetEntityName)) {
            this._clientEvent.targetEntityName = parser.fixFtName(this._clientEvent.targetEntityName);
        }
        return this._clientEvent;
    }

    private String getEventType(Event serverEvent) {
        String eventType = null;
        eventType = serverEvent instanceof ExtendedEvent ? ((ExtendedEvent)serverEvent).eventTypeId : (serverEvent instanceof EventEx ? ((EventEx)serverEvent).eventTypeId : serverEvent.getClass().getSimpleName());
        return eventType;
    }

    private OperationResult postProcessMor(Map<ManagedObjectReference, OperationResult> parentInfos, ManagedObjectReference entityMor, List<MethodFault> allFaults) {
        this._existingMoRefs.add(entityMor);
        OperationResult modifiedOpResult = null;
        boolean opResultUpdated = false;
        OperationResult parentLookupOperationResult = parentInfos.get(entityMor);
        if (parentLookupOperationResult != null) {
            if (parentLookupOperationResult.error != null) {
                allFaults.add((MethodFault)parentLookupOperationResult.error);
                return modifiedOpResult;
            }
            boolean customParentRelated = this._locator.customParentRelated(entityMor, (ManagedObjectReference)parentLookupOperationResult.entity);
            if (customParentRelated) {
                modifiedOpResult = parentLookupOperationResult;
                this._existingMoRefs.remove(entityMor);
                if (parentInfos.containsKey(parentLookupOperationResult.entity)) {
                    this._existingMoRefs.add((ManagedObjectReference)parentLookupOperationResult.entity);
                }
                opResultUpdated = true;
            }
        }
        if (!opResultUpdated && ManagedObjectUtil.isRootFolder((ManagedObjectReference)entityMor)) {
            modifiedOpResult = new OperationResult();
            modifiedOpResult.result = VcServiceUtil.getServiceName((String)this._clientEvent.serverGuid);
            modifiedOpResult.entity = entityMor;
        }
        if (modifiedOpResult != null) {
            modifiedOpResult.result = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)modifiedOpResult.result));
        }
        return modifiedOpResult;
    }

    private boolean isStoragePodRelated(Event serverEvent) {
        boolean result = false;
        if (serverEvent instanceof EventEx) {
            String objectType;
            EventEx event = (EventEx)serverEvent;
            String storagePodClassName = StoragePod.class.getAnnotation(wsdlName.class).value();
            if (event.objectType != null && storagePodClassName.equals(objectType = ((TypeNameImpl)event.objectType).getWsdlName())) {
                result = true;
            }
        }
        return result;
    }

    private void updateAssociatedEntitiesForRelocatedEvents(VmBeingRelocatedEvent relocatedEvent) {
        if (relocatedEvent.getDestHost() != null) {
            this._clientEvent.associatedEntities.put(DEST_HOST_ENTITY_KEY, new ClientEventEntityInfo(relocatedEvent.getDestHost()));
        }
        if (relocatedEvent.getDestDatacenter() != null) {
            this._clientEvent.associatedEntities.put(DEST_DATACENTER_ENTITY_KEY, new ClientEventEntityInfo(relocatedEvent.getDestDatacenter()));
        }
        if (relocatedEvent.getDestDatastore() != null) {
            this._clientEvent.associatedEntities.put(DEST_DATASTORE_ENTITY_KEY, new ClientEventEntityInfo(relocatedEvent.getDestDatastore()));
        }
    }

    private void localizeEventDetail(ClientEventInfo clientEvent) {
        String eventType = clientEvent.eventType;
        if (eventType != null) {
            String fullFormat;
            ClientEventDetailInfo detail = clientEvent.eventDetail;
            detail.category = this.getMessage(CATEGORY_FORMAT, detail.category, eventType);
            String defaultValue = detail.description != null ? detail.description : eventType;
            detail.description = this.getMessage(DESCRIPTION_FORMAT, defaultValue, eventType);
            defaultValue = detail.fullFormat != null ? detail.fullFormat : eventType;
            detail.fullFormat = fullFormat = this.getMessage(FULL_FORMAT, defaultValue, eventType);
            defaultValue = detail.formatOnComputeResource != null ? detail.formatOnComputeResource : fullFormat;
            detail.formatOnComputeResource = this.getMessage(COMPUTE_RESOURCE_FORMAT, defaultValue, eventType);
            defaultValue = detail.formatOnDatacenter != null ? detail.formatOnDatacenter : fullFormat;
            detail.formatOnDatacenter = this.getMessage(DATACENTER_FORMAT, defaultValue, eventType);
            defaultValue = detail.formatOnHost != null ? detail.formatOnHost : fullFormat;
            detail.formatOnHost = this.getMessage(HOST_FORMAT, defaultValue, eventType);
            defaultValue = detail.formatOnVm != null ? detail.formatOnVm : fullFormat;
            detail.formatOnVm = this.getMessage(VM_FORMAT, defaultValue, eventType);
            if (detail.key == null) {
                detail.key = new TypeNameImpl(eventType).toString();
            }
        }
    }

    private void formatArguments(MessageParser parser, ClientEventInfo clientEvent) {
        ClientEventDetailInfo oldDetail = clientEvent.eventDetail;
        ClientEventDetailInfo newDetail = new ClientEventDetailInfo();
        newDetail.category = oldDetail.category;
        parser.parse(oldDetail.description);
        newDetail.description = parser.getFullFormattedMessage();
        parser.parse(oldDetail.formatOnComputeResource);
        newDetail.formatOnComputeResource = parser.getFullFormattedMessage();
        parser.parse(oldDetail.formatOnDatacenter);
        newDetail.formatOnDatacenter = parser.getFullFormattedMessage();
        parser.parse(oldDetail.formatOnHost);
        newDetail.formatOnHost = parser.getFullFormattedMessage();
        parser.parse(oldDetail.formatOnVm);
        newDetail.formatOnVm = parser.getFullFormattedMessage();
        parser.parse(oldDetail.fullFormat);
        newDetail.fullFormat = parser.getFullFormattedMessage();
        clientEvent.linkableFormattedMessage = parser.getLinkableFormattedMessage();
        newDetail.key = oldDetail.key;
        newDetail.longDescription = oldDetail.longDescription;
        clientEvent.eventDetail = newDetail;
    }

    private String getMessage(String formatString, String defaultValue, String args) {
        String resourceId = String.format(formatString, args);
        String newDefaultValue = defaultValue == null ? resourceId : defaultValue;
        String message = LocalizationUtil.getLocalizedMessage((String)resourceId, null);
        if ((StringUtils.isEmpty((CharSequence)message) || message.equals(resourceId)) && (StringUtils.isEmpty((CharSequence)(message = this.getArgumentByKey(resourceId))) || message.equals(resourceId))) {
            message = newDefaultValue;
        }
        return message;
    }

    private String getArgumentByKey(String key) {
        if (this._clientEvent == null || !(this._clientEvent.serverEvent instanceof EventEx)) {
            return null;
        }
        EventEx extendedEvent = (EventEx)this._clientEvent.serverEvent;
        if (extendedEvent.arguments != null) {
            for (KeyAnyValue kav : extendedEvent.arguments) {
                if (!kav.getKey().equals(key)) continue;
                return (String)kav.getValue();
            }
        }
        return null;
    }

    Set<ManagedObjectReference> getUniqueTargets() {
        return this._uniqueTargetSet;
    }

    Set<ManagedObjectReference> getRemovedEntities() {
        return this._removedMoRefs;
    }

    static {
        REMOVAL_EVENT_TYPES.add("VmRemovedEvent");
        REMOVAL_EVENT_TYPES.add("HostRemovedEvent");
    }
}

