/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MigrationHistoryProcessor
extends BaseEventProcessor {
    public MigrationHistoryProcessor(DataServiceExtensionRegistry registry) {
        super(registry);
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{Util.MIGRATION_HISTORY};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> events, List<MethodFault> faults, QuerySpec spec) {
        Collection<List<Event>> rawEvents = events.values();
        ArrayList<ManagedObjectReference> migrationHistoryList = new ArrayList<ManagedObjectReference>();
        for (List<Event> currentEventList : rawEvents) {
            for (Event currentEvent : currentEventList) {
                if (!(currentEvent instanceof EventEx)) continue;
                ManagedObjectReference oldMoRef = null;
                EventEx currentEventEx = (EventEx)currentEvent;
                KeyAnyValue[] args = currentEventEx.arguments;
                for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                    KeyAnyValue currentArg = args[argIndex];
                    if (0 != currentArg.getKey().compareTo(Util.OLD_MO_REF)) continue;
                    String oldMoRefString = (String)currentArg.getValue();
                    oldMoRef = this.makeVirtualMachineMO(oldMoRefString);
                    migrationHistoryList.add(oldMoRef);
                    this.requestHistory(oldMoRef, migrationHistoryList);
                }
            }
        }
        ArrayList<ResultItem> results = new ArrayList<ResultItem>();
        for (ManagedObjectReference oldMoRef : migrationHistoryList) {
            PropertyValue property = new PropertyValue();
            property.propertyName = Util.MIGRATION_HISTORY;
            property.value = oldMoRef;
            ResultItem item = new ResultItem();
            item.properties = new PropertyValue[]{property};
            try {
                item.resourceObject = new URI("TODO:" + oldMoRef.getValue() + oldMoRef.getServerGuid());
            }
            catch (Exception exc) {
                continue;
            }
            results.add(item);
        }
        return results;
    }

    private ArrayList<ManagedObjectReference> requestHistory(ManagedObjectReference moRef, ArrayList<ManagedObjectReference> migrationHistoryList) {
        CompositeConstraint constraint = new CompositeConstraint();
        constraint.conjoiner = Conjoiner.AND;
        constraint.targetType = "vsphere:Event";
        PropertyConstraint entityProperty = QueryUtil.createPropertyConstraint((String)"vsphere:Event", (String)"info.entity", (Comparator)Comparator.EQUALS, (Object)moRef);
        PropertyConstraint recursionProperty = QueryUtil.createPropertyConstraint((String)"vsphere:Event", (String)"info.recursion", (Comparator)Comparator.EQUALS, (Object)"recursion.self");
        PropertyConstraint serverProperty = QueryUtil.createPropertyConstraint((String)"vsphere:Event", (String)"info.serverGuid", (Comparator)Comparator.EQUALS, (Object)moRef.getServerGuid());
        constraint.nestedConstraints = new Constraint[]{entityProperty, recursionProperty, serverProperty};
        QuerySpec qs = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{Util.MIGRATION_HISTORY});
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[]{Util.MIGRATION_HISTORY};
        propSpec.relation = "";
        propSpec.type = "vsphere:Event";
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.parameter = null;
        paramSpec.propertyName = Util.MIGRATION_HISTORY;
        propSpec.parameters = new ParameterSpec[]{paramSpec};
        qs.resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resultSpec.offset = 0;
        qs.resultSpec = resultSpec;
        ResultSet resultSet = this.getData(qs);
        for (ResultItem item : resultSet.items) {
            for (PropertyValue value : item.properties) {
                if (!(value.value instanceof ManagedObjectReference)) continue;
                migrationHistoryList.add((ManagedObjectReference)value.value);
            }
        }
        return migrationHistoryList;
    }

    private ManagedObjectReference makeVirtualMachineMO(String vmRef) {
        ManagedObjectReference moRef = null;
        try {
            String[] moComponents = vmRef.split(":");
            if (moComponents.length == 3) {
                String type2 = moComponents[0];
                type2 = type2.substring(type2.lastIndexOf(46) + 1);
                moRef = new ManagedObjectReference(type2, moComponents[2], moComponents[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return moRef;
    }
}

