/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.cm.impl.CmDataProviderAdapterBase;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.DataRetriever;
import com.vmware.vsphere.client.cm.util.DataRetrieverResult;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.ServiceInfoComparator;
import java.net.URI;

@type(value="cm:Service")
public class ServicesDataProviderAdapter
extends CmDataProviderAdapterBase<InternalServiceInfo> {
    private final DataRetriever _retriever;

    public ServicesDataProviderAdapter(DataRetriever retriever, CmAuthorizationService cmAuthzService) {
        super(cmAuthzService);
        this._retriever = retriever;
    }

    @Override
    protected ResultSet processQueryInternal(Constraint constraint, QuerySpec querySpec) {
        DataRetrieverResult<InternalServiceInfo> retrievalResult = this._retriever.retrieveServices(constraint);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec != null && (resultSpec.maxResultCount == null || resultSpec.maxResultCount > 0) && resultSpec.order != null) {
            retrievalResult.sort(new ServiceInfoComparator(resultSpec.order, this._retriever.getServiceValueExtractor(), retrievalResult.getResult()));
        }
        ResultSet result = this.createResultSet(querySpec, retrievalResult);
        return result;
    }

    protected Object[][] getPropertyValues(InternalServiceInfo[] services, String[] propertyNames) {
        return this._retriever.getServiceValues(services, propertyNames);
    }

    @Override
    protected URI getUri(InternalServiceInfo info) {
        return CmReferenceUtil.getServiceReference(info);
    }
}

