/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.util.HealthStateComparator;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.ServiceInfoPropertyValueExtractor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public final class ServiceInfoComparator
implements Comparator<InternalServiceInfo> {
    private final OrderingCriteria _orderingCriteria;
    private final ServiceInfoPropertyValueExtractor _serviceValueExtractor;
    private HashMap<String, HashMap<InternalServiceInfo, Object>> _precomputedProperties;
    private InternalServiceInfo[] _services;

    public ServiceInfoComparator(OrderingCriteria orderingCriteria, ServiceInfoPropertyValueExtractor serviceValueExtractor, InternalServiceInfo[] services) {
        this._orderingCriteria = orderingCriteria;
        this._serviceValueExtractor = serviceValueExtractor;
        this._services = services;
        this.precomputeNeededProperties();
    }

    private void precomputeNeededProperties() {
        HashSet<String> orderingPropertyNames = new HashSet<String>();
        for (OrderingPropertySpec ops : this._orderingCriteria.orderingProperties) {
            for (String propertyName : ops.propertyNames) {
                orderingPropertyNames.add(propertyName);
            }
        }
        String[] neededProperties = orderingPropertyNames.toArray(new String[orderingPropertyNames.size()]);
        Object[][] propertyResults = this._serviceValueExtractor.getValues(this._services, neededProperties);
        this._precomputedProperties = new HashMap();
        for (int i = 0; i < neededProperties.length; ++i) {
            HashMap<InternalServiceInfo, Object> propertyValuesByService = new HashMap<InternalServiceInfo, Object>();
            Object[] resultsForPropertyByService = propertyResults[i];
            for (int j = 0; j < this._services.length; ++j) {
                propertyValuesByService.put(this._services[j], resultsForPropertyByService[j]);
            }
            this._precomputedProperties.put(neededProperties[i], propertyValuesByService);
        }
    }

    @Override
    public int compare(InternalServiceInfo service1, InternalServiceInfo service2) {
        for (OrderingPropertySpec orderingProperty : this._orderingCriteria.orderingProperties) {
            for (String propertyName : orderingProperty.propertyNames) {
                int compareToResult;
                Object prop1 = this.getServiceProperty(service1, propertyName);
                Object prop2 = this.getServiceProperty(service2, propertyName);
                int result = 0;
                if (prop1 == null && prop2 == null || (result = prop1 == null ? 1 : (prop2 == null ? -1 : (prop1 instanceof HealthState ? this.compareByHealth((HealthState)((Object)prop1), (HealthState)((Object)prop2)) : (prop1 instanceof Comparable ? (compareToResult = ((Comparable)prop1).compareTo(prop2)) : prop1.toString().compareToIgnoreCase(prop2.toString()))))) == 0) continue;
                return orderingProperty.orderingType == SortType.ASCENDING ? result : -result;
            }
        }
        return 0;
    }

    private int compareByHealth(HealthState health1, HealthState health2) {
        return HealthStateComparator.getInstance().compare(health1, health2);
    }

    private Object getServiceProperty(InternalServiceInfo service, String propertyName) {
        assert (this._precomputedProperties.containsKey(propertyName) && this._precomputedProperties.get(propertyName).containsKey(service));
        return this._precomputedProperties.get(propertyName).get(service);
    }
}

