/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.compliance.ComplianceManager;
import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.pbm.fault.NoPermission;
import com.vmware.vim.binding.pbm.placement.CompatibilityResult;
import com.vmware.vim.binding.pbm.placement.MatchingReplicationResources;
import com.vmware.vim.binding.pbm.placement.MatchingResources;
import com.vmware.vim.binding.pbm.placement.PlacementHub;
import com.vmware.vim.binding.pbm.placement.PlacementSubject;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.DataServiceToPoliciesMap;
import com.vmware.vim.binding.pbm.profile.DefaultProfileInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.ResourceTypeEnum;
import com.vmware.vim.binding.sms.storage.replication.GroupInfo;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.sms.spec.SourceGroupQuerySpec;
import com.vmware.vsphere.client.common.spbm.data.ReplicationGroupInfo;
import com.vmware.vsphere.client.common.spbm.data.VirtualDiskStorageProfileAssignmentData;
import com.vmware.vsphere.client.common.spbm.data.VmStorageProfileAssignmentsData;
import com.vmware.vsphere.client.spbm.LocationLookupException;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.data.ProfileComplianceResultData;
import com.vmware.vsphere.client.spbm.data.ProfileVmComplianceData;
import com.vmware.vsphere.client.spbm.data.ProfileVmDiskComplianceData;
import com.vmware.vsphere.client.spbm.data.VmRollupComplianceSummayData;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmLocalizationUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.VirtualMachineDisk;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmUtil {
    private static final String SPBM_POLICY_PERMISSION_CAPABILITY = "capability.spbmPolicyPermissionSupported";
    private static final String RESOURCE_BUNDLE_NAME = "SpbmService";
    private static final String SPBM_VIEW_PRIV_ID = "StorageProfile.View";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String VM_TEMPLATE_PROPERTY = "config.template";
    private static final String VM_DEVICES_PROPERTY = "config.hardware.device";
    private static final String REPLICATION_GROUP_SOURCE_GROUP_INFO = "replicationGroupSourceGroupInfo";
    private static final Log _logger = LogFactory.getLog(PbmUtil.class);

    public static boolean canViewSpbmStorageProfiles(String vcServiceGuid, QueryExecutor queryExecutor, PbmServiceFactory pbmServiceFactory) throws Exception {
        ManagedObjectReference serviceInstance = new ManagedObjectReference(ServiceInstance.class.getSimpleName(), ServiceInstance.class.getSimpleName(), vcServiceGuid);
        ManagedObjectReference rootVcFolder = ManagedUtil.buildVcMoRef(vcServiceGuid);
        PropertyValue[] propertyValues = queryExecutor.getProperties(new Object[]{serviceInstance, rootVcFolder}, new String[]{SPBM_POLICY_PERMISSION_CAPABILITY, "grantedPrivileges"});
        if (propertyValues == null) {
            return false;
        }
        Boolean isSpbmPolicyPermissionSupported = (Boolean)PbmUtil.valueOf(propertyValues, serviceInstance, SPBM_POLICY_PERMISSION_CAPABILITY);
        String[] grantedVcPrivileges = (String[])PbmUtil.valueOf(propertyValues, rootVcFolder, "grantedPrivileges");
        return PbmUtil.canViewSpbmStorageProfiles(vcServiceGuid, isSpbmPolicyPermissionSupported, grantedVcPrivileges, pbmServiceFactory);
    }

    public static boolean canViewSpbmStorageProfiles(String vcServiceGuid, Boolean isSpbmPolicyPermissionSupported, String[] grantedVcPrivileges, PbmServiceFactory pbmServiceFactory) {
        boolean hasViewPrivilegeOnVcLevel = PbmUtil.hasViewPrivilegeOnVcLevel(grantedVcPrivileges);
        if (isSpbmPolicyPermissionSupported != null && isSpbmPolicyPermissionSupported.booleanValue()) {
            return hasViewPrivilegeOnVcLevel || PbmUtil.hasViewPrivilegeOnPolicyLevel(vcServiceGuid, pbmServiceFactory);
        }
        return hasViewPrivilegeOnVcLevel;
    }

    private static boolean hasViewPrivilegeOnVcLevel(String[] grantedVcPrivileges) {
        if (ArrayUtils.isEmpty((Object[])grantedVcPrivileges)) {
            return false;
        }
        return Arrays.asList(grantedVcPrivileges).contains(SPBM_VIEW_PRIV_ID);
    }

    private static boolean hasViewPrivilegeOnPolicyLevel(String vcServiceGuid, PbmServiceFactory pbmServiceFactory) {
        try {
            PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, pbmServiceFactory);
            ResourceType type2 = new ResourceType(ResourceTypeEnum.STORAGE.toString());
            String profileCategory = CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT.toString();
            Object[] profileIds = pbmService.getProfileManager().queryProfile(type2, profileCategory);
            return ArrayUtils.isNotEmpty((Object[])profileIds);
        }
        catch (LocationLookupException | PbmServiceUnableToConnectException ignored) {
            return false;
        }
    }

    public static MethodFault getMethodFault(Exception ex) {
        if (ex instanceof PbmServiceUnableToConnectException || ex instanceof UnexpectedStatusCodeException || ex.getCause() instanceof UnexpectedStatusCodeException) {
            return MixedUtil.getMethodFault((Throwable)PbmUtil.getLocalizedException("error.serviceUnavailable", ex));
        }
        if (ex instanceof ExecutionException && ex.getCause() != null) {
            return MixedUtil.getMethodFault((Throwable)ex.getCause());
        }
        return MixedUtil.getMethodFault((Throwable)ex);
    }

    public static Exception getLocalizedException(String key) {
        return new Exception(PbmUtil.getLocalizedString(key, new String[0]));
    }

    public static Exception getLocalizedException(String key, String ... args) {
        return new Exception(PbmUtil.getLocalizedString(key, args));
    }

    public static Exception getLocalizedException(String key, Exception cause) {
        return new Exception(PbmUtil.getLocalizedString(key, new String[0]), cause);
    }

    public static String getLocalizedString(String key, String ... args) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])args, (ClassLoader)PbmUtil.class.getClassLoader());
    }

    public static DefaultProfileInfo getDefaultRequirementProfile(PbmService pbmService, ManagedObjectReference moRef) throws Exception {
        if (pbmService == null || moRef == null || !"Datastore".equals(moRef.getType())) {
            return null;
        }
        PlacementHub hub = PbmUtil.moRefToPlacementHub(moRef);
        Object[] defaultProfileInfos = pbmService.getProfileManager().queryDefaultRequirementProfiles(new PlacementHub[]{hub});
        if (ArrayUtils.isEmpty((Object[])defaultProfileInfos)) {
            return null;
        }
        return defaultProfileInfos[0];
    }

    public static DefaultProfileInfo[] getDefaultRequirementProfiles(PbmService pbmService, ManagedObjectReference[] datastoreRefs) throws Exception {
        if (pbmService == null || datastoreRefs == null || datastoreRefs.length == 0) {
            return null;
        }
        PlacementHub[] placementHubs = PbmUtil.moRefToPlacementHub(datastoreRefs);
        BlockingFuture defaultProfileInfosFuture = new BlockingFuture();
        pbmService.getProfileManager().queryDefaultRequirementProfiles(placementHubs, (Future)defaultProfileInfosFuture);
        return (DefaultProfileInfo[])defaultProfileInfosFuture.get();
    }

    public static boolean areProfileIdsEqual(ProfileId profileId1, ProfileId profileId2) {
        if (profileId1 == null && profileId2 == null) {
            return true;
        }
        if (profileId1 == null || profileId2 == null) {
            return false;
        }
        return profileId1.uniqueId != null && profileId1.uniqueId.equals(profileId2.uniqueId);
    }

    public static PlacementSubject createPlacementSubject(String subjectType, String subjectId) {
        PlacementSubject placementSubject = new PlacementSubject();
        placementSubject.subjectId = subjectId;
        placementSubject.subjectType = subjectType;
        return placementSubject;
    }

    public static PlacementHub moRefToPlacementHub(ManagedObjectReference moRef) {
        if (moRef == null) {
            return null;
        }
        PlacementHub hub = new PlacementHub();
        hub.hubId = moRef.getValue();
        hub.hubType = moRef.getType();
        return hub;
    }

    public static PlacementHub[] moRefToPlacementHub(ManagedObjectReference[] moRefs) {
        if (moRefs == null) {
            return null;
        }
        PlacementHub[] hubs = new PlacementHub[moRefs.length];
        for (int i = 0; i < hubs.length; ++i) {
            hubs[i] = PbmUtil.moRefToPlacementHub(moRefs[i]);
        }
        return hubs;
    }

    public static ManagedObjectReference placementHubToMoRef(PlacementHub hub, String serverGuid) {
        if (hub == null) {
            return null;
        }
        return ManagedUtil.buildMoRef(hub.hubId, hub.hubType, serverGuid);
    }

    public static ManagedObjectReference[] placementHubToMoRef(PlacementHub[] hubs, String serverGuid) {
        if (hubs == null) {
            return null;
        }
        ManagedObjectReference[] moRefs = new ManagedObjectReference[hubs.length];
        for (int i = 0; i < hubs.length; ++i) {
            moRefs[i] = PbmUtil.placementHubToMoRef(hubs[i], serverGuid);
        }
        return moRefs;
    }

    public static void parseComplianceData(String complianceStatus, Boolean profileMismatch, ManagedObjectReference vm, HashMap<ManagedObjectReference, Boolean> vmsComplianceMap) {
        Boolean isCompliant = null;
        if (profileMismatch != null && profileMismatch.booleanValue()) {
            isCompliant = Boolean.FALSE;
        } else {
            ComplianceResult.ComplianceStatus entityComplianceStatus = null;
            if (complianceStatus != null) {
                entityComplianceStatus = ComplianceResult.ComplianceStatus.valueOf((String)complianceStatus);
            }
            if (ComplianceResult.ComplianceStatus.compliant.equals((Object)entityComplianceStatus)) {
                isCompliant = Boolean.TRUE;
            } else if (ComplianceResult.ComplianceStatus.nonCompliant.equals((Object)entityComplianceStatus)) {
                isCompliant = Boolean.FALSE;
            } else if (ComplianceResult.ComplianceStatus.notApplicable.equals((Object)entityComplianceStatus)) {
                isCompliant = Boolean.FALSE;
            }
        }
        if (!vmsComplianceMap.containsKey(vm)) {
            vmsComplianceMap.put(vm, isCompliant);
        } else {
            if (vmsComplianceMap.get(vm) == Boolean.FALSE) {
                return;
            }
            if (isCompliant != null && !isCompliant.booleanValue()) {
                vmsComplianceMap.put(vm, isCompliant);
                return;
            }
            if (vmsComplianceMap.get(vm) == null) {
                return;
            }
            vmsComplianceMap.put(vm, isCompliant);
        }
    }

    public static ProfileVmComplianceData[] getProfileComplianceData(URI profileUri, PbmServiceFactory pbmServiceFactory, DataService dataService, boolean checkCompliance) throws Exception {
        LinkedHashMap<ManagedObjectReference, ProfileVmComplianceData> resultMap = new LinkedHashMap<ManagedObjectReference, ProfileVmComplianceData>();
        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, pbmServiceFactory);
        if (pbmService == null) {
            return null;
        }
        ProfileId profileId = ManagedUtil.uriToProfileId(profileUri);
        Object[] associatedVmSoRefs = PbmUtil.queryAssociatedEntities(pbmService, profileId, ServerObjectRef.ObjectType.virtualMachine.toString());
        Object[] associatedDisksSoRefs = PbmUtil.queryAssociatedEntities(pbmService, profileId, ServerObjectRef.ObjectType.virtualDiskId.toString());
        if (ArrayUtils.isEmpty((Object[])associatedVmSoRefs) && ArrayUtils.isEmpty((Object[])associatedDisksSoRefs)) {
            return null;
        }
        HashSet<ManagedObjectReference> associatedVms = new HashSet<ManagedObjectReference>();
        if (!ArrayUtils.isEmpty((Object[])associatedVmSoRefs)) {
            for (int i = 0; i < associatedVmSoRefs.length; ++i) {
                associatedVms.add(ManagedUtil.serverObjectRefToManagedObjectRef((ServerObjectRef)associatedVmSoRefs[i], vcServiceGuid));
            }
        }
        HashSet<VirtualMachineDisk> associatedDisks = new HashSet<VirtualMachineDisk>();
        if (!ArrayUtils.isEmpty((Object[])associatedDisksSoRefs)) {
            for (int i = 0; i < associatedDisksSoRefs.length; ++i) {
                associatedDisks.add(PbmUtil.serverObjectReferenceToVirtualMachineDisk((ServerObjectRef)associatedDisksSoRefs[i], vcServiceGuid));
            }
        }
        ManagedObjectReference[] uniqueVmRefs = PbmUtil.getUniqueVmRefs(associatedVms, associatedDisks);
        Hashtable<ManagedObjectReference, ArrayList<VirtualDisk>> vmDisksTable = new Hashtable<ManagedObjectReference, ArrayList<VirtualDisk>>();
        PbmUtil.retrieveVmNamesAndDisks(dataService, uniqueVmRefs, associatedVms, resultMap, vmDisksTable);
        ComplianceManager complianceManager = pbmService.getComplianceManager();
        ServerObjectRef[] uniqueVmSoRefs = ManagedUtil.managedObjectRefToServerObjectRef(uniqueVmRefs);
        RollupComplianceResult[] rollupComplianceResults = PbmUtil.getRollupComplianceResultsForEntities(complianceManager, profileId, uniqueVmSoRefs, checkCompliance);
        PbmUtil.processRollupComplianceResults(rollupComplianceResults, associatedDisks, vmDisksTable, resultMap, profileId, vcServiceGuid);
        return resultMap.values().toArray(new ProfileVmComplianceData[0]);
    }

    public static ComplianceResult[] getComplianceResultsForEntities(ComplianceManager complianceManager, ProfileId profileId, ServerObjectRef[] associatedSoRefs, boolean checkCompliance) throws Exception {
        if (ArrayUtils.isEmpty((Object[])associatedSoRefs)) {
            return null;
        }
        BlockingFuture futureComplianceResult = new BlockingFuture();
        if (checkCompliance) {
            complianceManager.checkCompliance(associatedSoRefs, profileId, (Future)futureComplianceResult);
        } else {
            complianceManager.fetchComplianceResult(associatedSoRefs, profileId, (Future)futureComplianceResult);
        }
        ComplianceResult[] complianceResults = (ComplianceResult[])futureComplianceResult.get();
        PbmLocalizationUtil.localizeComplianceResults(complianceResults);
        return complianceResults;
    }

    public static RollupComplianceResult[] getRollupComplianceResultsForEntities(ComplianceManager complianceManager, ProfileId profileId, ServerObjectRef[] associatedSoRefs, boolean checkCompliance) throws Exception {
        if (ArrayUtils.isEmpty((Object[])associatedSoRefs)) {
            return null;
        }
        BlockingFuture futureRollupComplianceResult = new BlockingFuture();
        if (checkCompliance) {
            complianceManager.checkRollupCompliance(associatedSoRefs, (Future)futureRollupComplianceResult);
        } else {
            complianceManager.fetchRollupComplianceResult(associatedSoRefs, (Future)futureRollupComplianceResult);
        }
        RollupComplianceResult[] rollupComplianceResults = (RollupComplianceResult[])futureRollupComplianceResult.get();
        PbmLocalizationUtil.localizeRollupComplianceResults(rollupComplianceResults);
        return rollupComplianceResults;
    }

    private static void processRollupComplianceResults(RollupComplianceResult[] rollupComplianceResults, Set<VirtualMachineDisk> associatedDisks, Map<ManagedObjectReference, ArrayList<VirtualDisk>> vmDisksTable, Map<ManagedObjectReference, ProfileVmComplianceData> resultMap, ProfileId profileId, String vcServiceGuid) {
        if (ArrayUtils.isEmpty((Object[])rollupComplianceResults)) {
            return;
        }
        HashSet<VirtualMachineDisk> disksWithoutComplianceData = new HashSet<VirtualMachineDisk>(associatedDisks);
        for (RollupComplianceResult rollupComplianceResult : rollupComplianceResults) {
            if (ArrayUtils.isEmpty((Object[])rollupComplianceResult.result)) continue;
            for (ComplianceResult complianceResult : rollupComplianceResult.result) {
                VirtualMachineDisk vmDisk;
                if (complianceResult.profile == null || !profileId.getUniqueId().equals(complianceResult.profile.getUniqueId())) continue;
                if (ManagedUtil.isVmHome(complianceResult.entity)) {
                    PbmUtil.populateVmComplianceData(complianceResult, resultMap, vcServiceGuid);
                    continue;
                }
                if (!ManagedUtil.isVirtualDisk(complianceResult.entity) || !disksWithoutComplianceData.remove(vmDisk = PbmUtil.serverObjectReferenceToVirtualMachineDisk(complianceResult.entity, vcServiceGuid))) continue;
                PbmUtil.populateVmDiskComplianceData(vmDisk, complianceResult, vmDisksTable, resultMap, vcServiceGuid);
            }
        }
        for (VirtualMachineDisk vmDisk : disksWithoutComplianceData) {
            PbmUtil.populateVmDiskComplianceData(vmDisk, null, vmDisksTable, resultMap, vcServiceGuid);
        }
    }

    private static void populateVmComplianceData(ComplianceResult complianceResult, Map<ManagedObjectReference, ProfileVmComplianceData> resultMap, String vcServiceGuid) {
        ManagedObjectReference vmRef = ManagedUtil.serverObjectRefToManagedObjectRef(complianceResult.entity, vcServiceGuid);
        ProfileVmComplianceData complianceData = resultMap.get(vmRef);
        if (complianceData != null) {
            complianceData.vmComplianceResult = complianceResult;
            complianceData.isHomeProfileUnknownComplianceStatus = false;
        }
    }

    private static void populateVmDiskComplianceData(VirtualMachineDisk vmDisk, ComplianceResult complianceResult, Map<ManagedObjectReference, ArrayList<VirtualDisk>> vmDisksTable, Map<ManagedObjectReference, ProfileVmComplianceData> resultMap, String vcServiceGuid) {
        ManagedObjectReference vmRef = vmDisk.virtualMachine;
        String diskName = PbmUtil.getDiskName(vmDisksTable, vmDisk, vcServiceGuid);
        if (StringUtils.isEmpty((CharSequence)diskName)) {
            return;
        }
        ProfileVmComplianceData perVmComplianceData = resultMap.get(vmRef);
        if (perVmComplianceData.diskComplianceResults == null) {
            perVmComplianceData.diskComplianceResults = new ArrayList();
        }
        ProfileVmDiskComplianceData diskComplianceData = new ProfileVmDiskComplianceData();
        diskComplianceData.diskName = diskName;
        diskComplianceData.diskComplianceResult = complianceResult;
        perVmComplianceData.diskComplianceResults.add(diskComplianceData);
    }

    private static ServerObjectRef[] queryAssociatedEntities(PbmService pbmService, ProfileId profileId, String entityType) throws Exception {
        BlockingFuture futureServerObjRefs = new BlockingFuture();
        pbmService.getProfileManager().queryAssociatedEntity(profileId, entityType, (Future)futureServerObjRefs);
        return (ServerObjectRef[])futureServerObjRefs.get();
    }

    private static ManagedObjectReference[] getUniqueVmRefs(Set<ManagedObjectReference> associatedVms, Set<VirtualMachineDisk> associatedDisks) {
        HashSet<ManagedObjectReference> uniqueVmRefs = new HashSet<ManagedObjectReference>(associatedVms);
        if (associatedDisks != null) {
            for (VirtualMachineDisk disk : associatedDisks) {
                uniqueVmRefs.add(disk.virtualMachine);
            }
        }
        return uniqueVmRefs.toArray(new ManagedObjectReference[0]);
    }

    private static void retrieveVmNamesAndDisks(DataService dataService, ManagedObjectReference[] vmRefs, Set<ManagedObjectReference> associatedVms, Map<ManagedObjectReference, ProfileVmComplianceData> vmResultMap, Map<ManagedObjectReference, ArrayList<VirtualDisk>> vmDisksTable) throws Exception {
        PropertyValue[] vmProperties;
        for (PropertyValue val : vmProperties = QueryUtil.getProperties((DataService)dataService, (Object[])vmRefs, (String[])new String[]{VM_NAME_PROPERTY, VM_TEMPLATE_PROPERTY, VM_DEVICES_PROPERTY})) {
            VirtualDevice[] devices;
            ProfileVmComplianceData complianceData;
            ManagedObjectReference vmRef = (ManagedObjectReference)val.resourceObject;
            if (VM_NAME_PROPERTY.equals(val.propertyName) && val.value != null) {
                complianceData = vmResultMap.get(vmRef);
                if (complianceData == null) {
                    complianceData = new ProfileVmComplianceData();
                    vmResultMap.put(vmRef, complianceData);
                    complianceData.vm = vmRef;
                }
                if (associatedVms.contains(vmRef)) {
                    complianceData.isHomeProfileUnknownComplianceStatus = true;
                }
                complianceData.vmName = (String)val.value;
                continue;
            }
            if (VM_TEMPLATE_PROPERTY.equals(val.propertyName)) {
                Boolean isTemplate;
                complianceData = vmResultMap.get(vmRef);
                if (complianceData == null) {
                    complianceData = new ProfileVmComplianceData();
                    vmResultMap.put(vmRef, complianceData);
                    complianceData.vm = vmRef;
                }
                if ((isTemplate = (Boolean)val.value) == null) continue;
                complianceData.isTemplate = isTemplate;
                continue;
            }
            if (!VM_DEVICES_PROPERTY.equals(val.propertyName) || val.value == null) continue;
            vmDisksTable.put(vmRef, new ArrayList());
            for (VirtualDevice device : devices = (VirtualDevice[])val.value) {
                if (!(device instanceof VirtualDisk)) continue;
                VirtualDisk disk = (VirtualDisk)device;
                vmDisksTable.get(vmRef).add(disk);
            }
        }
    }

    public static VmRollupComplianceSummayData getVmRollupComplianceSummay(ManagedObjectReference vm, boolean checkCompliance, PbmServiceFactory pbmServiceFactory) throws Exception {
        Map<String, Profile> profilesMap;
        RollupComplianceResult[] rollupCompliance;
        PbmService pbmService;
        if (vm == null) {
            return null;
        }
        try {
            pbmService = PbmSessionUtil.getService(vm.getServerGuid(), pbmServiceFactory);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve VmRollupComplianceSummay: ", (Throwable)e);
            throw PbmUtil.getMethodFault(e);
        }
        ServerObjectRef vmSoRef = ManagedUtil.managedObjectRefToServerObjectRef(vm);
        BlockingFuture future = new BlockingFuture();
        try {
            if (checkCompliance) {
                pbmService.getComplianceManager().checkRollupCompliance(new ServerObjectRef[]{vmSoRef}, (Future)future);
            } else {
                pbmService.getComplianceManager().fetchRollupComplianceResult(new ServerObjectRef[]{vmSoRef}, (Future)future);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve VmRollupComplianceSummay: ", (Throwable)e);
            throw PbmUtil.getMethodFault(e);
        }
        try {
            rollupCompliance = (RollupComplianceResult[])future.get();
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve VmRollupComplianceSummay: ", (Throwable)e);
            throw PbmUtil.getMethodFault(e);
        }
        if (rollupCompliance == null || rollupCompliance.length == 0) {
            return null;
        }
        for (RollupComplianceResult rc : rollupCompliance) {
            PbmLocalizationUtil.localizeRollupComplianceResult(rc);
        }
        VmRollupComplianceSummayData result = new VmRollupComplianceSummayData();
        result.oldestCheckTime = rollupCompliance[0].oldestCheckTime;
        result.profileMismatch = rollupCompliance[0].profileMismatch;
        result.vm = vm;
        result.rollupComplianceStatus = rollupCompliance[0].overallComplianceStatus;
        if (rollupCompliance[0].result == null) {
            return result;
        }
        try {
            profilesMap = PbmUtil.getProfilesFromRollupComplianceResult(pbmService, rollupCompliance);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve VmRollupComplianceSummay: ", (Throwable)e);
            throw PbmUtil.getMethodFault(e);
        }
        ArrayList<ProfileComplianceResultData> profileComplianceResults = new ArrayList<ProfileComplianceResultData>();
        for (ComplianceResult complianceResult : rollupCompliance[0].result) {
            boolean isStorageProfileRestricted = PbmUtil.isStorageProfileRestricted(complianceResult);
            if (complianceResult.profile == null && !isStorageProfileRestricted) continue;
            ProfileComplianceResultData complianceResultData = new ProfileComplianceResultData();
            complianceResultData.isStorageProfileRestricted = isStorageProfileRestricted;
            complianceResultData.complianceResult = complianceResult;
            if (!isStorageProfileRestricted) {
                complianceResultData.storageProfile = profilesMap.get(complianceResult.profile.uniqueId);
            }
            profileComplianceResults.add(complianceResultData);
        }
        result.entityComplianceResults = profileComplianceResults.toArray(new ProfileComplianceResultData[0]);
        return result;
    }

    public static boolean isStorageProfileRestricted(ComplianceResult[] complianceResults) {
        if (ArrayUtils.isEmpty((Object[])complianceResults)) {
            return false;
        }
        boolean isRestricted = true;
        for (ComplianceResult complianceResult : complianceResults) {
            if (PbmUtil.isStorageProfileRestricted(complianceResult)) continue;
            isRestricted = false;
            break;
        }
        return isRestricted;
    }

    public static boolean isStorageProfileRestricted(ComplianceResult complianceResult) {
        return complianceResult != null && complianceResult.profile == null && ArrayUtils.isNotEmpty((Object[])complianceResult.errorCause) && PbmUtil.isStorageProfileRestricted(complianceResult.errorCause);
    }

    private static boolean isStorageProfileRestricted(Exception[] errorCauses) {
        boolean isRestricted = false;
        for (Exception errorCause : errorCauses) {
            if (!PbmUtil.isStorageProfileRestricted(errorCause)) continue;
            isRestricted = true;
            break;
        }
        return isRestricted;
    }

    public static boolean isStorageProfileRestricted(Exception errorCause) {
        return errorCause instanceof NoPermission;
    }

    private static String getDiskName(Map<ManagedObjectReference, ArrayList<VirtualDisk>> vmDisksTable, VirtualMachineDisk vmDisk, String serverGuid) {
        ManagedObjectReference vmRef = new ManagedObjectReference(vmDisk.virtualMachine.getType(), vmDisk.virtualMachine.getValue(), serverGuid);
        if (!vmDisksTable.containsKey(vmRef)) {
            return null;
        }
        for (VirtualDisk disk : vmDisksTable.get(vmRef)) {
            if (disk.key != vmDisk.diskKey) continue;
            return disk.deviceInfo.label;
        }
        return null;
    }

    private static ComplianceResult getDiskComplianceResult(VirtualMachineDisk vmDisk, ComplianceResult[] diskComplianceResults) {
        if (ArrayUtils.isEmpty((Object[])diskComplianceResults)) {
            return null;
        }
        for (ComplianceResult diskComplianceResult : diskComplianceResults) {
            VirtualMachineDisk disk = PbmUtil.serverObjectReferenceToVirtualMachineDisk(diskComplianceResult.entity, diskComplianceResult.entity.getServerUuid());
            if (disk == null || !disk.virtualMachine.getValue().equals(vmDisk.virtualMachine.getValue()) || disk.diskKey != vmDisk.diskKey) continue;
            return diskComplianceResult;
        }
        return null;
    }

    public static VirtualMachineDisk serverObjectReferenceToVirtualMachineDisk(ServerObjectRef diskSor, String vcServiceGuid) {
        VirtualMachineDisk result = new VirtualMachineDisk();
        String[] diskArtifacts = diskSor.key.split(":");
        if (diskArtifacts.length != 2) {
            _logger.error((Object)("Failed to parse virtual disk key. Expected <vm-id>:<device-key>, got: " + diskSor.key));
            return null;
        }
        result.virtualMachine = ManagedUtil.buildMoRef(diskArtifacts[0], "VirtualMachine", vcServiceGuid);
        result.diskKey = Integer.parseInt(diskArtifacts[1]);
        return result;
    }

    public static Map<String, Profile> getProfilesFromRollupComplianceResult(PbmService service, RollupComplianceResult[] rollupComplianceResults) throws Exception {
        HashMap<String, Profile> result = new HashMap<String, Profile>();
        ProfileId[] profilesToRetrieve = PbmUtil.getProfileIdsFromRollupCompliance(rollupComplianceResults);
        if (profilesToRetrieve == null || profilesToRetrieve.length == 0) {
            return result;
        }
        BlockingFuture future = new BlockingFuture();
        service.getProfileManager().retrieveContent(profilesToRetrieve, (Future)future);
        Profile[] profiles = (Profile[])future.get();
        if (profiles != null) {
            for (Profile profile : profiles) {
                result.put(profile.profileId.uniqueId, profile);
            }
        }
        return result;
    }

    public static RollupComplianceResult[] getRollupComplianceResult(PbmService service, ManagedObjectReference[] vms) throws Exception {
        if (vms == null || vms.length == 0) {
            return new RollupComplianceResult[0];
        }
        ComplianceManager complianceManager = service.getComplianceManager();
        ServerObjectRef[] vmSoRefs = ManagedUtil.managedObjectRefToServerObjectRef(vms);
        BlockingFuture future = new BlockingFuture();
        complianceManager.fetchRollupComplianceResult(vmSoRefs, (Future)future);
        RollupComplianceResult[] results = (RollupComplianceResult[])future.get();
        if (results != null) {
            for (RollupComplianceResult rc : results) {
                PbmLocalizationUtil.localizeRollupComplianceResult(rc);
            }
        }
        return (RollupComplianceResult[])future.get();
    }

    public static ProfileId[] getProfileIdsFromRollupCompliance(RollupComplianceResult[] rollupComplianceResults) {
        if (rollupComplianceResults == null || rollupComplianceResults.length == 0) {
            return new ProfileId[0];
        }
        ArrayList<ProfileId> profileIds = new ArrayList<ProfileId>();
        HashSet<String> profileIdsSet = new HashSet<String>();
        for (RollupComplianceResult vmRollupCompliance : rollupComplianceResults) {
            if (vmRollupCompliance == null || vmRollupCompliance.result == null || vmRollupCompliance.result.length == 0) continue;
            for (ComplianceResult complianceResult : vmRollupCompliance.result) {
                if (complianceResult.profile == null || profileIdsSet.contains(complianceResult.profile.uniqueId)) continue;
                profileIds.add(complianceResult.profile);
                profileIdsSet.add(complianceResult.profile.uniqueId);
            }
        }
        return profileIds.toArray(new ProfileId[0]);
    }

    public static ProfileId getDiskProfileId(VmStorageProfileAssignmentsData vmAssignments, int diskKey) {
        if (vmAssignments == null || vmAssignments.diskAssignments == null) {
            return null;
        }
        String diskIdString = ":" + Integer.toString(diskKey);
        for (VirtualDiskStorageProfileAssignmentData diskAssignment : vmAssignments.diskAssignments) {
            if (diskAssignment.diskId == null || !diskAssignment.diskId.endsWith(diskIdString)) continue;
            return diskAssignment.profile.profileId;
        }
        return null;
    }

    public static ProfileId[] getParentProfileId(ProfileManager profileManager, ProfileId dataServiceProfile) throws Exception {
        Object[] parentProfileMap = profileManager.queryParentStoragePolicies(new ProfileId[]{dataServiceProfile});
        if (!ArrayUtils.isEmpty((Object[])parentProfileMap)) {
            return ((DataServiceToPoliciesMap)parentProfileMap[0]).parentStoragePolicies;
        }
        return null;
    }

    public static void extractReplicationGroupIds(CompatibilityResult compatibilityResult, HashMap<String, ReplicationGroupId> replicationGroups) {
        if (replicationGroups == null || compatibilityResult == null || compatibilityResult.matchingResources == null) {
            return;
        }
        for (MatchingResources matchingResources : compatibilityResult.matchingResources) {
            MatchingReplicationResources replicationResources;
            if (!(matchingResources instanceof MatchingReplicationResources) || (replicationResources = (MatchingReplicationResources)matchingResources) == null || replicationResources.replicationGroup == null) continue;
            for (ReplicationGroupId replicationGroupId : replicationResources.replicationGroup) {
                String rgKey = PbmUtil.replicationGroupIdAsString(replicationGroupId);
                if (replicationGroups.containsKey(rgKey)) continue;
                replicationGroups.put(rgKey, replicationGroupId);
            }
        }
    }

    public static ReplicationGroupInfo[] getReplicationGroupInfos(Collection<ReplicationGroupId> replicationGroupIds, ManagedObjectReference vcRef, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        if (replicationGroupIds == null || replicationGroupIds.isEmpty()) {
            return null;
        }
        HashMap<String, ReplicationGroupId> uniqueReplicationGroupIds = new HashMap<String, ReplicationGroupId>();
        for (ReplicationGroupId id : replicationGroupIds) {
            String stringId = PbmUtil.replicationGroupIdAsString(id);
            if (uniqueReplicationGroupIds.containsKey(stringId)) continue;
            uniqueReplicationGroupIds.put(stringId, id);
        }
        SourceGroupQuerySpec spec = new SourceGroupQuerySpec();
        spec.replicationGroupIds = uniqueReplicationGroupIds.values().toArray(new ReplicationGroupId[0]);
        QuerySpec querySpec = querySpecBuilder.buildQuerySpec((Object)vcRef, new String[]{REPLICATION_GROUP_SOURCE_GROUP_INFO});
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = REPLICATION_GROUP_SOURCE_GROUP_INFO;
        paramSpec.parameter = spec;
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{paramSpec};
        try {
            ResultSet resultSet = queryExecutor.getData(querySpec);
            if (resultSet == null || resultSet.items == null) {
                return null;
            }
            GroupInfo[] groupInfos = null;
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null || resultItem.properties == null) continue;
                for (PropertyValue propValue : resultItem.properties) {
                    if (propValue == null || !REPLICATION_GROUP_SOURCE_GROUP_INFO.equals(propValue.propertyName) || !(propValue.value instanceof GroupInfo[])) continue;
                    groupInfos = (GroupInfo[])propValue.value;
                }
            }
            if (groupInfos != null) {
                ArrayList<ReplicationGroupInfo> result = new ArrayList<ReplicationGroupInfo>();
                for (void var14_19 : groupInfos) {
                    ReplicationGroupInfo rgInfo = new ReplicationGroupInfo();
                    rgInfo.id = var14_19.groupId;
                    rgInfo.groupInfo = var14_19;
                    result.add(rgInfo);
                }
                return result.toArray(new ReplicationGroupInfo[result.size()]);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve source group infos: ", (Throwable)ex);
        }
        return null;
    }

    public static String replicationGroupIdAsString(ReplicationGroupId id) {
        if (id == null) {
            return null;
        }
        return id.faultDomainId.id + ":" + id.deviceGroupId.id;
    }

    public static boolean isResultCompatible(CompatibilityResult result) {
        if (result == null) {
            return true;
        }
        return result.error == null;
    }

    public static CompatibilityResult mergeCompatibilityResults(CompatibilityResult compResultA, CompatibilityResult compResultB) {
        if (compResultA == null) {
            return compResultB;
        }
        if (compResultB == null) {
            return compResultA;
        }
        CompatibilityResult mergedResult = new CompatibilityResult();
        mergedResult.hub = compResultA.hub;
        if (compResultA.matchingResources == null && compResultB.matchingResources == null) {
            return mergedResult;
        }
        if (compResultA.matchingResources != null && compResultB.matchingResources != null) {
            ArrayList<MatchingResources> mergedMatchingResources = new ArrayList<MatchingResources>();
            for (MatchingResources matchingResourcesA : compResultA.matchingResources) {
                boolean matchingGroupFound = false;
                for (MatchingResources matchingResourcesB : compResultB.matchingResources) {
                    MatchingResources mergedResources = PbmUtil.mergeMatchingResources(matchingResourcesA, matchingResourcesB);
                    if (mergedResources == null) continue;
                    mergedMatchingResources.add(mergedResources);
                    matchingGroupFound = true;
                    break;
                }
                if (matchingGroupFound) break;
            }
            if (mergedMatchingResources.isEmpty()) {
                return null;
            }
            mergedResult.matchingResources = mergedMatchingResources.toArray(new MatchingResources[mergedMatchingResources.size()]);
            return mergedResult;
        }
        return null;
    }

    private static MatchingResources mergeMatchingResources(MatchingResources resourcesA, MatchingResources resourcesB) {
        if (resourcesA instanceof MatchingReplicationResources && !(resourcesB instanceof MatchingReplicationResources) || resourcesB instanceof MatchingReplicationResources && !(resourcesA instanceof MatchingReplicationResources)) {
            return null;
        }
        ServerObjectRef[] compatibleHosts = null;
        if (resourcesA.compatibleHost == null) {
            compatibleHosts = resourcesB.compatibleHost;
        } else if (resourcesB.compatibleHost == null) {
            compatibleHosts = resourcesA.compatibleHost;
        } else {
            ArrayList<ServerObjectRef> mergedCompatibleHosts = new ArrayList<ServerObjectRef>();
            HashSet<String> compatibleHostIds = new HashSet<String>();
            for (ServerObjectRef hostRef : resourcesA.compatibleHost) {
                compatibleHostIds.add(hostRef.key);
            }
            for (ServerObjectRef hostRef : resourcesB.compatibleHost) {
                if (!compatibleHostIds.contains(hostRef.key)) continue;
                mergedCompatibleHosts.add(hostRef);
            }
            if (mergedCompatibleHosts.isEmpty()) {
                return null;
            }
            compatibleHosts = mergedCompatibleHosts.toArray(new ServerObjectRef[mergedCompatibleHosts.size()]);
        }
        if (resourcesA instanceof MatchingReplicationResources) {
            Object[] replicationGroupIdsA = ((MatchingReplicationResources)resourcesA).replicationGroup;
            Object[] replicationGroupIdsB = ((MatchingReplicationResources)resourcesB).replicationGroup;
            if (!ArrayUtils.isEmpty((Object[])replicationGroupIdsA) && ArrayUtils.isEmpty((Object[])replicationGroupIdsB) || !ArrayUtils.isEmpty((Object[])replicationGroupIdsB) && ArrayUtils.isEmpty((Object[])replicationGroupIdsA)) {
                return null;
            }
            ArrayList<Object> mergedReplicationGroupIds = new ArrayList<Object>();
            if (!ArrayUtils.isEmpty((Object[])replicationGroupIdsA)) {
                HashSet<String> replicationGroupIdsSet = new HashSet<String>();
                for (Object rgId : replicationGroupIdsA) {
                    replicationGroupIdsSet.add(PbmUtil.replicationGroupIdAsString((ReplicationGroupId)rgId));
                }
                for (Object rgId : replicationGroupIdsB) {
                    if (!replicationGroupIdsSet.contains(PbmUtil.replicationGroupIdAsString((ReplicationGroupId)rgId))) continue;
                    mergedReplicationGroupIds.add(rgId);
                }
                if (mergedReplicationGroupIds.isEmpty()) {
                    return null;
                }
            }
            MatchingReplicationResources result = new MatchingReplicationResources();
            result.compatibleHost = compatibleHosts;
            if (!mergedReplicationGroupIds.isEmpty()) {
                result.replicationGroup = mergedReplicationGroupIds.toArray(new ReplicationGroupId[mergedReplicationGroupIds.size()]);
            }
            return result;
        }
        MatchingResources result = new MatchingResources();
        result.compatibleHost = compatibleHosts;
        return result;
    }

    private static <T> T valueOf(PropertyValue[] propertyValues, ManagedObjectReference resourceObject, String propertyName) {
        for (PropertyValue propertyValue : propertyValues) {
            if (!propertyValue.resourceObject.equals(resourceObject) || !propertyValue.propertyName.equals(propertyName)) continue;
            return (T)propertyValue.value;
        }
        return null;
    }
}

