/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmVcUtil {
    private static final Log _logger = LogFactory.getLog(PbmVcUtil.class);

    public static URI[] getProfilesForResourceType(final ResourceType resourceType, final CapabilityBasedProfile.ProfileCategoryEnum profileCategory, final PbmServiceFactory pbmServiceFactory, final QueryExecutor queryExecutor, ThreadPoolExecutor threadPoolExecutor) {
        final ArrayList profiles = new ArrayList();
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroups = vcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        if (linkedVcGroups == null) {
            return new URI[0];
        }
        ArrayList<1> retrieveProfilesTasks = new ArrayList<1>();
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            for (final VcService vcService : linkedVcGroup.getVcServices()) {
                if (!vcService.getConnectionInfo().getErrorCode().equals("noError")) continue;
                retrieveProfilesTasks.add(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try {
                            SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                            ArrayList<URI> profilesForVc = new ArrayList<URI>();
                            PbmVcUtil.getProfilesForVc(resourceType, profileCategory, pbmServiceFactory, queryExecutor, vcService.getServiceGuid(), profilesForVc);
                            List list = profiles;
                            synchronized (list) {
                                profiles.addAll(profilesForVc);
                            }
                        }
                        catch (Exception ex) {
                            _logger.error((Object)("Failed to load profiles for VC: " + ex.getMessage()));
                        }
                        return null;
                    }
                });
            }
        }
        if (!retrieveProfilesTasks.isEmpty()) {
            try {
                threadPoolExecutor.invokeAll(retrieveProfilesTasks);
            }
            catch (Exception ex) {
                _logger.error((Object)"Failed to load profiles: ", (Throwable)ex);
            }
        }
        return profiles.toArray(new URI[0]);
    }

    public static void getProfilesForVc(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory, PbmServiceFactory pbmServiceFactory, QueryExecutor queryExecutor, String vcGuid, List<URI> profiles) throws Exception {
        if (!PbmUtil.canViewSpbmStorageProfiles(vcGuid, queryExecutor, pbmServiceFactory)) {
            return;
        }
        PbmService pbmService = PbmSessionUtil.getService(vcGuid, pbmServiceFactory);
        if (pbmService.isFeatureSupported("queryProfileDetails") && CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT == profileCategory) {
            profiles.add(ManagedUtil.buildAllVcProfilesSystemUri(resourceType, profileCategory, vcGuid));
            return;
        }
        if (CapabilityBasedProfile.ProfileCategoryEnum.DATA_SERVICE_POLICY == profileCategory && !pbmService.isFeatureSupported("dataService")) {
            return;
        }
        BlockingFuture future = new BlockingFuture();
        ProfileManager profileManager = pbmService.getProfileManager();
        profileManager.queryProfile(resourceType, profileCategory.toString(), (Future)future);
        ProfileId[] profileIds = (ProfileId[])future.get();
        if (profileIds == null) {
            return;
        }
        for (ProfileId profileId : profileIds) {
            profiles.add(ManagedUtil.buildProfileUri(resourceType, profileCategory, vcGuid, profileId));
        }
    }

    public static Profile[] getProfileContent(List<URI> profileUriList, String vcServerGuid, PbmServiceFactory pbmServiceFactory) throws Exception {
        PbmService pbmService = PbmSessionUtil.getService(vcServerGuid, pbmServiceFactory);
        if (pbmService == null) {
            return null;
        }
        BlockingFuture future = new BlockingFuture();
        pbmService.getProfileManager().retrieveContent(ManagedUtil.uriListToProfileId(profileUriList), (Future)future);
        return (Profile[])future.get();
    }
}

