/* Copyright 2015-2020 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * This file must come first.
 */
window.h5 = window.h5 || {};
window.h5.uiLib = window.h5.uiLib || {};
window.h5.actions = window.h5.actions || {};
window.h5.dragAndDropValidationMethods = window.h5.dragAndDropValidationMethods || {};
window.h5.listViewSelectedItemIdProperty = "lvSelectedItemId";
window.h5.resourcesDirectory = "resources10880725";

// TEMPORARY SETUP of global h5.ngMigrationEnabled flag for all Angular migration work
// This global approach was chosen for its simplicity and minimal code churn.
// h5.ngMigrationEnabled will be removed when the migration is fully done!

/*jshint devel:true */
h5.ngMigrationEnabled = true; // sets the default value for ngMigrationEnabled

// Special function to extract and re-use legacy controller inside upgraded components
h5.ngMigrationResolveController = function (moduleName, controllerName) {
   var result = moduleName["_invokeQueue"].filter(function (assembly) {
      return assembly[0] === "$controllerProvider" && assembly[2][0] === controllerName;
   });
   if (result.length === 0) {
      console.error("Cannot find controller " + controllerName);
      return null;
   }
   return result[0][2][1];
};

// Default controller assigned to zng1 wrappers of templates that don't define ng-controller.
h5.ngMigrationDefaultCompatibilityController = function() {
   var controllerCtor = function(i18nService, $scope){
      $scope.i18n = i18nService.getString;
   };
   controllerCtor.$inject = ['i18nService', '$scope'];
   return controllerCtor;

};

/**
 * @ngdoc overview
 * @name com.vmware.platform.ui
 * @module com.vmware.platform.ui
 *
 * @description
 *    # com.vmware.platform.ui
 *    This module contains various utility services for fetching and mutating objects
 *    and data, navigating, localization and other common tasks.
 *
 *    <mark style="background: #FA8072">Many of the APIs in this module are still
 *    candidate only and subject to change. Send feedback to h5-reviews@vmware.com.</mark>
 */
window.h5.uiLib.angularModule = angular
      .module('com.vmware.platform.ui', [
            'ngAria',
            'ngCookies',
            'vui.angular',
            'kendo.directives',
            'angulartics',
            'angulartics.piwik',
            'clarity-bridge', // Angular2 based Clarity
            'ui.sortable'
         ]
      )
      .config([
         'vuiModalServiceProvider', 'vuiDialogServiceProvider', 'vuiWizardServiceProvider',
         function(vuiModalServiceProvider, vuiDialogServiceProvider, vuiWizardServiceProvider) {
            vuiModalServiceProvider.setDefaultConfig({
               destroyOnHide: true,
               destroyOuterScope: true
            });

            vuiDialogServiceProvider.setDefaultConfig({
               destroyOnHide: true,
               destroyOuterScope: true
            });
            vuiDialogServiceProvider.setDefaultDialogOptions({
               maximizable: false,
               resizable: false,
               draggable: true,
               resizeMinWidth: 320,
               resizeMinHeight: 320
            });

            vuiWizardServiceProvider.setDefaultConfig({
               destroyOnHide: true,
               destroyOuterScope: true
            });
            vuiWizardServiceProvider.setDefaultWizardOptions({
               maximizable: true,
               resizable: true,
               draggable: true,
               resizeMinWidth: 700,
               resizeMinHeight: 420,
               closeOnEsc: true
            });
         }])
      .config([
         '$compileProvider', '$httpProvider', '$locationProvider',
               function ($compileProvider, $httpProvider, $locationProvider) {
            $compileProvider.aHrefSanitizationWhitelist(
                  /^\s*((https?|ftp|mailto|tel|file|vmrc):|(javascript:((void\(0\))?;?|(\/{2})))$)/);
            $compileProvider.debugInfoEnabled(h5.debug);

            $httpProvider.defaults.xsrfCookieName = h5.xsrfCookieName;
            $httpProvider.defaults.xsrfHeaderName = h5.xsrfHeaderName;

            // Disables the compilation of directives on comments.
            // Results in a compilation performance gain.
            $compileProvider.commentDirectivesEnabled(false);
            // Disables the compilation of directives on element classes.
            // Results in a compilation performance gain.
            $compileProvider.cssClassDirectivesEnabled(false);

            // Required for Angular router
            $locationProvider.html5Mode({
               enabled: true
            });
         }])
      .config(['$qProvider', function($qProvider) {
         // Possibly unhandled rejected promises will be logged to the
         // $exceptionHandler. Normally, that means that an error will be
         // logged to the console, but in tests $exceptionHandler will
         // (by default) re-throw any exceptions.
         // Tests that are affected by this change.
         // Adding this config option to keep 1.5 - 1.6 compatibility.
         // https://docs.angularjs.org/guide/migration#migrate1.5to1.6-ng-services-$q
         $qProvider.errorOnUnhandledRejections(false);
      }])
      .config(['$locationProvider', function ($locationProvider) {
         // Angular 1.6 introduces '!' as default hash prefix.
         // Adding this config option to keep 1.5 - 1.6 compatibility.
         // https://docs.angularjs.org/guide/migration#commit-aa077e8
         $locationProvider.hashPrefix('');
      }])
      .directive('input', function() {
         // Added for backward compatibility between Angular 1.5 & 1.6
         // https://docs.angularjs.org/guide/migration#migrate1.5to1.6-ng-directives-input%5Bnumber%5D
         return {
            restrict: 'E',
            require: '?ngModel',
            link: function (scope, elem, attrs, ngModelCtrl) {
               // ...that are of type "number" and have `ngModel`...
               if ((attrs.type === 'number') && ngModelCtrl) {
                  // ...remove the `step` validator.
                  delete ngModelCtrl.$validators.step;
               }
            }
         };
      })
      .run(['$rootScope', 'i18nService', '$cookies', 'vuiLocalizationService',
         function ($rootScope, i18nService, $cookies, vuiLocalizationService) {
         // Adding Language Resources to h5 global variable and $rootScope.
         h5.i18n.getString = i18nService.getString;
         angular.extend($rootScope, {
            i18n: i18nService.getString
         });

         vuiLocalizationService.set("navigationTree", i18nService.getString("CommonUi", "wizard.navigationTree.label"));
         vuiLocalizationService.set("alertCloseText", i18nService.getString("CommonUi", "clarity.i18n.alertCloseButtonAriaLabel"));

         jQuery.ajaxPrefilter(function (options, originalOptions, jqXHR) {
            var xsrfCookie = $cookies.get(h5.xsrfCookieName);
            if (xsrfCookie) {
               jqXHR.setRequestHeader(h5.xsrfHeaderName, xsrfCookie);
            }
         });
         }])
      // replaces initialization once performed by now deleted `MainTemplateController.js`
      .run(['$rootScope', '$http',
         function ($rootScope, $http) {

            // Debug function to dump pending http requests
            // system test util: `WebClientBaseView.java waitForRefreshButton()` given direct access AngularJS `$http`
            h5.__getPendingHttpRequests = function getPendingHttpRequests() {
               var pendingRequests = _.clone($http.pendingRequests);
               var jqueryRequests = _.clone(pendingJqueryRequests);
               var xhrRequests = _.clone(pendingXhrs);
               var i;
               for (i = 0; i < jqueryRequests.length; i++) {
                  var key = "jquery_" + i;
                  var obj = {};
                  obj[key] = jqueryRequests[i];
                  pendingRequests.push(obj);
               }

               var xhrKeys = _.keys(xhrRequests);
               for (i = 0; i < xhrKeys.length; i++) {
                  var key2 = "xhr:" + xhrKeys[i];
                  var obj2 = {};
                  obj2[key2] = xhrRequests[xhrKeys[i]];
                  pendingRequests.push(obj2);
               }

               return pendingRequests;
            };
         }]);

window.h5.h5main = window.h5.h5main || {};
window.h5.h5main.angularModule = angular.module('h5main',
      ['ngAnimate', 'com.vmware.platform.ui', 'angulartics', 'angulartics.piwik']);

var pendingJqueryRequests = [];
var pendingXhrs = {};

// context / right click disabled
if (!h5.debug) {
   if (h5.configuration && h5.configuration.configParams
         && h5.configuration.configParams["browser.context.menu"] === "false") {
      $(window).on('contextmenu', function() {
         return false;
      });
   } else {
      $(document).ready(function() {
         $('#applicationMenuContainer').on('contextmenu', function() {
            return false;
         });
      });
   }

   // Instrumentation to capture pending jQuery requests in addition to
   // pending Angular requests. h5.__getPendingHTTPRequests() is invoked by
   // the SystemTest automation.
   // See https://reviewboard.eng.vmware.com/r/1243537
   (function () {
      $(document).ready(function () {
         (function (open) {
            XMLHttpRequest.prototype.open = function (method, url, async, user, pass) {
               this.addEventListener("loadstart", function () {
                  pendingXhrs[url] = {'method': method};
               }, false);
               this.addEventListener("loadend", function () {
                  delete pendingXhrs[url];
               }, false);
               open.apply(this, arguments);
            };
         })(XMLHttpRequest.prototype.open);

         $(document).ajaxSend(function (evt, xhr, opts) {
            xhr.vmwopts = opts.url + " - " + opts.data;
            pendingJqueryRequests.push(xhr.vmwopts);
            xhr.always(function () {
               var idx = pendingJqueryRequests.indexOf(xhr.vmwopts);
               if (idx === -1) {
                  pendingJqueryRequests = [];
               }
               pendingJqueryRequests.splice(idx, 1);
            });
         });
      });
   })();
}

// plugin clarity specially patched components. Required because they don't port perfectly into Angular 1.x
angular.module("clarity-bridge", []);



/// <reference path="../../../types/clarity/index.d.ts" />
/**
 * Angular 2 downgraded components require special care because content projection with children sub-components breaks
 * These utilities are crafted to let special directives for Clarity tabs, wizard to workaround known Angular defect
 * Goal is to offer tooling for injector detection and expose underlying component
 */
var platform;
(function (platform) {
    var ClarityExtenderService = (function () {
        function ClarityExtenderService($q, $parse) {
            this.$q = $q;
            this.$parse = $parse;
            this.scopePseudoNotationSubstrate();
        }
        // reassemble :scope support for deadhead MS browsers
        ClarityExtenderService.prototype.scopePseudoNotationSubstrate = function () {
            (function (doc, elemProto) {
                try {
                    doc.querySelector(":scope BODY");
                }
                catch (err) {
                    var _loop_1 = function(method) {
                        var nativ = elemProto[method];
                        elemProto[method] = function (selectors) {
                            if (/(^|,)\s*:scope/.test(selectors)) {
                                var id = this.id; // remember
                                this.id = 'scopedPseudo_' + Date.now(); // new unique id
                                selectors = selectors.replace(/((^|,)\s*):scope/g, '$1#' + this.id); // replace :scope with #ID
                                var result = doc[method](selectors); // trigger
                                this.id = id; // restore previous id
                                return result;
                            }
                            else {
                                return nativ.call(this, selectors); // norml routine
                            }
                        };
                    };
                    for (var _i = 0, _a = ['querySelector', 'querySelectorAll']; _i < _a.length; _i++) {
                        var method = _a[_i];
                        _loop_1(method);
                    }
                }
            })(window.document, Element.prototype);
        };
        // utility : host bindings @Input emulated
        ClarityExtenderService.prototype.observeHostToController = function (hostMap, componentInstance, componentScope, componentAttributes) {
            var rules = [], list = Object.keys(hostMap);
            var _loop_2 = function(internalProperty) {
                var externalProperty = hostMap[internalProperty];
                // track rules for assigner
                rules.push([
                    externalProperty,
                    // binder back to live component onchange
                    function (val) {
                        componentInstance[internalProperty] = val;
                    }]);
            };
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var internalProperty = list_1[_i];
                _loop_2(internalProperty);
            }
            // next, observe
            this.observeHostInputsList(rules, componentScope, componentAttributes);
        };
        // routine :: internally host bindings @Input emulated
        ClarityExtenderService.prototype.observeHostInputsList = function (rules, componentScope, componentAttributes) {
            var _this = this;
            var _loop_3 = function(bindingProperty, valueAssigner) {
                var observedProperty = bindingProperty;
                // unless it doesn't have brackets ( then rewrite )
                if (observedProperty.indexOf("[") !== 0 && observedProperty.substr(observedProperty.length - 1) !== "]") {
                    observedProperty = "[" + componentAttributes.$normalize(observedProperty) + "]"; // prefer ng4 wrapping nomenclature
                }
                componentAttributes.$observe(observedProperty, function (val) {
                    valueAssigner(_this.$parse(val)(componentScope)); // deref expression and call assignment
                });
            };
            for (var _i = 0, rules_1 = rules; _i < rules_1.length; _i++) {
                var _a = rules_1[_i], bindingProperty = _a[0], valueAssigner = _a[1];
                _loop_3(bindingProperty, valueAssigner);
            }
        };
        /**
         * Notes: https://github.com/angular/angular/commit/1367cd9 - believe wiring process to be different
         *
         * In order to enable more control over the wiring of downgraded components and
         * their content (which eventually allows better control over features like
         * injector setup and content projection), it was necessary to change the
         * implementation of the directives generated for downgraded components.
         * The directives are now terminal and manually take care of projecting and
         * compiling their contents in the post-linking function. This is similar to how
         * the dynamic version of `upgrade` does it.
         * This is not expected to affect apps, since the relative order of individual
         * operations is preserved. Still, it is difficult to predict how every possible
         * usecase may be affected.
         * @param elem
         * @returns {any}
         */
        // two ways of preparation : encapsulated
        ClarityExtenderService.prototype.preparingHostComponent = function (elem) {
            var _this = this;
            // note: this reference may not have been fully resolved, due to deep component composition
            //const injectableRef = elem.inheritedData()[this.getInjectorControllerName()],
            var $q = this.$q.defer();
            this.fetchingComponentInjectorReference(elem).then(function (injectableRef) {
                var m = (_a = {}, _a[_this.injectorName] = injectableRef, _a);
                $q.resolve(injectableRef.then
                    ? _this.fetchingHostComponent(m) // injectable unavailable ( still ... processing )
                    : _this.getHostComponent(injectableRef) // grab it by the pointer!
                );
                var _a;
            });
            return $q.promise;
        };
        // ng4 wires downgraded components using a different technique
        // may yield injector OR a promise that resolves to an injector
        ClarityExtenderService.prototype.fetchingComponentInjectorReference = function (elem) {
            var $q = this.$q.defer(), icn = this.getInjectorControllerName(), injectableRef = _getReference();
            if (injectableRef) {
                $q.resolve(injectableRef);
            }
            else {
                // awaits ng4 component fabrication and linking process. must complete no exception
                var _ticker_1 = setInterval(function () {
                    var r = _getReference();
                    if (r) {
                        clearInterval(_ticker_1);
                        $q.resolve(_getReference());
                    }
                }, 0);
            }
            return $q.promise;
            function _getReference() {
                return elem.data(icn);
            }
        };
        // resolves NG4 component from an element: critical piece in normalizing interpretation of nested ng2 components
        ClarityExtenderService.prototype.fetchingHostComponent = function (controllerMap) {
            var _this = this;
            var $q = this.$q.defer();
            var injectorPromise = controllerMap[this.injectorName];
            if (injectorPromise && injectorPromise.then) {
                injectorPromise.then(function (elemInjector) { return $q.resolve(_this.getHostComponent(elemInjector)); });
            }
            else {
                $q.reject(); // malformed
            }
            return $q.promise;
        };
        // for external access in a template to an NG1 directive, resolve its class controller instance ( bound to elem )
        // normalized selector in the form of "clrTabs"
        ClarityExtenderService.prototype.getElementControllerByIdSelector = function (markerId, normalizedSelector, containerNodeElement) {
            if (normalizedSelector.indexOf("-") > 0) {
                return;
            }
            var expandedControllerNotation = "$" + normalizedSelector + "Controller"; //ng1 factory notation
            var $targetElement = angular.element(this.determineContainerDOM(containerNodeElement).querySelector("[" + '\\' + "#" + markerId + "]")); // using marker
            var potentials = $targetElement.data();
            // extract
            var probableClassMatch = Object.keys(potentials)
                .filter(function (k) { return [expandedControllerNotation, normalizedSelector].indexOf(k) >= 0; })
                .map(function (k) { return potentials[k]; });
            if (probableClassMatch.length) {
                return probableClassMatch[0];
            }
        };
        // standard identity technique
        // for external access in a template to an NG4 component decorated with hash notation
        ClarityExtenderService.prototype.getComponentById = function (markerId, containerNodeElement) {
            var $targetElement = angular.element(this.determineContainerDOM(containerNodeElement).querySelector("[" + '\\' + "#" + markerId + "]")); // using marker
            if ($targetElement) {
                var injectableRef = $targetElement.data(this.getInjectorControllerName());
                // injectable has resolved and isn't awaiting
                if (injectableRef && !(typeof injectableRef.then === "function")) {
                    return this.getHostComponent(injectableRef);
                }
            }
        };
        ClarityExtenderService.prototype.determineContainerDOM = function (containerNodeElement) {
            // decide which particle?
            var originalChildNode = containerNodeElement[0];
            // IE misinterprets
            var containerDOM = (originalChildNode && (originalChildNode instanceof HTMLElement || containerNodeElement[0] instanceof HTMLUnknownElement))
                ? containerNodeElement[0]
                : containerNodeElement;
            return containerDOM;
        };
        //internal only for safety:: having an injector, extract the component
        ClarityExtenderService.prototype.getHostComponent = function (ng4Injector) {
            return ng4Injector.view.nodes[0].componentView.component;
            /*
             20170227 - special notes for previous build before view engine refactor from Angular
             let nodeIndex        = 0, // assumption is the component is first in the template where it is defined
             primarySpecCmpId = `compView_${nodeIndex}`; // proven via view_compiler as such - keep a watchful eye
             return ng4Injector._view.ref.internalView[primarySpecCmpId].context; // targeted via component factory
             */
        };
        // find a list of angular DOM fragments in the sub-hierarchy
        ClarityExtenderService.prototype.getChildrenNodesList = function (selector, elem) {
            var scopeDescendants = ":scope "; // baseElement bracing
            //const children: Array<any> = Array.prototype.slice.call(elem.find(selector))
            return Array.prototype.slice.call(elem[0].querySelectorAll(scopeDescendants + selector));
        };
        // find a list of angular components in the sub-hierarchy
        ClarityExtenderService.prototype.getChildrenComponentsList = function (selector, elem) {
            var _this = this;
            return this.getChildrenNodesList(selector, elem)
                .map(function (elem) {
                return _this.getHostComponent(angular.element(elem).data(_this.getInjectorControllerName()));
            });
        };
        // supply ng4 injected promise by its specific compilation phase
        ClarityExtenderService.prototype.augmentRequire = function (requireMap, searchAncestors) {
            if (searchAncestors === void 0) { searchAncestors = true; }
            // generally scan ancestors, unless overrriden
            requireMap[this.injectorName] = searchAncestors ? "^^" : ""; // ng4 downgraded enclosing
            return requireMap;
        };
        Object.defineProperty(ClarityExtenderService.prototype, "injectorName", {
            // canonical definition from the scriptures
            get: function () {
                //return "ng2.Injector"; // ng2
                return "$$angularInjector"; // ng 4 2017
            },
            enumerable: true,
            configurable: true
        });
        // buried in inherited data
        ClarityExtenderService.prototype.getInjectorControllerName = function () {
            return "$" + this.injectorName + "Controller";
        };
        ClarityExtenderService.Metastructure = {
            name: "ClarityExtenderService",
            factory: ["$q", "$parse", function ($q, $parse) { return new ClarityExtenderService($q, $parse); }]
        };
        return ClarityExtenderService;
    }());
    platform.ClarityExtenderService = ClarityExtenderService;
    angular.module("clarity-bridge").service(ClarityExtenderService.Metastructure.name, ClarityExtenderService.Metastructure.factory);
})(platform || (platform = {}));



/// <reference path="../../../types/clarity/index.d.ts" />
var platform;
(function (platform) {
    // missing clarity pieces regenerated
    var DropdownToggleDirective = (function () {
        function DropdownToggleDirective(clarityExtender) {
            var _this = this;
            this.clarityExtender = clarityExtender;
            this.restrict = "A";
            this.link = function (scope, element, attrs, requiredCtrlMap) {
                var clarityDropdown;
                element.addClass("dropdown-toggle"); // styled
                _this.clarityExtender.fetchingHostComponent(requiredCtrlMap).then(function (cmp) { return clarityDropdown = cmp; });
                // behavioral
                element.on("click", function (evt) {
                    clarityDropdown.toggleDropdown();
                });
            };
            // shared state only
            this.require = clarityExtender.augmentRequire({}, true);
        }
        DropdownToggleDirective.Metastructure = {
            name: "clrDropdownToggle",
            factory: ["ClarityExtenderService", function (ClarityExtenderService) { return new DropdownToggleDirective(ClarityExtenderService); }]
        };
        return DropdownToggleDirective;
    }());
    platform.DropdownToggleDirective = DropdownToggleDirective;
    var DropdownItemDirective = (function () {
        function DropdownItemDirective(clarityExtender) {
            this.clarityExtender = clarityExtender;
            this.restrict = "A";
            this.bindToController = {
                "(click)": "&" // item action per click
            };
            this.controller = (function () {
                function class_1($element, clarityExtender) {
                    this.$element = $element;
                    this.clarityExtender = clarityExtender;
                    $element.addClass("dropdown-item"); // styled
                }
                class_1.prototype.$onInit = function () {
                    var _this = this;
                    this.clarityExtender.fetchingHostComponent(this).then(function (cmp) { return _this.clarityDropdown = cmp; });
                    // behavioral : menu item mouse click
                    this.$element.on("click", function (evt) {
                        var outputEvent = _this["(click)"];
                        if (outputEvent) {
                            outputEvent({ "$evt": evt }); // decorate with MouseEvent
                            _this.onDropdownItemClick();
                        }
                    });
                };
                // behavior via clarity
                class_1.prototype.onDropdownItemClick = function () {
                    if (this.clarityDropdown.isMenuClosable && !this.$element.hasClass("disabled")) {
                        this.clarityDropdown.toggleDropdown();
                    }
                };
                class_1.$inject = ["$element", platform.ClarityExtenderService.Metastructure.name];
                return class_1;
            }());
            // shared state only
            this.require = clarityExtender.augmentRequire({}, true);
        }
        // link: angular.IDirectiveLinkFn = (scope: DropdownItemDirectiveScope, element: angular.IAugmentedJQuery, attrs: angular.IAttributes, requiredCtrlMap: any) => { };
        DropdownItemDirective.Metastructure = {
            name: "clrDropdownItem",
            factory: ["ClarityExtenderService", function (ClarityExtenderService) { return new DropdownItemDirective(ClarityExtenderService); }]
        };
        return DropdownItemDirective;
    }());
    platform.DropdownItemDirective = DropdownItemDirective;
    // module definition0
    angular.module("clarity-bridge").directive(DropdownToggleDirective.Metastructure.name, DropdownToggleDirective.Metastructure.factory);
    angular.module("clarity-bridge").directive(DropdownItemDirective.Metastructure.name, DropdownItemDirective.Metastructure.factory);
})(platform || (platform = {}));



/* Copyright 2020 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var StackViewOverridesDirective = (function () {
        function StackViewOverridesDirective() {
            this.restrict = 'A';
            this.elements = [];
        }
        StackViewOverridesDirective.prototype.link = function (scope, element) {
            var _this = this;
            this.setupObserver(element);
            scope.$on("$destroy", function () {
                _this.onDestroy();
            });
        };
        /**
         * There are stack view components that are dynamically adding and removing stack blocks
         * ex. Edit Settings of VM, so we need to stop the propagation for the new elements as well
         */
        StackViewOverridesDirective.prototype.setupObserver = function (element) {
            var _this = this;
            this.changes = new MutationObserver(function (mutations) {
                if (mutations) {
                    for (var _i = 0, mutations_1 = mutations; _i < mutations_1.length; _i++) {
                        var mutation = mutations_1[_i];
                        _this.stopEventPropagationOnStackContent(mutation);
                    }
                }
            });
            this.changes.observe(element[0], {
                childList: true,
                subtree: true,
                attributes: true,
                attributeFilter: ["class"]
            });
        };
        StackViewOverridesDirective.prototype.stopPropagation = function (event) {
            event.stopPropagation();
        };
        StackViewOverridesDirective.prototype.stopEventPropagationOnStackContent = function (mutation) {
            if (mutation.target.nodeType !== Node.ELEMENT_NODE) {
                return;
            }
            var element = (mutation.target);
            if (element.tagName !== "CLR-STACK-BLOCK") {
                return;
            }
            if (!element.classList || !element.classList.contains("stack-block-expandable")) {
                return;
            }
            var expandableStackBlockContent = element.querySelector(".stack-block-label .stack-block-content");
            if (expandableStackBlockContent) {
                expandableStackBlockContent.addEventListener("click", this.stopPropagation);
                this.elements.push(expandableStackBlockContent);
            }
        };
        StackViewOverridesDirective.prototype.onDestroy = function () {
            var _this = this;
            this.elements.forEach(function (element) {
                element.removeEventListener("click", _this.stopPropagation);
            });
        };
        StackViewOverridesDirective.MetaStructure = {
            factory: [function () { return new StackViewOverridesDirective(); }]
        };
        return StackViewOverridesDirective;
    }());
    angular
        .module("com.vmware.platform.ui")
        .directive("stackViewOverrides", StackViewOverridesDirective.MetaStructure.factory);
})(platform || (platform = {}));



/// <reference path="../../../types/clarity/index.d.ts" />
var platform;
(function (platform) {
    // --------------- shim for tabs ----------------------
    var TabsDirective = (function () {
        function TabsDirective(clarityExtender) {
            this.clarityExtender = clarityExtender;
            this.restrict = "E"; //realized like a component
            this.bindToController = {};
            this.hostToController = {};
            this.terminal = false; // no guarantee
            this.controllerAs = "tabsCtrl"; // ng 1.5 needs identifier to bind to controller, remove in later versions?
            this.controller = (function () {
                function TabsDirectiveController($scope, $element, $attrs, $timeout, clarityExtender) {
                    this.$scope = $scope;
                    this.$element = $element;
                    this.$attrs = $attrs;
                    this.$timeout = $timeout;
                    this.clarityExtender = clarityExtender;
                    this.active = false;
                    // host bindings @Input
                }
                TabsDirectiveController.prototype.$onInit = function () {
                };
                TabsDirectiveController.prototype.$postLink = function () {
                    var _this = this;
                    this.clarityExtender.preparingHostComponent(this.$element).then(function (cmp) {
                        _this.clarityTabs = cmp; // bindable component as it's prepared
                        // tick...
                        // Add second argument, temporary solution in order the tests to work
                        _this.timer = _this.$timeout(function () {
                            _this.afterViewInit();
                        }, 0);
                    });
                };
                TabsDirectiveController.prototype.$onDestroy = function () {
                    if (this.timer) {
                        this.$timeout.cancel(this.timer);
                    }
                };
                // Respond after Angular initializes the component's views and child views.
                // @ContentChildren initialized at this sequence
                TabsDirectiveController.prototype.afterViewInit = function () {
                    this.applyComponentPatch();
                    // higher dimension alignment of children TabLink components
                    this.clarityTabs.tabLinkChildren.reset(this.queryTabLinkContentChildren());
                    // higher dimension alignment of children TabContent components
                    this.clarityTabs.tabContentChildren.reset(this.queryTabContentContentChildren());
                    // sync
                    this.clarityTabs.setUpLinksAndContents();
                    // assign safely class references
                    if (Array.isArray(this.tabContentComponentsList)) {
                        this.TabContentClass = this.tabContentComponentsList[0].constructor;
                    }
                    if (Array.isArray(this.tabLinkComponentsList)) {
                        this.TabLinkClass = this.tabLinkComponentsList[0].constructor;
                    }
                };
                // scan within component QueryList
                TabsDirectiveController.prototype.queryTabLinkContentChildren = function () {
                    return this.tabLinkComponentsList = this.clarityExtender.getChildrenComponentsList("> UL > clr-tab-link", this.$element);
                };
                TabsDirectiveController.prototype.queryTabContentContentChildren = function () {
                    return this.tabContentComponentsList = this.clarityExtender.getChildrenComponentsList("> clr-tab-content", this.$element);
                };
                // accommodate shortcoming in AoT builds
                // WRONG  mapped content projection
                TabsDirectiveController.prototype.applyComponentPatch = function () {
                    var _this = this;
                    // organization of "lost" TabContent blocks. bug in downgraded AoT?
                    this.clarityExtender.getChildrenNodesList("> UL > clr-tab-content", this.$element)
                        .forEach(function (sheep) { return _this.$element[0].appendChild(sheep); });
                };
                ;
                TabsDirectiveController.$inject = ["$scope", "$element", "$attrs", "$timeout", 'ClarityExtenderService'];
                return TabsDirectiveController;
            }());
            this.link = function (scope, element, attrs, requiredCtrlMap) {
            };
            // shared state only
            this.controller["HostToController"] = this.hostToController; // static inject
        }
        TabsDirective.Metastructure = {
            name: "clrTabs",
            factory: ["ClarityExtenderService", function (ClarityExtenderService) { return new TabsDirective(ClarityExtenderService); }]
        };
        return TabsDirective;
    }());
    platform.TabsDirective = TabsDirective;
    angular.module("clarity-bridge").directive(TabsDirective.Metastructure.name, TabsDirective.Metastructure.factory);
})(platform || (platform = {}));



var common_ui;
(function (common_ui) {
    var ActionBarController = (function () {
        function ActionBarController(vuiConstants, $log) {
            this.vuiConstants = vuiConstants;
            this.$log = $log;
            this.isDisabled = function (action) {
                if (!action) {
                    return false;
                }
                if (action.enabled === undefined) {
                    return false;
                }
                if (!action.enabled) {
                    return true;
                }
                return false;
            };
        }
        ActionBarController.prototype.isSeparator = function (action) {
            return action === this.vuiConstants.actions.SEPARATOR ? true : false;
        };
        ActionBarController.prototype.isVisible = function (action) {
            if (!action) {
                return true;
            }
            if (action.visible === undefined) {
                return true;
            }
            return action.visible;
        };
        ActionBarController.prototype.hasLabel = function (action) {
            return action.label && action.label.trim().length > 0;
        };
        ActionBarController.prototype.clickAction = function (event, action) {
            // handle event propogation when action is disabled
            if (!action.enabled) {
                event.stopPropagation();
                event.preventDefault();
            }
            else if (angular.isDefined(action.onClick) &&
                angular.isFunction(action.onClick)) {
                action.onClick.call(undefined, event, action);
            }
            else {
                this.$log.warn("No onClick action defined for action id: " +
                    action.id + " label: " + action.label);
            }
        };
        ActionBarController.prototype.hasClarityIcon = function (action) {
            if (!action || !action.iconClass) {
                return false;
            }
            if (action.shape) {
                return true;
            }
            var index = action.iconClass.indexOf("clr:");
            if (index === 0) {
                action.shape = action.iconClass.slice(4);
                return true;
            }
            return false;
        };
        ActionBarController.$inject = ["vuiConstants", "$log"];
        return ActionBarController;
    }());
    var ActionBarComponent = (function () {
        function ActionBarComponent() {
            this.templateUrl = "resources/ui/components/action-bar/action-bar.component.html";
            this.controller = ActionBarController;
            this.bindings = {
                options: "<",
                clrTemplate: "<?"
            };
        }
        return ActionBarComponent;
    }());
    common_ui.ActionBarComponent = ActionBarComponent;
    angular.module("com.vmware.platform.ui")
        .component("actionBar", new ActionBarComponent());
})(common_ui || (common_ui = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive for showing a Clarity spinner
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .directive('vxActivityIndicator', vxActivityIndicator);

   function vxActivityIndicator () {

      return {
         templateUrl: 'resources/ui/components/activityIndicator/vxActivityIndicator.html',
         transclude: true,
         scope: {
            isInteractive: "=?",
            isVisible: "=",
            title: "@",
            size: "@?",
            loadingAriaLabel: "@?"
         },
         controller: ['$scope', function($scope) {
            this.$onInit = function() {
               $scope.isInteractive = angular.isDefined($scope.isInteractive) ? $scope.isInteractive : true;
            };
         }],
         restrict: "E",
         priority: -500
      };
   }
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
*@ngdoc directive
*@name com.vmware.platform.ui:vxAlert
*@description
*  Directive to create a confirmation or alert dialog
*@example

   <html>
      <div vx-alert='alertOptions'></div>
   </html>

   <script>
   $scope.alertOptions = {
      title: 'new title',
      text: 'Some scary text',
      icon: 'icon-applib-cool-class' // 32x32 px
      visible:true
      confirmOptions: {
         label: 'Yay'
         visible: true,
         disabled: false,
         onClick: function(){
            console.log('yes clicked');
         }
      },
      rejectOptions: {
         label: 'Nay'
         visible: true,
         focused: true,
         disabled: false,
         onClick: function(){
            alert('Reject button clicked or escape pressed');
         }
      }
   };
   </script>
*/
(function() {
var vxAlertTemplateUrl = 'resources/ui/components/alert/vxAlertTemplate.html';

angular
   .module('com.vmware.platform.ui')
   .directive('vxAlert', vxAlert);

vxAlert.$inject = [
   '$templateCache',
   '$document',
   '$timeout'
];

function vxAlert($templateCache, $document, $timeout) {
   return {
      restrict: 'A',
      template: $templateCache.get(vxAlertTemplateUrl),
      scope: {
         vxAlert: '='
      },
      link: function (scope, element, attrs) {
         var ESC_KEYCODE = 27;

         if (!_.isObject(scope.vxAlert)) {
            throw new TypeError('Alert configuration is not an object');
         }

         function onReject() {
            if (_.isObject(scope.vxAlert.rejectOptions) &&
                _.isFunction(scope.vxAlert.rejectOptions.onClick)) {
               scope.vxAlert.rejectOptions.onClick.call(undefined);
            }

            // hide alert
            scope.vxAlert.visible = false;
         }

         var dismissAlertHandler = function (event) {
            // Avoid propagation of any keydown event since some other dialog might be
            // listening for it and trigger undesired functionality as closing the other
            // dialog when the current one on is on focus.
            event.stopImmediatePropagation();

            if (event.which === ESC_KEYCODE || event.keyCode === ESC_KEYCODE) {
               // hide alert
               //  need $apply beacuse digest does not trigger ?
               scope.$apply(function () {
                  onReject();
               });
            }
         };

         scope.vxAlert.htmlSafe = scope.vxAlert.text;

         $document.on('keydown', dismissAlertHandler);

         // clean up bindings
         scope.$on('$destroy', function(){
            $document.off('keydown', dismissAlertHandler);
         });

         // watch the text and replace with safeHtml
         scope.$watch('vxAlert.text', function(oldVal,newVal){
            if(scope.vxAlert.htmlSafe && angular.equals(oldVal, newVal)){
               return;
            }
            scope.vxAlert.htmlSafe = scope.vxAlert.text;
         });

         scope.isConfirmVisible = function (){
            // if not defined default to visible/true
            if ( _.isUndefined(scope.vxAlert.confirmOptions.visible)) {
               scope.vxAlert.confirmOptions.visible = true;
            }
            return scope.vxAlert.confirmOptions.visible ;
         };

         scope.isRejectVisible = function (){
            // if not defined default to visible/true
            if ( _.isUndefined(scope.vxAlert.rejectOptions.visible)) {
               scope.vxAlert.rejectOptions.visible = true ;
            }
            return scope.vxAlert.rejectOptions.visible;
         };

         scope.isConfirmDisabled = function (){
            // if not defined default to not-disabled/false
            if ( _.isUndefined(scope.vxAlert.confirmOptions.disabled)) {
               scope.vxAlert.confirmOptions.disabled = false ;
            }
            return scope.vxAlert.confirmOptions.disabled ;
         };

         scope.isRejectDisabled = function (){
            // if not defined default to not-disabled/false
            if ( _.isUndefined(scope.vxAlert.rejectOptions.disabled)) {
               scope.vxAlert.rejectOptions.disabled = false;
            }
            return scope.vxAlert.rejectOptions.disabled;
         };

         scope.onConfirmClick = function (event){
            if (angular.isDefined(scope.vxAlert.confirmOptions.onClick) &&
                  angular.isFunction(scope.vxAlert.confirmOptions.onClick)) {
               scope.vxAlert.confirmOptions.onClick.call(undefined,event);
            }
            // hide alert right now the alert closes immediately after hitting yes or no
            // TODO: jaked move this to a service and give control to user to close the alert.
            scope.vxAlert.visible = false;
         };

         scope.onRejectClick = onReject;

         scope.getConfirmText = function (){
            return scope.vxAlert.confirmOptions.label  ;
         };

         scope.getRejectText = function (){
            return scope.vxAlert.rejectOptions.label;
         };

         if (scope.vxAlert.rejectOptions.focused) {
            $timeout(function() {
               element.find('.reject-button').focus();
            }, 0);
         }
      }
   };
}
}());

/**
 * the HTML5 autofocus property can be finicky when it comes to dynamically loaded
 * templates and such with AngularJS. Use this simple directive to
 * tame this beast once and for all.
 *
 * Usage:
 * <input type="text" autofocus>
 *
 * License: MIT
 */
(function() {
   angular.module('com.vmware.platform.ui')

      .directive('autofocus', ['$timeout', function($timeout) {
         return {
            restrict: 'A',
            link : function($scope, $element) {
               $timeout(function() {
                  $element[0].focus();
               }, 500);
            }
         };
      }]);
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive for right-click on a data row of a kendo-grid. Given a function callback for the vxDatagridRowRightClick attribute, it calls that function.
 * The function is called passing the (event) parameter. event.data contains the selected data rows in the grid.
 * Usage: Place this on the same element as the vui-datagrid directive.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxDatagridRowRightClick', vxDatagridRowRightClick);

   vxDatagridRowRightClick.$inject = ['$parse', 'vuiConstants'];

   function vxDatagridRowRightClick($parse, vuiConstants) {
      var directive = {
            link: link
      };
      return directive;

      function link(scope, element, attrs) {
         var fn = null;
         if (attrs.vxDatagridRowRightClick !== '') {
            fn = $parse(attrs.vxDatagridRowRightClick);
         }

         // Find the kendoGrid by using the selector.
         var kendoGrid = element.children('div[kendo-grid]');
         var onContextMenu = function(event) {

              function rightClickPreselection(currentTarget){
                  grid.clearSelection();
                  // Select the row that has been right-clicked.
                  grid.select(currentTarget); // currentTarget is the row (because of the selector used during event binding).
              }


              if (fn === null) {
                  event.preventDefault();
                  return;
              }
              event.preventDefault();

              var grid = kendoGrid.data('kendoGrid');

              if (grid.options.selectionMode === vuiConstants.grid.selectionMode.SINGLE) {
                  event.data = [grid.dataItem(event.currentTarget)];
                  if(attrs.hasOwnProperty('vxDatagridRowRightClickPreselection')) {
                      rightClickPreselection(event.currentTarget);
                  }
              } else if (grid.options.selectionMode === vuiConstants.grid.selectionMode.MULTI) {
                  var selectedRows = grid.select();
                  var dataRows = [];
                  for (var i = 0; i < selectedRows.length; i++) {
                      var data = grid.dataItem(selectedRows[i]);
                      dataRows.push(data);
                  }
                  if (isTargetSelected(dataRows, grid.dataItem(event.currentTarget))) {
                      event.data = dataRows;
                  } else {
                      rightClickPreselection(event.currentTarget);
                      event.data = [grid.dataItem(event.currentTarget)];
                  }
              }
              var eventCopy = jQuery.extend(true, {}, event);
              var callback = function() {
                  fn(scope, {$event:eventCopy});
              };
              scope.$apply(callback);
         };
         kendoGrid.on('contextmenu', "tr[role='row'][data-uid]", onContextMenu);
        /**
        * trigger context menu on OS
        * with no supported context menu keyboard shortcut
         * https://jira.eng.vmware.com/browse/VSUIP-3815
        */
         kendoGrid.on('keydown', function(e) {
             var isContextShortcut = e.ctrlKey && (e.key === '5' || e.key ==='i');
             if (!isContextShortcut) {
                 return;
             }
             var grid = kendoGrid.data('kendoGrid');
             var selected  = grid.select();
             if (!selected.length) {
                 grid.select('tr:eq(0)');
                 selected  = grid.select();
             }

             if (!selected.length) {
                 return;
             }

             var currentCell = grid.current();
             if (!currentCell || !currentCell.get(0).matches('tr.k-state-selected *')) {
                 currentCell = selected.find('td');
             }

             const offset = currentCell.offset();
             onContextMenu(jQuery.extend(true, e, {
                 currentTarget: selected.get(0),
                 clientX: offset.left,
                 clientY: offset.top
             }));
         });
       }

      /**
       * Is the currently selected target part of the already selected rows?
       * @param dataRows Selected rows in the grid.
       * @param target New row to be selected.
       * @returns {boolean} True if the target is already selected, false otherwise.
       */
      function isTargetSelected(dataRows, target) {
         if (!dataRows || !target) {
            return false;
         }
         for (var i = 0; i < dataRows.length; i++) {
            if (dataRows[i].id === target.id) {
               return true;
            }
         }
         return false;
      }
   }

})();

angular.module('com.vmware.platform.ui')
.run(['columnRenderersRegistry',
      'resourceUtil',
      'i18nService',
      'timeFormatterService',
      'statusFormatterService',
      '$interpolate',
      'vimEntityEscapingService',
      function(columnRenderersRegistry, resourceUtil, i18nService,
               timeFormatterService, statusFormatterService, $interpolate,
               vimEntityEscapingService) {
         'use strict';

   columnRenderersRegistry.registerColumnRenderers({
      /**
       * Renderer to render icon and label which is link-enabled in a cell. [e.g. <icon> name(label1)(label2)]
       * @param  {array} props Array of property names, where 1st property is an object reference,
       *  2nd icon property,
       *  3nd is a label property,
       *  4th is tagging labels
       *  5th is tooltip title
       * @param  {object} data  Map of values for icon and label properties.
       * @param {object} config A dictionary (key/value) to control the renderer behavior.
       *  'navigatable' - controls whether a link navigating to the object should be rendered.
       */
      'object-name': function(props, data, config) {
         var objectId = data[props[0]];
         var iconClass = data[props[1]] || '';
         var label = data[props[2]];
         if (!label) {
            return '';
         }
         var labelIds = data[props[3]];
         var title = data[props[4]];
         var taggingLabel = resourceUtil.getTaggingLabelString(labelIds);

         var navigatable = config ? config.navigatable: undefined;

         var options = null;
         if (config && config.extensionName) {
            options = {
               extensionName: config.extensionName
            };
         }
         // TODO - vaivanov - This needs to be reworked to use options object
         return linkRenderer(
               objectId, label + taggingLabel, iconClass, false, options, title, navigatable);
      },

      /**
       * Renders dates represented by timstamps in local date and date format a
       * nd local time zone .
       * @param  {array} props Array of property names first of which should be the
       * the name of the property containing the date.
       * @param  {object} data  Map of values containing the column data including the
       * date timestamp.
       * @returns {string} Html to be rendered for the column cell value.
       */
      'date': function(props , data) {
         var timestamp = data[props[0]];
         if (typeof timestamp !== "number") {
            return "";
         }
         var text = timeFormatterService.formatDateSync(timestamp);
         return textWithTooltipRenderer(text, text);
      },

      /**
       * Renderer to render status icon and status label in a cell.
       * @param  {array} props Array of property names, where there is only 1 "status" property
       * @param  {object} data  Map of values for a "status" property.
       */
      'status': function(props, data) {
         var stat = data[props[0]];

         var properties = statusFormatterService.format(stat);

         var label = _.escape(properties.label);

         return '<div ng-non-bindable class="object"><span title="' + label +
               '"><i class="' +  properties.icon +'"></i>' + label + '</span></div>';
      },

      /**
       * Renderer to render object icon and name as navigable link in a cell if
       * object id is provided, otherwise the object name is displayed as a plain text.
       * @param  {array} props Array of property names, where
       *    1st property is the object reference
       *    2nd property is the object name
       *    3rd property is the object icon
       *    4th property is a custom label to be displayed if the object name is not
       *       available, e.g. if datastore does not belong to a datastore cluster,
       *       the parentPod property of the datastore will be null, so for those
       *       datastores we could want to display a custom label, e.g. --, na, etc.
       *    5th property is a boolean defining if the object exists. If set to
       *    false, the link will be non-navigatable.
       *    6th property is tooltip title
       * @param  {object} data  Map of values for icon and label properties.
       * @param {object} config A dictionary (key/value) to control the renderer behavior.
       *  'navigatable' - controls whether a link navigating to the object should be rendered.
       */
      'object-link': function(props, data, config) {
         var objectId = data[props[0]],
               objectName = data[props[1]],
               objectIcon = props[2],
               customLabel = data[props[3]],
               targetExists = props[4],
               title = data[props[5]],
               displayText; // objectName or customLabel (if objectName not provided)

         displayText = !objectName ? customLabel : objectName;

         var isDisabled = targetExists === false;

         var navigatable = config ? config.navigatable: undefined;
         var focusable = config && config.focusable === true;

         return linkRenderer(objectId, displayText, objectIcon, isDisabled, config, title, navigatable, focusable);
      },

      /**
       * Renderer to render a custom attribute value in a cell.
       * @param {array} props Array of property names, where there is "customValue" and
       *    "@instanceUuid" properties
       * @param {object} data  Map of values for a "customValue" and "@instanceUuid"
       *    properties.
       * @param {object} config Object with custom attribute's 'key' and 'serverGuid' to
       *       identify the correct custom attribute value that matches current cell.
       *       @link config value
       */
      'custom-attr': function(props, data, config) {
         var customAttr = _.find(data.customValue, function(attr) {
            return config.key === attr.key && config.serverGuid === data['@instanceUuid'];
         });
         var value = customAttr ? customAttr.value : "";
         return textWithTooltipRenderer(value, value);
      },

      /**
       * Plain-text renderer. Used when no renderer is specified.
       * @param  {array} props Array of property names.
       * 1st property is displayed both as value and a tooltip.
       * Other properties are ignored.
       *
       * @param  {object} data  Map of values.
       *
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'text': function(props, data, unescapeCharacters) {
         return textWithTooltipRenderer(data[props[0]], undefined, unescapeCharacters);
      },

      /**
       * Plain-text renderer. Used when no renderer is specified.
       * @param  {array} props Array of property names.
       * 1st property is displayed.
       * 2nd property is the tootlip of the displayed property.
       * Other properties are ignored.
       *
       * @param  {object} data  Map of values.
       *
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'text-with-custom-tooltip': function(props, data, unescapeCharacters) {
         return textWithTooltipRenderer(data[props[0]], data[props[1]], unescapeCharacters);
      },

      /**
       * Multi-line text renderer.
       * @param  {array} props Array of property names. 1st property is displayed.
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'wrapped-text': function(props, data) {
         var value = data[props[0]] !== undefined ? data[props[0]] : '';
         return $('<div/>')
               .attr('ng-non-bindable', '')
               .addClass('line-wrap')
               .text(value)[0].outerHTML;
      },

      /**
       * Renders disabled (grayed out and in italics) text.
       * @param props Array of property names, where:
       *    1st property is the property to display,
       *    2nd property controls whether the text should be rendered as disabled.
       *        The first property will be rendered disabled only when
       *        data[ <2nd property> ] equals 'true'.
       *
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'disabled-text': function(props, data) {
         var textValue = data[props[0]] !== undefined ? data[props[0]] : '';
         var className = 'vertical-aligned-text';
         if (data[props[1]] !== undefined && data[props[1]] === true) {
            className += ' disabled-text';
         }
         return $('<span/>')
               .attr('ng-non-bindable', '')
               .addClass(className)
               .text(textValue)[0].outerHTML;
      },

      /**
       * Renders disabled (grayed out and in italics) text with an icon and a tooltip.
       * @param props Array of property names, where:
       *    1st property is the icon to display,
       *    2st property is the text to display,
       *    3nd property controls whether the text should be rendered as disabled.
       *        The first property will be rendered disabled only when
       *        data[ <2nd property> ] equals 'true'.
       *    4nd property is the tooltip of the displayed property.
       *
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'disabled-text-icon-with-tooltip': function(props, data) {
         var icon = data[props[0]];
         var text = data[props[1]];

         if (typeof text === 'undefined' || text === null) {
            text = '';
         }

         var className = 'vertical-aligned-text';
         if (data[props[2]] !== undefined && data[props[2]] === true) {
            className += ' disabled-text';
         }

         var title = data[props[3]];
         if (typeof title === 'undefined' || title === null) {
            title = text;
         }

         return "<span ng-non-bindable class='" + className + "'>" +
            "<span title='" + _.escape(title) + "' class='object'>" +
                  "<i class='" + _.escape(icon) + "'></i>" + _.escape(text) +
            "</span></span>";
      },

      /**
       * Renders number values (right-aligned).
       * @param props Array of property names, where:
       *    1st property is the property to display
       *
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'number': function(props, data) {
         var textValue = data[props[0]] !== undefined ? data[props[0]] : '';
         return $('<span/>')
               .attr('ng-non-bindable', '')
               .addClass('numeric-text')
               .text(textValue)[0].outerHTML;
      },

      /**
       * Renders an array as a comma-separated list.
       * @param  {array} props Array of property names, where 1st property is
       * the name of the array property. Other properties are ignored
       * @param  {object} data  Map of values, contains the array.
       */
      'array': function(props, data) {
         var items = data[props[0]];
         var displayText = items ? items.join(', ') : '';
         return '<div ng-non-bindable class="line-wrap">' + displayText + '</div>';
      },

      /**
       * Renders a percentage meter
       * @param  {array} props Array of property names. 1st property is displayed.
       * Other properties are ignored
       * @param  {object} data  Map of values, contains the percentage to render.
       */
       'meter': function(props, data) {
         var value = data[props[0]];
         if (!value) {
            value = 0;
         }
         if (value === -1) {
            value = i18nService.getString('CommonModuleUi', 'vm.drs.score.list.naLabel');
            return '<div>' + value + '</div>';
         }
         var labelElement = '<span ng-non-bindable>' + value + '%</span>';
         var meterElement = '<vx-resource-meter percentage="' + value + '" orientation="horizontal"/>';
         return '<div class="column-meter">' + labelElement + meterElement + '</div>';
      },

      /**
       * Renders an icon and text
       * @param  {array} props Array of property names. 1st property is icon,
       * second is text
       * @param  {object} data  Map of values
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'icon-text': function(props, data, unescapeCharacters) {
			return iconTextExRenderer(props, data, null, unescapeCharacters);
      },


      /**
       *
       *
       * @param  {array} props Array of property names. If no renderConfig is
       * specified it is expected the 1st property is the icon, second is the text.
       *
       * @param  {object} data Map of the property values.
       *
       * @param {object} rendererConfig A dictionary (key/value) to contrl the behavior.
       *    'icon' - if the key is specified it should contain the icon class that
       *       provides the icon.
       *    'iconProperty' - usually you won't specify this if you specify an 'icon'
       *       value. Use this key to specify the name of the property in the
       *       'data' map that holds the icon class.
       *    'dataProperty' - use this key to specify the name of the property in the
       *       'data' map that hold the text to show next to the icon.
       *
       *     e.g {
       *       icon: "vx-icon-vcenter"
       *     }
       *     or {
       *       icon: ["vx-warning", "vx-icon-vcenter"]
       *     }
       *
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'icon-text-ex': function(props, data, rendererConfig, unescapeCharacters) {
         return iconTextExRenderer(props, data, rendererConfig, unescapeCharacters);
      },

      /**
       * @see linkRenderer
       */
      'link': linkRenderer,

      /**
       * @see linkAndTextRenderer
       */
      'link-and-text': linkAndTextRenderer,

      /**
       * @see issueStatusRenderer
       */
      'issue-status': issueStatusRenderer
   });

   /**
    * Null-checks a string and if present, wraps it in a span with a title
    * attribute(to show a tooltip).
    * @param text the text to show
    * @param title the tooltip title to show, if not set text param will be used
    * @param unescapeCharacters (Optional) specifies whether the renderer
    * should unescape special characters such as % / and \.
    */
   function textWithTooltipRenderer(text, title, unescapeCharacters) {
      // just the falsy check incorrectly disregards 0
      if (!text && text !== 0) {
         return '';
      }

      if (typeof title === 'undefined') {
         title = text;
      }

      if (unescapeCharacters) {
         title = vimEntityEscapingService.unescapeSpecialCharacters(title);
         text = vimEntityEscapingService.unescapeSpecialCharacters(text);
      }

      return ['<span ng-non-bindable class="vertical-aligned-text"><span title="',
         _.escape(title), '">', _.escape(text), '</span></span>'].join('');
   }

   /**
    * Renders text/link with an icon.
    * @param objectId the object reference, if not set, will render plain text
    * @param text the text to show
    * @param icon the object icon
    * @param disabled if set to true, the link will be non-navigatable
    * @param options hash of additional options including "extensionName" to specify a custom extension
    * @param title the tooltip title to show, if not set text param will be used
    * @param navigatable indicates whether the link should navigate to the object or not.
    * @param focusable - if set to true the link receives a href attribute
    */
   function linkRenderer(objectId, text, icon, disabled, options, title, navigatable, focusable) {
      var anchorCssClass = '';
      var iconSpan = '';

      if (typeof title === 'undefined') {
         title = text;
      }

      var textElement;
      if (!text) {
         return '';
      }
      if (!!icon) {
         var iconAriaLabel = resourceUtil.getLocalizedEntityType(objectId);
         var iconAriaLabelAttr = "";
         if (iconAriaLabel) {
            iconAriaLabelAttr = ' aria-label="' + _.escape(iconAriaLabel) + '"';
         }
         var parts = icon.split(':');
         if (parts.length === 1) {
            parts.unshift(undefined);
         }

         var iconParts = parts;
         if (!iconParts[0]) {
            iconSpan = '<span class="' + icon + '"' + iconAriaLabelAttr + ' ></span>';
         } else if (iconParts[0] === 'clr') {
            iconSpan = '<span><clr-icon shape="' + iconParts[1] + '"' + iconAriaLabelAttr+ '></clr-icon></span>';
         }
      }
      if (disabled) {
         anchorCssClass = 'disabled-link';
      }
      // Disable navigation only when `navigatable` is explicitly specified to `false`
      if (navigatable === false) {
         anchorCssClass += ' non-navigatable-link';
      }
      if (!objectId) {
         textElement = textWithTooltipRenderer(text, title);
      } else {
         var extensionName = (options && options.extensionName) || 'vsphere.core.inventory.serverObjectViewsExtension';
         var navParams = [
            '"' + extensionName + '"',
            '"' + objectId + '"'
         ];

         if (options && options.isKendoGrid) {
            var $jqElement = $('<a/>')
               .addClass(anchorCssClass)
               .attr('onClick', "angular.element('recent-tasks-view').injector().get('navigation').navigateToViewAndObject(" + navParams.join(', ') + ")")
               .html([
                  '<span ng-non-bindable>',
                  $('<span/>').attr('title', title).text(text)[0].outerHTML,
                  '</span>'
               ].join(''));
            if (focusable === true && !$jqElement.attr('href')) {
               // just putting a href attribute to the link to make it focusable
               // in order to enable interaction when Enter or Space is pressed on it
               $jqElement.attr('href', '');
            }
            textElement = $jqElement[0].outerHTML;
         } else {
            text = _.escape(text);

            var onclick = navigatable === false ? '' : "ng-click='$root._navigateToViewAndObject(" + navParams.join(', ').replace(/"/g, '&quot;') + ")'";
            var classStr = anchorCssClass ? 'class="' + anchorCssClass + '"' : '';
            // just putting a href attribute to the link to make it focusable
            // in order to enable interaction when Enter or Space is pressed on it
            var href = focusable === true ? ' href ' : '';
            textElement = [
               '<a ' + classStr + ' ' + onclick + href + '>',
               '<span ng-non-bindable="">',
               '<span title="' + _.escape(title) + '">' + text + '</span>',
               '</span>',
               '</a>'].join('');
         }
      }
      return [
         '<div class="object object-link">',
         iconSpan,
         textElement,
         '</div>'].join('');
   }

   /**
    * Renders text with an optional link to an element in front of it.
    * I.e. link: text.
    * @param objectId the object reference, if not set, will not render link
    * @param linkText the text to show on the link, if not set, will not render link
    * @param labelIds the labelIds associated with the given objectId
    * @param plainText the text to show after the link
    * @param textFirst if true renders the text before the link
    * @param styleClass css class to be applied to the link
    */
   function linkAndTextRenderer(objectId, linkText, labelIds, plainText, textFirst, styleClass) {
      var objectLink = '';
      if (objectId && linkText) {
         var labelIdsString = resourceUtil.getTaggingLabelString(labelIds);

         var objectLinkText = textFirst
               ? linkText + labelIdsString
               : linkText + labelIdsString + ':';

         objectLink = $('<a/>')
            .attr('ng-click', '$root._navigateToObject("' + objectId + '")')
            .html([
               '<span ng-non-bindable>',
               $('<span/>')
                  .attr('title', objectLinkText)
                  .text(objectLinkText)[0].outerHTML,
               '</span>'].join(''))[0].outerHTML;
      }

      var wrappedPlainText = $('<span/>')
          .attr('title', plainText)
          .text(plainText)
          [0].outerHTML;

      var elementsArray = textFirst
            ? ['<div class ="' + styleClass + '">', wrappedPlainText, ' ', objectLink, '</div>']
            : ['<div class ="' + styleClass + '">', objectLink, ' ', wrappedPlainText, '</div>'];

      return elementsArray.join('');
   }

   /**
    * Renders an icon with status text for an issue, based on a provided status string.
    * @param status the issue status string as returned by the backend
    */
   function issueStatusRenderer(status) {

      var issueStatusToIconAndLabelMap = {
         'WARNING': {'iconClass': 'vsphere-icon-status-warning',
            'label': i18nService.getString('Common', 'issueStatus.warning')},
         'ERROR': {'iconClass': 'vsphere-icon-status-error',
            'label': i18nService.getString('Common', 'issueStatus.error')},
         'INFO': {'iconClass': 'vui-icon-info',
            'label': i18nService.getString('Common', 'issueStatus.info')},
         'QUESTION': {'iconClass': 'vsphere-icon-status-unkown',
            'label': i18nService.getString('Common', 'issueStatus.questions')}
      };

      if (!status || !issueStatusToIconAndLabelMap[status]) {
         return '';
      }

      return '<span class="' + issueStatusToIconAndLabelMap[status].iconClass + '"></span>' +
           issueStatusToIconAndLabelMap[status].label;
   }


	function iconTextExRenderer(props, data, rendererConfig, unescapeCharacters) {
		var iconClass = "undefined";
		var text = "";

		if (!rendererConfig) {
			iconClass = data[props[0]];
			text = data[props[1]];
			if (unescapeCharacters) {
				text = vimEntityEscapingService
						.unescapeSpecialCharacters(text);
			}
		} else {
			if (rendererConfig.icon) {
				iconClass = rendererConfig.icon;
			} else if (rendererConfig.iconProperty) {
				iconClass = data[rendererConfig.iconProperty];
			} else {
				iconClass = "unspecified";
			}

			if (rendererConfig.dataProperty) {
				text = data[rendererConfig.dataProperty];
				if (unescapeCharacters) {
					text = vimEntityEscapingService
							.unescapeSpecialCharacters(text);
				}
			} else {
				text = data[props[0]];
				if (unescapeCharacters) {
					text = vimEntityEscapingService
							.unescapeSpecialCharacters(text);
				}
			}
		}

		var title = _.escape(text);

		var iconHtml = '';
		if (Array.isArray(iconClass)) {
			_.each(iconClass, function(item) {
				iconHtml += '<i class="' + _.escape(item) + '"></i>';
			});
		} else {
			iconHtml = '<i class="' + _.escape(iconClass) + '"></i>';
		}

		return '<span ng-non-bindable class="object" title="' + title + '">' + iconHtml + _.escape(text) + '</span>';
	}
}]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Provides columns renderers.
 */
angular.module('com.vmware.platform.ui')
.service('columnRenderersRegistry', function() {
   'use strict';
   var columnRenderers = {};
   return {
      /**
       * Registers a column renderer with the provider.
       * @param  {string} id     Id to reference a rendere
       * @param  {function} columnRenderer The column renderer function
       */
      registerColumnRenderers: function(columnRendererConfig) {
         angular.extend(columnRenderers, columnRendererConfig);
      },
      /**
       * Retrieves a column renderer based on its id.
       * @param  {string} id Id of a column renderer
       * @return {function}    A column renderer
       */
      getColumnRenderer: function(id) {
         return columnRenderers[id];
      }
   };
});
/* Copyright 2013-2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Util methods to help managing resource logic.
 */
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').factory('resourceUtil', resourceUtil);

   resourceUtil.$inject = ['i18nService', 'defaultUriSchemeUtil'];

   function resourceUtil(i18nService, defaultUriSchemeUtil) {
      return {
         /**
          * Utility function to process and internationalize the labelIds property of an object.
          * @param labelIdsStr: labelIds property of an object - semicolon separated string
          *
          * @return Empty string if there are no label ids provided, otherwise - comma
          *    separated list of internationalized labelIds surrounded in brackets " ( )"
          *    with a leading whitespace.
          */
         getTaggingLabelString: function (labelIdsStr) {
            if (!angular.isString(labelIdsStr)) {
               return '';
            }
            var labelIds = labelIdsStr.split(';');
            var labels = [];

            labelIds.forEach(function (labelId) {
               labelId = labelId.trim();
               if (!labelId) {
                  return;
               }
               var tokens = labelId.split(':');
               var label = '';
               if (tokens.length === 2) {
                  label = i18nService.getString(tokens[0], tokens[1]);
               } else if (tokens.length === 1) {
                  label = i18nService.getString('Common', tokens[0]);
               }

               if (!label) {
                  label = labelId;
               }

               labels.push(label);
            });
            return labels.length === 0 ? '' : (' (' + labels.join(', ') + ')');
         },

         /**
          * Utility function to figure out if that element needs to be italic
          *
          * @param labelIds: labelIds property of an object - semicolon separated string
          * @param primaryIconId: primaryIconId property of an object - semicolon separated string
          *
          * @return string
          * "italic" - the elements has to be italic
          * "" - empty string when no need to be italic
          */
         getItalicClassName: function (labelIds, primaryIconId) {
            var DISCONNECTED = "disconnected";
            var NOT_RESPONDING = "notResponding";
            var INACCESSIBLE = "inaccessible";

            var isDisconnectedOrNotResponding = labelIds && ( labelIds.indexOf(DISCONNECTED) !== -1 || labelIds.indexOf(NOT_RESPONDING) !== -1 );
            var isInaccessible = primaryIconId && primaryIconId.indexOf(INACCESSIBLE) !== -1;
            return ( isDisconnectedOrNotResponding || isInaccessible ) ? "italic" : "";
         },

         /**
          * Returns the localized type for a given object or empty string in case of unknown type.
          */
         getLocalizedEntityType: function (objectId) {
            if (objectId && typeof objectId === "string") {
               var entityType = defaultUriSchemeUtil.getEntityType(objectId);
               switch (entityType) {
                  case "HostSystem":
                     return i18nService.getString("Common", "typeResource.host");
                  case "Datacenter":
                     return i18nService.getString("Common", "typeResource.datacenter");
                  case "Datastore":
                     return i18nService.getString("Common", "typeResource.datastore");
                  case "Folder":
                     if (defaultUriSchemeUtil.isRootFolder(objectId)) {
                        return i18nService.getString("Common", "typeResource.vCenter");
                     }
                     return i18nService.getString("Common", "typeResource.folder");
                  case "VirtualMachine":
                     return i18nService.getString("Common", "typeResource.vm");
                  case "ClusterComputeResource":
                     return i18nService.getString("Common", "typeResource.cluster");
                  case "VirtualApp":
                     return i18nService.getString("Common", "typeResource.vapp");
                  case "ResourcePool":
                     return i18nService.getString("Common", "typeResource.rp");
                  case "Network":
                     return i18nService.getString("Common", "typeResource.network");
                  case "VmwareDistributedVirtualSwitch":
                     return i18nService.getString("Common", "typeResource.dvs");
                  case "DistributedVirtualPortgroup":
                     return i18nService.getString("Common", "typeResource.dvpg");
                  case "StoragePod":
                     return i18nService.getString("Common", "typeResource.storagePod");
               }
            }
            return "";
         }
      };
   }
})();
/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Resizes the contained kendo grid to fill it's parent (i.e. have 100% height)
 */
angular.module('com.vmware.platform.ui').directive('vxStretchGrid', [
function() {
   'use strict';
   return {
      restrict: 'A',
      link: function(scope, element) {
         scope.$on('resize', resizeGrid);

         function resizeGrid() {
            kendo.resize(element, true);
         }

         scope.$on('kendoWidgetCreated', function(event, widget) {
            if (!widget || widget.constructor !== kendo.ui.Grid) {
               return;
            }

            widget.resize = _.wrap(widget.resize, function(originalResize) {
               var args = Array.prototype.slice.call(arguments, 1);
               // force resize
               if (args.length === 0) {
                  args.push(true);
               } else {
                  args[0] = true;
               }

               return originalResize.apply(widget, args);
            });

            widget._setContentHeight = function() {
               var that = this,
                  options = that.options,
                  height = that.wrapper.innerHeight(),
                  header = that.wrapper.children(".k-grid-header"),
                  scrollbar = kendo.support.scrollbar();

               if (options.scrollable && that.wrapper.is(":visible")) {

                  height -= header.outerHeight();

                  if (that.pager) {
                     height -= that.pager.element.outerHeight();
                  }

                  if(options.groupable) {
                     height -= that.wrapper.children(".k-grouping-header").outerHeight();
                  }

                  if(options.toolbar) {
                     height -= that.wrapper.children(".k-grid-toolbar").outerHeight();
                  }

                  if (that.footerTemplate) {
                     height -= that.wrapper.children(".k-grid-footer").outerHeight();
                  }

                  var isGridHeightSet = function(el) {
                     var initialHeight, newHeight;
                     if (el[0].style.height) {
                        return true;
                     } else {
                        initialHeight = el.height();
                     }

                     el.height("auto");
                     newHeight = el.height();

                     if (initialHeight !== newHeight) {
                        el.height("");
                        return true;
                     }
                     el.height("");
                     return false;
                  };

                  if (isGridHeightSet(that.wrapper)) { // set content height only if needed
                     if (height > scrollbar * 2) { // do not set height if proper scrollbar cannot be displayed
                        if (that.lockedContent) {
                           scrollbar = that.table[0].offsetWidth > that.table.parent()[0].clientWidth ? scrollbar : 0;
                           that.lockedContent.outerHeight(height - scrollbar);
                        }

                        that.content.outerHeight(height);
                     } else {
                        that.content.outerHeight(scrollbar * 2 + 1);
                     }
                  }
               }
            };

            resizeGrid();
         });
      }
   };
}]);

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Component, that shows a server error stack
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxErrorStack', vxErrorStack);

   function vxErrorStack() {
      return {
         restrict: 'A',
         scope: {
            vxErrorStack: '=',
            errorReportArgs: '='
         },
         template: [
            '<div class="property-value horizontal-flex-container">',
               '<span class="property">',
                  '{{::ctrl.i18n(\'errorStack.label\')}}',
               '</span>',
               // TODO semerdzhievp copy /errorReport/errorReport.jsp and
               // assets from flex container-app and enable link
               //
               // Submit error report link:
               //'<a style="margin-left:auto;" ',
               //      'ng-click="ctrl.onSubmitErrorReportClicked()" ',
               //      'title="{{::ctrl.i18n(\'SubmitErrorReport.toolTip.text\')}}">',
               //   '{{::ctrl.i18n(\'SubmitErrorReport.link.text\')}}',
               //'</a>',
            '</div>',
            '<span class="horizontal-flex-container property-value"' +
                  'ng-repeat="line in ctrl.stack track by $index"' +
                  'style="white-space: pre;">',
               '<span class="vui-icon-error-stack" ',
                  'style="flex-shrink:0;"></span>',
               '{{line}}',
            '</span>'
         ].join(''),
         controller: ErrorStackViewController,
         controllerAs: 'ctrl'
      };
   }

   var ERROR_REPORT_URL = '/h5ngc/errorReport/';

   ErrorStackViewController.$inject = ['$scope', 'i18nService', '$window'];

   function ErrorStackViewController($scope, i18nService, $window) {
      var self = this;

      self.i18n = function(key) {
         return i18nService.getString('Common', key);
      };

      self.onSubmitErrorReportClicked = function() {
         var url = ERROR_REPORT_URL + '?' +
               angular.element.param($scope.errorReportArgs);
         $window.open(url);
      };

      self.stack = $scope.vxErrorStack;
   }
})();
var platform;
(function (platform) {
    var ImageDirective = (function () {
        function ImageDirective() {
        }
        ImageDirective.prototype.link = function (scope, element, attrs) {
            var _this = this;
            scope.$watch('ngSrc', function () {
                if (attrs.ngSrc) {
                    var fixedUrl = _this.fixUrl(attrs.ngSrc);
                    attrs.$set('ngSrc', fixedUrl);
                }
            });
            scope.$watch('src', function () {
                if (attrs.src) {
                    var fixedUrl = _this.fixUrl(attrs.src);
                    attrs.$set('src', fixedUrl);
                }
            });
        };
        ImageDirective.prototype.fixUrl = function (url) {
            var fixedUrl = url.replace('resources/', h5.resourcesDirectory + "/");
            return fixedUrl;
        };
        ImageDirective.MetaStructure = {
            factory: [function () { return new ImageDirective(); }]
        };
        return ImageDirective;
    }());
    angular.module("com.vmware.platform.ui").directive('img', ImageDirective.MetaStructure.factory);
})(platform || (platform = {}));



/**
 * Accepts text of the form  "something {vm.name} with {host.otherName} and {someUnknownEntity.name}"
 * As well as an object specifying the values to replace the {variable} expressions
 * and renders HTML ready text that has navigation links inside.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('linkedText', linkedText);

   linkedText.$inject = ['defaultUriSchemeUtil', 'columnRenderersRegistry', '$compile'];

   function linkedText(defaultUriSchemeUtil, columnRenderersRegistry, $compile) {
      var getLinkHTMl = columnRenderersRegistry.getColumnRenderer('link');

      return {
         scope: {
            text: '=',
            targets: '=',
            fallbackText: '='
         },
         template: "",
         link: link
      };

      function link(scope, element) {
         scope.$watch('text', function() {
            var text = _.escape(scope.text);
            if (!scope.targets) {
               scope.targets = {};
            }

            _.every(parseEntities(text), function(entity) {
               if (getTargetEntity(entity)) {
                  var linkHTML = getLinkHTMl(getLinkTarget(entity), getLinkText(entity));
                  text = text.replace(entity, linkHTML);
                  return true;
               } else {
                  text = '<span ng-non-bindable>' + scope.fallbackText + '</span>';
                  return false;
               }
            });
            element.html(text);
            $compile(element.contents())(scope);
         }, true);


         function getTargetEntity(entity) {
            var key = entity.match(/{([^{}]+)}/)[1];
            return (scope.targets[key] || {}). entity;
         }

         function parseEntities(text) {
            return text.match(/{([^{}]+)}/g) || [];
         }

         function getLinkTarget(entity) {
            return defaultUriSchemeUtil.getVsphereObjectId(getTargetEntity(entity));
         }

         function getLinkText(entity) {
            var key = entity.match(/{([^{}]+)}/)[1];
            return (scope.targets[key] || {}).name;
         }
      }
   }
})();

angular.module('com.vmware.platform.ui').directive('vxResourceMeter', function () {
   return {
      restrict: 'E',
      replace: true,
      scope: {
         percentage: '=',
         orientation: '@'
      },
      templateUrl: 'resources/ui/components/meter/vxResourceMeter.html'
   };
});
/**
 * Clarity Modal decorators
 * - formats the title into two pieces, action and optional ( but recommended ) object title
 */
angular.module('com.vmware.platform.ui').directive('modalTitle', function() {
   return {
      restrict: 'E',
      scope: {
         primaryTitle: "=",
         secondaryTitle: "="
      },
      templateUrl: 'resources/ui/components/modal/modalTitle.html'
   };
});

/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var VxModalKeyService = (function () {
        function VxModalKeyService(vxZoneService, clarityConstants) {
            this.vxZoneService = vxZoneService;
            this.clarityConstants = clarityConstants;
        }
        VxModalKeyService.prototype.onKeydownHandler = function (event, onEsc, onEnter) {
            var _this = this;
            var code = event.which || event.keyCode;
            if (code !== this.clarityConstants.keys.ESC &&
                code !== this.clarityConstants.keys.ENTER) {
                return;
            }
            // Avoid propagation of any keydown event for ESC and ENTER since some other dialog might be
            // listening for it and trigger undesired functionality as closing the other
            // dialog when the current one on is on focus.
            event.stopImmediatePropagation();
            // Run handling inside angular otherwise
            // $digest already in progress error appears
            this.vxZoneService.runInsideAngular(function () {
                switch (code) {
                    case _this.clarityConstants.keys.ESC:
                        if (!!onEsc) {
                            onEsc();
                        }
                        break;
                    case _this.clarityConstants.keys.ENTER:
                        if (!!onEnter) {
                            onEnter();
                        }
                        break;
                }
            });
        };
        ;
        VxModalKeyService.$inject = ['vxZoneService', 'clarityConstants'];
        return VxModalKeyService;
    }());
    platform.VxModalKeyService = VxModalKeyService;
    angular.module("com.vmware.platform.ui")
        .service("vxModalKeyService", VxModalKeyService);
})(platform || (platform = {}));



/**
 * Copyright 2015 VMware, Inc. All rights reserved.
 *
 * The progress directive shows an indeterminate progress bar
 */
angular.module('com.vmware.platform.ui').directive('vxProgress', function () {
   return {
      restrict: 'E',
      templateUrl: 'resources/ui/components/progress/vxProgress.html',
      scope: {
         message: "@",
         loadingAriaLabel: "@?"
      },
      link: function (scope, element, attributes) {
         scope.message = attributes.message;
      }
   };
});
/* Copyright 2016 Vmware, Inc. All rights reserved. -- VMware Confidential */

/**
 * The static, non-transitioning progress directive shows a percentage-labeled progress bar
 * Shows an optional cancel button
 */
angular.module('com.vmware.platform.ui').directive('vxStaticProgressIndicator', function() {

   vxStaticProgressIndicatorController.$inject = ['i18nService'];

   function vxStaticProgressIndicatorController (i18nService) {
      var self = this;

      self.$onInit = function() {
         self.resources = {
            cancelTooltip: i18nService.getString('Common', 'cancel'),
            cancelEnableClass: "vui-icon-datagrid-cancel",
            cancelDisabledClass: "vui-icon-datagrid-cancel-disabled"
         };

         // derived CSS states
         self.resources.resolvedCancelClass = self.isCancelPending
            ? self.resources.cancelDisabledClass
            : self.resources.cancelEnableClass;

         if (!self.enableCancelButton) {
            self.resources.resolvedCancelClass = self.resources.cancelDisabledClass;
         }

         self.events = {
            onCancelClickEvent: function(event) {
               if (self.enableCancelButton) {
                  self.cancelCallback(event);
               }
            }
         };
      };
   }
   return {
      restrict: 'E',
      bindToController: true,
      controllerAs: "vx_spi_ctrl",
      templateUrl: 'resources/ui/components/progress/vxStaticProgressIndicator.html',
      scope: {
         progress: "=",
         enableCancelButton: "=",
         isCancelPending: "=",
         cancelCallback: "&"
      },
      controller: vxStaticProgressIndicatorController
   };

});


/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive that adds refresh functionality (both manual and auto-refresh) to the view.
 * This directive takes a isolated scope which should contain something like:
 *    {  Array of objectIds (watchObjects): ObjectIds of the objects whose properties change trigger the refresh of the view.
 *       refresh() - callback to get refresh the view.
 *       delayRefreshOnObjectUpdatesBy: Optional Time in MSecs to refresh data after a object change is detected. Use this only when you find inconsistencies
 *       where backend VC server does not change the object properties before returning.
 *    }
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxRefreshable', refreshableCtrl);

   function refreshableCtrl() {
      var directive = {
            restrict: 'A',
             scope: {
                objectIds: '@watchObjects', // Array of object Ids to watch for changes.
                refreshCallback: '&refresh',
                refreshEventTypes: '@refreshEventTypes',
                delayRefreshOnObjectUpdatesBy: '@delayRefreshOnObjectUpdatesBy',
                liveRefreshEnabled: '@',
                liveRefreshProperties: '=?',
                hasObjectStateProperty: '@'
             },
             controller: RefreshController
      };
      return directive;
   }

   RefreshController.$inject = ['$scope', '$element', '$timeout',
      'visibilityAwareDataUpdateNotificationService', 'defaultUriSchemeUtil', 'vcH5ConstantsService'];
   function RefreshController($scope, $element, $timeout,
         visibilityAwareDataUpdateNotificationService, defaultUriSchemeUtil, vcH5ConstantsService) {
      var OBJECT_DETAILS_CHANGED_EVENT = 'object-details';
      var liveRefreshEnabled = $scope.liveRefreshEnabled ?
            $scope.liveRefreshEnabled === 'true' : true;
      var relevantProperties = {};
      if (liveRefreshEnabled) {
         _.each($scope.liveRefreshProperties, function (prop) {
            relevantProperties[prop] = true;
         });
      }
      var debouncedRefreshCallback = _.debounce(function() {
         $scope.refreshCallback();
      }, vcH5ConstantsService.CHANGELOG_REFRESH_DELAY);
      var timeoutPromise = null;

      var dataUpdateEventsConfig = {};

      var refreshInvocationEventEnabled = !$scope.refreshEventTypes ||
            ($scope.refreshEventTypes.indexOf(vcH5ConstantsService.DATA_REFRESH_INVOCATION_EVENT) !== -1);
      var modelChangedEventEnabled = !$scope.refreshEventTypes ||
            ($scope.refreshEventTypes.indexOf(vcH5ConstantsService.MODEL_CHANGED_EVENT) !== -1);
      var objectDetailsChangedEventEnabled = !$scope.refreshEventTypes ||
            ($scope.refreshEventTypes.indexOf(OBJECT_DETAILS_CHANGED_EVENT) !== -1);

      if (refreshInvocationEventEnabled) {
         dataUpdateEventsConfig[vcH5ConstantsService.DATA_REFRESH_INVOCATION_EVENT] = {
            handler: $scope.refreshCallback
         };
      }

      if (modelChangedEventEnabled) {
         dataUpdateEventsConfig[vcH5ConstantsService.MODEL_CHANGED_EVENT] = {
            handler: onModelChanged,
            checker: isModelChangeRelevant
         };
      }

      if (objectDetailsChangedEventEnabled) {
         dataUpdateEventsConfig[OBJECT_DETAILS_CHANGED_EVENT] = {
            handler: onObjectDetailsChanged,
            checker: isObjectDetailsChangeRelevant
         };
      }

      var dataUpdateNotificationSubscriberId =
         visibilityAwareDataUpdateNotificationService.subscribeForDataUpdate(
            $element,
            $scope.refreshCallback,
            dataUpdateEventsConfig
         );

      function isObjectDetailsChangeRelevant(event, partialUpdate) {
         if (!$scope.objectIds || !liveRefreshEnabled) {
            return false;
         }

         if (!$scope.hasObjectStateProperty && _.isEmpty(relevantProperties)) {
            return false;
         }

         return partialUpdate.updates.some(isUpdateRelevant);
      }

      function isUpdateRelevant(update) {
         var mor = update.data;
         if(!mor) {
            return false;
         }
         var objectId = defaultUriSchemeUtil.createVmomiUri(
               mor.type, mor.value, mor.serverGuid
         );

         if ($scope.hasObjectStateProperty && $scope.hasObjectStateProperty === 'true') {
            return $scope.objectIds.indexOf(objectId) >= 0
                  && update.metadata
                  && update.metadata['hasObjectStateProperty'];
         }

         return $scope.objectIds.indexOf(objectId) >= 0
               && update.deltaProperties
               && update.deltaProperties.some(function (prop) {
                  return _.has(relevantProperties, prop);
               });
      }

      function onObjectDetailsChanged(event, partialUpdate) {
         debouncedRefreshCallback();
      }

      function isModelChangeRelevant(event, objectChangeInfo) {
         var objectIdsToWatchFor = $scope.objectIds;

         var changedId = null;
         if (objectChangeInfo.operationType === 'CHANGE') {
            changedId = objectChangeInfo.objectId;
         }

         return objectIdsToWatchFor &&
               objectIdsToWatchFor.indexOf(changedId) >= 0;
      }

      function onModelChanged(event, objectChangeInfo) {
         // Use debounced refresh if model change and live refresh updates are
         // both enabled to avoid multiple view refreshes. A debounce will not
         // ensure that in general, but should improve the chances and is easy
         // to implement.
         var refreshCallback = objectDetailsChangedEventEnabled
               ? debouncedRefreshCallback
               : $scope.refreshCallback;
         // TODO smarathe: WORKAROUND for VC bug - for cases like
         // https://bugzilla.eng.vmware.com/show_bug.cgi?id=1508760
         // In some cases, the edit action takes place on the server and
         // returns without a task (VC server bug). In this case, if there
         // is no timeout set, the view refreshes before VC server has actually
         // completed the task. For those rare mutations, let the view know
         // that it has to refresh after a timeout.
         if ($scope.delayRefreshOnObjectUpdatesBy > 0) {
            timeoutPromise = $timeout(refreshCallback, $scope.delayRefreshOnObjectUpdatesBy);
         } else {
            refreshCallback();
         }
      }

      // Cancel and nullify the promise when the scope is destroyed (meaning if the view is destroyed).
      $scope.$on('$destroy', function() {
         if (timeoutPromise) {
            $timeout.cancel(timeoutPromise);
            timeoutPromise = null;
         }

         if (dataUpdateNotificationSubscriberId !== null) {
            visibilityAwareDataUpdateNotificationService.unsubscribe(
               dataUpdateNotificationSubscriberId
            );
            dataUpdateNotificationSubscriberId = null;
         }
      });
}
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Expands all panes in a splitter if a watched value is
 * set from false to true. Unregisters the watcher
 * after that.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .directive('vxVuiSplitterExpandIf', vxVuiSplitterExpandIf);

   function vxVuiSplitterExpandIf() {

      return {
         link: link
      };

      function link(scope, element, attrs) {
         var removeWatch = scope.$watch(attrs.vxVuiSplitterExpandIf, function (newValue, oldValue) {
            if (!oldValue && newValue) {
               var splitter = element.find('[kendo-splitter]').data('kendoSplitter');
               var panes = splitter.element.find(".k-pane");

               if (panes) {
                  panes.each(function (index, pane) {
                     splitter.expand(pane);
                  });
               }
               removeWatch();
            }
         });
      }
   }
})();
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Watches the vx-vui-splitter-resize-notifier attribute and triggers
 * a resize on the contained kendo-splitter, when the value changes.
 * This directive works around a problem with split-views - if the splitter is
 * initialized before its child panes' contents, the view is not rendered
 * properly.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .directive('vxVuiSplitterResizeNotifier', vxVuiSplitterResizeNotifier);

   vxVuiSplitterResizeNotifier.$inject = ['$timeout'];

   function vxVuiSplitterResizeNotifier($timeout) {

      return {
         priority: -500,
         link: link
      };

      function link(scope, element, attrs) {
         var triggerResize = function() {
            var splitter = element.find('[kendo-splitter]').data('kendoSplitter');
            if(splitter) {
               splitter.resize(true);
            }
         };
         scope.$watch(attrs.vxVuiSplitterResizeNotifier, function(value) {
            if (typeof attrs.noDelay !== 'undefined') {
               triggerResize();
            } else {
               $timeout(triggerResize, 0);
            }
         });
      }
   }
})();
/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */

(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxTimePicker', [vxTimePicker]);

   function vxTimePicker() {
      var VALUE_MOMENT_FORMATS = ["HH:mm:ss", "HH:mm"];
      var DISPLAY_VALUE_MOMENT_FORMATS = ['HH:mm:ss', 'HH:mm'];

      return {
         restrict: "A",
         require: "ngModel",
         link: function(scope, element, attrs, ngModelCtrl) {

            function formatTime(value) {
               if (typeof value !== 'string') {
                  return '';
               }

               var valueMoment =
                     moment(value, VALUE_MOMENT_FORMATS, true);
               if (!valueMoment.isValid()) {
                  return '';
               }

               return valueMoment.format(DISPLAY_VALUE_MOMENT_FORMATS[0]);
            }

            function parseTime(displayValue) {
               if (typeof displayValue !== 'string') {
                  return '';
               }

               var displayValueMoment =
                     moment(displayValue, DISPLAY_VALUE_MOMENT_FORMATS, true);
               if (!displayValueMoment.isValid()) {
                  return '';
               }

               return displayValueMoment.format(VALUE_MOMENT_FORMATS[0]);
            }

            ngModelCtrl.$formatters.push(formatTime);
            ngModelCtrl.$parsers.push(parseTime);
         }
      };
   }
})();

/*
 * This is directly taken from
 * https://github.com/angular-ui/bootstrap/tree/master/src/position
 */
angular.module('com.vmware.platform.ui')

/**
 * A set of utility methods that can be use to retrieve position of DOM elements.
 * It is meant to be used where we need to absolute-position DOM elements in
 * relation to other, existing elements (this is the case for tooltips, popovers,
 * typeahead suggestions etc.).
 */
   .factory('positionService', ['$document', '$window', function ($document, $window) {
      'use strict';
      function getStyle(el, cssprop) {
         if (el.currentStyle) { //IE
            return el.currentStyle[cssprop];
         } else if ($window.getComputedStyle) {
            return $window.getComputedStyle(el)[cssprop];
         }
         // finally try and get inline style
         return el.style[cssprop];
      }

      /**
       * Checks if a given element is statically positioned
       * @param element - raw DOM element
       */
      function isStaticPositioned(element) {
         return (getStyle(element, 'position') || 'static' ) === 'static';
      }

      /**
       * returns the closest, non-statically positioned parentOffset of a given element
       * @param element
       */
      var parentOffsetEl = function (element) {
         var docDomEl = $document[0];
         var offsetParent = element.offsetParent || docDomEl;
         while (offsetParent && offsetParent !== docDomEl && isStaticPositioned(offsetParent)) {
            offsetParent = offsetParent.offsetParent;
         }
         return offsetParent || docDomEl;
      };

      return {
         /**
          * Provides read-only equivalent of jQuery's position function:
          * http://api.jquery.com/position/
          */
         position: function (element) {
            var elBCR = this.offset(element);
            var offsetParentBCR = {top: 0, left: 0};
            var offsetParentEl = parentOffsetEl(element[0]);
            if (offsetParentEl !== $document[0]) {
               offsetParentBCR = this.offset(angular.element(offsetParentEl));
               offsetParentBCR.top += offsetParentEl.clientTop - offsetParentEl.scrollTop;
               offsetParentBCR.left += offsetParentEl.clientLeft - offsetParentEl.scrollLeft;
            }

            var boundingClientRect = element[0].getBoundingClientRect();
            return {
               width: boundingClientRect.width || element.prop('offsetWidth'),
               height: boundingClientRect.height || element.prop('offsetHeight'),
               top: elBCR.top - offsetParentBCR.top,
               left: elBCR.left - offsetParentBCR.left
            };
         },

         /**
          * Provides read-only equivalent of jQuery's offset function:
          * http://api.jquery.com/offset/
          */
         offset: function (element) {
            var boundingClientRect = element[0].getBoundingClientRect();
            return {
               width: boundingClientRect.width || element.prop('offsetWidth'),
               height: boundingClientRect.height || element.prop('offsetHeight'),
               top: boundingClientRect.top + ($window.pageYOffset || $document[0].documentElement.scrollTop),
               left: boundingClientRect.left + ($window.pageXOffset || $document[0].documentElement.scrollLeft)
            };
         },

         /**
          * Provides coordinates for the targetEl in relation to hostEl
          */
         positionElements: function (hostEl, targetEl, positionStr, appendToBody) {

            var positionStrParts = positionStr.split('-');
            var pos0 = positionStrParts[0], pos1 = positionStrParts[1] || 'center';

            var hostElPos,
               targetElWidth,
               targetElHeight,
               targetElPos,
               shiftWidth,
               shiftHeight;
            hostElPos = appendToBody ? this.offset(hostEl) : this.position(hostEl);

            targetElWidth = targetEl.prop('offsetWidth');
            targetElHeight = targetEl.prop('offsetHeight');

            shiftWidth = {
               center: function () {
                  return hostElPos.left + hostElPos.width / 2 - targetElWidth / 2;
               },
               left: function () {
                  return hostElPos.left;
               },
               right: function () {
                  return hostElPos.left + hostElPos.width;
               }
            };

            shiftHeight = {
               center: function () {
                  return hostElPos.top + hostElPos.height / 2 - targetElHeight / 2;
               },
               top: function () {
                  return hostElPos.top;
               },
               bottom: function () {
                  return hostElPos.top + hostElPos.height;
               }
            };

            switch (pos0) {
               case 'right':
                  targetElPos = {
                     top: shiftHeight[pos1](),
                     left: shiftWidth[pos0]()
                  };
                  break;
               case 'left':
                  targetElPos = {
                     top: shiftHeight[pos1](),
                     left: hostElPos.left - targetElWidth
                  };
                  break;
               case 'bottom':
                  targetElPos = {
                     top: shiftHeight[pos0](),
                     left: shiftWidth[pos1]()
                  };
                  break;
               default:
                  targetElPos = {
                     top: hostElPos.top - targetElHeight,
                     left: shiftWidth[pos1]()
                  };
                  break;
            }

            return targetElPos;
         }
      };
   }]);
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * @ngdoc directive
 * @name com.vmware.platform.ui:vxError
 *
 * @description
 *
 * Directive to show an error tooltip on error in an input.
 * Tooltip is shown when mouseenter event is triggered on the element the directive is attached to.
 * The tooltip will be visible only if the message is not empty and isVisible is set to true. The tooltip is hidden on mouseleave or if the error message becomes empty.
 *
 * |---------|  /-----------------------|
 * | Input   | <  This is the tooltip   |
 * |---------|  \-----------------------|
 *
 *
 * ******
 * Usage:
 * ******
 *
 *  <input type="text" vx-error="booleanConfig"></input>
 *  <input type="text" vx-error="functionConfig"></input>
 *
 *  <script>
 *     $scope.booleanConfig = {
 *        message: 'Some error message',
 *        isVisible: true/false
 *     };
 *
 *     $scope.functionConfig = {
 *        message: 'Some error message',
 *        isVisible: function() {
 *          if(condition){ return true; }
 *          return false;
 *        }
 *     };
 *  </script>
 *
 *<BR>
 *
 *
 *
 * @element input
 * @priority default
 *
 */
(function () {
   'use strict';
angular.module('com.vmware.platform.ui')
   .directive('vxError', [
      '$compile', '$window', '$rootScope', 'positionService',
      function($compile, $window, $rootScope, positionService) {

         return {
            restrict: 'EA',
            require: 'ngModel',
            scope: {
               'vxError': '=' // two way binding
            },
            link: function(scope, element, attrs, ctrl) {
               element.bind('mouseenter focusin', show);
               element.bind('mouseleave focusout', hide);

               var bodyElement = angular.element($window.document.body);
               var templateElement;
               var tooltipId = 'vxError-' + Date.now();

               scope.getMessage = function() {
                  if (!scope.vxError) {
                     return '';
                  }
                  if (typeof(scope.vxError.message) === 'function') {
                     return scope.vxError.message();
                  }

                  return scope.vxError.message;
               };

               var template = '<div class="vx-error-tooltip tooltip right in" ' +
                  'role="tooltip" aria-hidden="false" id="' + tooltipId + '">' +
                  '<div class="tooltip-arrow"></div>' +
                  '<div class="tooltip-inner">{{getMessage()}}</div>' +
                  '</div>';

               templateElement = $compile(template)(scope);

               function positionTooltip() {
                  var ttPosition = positionService.positionElements(element, templateElement, 'right', true);
                  ttPosition.top += 'px';
                  ttPosition.left += 'px';

                  templateElement.css(ttPosition);
               }

               function show() {
                  var isErrorMessageVisible;
                  if (typeof(scope.vxError.isVisible) === 'function') {
                     isErrorMessageVisible = scope.vxError.isVisible.call(scope.vxError, ctrl);
                  } else if (typeof(scope.vxError.isVisible) === 'boolean') {
                     isErrorMessageVisible = scope.vxError.isVisible;
                  }
                  if (isErrorMessageVisible) {
                     bodyElement.append(templateElement);
                     positionTooltip();
                     element.attr('aria-describedby', tooltipId);
                  }
               }

               function hide() {
                  if (templateElement) {
                     templateElement.remove();
                     element.removeAttr('aria-describedby');
                  }
               }

               scope.$on('$destroy', function() {
                  if (templateElement) {
                     templateElement.remove();
                  }
                  cancelOnMessageChange();
               });

               var cancelOnMessageChange = scope.$watch('vxError.message', function(value) {
                  if (_.isEmpty(value)) {
                     hide();
                  }
               });
            }
         };
      }
   ]);
}());

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn format numbers into the closest byte unit Eg: 1024 to 1 kB,
 * 1024*1024 to 1 MB
 */
// originally from https://gist.github.com/thomseddon/3511330
angular.module('com.vmware.platform.ui').filter('bytes', bytesFilter);

bytesFilter.$inject = ['numberFormatterService'];

function bytesFilter (numberFormatterService) {
   'use strict';

   return function (bytes, sourceUnit, targetUnit, fractionSize) {
      return numberFormatterService.formatStorage(bytes, sourceUnit, targetUnit, fractionSize);
   };
}

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Display a mhz value as either MHz or GHz depending on the magnitude
 */
angular.module('com.vmware.platform.ui').filter('cpuClock', cpuClockFilter);

cpuClockFilter.$inject = ['i18nService', 'numberFormatterService'];

function cpuClockFilter(i18nService, numberFormatterService) {
   'use strict';
   return function (cpuMhz) {
      var suffixMHz = i18nService.getString('VmUi', "VmCpu.MHz");
      var suffixGHz = i18nService.getString('VmUi', "VmCpu.GHz");

      if (cpuMhz < 0) {
         return i18nService.getString('VmUi', "labelUnlimited");
      }

      var suffix;

      if (((cpuMhz % 1000) === 0) && (cpuMhz > 0)) {
         cpuMhz = cpuMhz / 1000;
         suffix = suffixGHz;
      } else {
         suffix = suffixMHz;
      }

      return numberFormatterService.format(cpuMhz, { suffix: suffix });
   };
}

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Takes in the resource-info valueTypeName and apply a default formatter to it
 */
angular.module('com.vmware.platform.ui').filter('dataFormat', ['$filter',
function($filter) {
   return function(raw, valueTypeName) {

      // valueTypeName to formatter definition
      var map = {
            'Storage.B' : {
               name: 'bytes'
            }
      };
      var meta = map[valueTypeName];
      if (!meta) {
         return raw;
      }

      return $filter(meta.name)(raw);
   };
}]);
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn boolean into @trueValue/@falseValue or Yes/No by default
 */
angular.module('com.vmware.platform.ui').filter('dateLocale', ['timeFormatterService',
   function(timeFormatterService) {
      'use strict';
      return function(value) {
         return timeFormatterService.timestampToText(value);
      };
   }]);
/**
 * Created by vmware on 12/2/16.
 */
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn boolean into @trueValue/@falseValue or Enabled/Disabled by default
 */
angular.module('com.vmware.platform.ui').filter('enabled', ['$filter', 'i18nService',
   function($filter, i18nService) {
      'use strict';
      return function(value, trueValue, falseValue) {
         trueValue = trueValue || i18nService.getString("Common", "enabled");
         falseValue = falseValue || i18nService.getString("Common", "disabled");

         value = !!value;
         return value ? trueValue : falseValue;
      };
   }]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turns floating point numbers into integers always rounding to the higher integer using Math.ceil
 */

angular.module('com.vmware.platform.ui').filter('ceil', function() {
   return function(input) {
      return Math.ceil(input);
   };
});
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Reverse an array
 */
angular.module('com.vmware.platform.ui').filter('reverse', [
function() {
   return function(items) {
      return items.slice().reverse();
    };
}]);
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Adds the cancelOnDestroy: $scope, option to $http() requests. When specified, the http
 * request will be automatically aborted if the scope $destroy event fires.
 */
angular.module('com.vmware.platform.ui').config(["$httpProvider", function($httpProvider) {

   $httpProvider.interceptors.push(["$q", function($q) {
      return {
         'request' : function(config) {
            if (config.cancelOnDestroy) {
               var deferred = $q.defer();

               config.timeout = deferred.promise;
               config.cancelOnDestroy.$on("$destroy", function(){
                  deferred.resolve();
               });
            }

            return config;
         }
      };
   }]);

}]);

/* Copyright 2014 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Http request interceptor which injects custom header for each request made from angular.
     *
     * TODO review if this is still needed now that we have RequestWrapperInterceptor in Angular
     */
    var RequestInterceptor = (function () {
        function RequestInterceptor(userSessionService, $window, $q) {
            var _this = this;
            this.userSessionService = userSessionService;
            this.$window = $window;
            this.$q = $q;
            this.vac_url = "https://vcsa.vmware.com";
            this.request = function (config) {
                // If logout is in progress, any requests that occur in the meantime have to be
                // blocked from executing as at this point it is possible the client session
                // to be already invalidated. By blocking the requests and not rejecting them
                // altogether, it is being prevented executing callers' error handlers
                // and showing unnecessary errors before the logout actually completes.
                if (_this.$window.h5.isLogoutInProgress) {
                    return _this.$q.defer().promise;
                }
                var requestUrl = new URL(config.url, document.baseURI);
                var clientUrl = new URL(document.baseURI);
                // add the header only for requests made to /ui and on the primary hostname
                var addSessionIdHeader = _this.userSessionService.webClientSessionId &&
                    /^\/ui(\/.*)?$/.test(requestUrl.pathname) && requestUrl.hostname === clientUrl.hostname;
                if (addSessionIdHeader) {
                    //Add web client session id to the request header, needed to
                    //an application other than h5ngc (DispatcherServlets of the plugins).
                    config.headers[_this.userSessionService.WEB_CLIENT_SESSION_ID] =
                        _this.userSessionService.webClientSessionId;
                }
                return config;
            };
        }
        return RequestInterceptor;
    }());
    platform.RequestInterceptor = RequestInterceptor;
    angular.module('com.vmware.platform.ui').factory('requestInterceptor', [
        'userSessionService', '$window', '$q', function (userSessionService, $window, $q) {
            return new RequestInterceptor(userSessionService, $window, $q);
        }]);
    angular.module('com.vmware.platform.ui').config(['$httpProvider', function ($httpProvider) {
            $httpProvider.interceptors.push('requestInterceptor');
            // change all GET headers to contain Pragma: no-cache header
            // this is required for IE 10/11 to prevent it from caching GET requests and
            // forcing all GET requests to hit the server.
            // https://github.com/saintmac/angular-cache-buster may be a better solution
            // initialize get if not there
            if (!$httpProvider.defaults.headers.get) {
                $httpProvider.defaults.headers.get = {};
            }
            //disable IE ajax request caching
            $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';
        }]);
})(platform || (platform = {}));



/* Copyright 2014-2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Http interceptor to handle ajax timeout errors.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .factory('responseErrorInterceptor', responseErrorInterceptor);

   responseErrorInterceptor.$inject = ['$q', '$injector', '$window', 'sessionExpiredModalService'];

   function responseErrorInterceptor($q, $injector, $window, sessionExpiredModalService) {
      var isErrorShown = false;
      var loginUrl;

      var interceptor = {
         responseError: function (response) {
            // If the app is navigating away, don't throw errors.
            if (response.status === -1) {
               var neverResolvingPromise = $q.defer().promise;
               return neverResolvingPromise;
            }

            // If the error is due to session timeout, then logout.
            if (response.status === 401 && !isErrorShown) {
               // The application is loading for the first time and we check whether
               // the user is authenticated. If authentication check fails, we redirect
               // to the login page (see redirect.js). The application may try to access
               // secure resources before the authentication check completes and we will
               // receive "401" response. In this case don't show alert and directly
               // navigate to the login page.
               if (!$window.h5.isLoggedIn) {
                  if (!loginUrl) {
                     var applicationConstants = $injector.get('vscApplicationConstantsService');
                     loginUrl = applicationConstants.loginUrl;
                  }
                  $window.location.href = loginUrl;
                  return;
               }

               isErrorShown = true;

               sessionExpiredModalService.open(false);
            }

            return $q.reject(response);
         },

         isErrorShown: function() {
            return isErrorShown;
         }
      };

      return interceptor;
   }

   angular.module('com.vmware.platform.ui').config(['$httpProvider',
      function ($httpProvider) {
         $httpProvider.interceptors.push('responseErrorInterceptor');
      }
   ]);
}());

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function () {
   'use strict';
   /**
    * Service to alter the browser window history title (inherently the document.title) on each router (UR) change.
    */
   angular.module('com.vmware.platform.ui').factory('browserHistoryService',
   ['$document', 'i18nService', function ($document, i18nService) {
      var savedObjectId, savedObjectName, savedViewName, savedAdditionalText;
      var productName =  i18nService.getString('Common', 'productName');
      var productNameWithSucceedingDash = productName + " - " ;

      return {
         setBrowserTitle: setBrowserTitle,
         notifyCurrentObjNameChanged: notifyCurrentObjNameChanged
      };

      /**
       * Sets the browser title to the title like
       * '<objectName> - <viewName>[: "<additionalText>"] - <productName>'
       * based on the current context. The additionalText may or may not be present.
       *
       * @param tree
       *    Navigation Tree
       * @param objectId
       *    Optional objectId
       * @param additionalText
       *    Optional additional text to be displayed after the view name
       */
      function setBrowserTitle(tree, objectId, additionalText) {
         if (!($document) || !($document[0])) {
            return;
         }
         if (objectId) {
            setTitleWithObject(tree, objectId, additionalText);
            return;
         }
         setTitle(null, tree, additionalText);
      }

      /**
       * Gives the name for the object with objectId .
       * @param objectId
       *    Object Identifier whose name is given in second param
       * @param objectName
       *    Name of the object.
       */
      function notifyCurrentObjNameChanged(objectId, objectName) {
         if (savedObjectId === objectId) {
            savedObjectName = objectName;
            setTitle(savedObjectName);
         }
      }

      // Private functions
      /**
       * Sets the title of the browser given a tree and objectId.
       * If the savedObjectId is the same as the objectId given, the savedObjectName is used in the title
       * else the we cache the new objectId and clean up the savedObjectName and show nothing for object name
       * in the title.
       * @param tree - NavigationTree
       * @param objectId - objectId
       * @param additionalText
       */
      function setTitleWithObject(tree, objectId, additionalText) {
         if (objectId) {
            if (savedObjectId !== objectId) {
               savedObjectId = objectId;
               savedObjectName = null;
            }
            setTitle(savedObjectName, tree, additionalText);
         }
      }

      function setTitle(partialTitle, tree, additionalText) {
         // The general title format is:
         // <product name> - <partialTitle> - <view name>[: <additionalText>].
         var title = "";
         if (partialTitle) {
            title = partialTitle;
         }
         if (tree) {
            savedViewName = getSelectedLeafNodeName(tree);
            savedAdditionalText = additionalText;
         }
         if (isValidNodeName(savedViewName)) {
            if (title) {
               title += " - " + savedViewName;
            } else {
               title = savedViewName;
            }
         }
         if (title) {
            title = productNameWithSucceedingDash + title;
         } else {
            title = productName;
         }
         if (additionalText) {
            savedAdditionalText = additionalText;
         }
         if (savedAdditionalText) {
            title += ': "' + savedAdditionalText + '"';
         }
         if ($document && $document[0]) {
            $document[0].title = title;
         }
      }

      /**
       * Gets the name of the lead node of the NavigationTree.
       * In case of relatedObjectViews, label is used.
       *
       * @param tree - NavigationTree
       */
      function getSelectedLeafNodeName(tree)  {
         var leafNode = tree.getSelectedLeafNode();
         if (leafNode) {
            if (leafNode.name) {
               return leafNode.name;
            } else {
               return leafNode.label;
            }
         }
         return "";
      }

      function isValidNodeName(name) {
         // This, alas, is a hack. Blame it on the genius decision to
         // use a random string for the name of a non-existing leaf node.
         // Otherwise the 'missing name' creeps into our browser history.
         // Unlocalized. Because it is hard-coded.
         return name && name !== '(missing name)';
      }
   }]);

})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Url routing.
 *
 * Supports nested <vx-view> directive backed by a tree data structure.
 *
 * Originally inspired by ui-router.
 *
 */
var platform;
(function (platform) {
    "use strict";
    var Navigation = (function () {
        function Navigation($rootScope, $location, $http, $templateCache, $q, $log, navigationTreeService, navigationPreferenceService, browserHistoryService, urlService, telemetryTimeTrackerFactory, navigationConstants, ngMigrationHelper, currentObjectService, defaultUriSchemeUtil, routingService) {
            this.$rootScope = $rootScope;
            this.$location = $location;
            this.$http = $http;
            this.$templateCache = $templateCache;
            this.$q = $q;
            this.$log = $log;
            this.navigationTreeService = navigationTreeService;
            this.navigationPreferenceService = navigationPreferenceService;
            this.browserHistoryService = browserHistoryService;
            this.urlService = urlService;
            this.telemetryTimeTrackerFactory = telemetryTimeTrackerFactory;
            this.navigationConstants = navigationConstants;
            this.ngMigrationHelper = ngMigrationHelper;
            this.currentObjectService = currentObjectService;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.routingService = routingService;
            this.route = {};
            this.previousRoute = {};
            this.offLocationChangeSuccess = null;
            this.retries = 0;
        }
        Navigation.prototype.getTree = function () {
            return this.tree;
        };
        Navigation.prototype.getRoute = function () {
            return this.route;
        };
        /**
         * Gets the navigation context associated with the last navigation.
         */
        Navigation.prototype.getNavigationContext = function () {
            return this.route._navigationParam;
        };
        /**
         * Gets the navigator used in the last navigation.
         * The navigator can be the inventory tree, object navigator or any specific tree view
         * (vm, compute, storage, networking).
         */
        Navigation.prototype.getNavigator = function () {
            return h5.ngMigrationEnabled ? this.routingService.getNavigator() : this.route.navigator;
        };
        // Gets the current object id (focused object in workspace)
        Navigation.prototype.getObjectId = function () {
            return h5.ngMigrationEnabled ? this.currentObjectService.getObjectId() : this.getRoute().objectId;
        };
        Navigation.prototype.getQueryParams = function () {
            if (h5.ngMigrationEnabled) {
                return this.routingService.getRootActivatedRoute().snapshot.queryParams;
            }
            else {
                return this.$location.search();
            }
        };
        Navigation.prototype.getPreviousRoute = function () {
            return this.previousRoute;
        };
        Navigation.prototype.populateScope = function (scope) {
            var self = this;
            angular.extend(scope, {
                _route: self.route,
                _navigate: self.navigate.bind(self),
                _navigateToObject: self.navigateToObject.bind(self),
                _navigateToViewAndObject: self.navigateToViewAndObject.bind(self),
                _navigateToView: self.navigateToView.bind(self)
            });
        };
        Navigation.prototype.fetch = function (searchParam, options) {
            var _this = this;
            // If this call is coming because of navigate(), we might have already
            // got the tree for this extensionId and objectId if extensionId is 'serverObjectView'.
            if (this.tree
                && this.extensionId && this.extensionId === searchParam.extensionId
                && this.objectId && this.objectId === searchParam.objectId
                && this.relatedItem === searchParam.relatedItem) {
                // Cancel previous request to avoid late http resolve with the wrong data.
                this.navigationTreeService.cancelPrevious();
                // Reuse once is enough since we want to deal with only back-to-back fetch() calls only.
                this.extensionId = null;
                this.objectId = null;
                this.relatedItem = undefined;
                return this.$q.resolve(this.tree);
            }
            // Optimization added that when the user is on the search view and the search view is requested again,
            // send the same navigation tree. The navigationTree for search view is constant and does not depend on the
            // query or any dynamic user input.
            if (this.tree && this.extensionId && this.extensionId === searchParam.extensionId
                && this.extensionId === this.navigationConstants.SEARCH_VIEW_EXTENSION_ID) {
                return this.$q.resolve(this.tree);
            }
            var cancellable = !(options && options.cancellable === false);
            return this.navigationTreeService
                .fetchNavigationTree(searchParam, cancellable).then(function (tree) {
                _this.tree = tree;
                _this.extensionId = searchParam.extensionId;
                _this.objectId = searchParam.objectId;
                _this.relatedItem = searchParam.relatedItem || undefined;
                return tree;
            }, function (err) {
                return _this.$q.reject(err);
            });
        };
        Navigation.prototype.getRouteFromUrl = function () {
            var search = this.$location.search();
            if (search.objectId === 'null') {
                search.objectId = null;
            }
            var route = angular.copy(search);
            if (!search.extensionId && !search.objectId && !search.navigator) {
                // front page
                // Create an empty route
                route.extensionId = null;
                route.objectId = null;
                route._frontPage = true;
            }
            // helper function to get additional query params from the route or from a passed argument
            // checks through a list of params and returns the rest
            route.getAdditionalParams = function (nav) {
                var r = (nav === undefined) ? this : nav;
                var queryParams = {};
                var PARAMS = ['extensionId', 'objectId', '_navigationParam'];
                for (var key in r) {
                    if (PARAMS.indexOf(key) === -1 && !angular.isFunction(r[key])) {
                        queryParams[key] = r[key];
                    }
                }
                return queryParams;
            };
            return route;
        };
        Navigation.prototype.navigateToServerObject = function (searchParam, navParam) {
            var _this = this;
            if (h5.ngMigrationEnabled) {
                return;
            }
            this.applyUserRoutePreferences(searchParam)
                .then(function (route) {
                return _this.fetch(route);
            })
                .then(function (tree) {
                if (searchParam.extensionId !== _this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID) {
                    // Navigating to non default extension. Check extension availability.
                    var node = tree.getById(searchParam.extensionId);
                    if (!node || !node.parent || node.parent.$childIndexToActivate < 0) {
                        // The object either has no node with this extension or other node should be activated.
                        // Navigate to nodeToActivate extension
                        var nodeToActivate = _this.tree.getSelectedLeafNode();
                        searchParam.extensionId = nodeToActivate.$id;
                    }
                }
                _this.retries = 0;
                var location = _this.$location.search();
                // The corner case which the above if is handling happens
                // from time to time on the pipe line, when it is run against
                // Edge or Firefox browser.
                // The test logs in and navigates to the vCenter object in the tree.
                // In very rare cases the UI has already navigated to the server
                // object when the code above is executed,and the URL is already
                // changed. In this case if the test navigates to object navigator
                // view by changing the browser URL directly in the browser
                // address bar and the "this._navigationParam" is true in this
                // moment, the ObjectNavigatorController doesn’t switch from
                // tree to object navigator mode.
                //
                // The change of URL directly in the browser address bar is
                // handled in the onLocationChange() method of this service
                // which calls methods which get this._navigationParam and
                // adds it to the new route which will cause a new navigation.
                // The new navigation is triggered, the ObjectNavigatorController
                // is notified for route change but when it sees  _navigationParam = true
                // parameter in the route, it doesn’t switch from tree to object
                // navigator view.
                // In order to prevent this we check whether the $location
                // service returns the same route to which we want to navigate
                // (the searchParam param route) and don’t set this._navigationParam
                // to true.
                // This is safe because the setting of searchParam to the $location
                // service will not change the URL and will not trigger
                // navigation.
                if (JSON.stringify(location) !== JSON.stringify(searchParam) ||
                    navParam !== true) {
                    _this._navigationParam = navParam;
                }
                var search = _this.$location.search(searchParam);
                // Caution, the following should be regarded as a hack/patch. It
                // handles a couple of very specific cases that occur rarely, but
                // lead to some weird behavior, e.g. the browser history buttons
                // not working properly. A lot of issues related to browser
                // navigation are caused by the fact that 'navigation' in the H5
                // client does not necessarily correspond to a single URL change,
                // in fact there are cases where more than two calls to
                // $location.search() are made. Note that a call to search() without
                // replace() causes a new history record to be written. If you ever
                // come across issues with browser navigation, watch out for multiple
                // calls to $location.search().
                //
                // Without further ado, the special cases are the following:
                // 1) The previous call to $location.search() was made as a result
                // of handling an inventory tree event (in that case the extensionId
                // is a vi tree id).
                // 2) The only modified URL parameter is 'navigator' with the
                // additional restriction that the previous value was the bogus
                // 'tree' and the new value is one of the tree IDs. For example this
                // can happen when navigating using hyperlinks and the navigator is
                // changed from object selector to inventory tree.
                if (location
                    && ((location.extensionId
                        && _.contains(_this.navigationConstants.NAVIGATOR_IDS, location.extensionId))
                        || (location.extensionId === searchParam.extensionId
                            && location.objectId === searchParam.objectId
                            && location.navigator === "tree"
                            && _.contains(_this.navigationConstants.NAVIGATOR_IDS, searchParam.navigator)))) {
                    search.replace();
                }
            }, function (err) {
                if (_this.retries >= _this.navigationConstants.RETRIES_THRESHOLD) {
                    _this.retries = 0;
                    return _this.$q.reject(err);
                }
                if (err.status !== 500) {
                    return _this.$q.reject(err);
                }
                _this.retries++;
                // We failed to retrieve the extension id. Clear the invalid extension id in
                // the local storage and navigate the user to the first object tab.
                _this.navigationPreferenceService.invalidate(searchParam.objectId);
                _this.navigate(_this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID, searchParam.objectId);
                return _this.$q.reject(err);
            });
        };
        Navigation.prototype.navigateToRelatedObject = function (objectId, relation, relatedItemUri) {
            if (h5.ngMigrationEnabled) {
                this.routingService.navigateToRelatedObject(objectId, relation, relatedItemUri);
                return;
            }
            var searchParam = angular.extend({}, {
                extensionId: this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID,
                objectId: objectId
            });
            this.$location.search(searchParam);
        };
        Navigation.prototype.navigateWorkspaceToView = function (extensionId, queryParams, navigationContext) {
            this.routingService.navigateWorkspaceToView(extensionId, queryParams, navigationContext);
        };
        Navigation.prototype.navigate = function (extensionId, objectId, arg, _navigationParam) {
            //all navigation does is set the url in the correct format so onLocationChange can read it back
            _navigationParam = _navigationParam || this._navigationParam || true;
            arg = arg || {};
            // special case for related item
            if (arg.relatedItemParentId) {
                arg.relatedItem = extensionId;
                extensionId = arg.relatedItemParentId;
                delete arg.relatedItemParentId;
            }
            var searchParam = angular.extend({
                extensionId: extensionId,
                objectId: objectId
            }, arg);
            if (h5.ngMigrationEnabled) {
                this.routingService.navigate(extensionId, objectId, arg, _navigationParam);
                return;
            }
            var currView = this.$location.search();
            if (angular.equals(currView, searchParam)
                || (searchParam.extensionId === this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID
                    && searchParam.objectId === currView.objectId
                    && searchParam.navigator === currView.navigator)) {
                return;
            }
            // start time counter for the current navigation request
            this.telemetryTimeTracker.startTimeTracking();
            if (searchParam.objectId) {
                this.navigateToServerObject(searchParam, _navigationParam);
            }
            else {
                this._navigationParam = _navigationParam; //see note at variable declaration
                this.$location.search(searchParam);
                this.telemetryTimeTracker.stopTimeTracking();
            }
        };
        Navigation.prototype.init = function () {
            this.telemetryTimeTracker = this.telemetryTimeTrackerFactory.createTelemetryTracker(this.navigationConstants.NAVIGATION_REQUEST_DURATION_MEDIAN, this.navigationConstants.NAVIGATION_REQUEST_BUFFER_TIME_PROP);
            if (!h5.ngMigrationEnabled) {
                this.route = angular.copy(this.getRouteFromUrl());
            }
            this.populateScope(this.$rootScope);
        };
        Navigation.prototype.doInitialRouting = function () {
            var _this = this;
            if (h5.ngMigrationEnabled) {
                this.$q.when(this.route);
            }
            else {
                var applyUserPreferencesIfNeeded = this.route._frontPage ?
                    this.applyUserRoutePreferences(this.route) :
                    this.$q.when(this.route);
                return applyUserPreferencesIfNeeded.then(function (route) {
                    if (route._frontPage) {
                        _this.$location.search({
                            extensionId: route.extensionId || _this.navigationConstants.DEFAULT_CLIENT_LOCATION
                        }).replace();
                    }
                    return _this.onLocationChange({ cancellable: false, forceNavigate: true }).then(function () {
                        // Subscribe for $locationChangeSuccess here so that
                        // onLocationChange() does not get fired twice when initially loading
                        // the client where we change the browser location through
                        // this.$location.search() call.
                        _this.subscribeForLocationChange();
                    }, function (err) {
                        _this.$log.error(err);
                        _this.subscribeForLocationChange();
                    });
                });
            }
        };
        Navigation.prototype.navigateToObject = function (objectId, context) {
            var finalContext = angular.extend({ navigator: "tree" }, context);
            if (h5.ngMigrationEnabled) {
                var queryParams = angular.extend({}, context);
                this.routingService.navigateToServerObject(objectId, null, finalContext.navigator, queryParams);
            }
            else {
                this.navigate(this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID, objectId, finalContext, { triggerONChange: true });
            }
        };
        Navigation.prototype.navigateToViewAndObject = function (extensionId, objectId, context) {
            var finalContext = angular.extend({ navigator: "tree" }, context);
            if (h5.ngMigrationEnabled) {
                var queryParams = angular.extend({}, context);
                // The navigateToViewAndObject method can be called from htmlBridgeService and the provided objectId
                // can be null or undefined, to handle this case we call navigateToView method of routing service
                // when objectId in null or undefined
                if (objectId) {
                    this.routingService.navigateToServerObject(objectId, extensionId, finalContext.navigator, queryParams);
                }
                else {
                    this.routingService.navigateToView(extensionId, queryParams);
                }
            }
            else {
                this.navigate(extensionId, objectId, finalContext, { triggerONChange: true });
            }
        };
        Navigation.prototype.navigateToView = function (extensionId, context) {
            if (h5.ngMigrationEnabled) {
                var queryParams = angular.extend({}, context);
                this.routingService.navigateToView(extensionId, queryParams);
            }
            else {
                this.navigate(extensionId, null, context, { triggerONChange: true });
            }
        };
        Navigation.prototype.shouldReload = function (node, previousNode, route, previousRoute) {
            return (route.objectId !== previousRoute.objectId);
        };
        Navigation.prototype.onLocationChange = function (options) {
            var _this = this;
            this.telemetryTimeTracker.stopTimeTracking();
            var route = this.getRouteFromUrl();
            var cancellable = !(options && options.cancellable === false);
            if (options && options.forceNavigate === true) {
                route.forceNavigate = true;
            }
            //TODO: corner case:
            // Eg: navigate to host view (which shows the host summary tab), then navigate to host summary tab
            // two possible approaches:
            // 1. if we navigate to a middle of the tree, we might want to replace the url with the leaf extId
            // 2. OR, fetch on navigate, if returned tree is same, then do nothing.
            var promise = this.fetch(route, { cancellable: cancellable }).then(function (tree) {
                return _this.handleRelatedItemLeafNode(tree, route);
            }, function (err) {
                if (_this.retries >= _this.navigationConstants.RETRIES_THRESHOLD) {
                    _this.retries = 0;
                    return _this.$q.reject(err);
                }
                if (err.status !== 500) {
                    return _this.$q.reject(err);
                }
                _this.retries++;
                var newRoute = _this.$location.search();
                // We failed to retrieve the extension id. Clear the invalid extension id in
                // the local storage and navigate the user to the first object tab.
                if (newRoute.objectId) {
                    newRoute.extensionId = _this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID;
                    _this.navigationPreferenceService.invalidate(route.objectId);
                }
                else {
                    newRoute.extensionId = _this.navigationConstants.HOME_EXTENSION_ID;
                }
                // Conditionally subscribe for location change in case this method was
                // called directly from the init() method. This is the case where user
                // opens the browser and navigates to an invalid URL or to an invalid
                // bookmark or there is invalid URL in the local storage.
                _this.subscribeForLocationChange();
                _this.$location.search(newRoute).replace();
                return _this.$q.reject(err);
            });
            route._navigationParam = this._navigationParam;
            this._navigationParam = null; // see note above
            return promise.then(function (tree) {
                _this.browserHistoryService.setBrowserTitle(tree, route.objectId, route.query);
                if (tree.constructor !== NavigationTree) {
                    throw 'tree needs to be of type NavigationTreeModel';
                }
                _this.tree = tree;
                angular.copy(_this.route, _this.previousRoute);
                angular.copy(route, _this.route);
                return _this.precacheTemplates(_this.tree).then(function () {
                    _this.preCacheTemplateCallback(route);
                }, function (err) {
                    _this.$log.error("Failed to retrieve one or more html templates." + err);
                    _this.preCacheTemplateCallback(route);
                });
            });
        };
        // load all html templates to reduce flickering
        // this fetches the navi path htmls + sibling htmls.
        // We could stop fetching siblings if this is too aggressive.
        Navigation.prototype.precacheTemplates = function (tree) {
            var _this = this;
            var promises = [];
            tree.everyNode(function (node) {
                // url used in iframe src is not a template so no request should be sent
                var iframeRelated = node.contentSpec && node.contentSpec.sandbox;
                if (node.$templateUrl && !iframeRelated) {
                    promises.push(_this.$http.get(node.$templateUrl, { cache: _this.$templateCache }));
                }
            });
            return this.$q.all(promises);
        };
        Navigation.prototype.preCacheTemplateCallback = function (route) {
            if (route.extensionId
                && route.extensionId !== this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID) {
                this.navigationPreferenceService.persistLastExtension(route.objectId, route.extensionId, route.relatedItem, route.navigator);
            }
            // this is to trigger all existing <vx-view> to tell them to update themselves
            this.$rootScope.$broadcast('vxRouteChangeSuccess', this.tree, this.route, this.previousRoute);
        };
        Navigation.prototype.subscribeForLocationChange = function () {
            var _this = this;
            if (!this.offLocationChangeSuccess) {
                this.offLocationChangeSuccess =
                    this.$rootScope.$on('$locationChangeSuccess', function (event, newUrl, oldUrl) {
                        // Don't handle URL changes if only the list view selection
                        // parameter was changed (we're not really changing location
                        // in this case).
                        newUrl = _this.urlService.removeParameter(newUrl, h5.listViewSelectedItemIdProperty);
                        oldUrl = _this.urlService.removeParameter(oldUrl, h5.listViewSelectedItemIdProperty);
                        if (newUrl !== oldUrl) {
                            _this.onLocationChange();
                        }
                    });
            }
        };
        // code to handle relatedItems as they come from a different endpoint
        // if the leaf node has related items as children, we fetch from a different endpoint
        // and add the results as its children into the tree
        Navigation.prototype.handleRelatedItemLeafNode = function (tree, route) {
            var leaf = tree.getSelectedLeafNode();
            if (!(leaf.extensionObject &&
                leaf.extensionObject.contentSpec &&
                leaf.extensionObject.contentSpec.metadata &&
                (leaf.extensionObject.contentSpec.metadata.fetchRelatedAsChildren ||
                    leaf.extensionObject.contentSpec.metadata.showRelationsFor))) {
                return this.$q.resolve(tree);
            }
            if (leaf.$children.length !== 0) {
                throw "Assumption violated: any extension with fetchRelatedAsChildren or " +
                    "showRelationsFor set should not have any children as they come " +
                    "from a different data structure";
            }
            var url;
            var params = {
                relationsViewId: leaf.uid
            };
            if (leaf.extensionObject.contentSpec.metadata.fetchRelatedAsChildren) {
                url = 'relateditems/list/' + route.objectId;
            }
            else {
                url = 'relateditems/listspec/' + leaf.extensionObject.contentSpec.metadata.showRelationsFor;
                params.onlyFavorites = false;
            }
            return this.$http({
                method: 'get',
                url: url,
                params: params
            }).then(function (resp) {
                var data = resp.data;
                leaf.$children = data;
                leaf.$selectedChildIndex = data.length ? 0 : -1;
                for (var i = 0; i < data.length; i++) {
                    var relatedNode = data[i];
                    var url_1 = (relatedNode.listSpec && relatedNode.listSpec.contentSpec) ?
                        relatedNode.listSpec.contentSpec.url :
                        null;
                    angular.extend(relatedNode, {
                        $id: relatedNode.listSpec.uid,
                        $children: [],
                        $parent: leaf,
                        $selectedChildIndex: -1,
                        $templateUrl: url_1,
                        //$viewRetentionPolicy: node.extensionObject.contentSpec.viewRetentionPolicy //TODO: copy over this field
                        liveRefreshEnabled: true
                    });
                    // if url specified a related item to go to, set the index correctly
                    if (route.relatedItem === relatedNode.$id) {
                        leaf.$selectedChildIndex = i;
                    }
                }
                return tree;
            });
        };
        /**
         * Applies the user preferences for the route.
         *
         * @param searchParam the location
         * @returns {Function} future with applied modifications to the search param
         */
        Navigation.prototype.applyUserRoutePreferences = function (searchParam) {
            var self = this;
            if (!h5.ngMigrationEnabled &&
                (!searchParam.extensionId || this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID === searchParam.extensionId)) {
                // No extension specified for object - swap with the last extension the user navigated to
                return this.navigationPreferenceService.getLastExtension(searchParam.objectId)
                    .then(function (userSetting) {
                    if (userSetting && userSetting.extensionId) {
                        searchParam.extensionId = userSetting.extensionId;
                    }
                    if (userSetting && userSetting.relatedItem) {
                        searchParam.relatedItem = userSetting.relatedItem;
                    }
                    return searchParam;
                }, function (err) {
                    self.$log.error("User preferences for the route not applied correctly." + err);
                });
            }
            return this.$q.resolve(searchParam);
        };
        Navigation.$inject = [
            '$rootScope',
            '$location',
            '$http',
            '$templateCache',
            '$q',
            '$log',
            'navigationTreeService',
            'navigationPreferenceService',
            'browserHistoryService',
            'urlService',
            'telemetryTimeTrackerFactory',
            'navigationConstants',
            'ngMigrationHelper',
            'currentObjectService',
            'defaultUriSchemeUtil',
            'routingService'
        ];
        return Navigation;
    }());
    platform.Navigation = Navigation;
    angular.module("com.vmware.platform.ui").service("navigation", Navigation);
})(platform || (platform = {}));



"use strict";
/* Note: there is a parallel clone of this data structure exposed in Angular as a service. */
/* Should be migrated in the near future */
angular
    .module("com.vmware.platform.ui")
    .constant("navigationConstants", {
    DEFAULT_CLIENT_LOCATION: "vsphere.core.viTree.hostsAndClustersView",
    SERVER_OBJECT_VIEW_EXTENSION_ID: "vsphere.core.inventory.serverObjectViewsExtension",
    SEARCH_VIEW_EXTENSION_ID: "vsphere.core.search.domainView",
    NAVIGATOR_IDS: [
        "vsphere.core.viTree.hostsAndClustersView",
        "vsphere.core.viTree.vmsAndTemplatesView",
        "vsphere.core.viTree.storageView",
        "vsphere.core.viTree.networkingView",
    ],
    HOME_EXTENSION_ID: "com.vmware.samples.dashboard.mainView",
    HOSTS_AND_CLUSTERS_EXTENSION_ID: "vsphere.core.viTree.hostsAndClustersView",
    VMS_EXTENSION_ID: "vsphere.core.viTree.vmsAndTemplatesView",
    STORAGE_EXTENSION_ID: "vsphere.core.viTree.storageView",
    NETWORKING_EXTENSION_ID: "vsphere.core.viTree.networkingView",
    DATASTORES_EXTENSION_ID: "vsphere.core.viLibraries.domainView",
    HELP_VIEW_EXTENSION_ID: "vsphere.core.actions.openHelp",
    NAMESPACES_EXTENSION_ID: "vsphere.core.namespaces.domainView",
    GLOBAL_INVENTORY_LISTS_EXTENSION_ID: "vsphere.core.viHome.domainView",
    // retry 3 times at most, when navigating to an invalid extension
    RETRIES_THRESHOLD: 3,
    NAVIGATION_REQUEST_DURATION_MEDIAN: "navReqDurationMed",
    NAVIGATION_REQUEST_BUFFER_TIME_PROP: "telemetry.navigation.bufferTime"
});



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Persistence of the navigation object extensions.
 */
angular.module('com.vmware.platform.ui').factory(
   'navigationPreferenceService',
   ['localStorageService', 'defaultUriSchemeUtil', '$q',
      function (localStorageService, defaultUriSchemeUtil, $q) {
         var LOCAL_STORAGE_KEY = 'navigation.history.extension';

         var _isPersistenceEnabled = true;

         // public API
         return {
            disablePersistence: disablePersistence,
            enablePersistence: enablePersistence,
            getLastExtension: getLastExtension,
            persistLastExtension: persistLastExtension,
            invalidate: invalidate
         };

         /**
          * Disables the navigation settings persistence.
          */
         function disablePersistence() {
            _isPersistenceEnabled = false;
         }

         /**
          * Enables the persistence of the navigation settings.
          */
         function enablePersistence() {
            _isPersistenceEnabled = true;
         }

         /**
          * Extracts the last extension id which was navigated to in the client.
          * If given an objectId then extracts the last extension id for that particular
          * inventory object
          *
          * @param objectId the server object id
          * @returns {string|*|Object|the} extension id as a string
          */
         function getLastExtension(objectId) {
            if (!_isPersistenceEnabled) {
               return $q.resolve();
            }

            return localStorageService.getUserData(generateStorageKey(objectId));
         }

         /**
          * Invalidates an entry for a particular inventory object
          *
          * @param objectId the server object id
          * @returns {Boolean} false if persistence is not enabled, true otherwise.
          */
         function invalidate(objectId) {
            if (!_isPersistenceEnabled) {
               return false;
            }

            localStorageService.setUserData(generateStorageKey(objectId), {});

            return true;
         }

         /**
          * Persists the extension id in the browsers local storage
          *
          * @param objectId the server object id
          * @param extensionId extension id to persist
          * @param relatedItem related item id to persist
          * @param navigator The extensionId of the view which is used to navigate to
          *    the object and view described by objectId and extensionId params.
          */
         function persistLastExtension(objectId, extensionId, relatedItem, navigator) {
            if (_isPersistenceEnabled) {
               if (navigator && navigator !== 'tree') {
                  localStorageService.setUserData(generateStorageKey(), {
                     extensionId: navigator
                  });
               }
               localStorageService.setUserData(generateStorageKey(objectId), {
                  extensionId: extensionId,
                  relatedItem: relatedItem
               });
            }
         }

         /**
          * Generates the key for local storage per object
          *
          * @param objectId
          * @returns {string}
          */
         function generateStorageKey(objectId) {
            var storageKey = objectId ?
                  LOCAL_STORAGE_KEY + '.' + getEntityTypeKey(objectId) :
                  LOCAL_STORAGE_KEY;

            return storageKey;
         }

         /**
          * Extracts entity type from object id
          *
          * @param objectId
          * @returns {Promise} with the entity
          */
         function getEntityTypeKey(objectId) {
            if (defaultUriSchemeUtil.isRootFolder(objectId)) {
               return "RootFolder";
            }
            return defaultUriSchemeUtil.getEntityType(objectId);
         }
      }]);
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
var NavigationTree = (function () {
    /**
     * root is of the form:
     * {
     *    $id: string,
     *    $selectedChildIndex: int,
     *    $children: [],
     *    other fields...
     * }
     */
    function NavigationTree(root) {
        var _this = this;
        this.root = root;
        // this adds the helper getSelectedChild() method to every node
        // we might refactor to use proper prototypes in the future
        this.everyNode(function (node) {
            node.getSelectedChild = function () {
                return _this.getSelectedChild(node);
            };
            node.getNonEmptyChildren = function () {
                var result = [];
                for (var i = 0; i < node.$children.length; i++) {
                    var child = node.$children[i];
                    // Skip extensions created by vsphere.core.inventory.objectViewTemplate
                    // for which there is no content yet, to avoid empty tabs
                    if (child.$templateUrl !== "resources/ui/views/TocView.html" ||
                        (angular.isArray(child.$children) && (child.$children.length > 0))) {
                        result.push(child);
                    }
                }
                return result;
            };
        });
    }
    NavigationTree.everyNode = function (node, visitor, childFieldName, parent) {
        visitor(node, parent);
        node[childFieldName].forEach(function (child) {
            NavigationTree.everyNode(child, visitor, childFieldName, node);
        });
    };
    // visitor(node,parent) function will be called on every node of this tree
    NavigationTree.prototype.everyNode = function (visitor) {
        return NavigationTree.everyNode(this.root, visitor, '$children');
    };
    ;
    // returns the leaf node of the navigation tree
    NavigationTree.prototype.getSelectedLeafNode = function () {
        var n = this.root;
        var child;
        while (n.getSelectedChild && (child = n.getSelectedChild())) {
            n = child;
        }
        return n;
    };
    ;
    // searches for a node by id, then return {node, parent}
    NavigationTree.prototype.getById = function (id) {
        var result = {};
        // not the most optimized way...
        this.everyNode(function (node, parent) {
            if (node.$id === id) {
                result.node = node;
                result.parent = parent;
            }
        });
        return result;
    };
    ;
    // returns the node at a certain depth, 0 being the root node
    NavigationTree.prototype.getNodeAtLevel = function (idx) {
        var n = this.root;
        for (var i = 0; i < idx; i++) {
            n = this.getSelectedChild(n);
            if (!n) {
                return null;
            }
        }
        return n;
    };
    ;
    // return the selected node at the next level, or null
    NavigationTree.prototype.getSelectedChild = function (node) {
        if (node && node.$selectedChildIndex !== -1) {
            return node.$children[node.$selectedChildIndex] || null;
        }
        return null;
    };
    return NavigationTree;
}());



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service to persist the navigation tree
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('navigationTreeService', navigationTreeService);

   navigationTreeService.$inject = ['$http', '$q', 'httpCancellationService', 'logService'];

   function navigationTreeService($http, $q, httpCancellationService, logService) {
      var notImplementedUrl = "common-module-ui/resources10880725/common-module/views/NotImplemented.html";
      var notSupportedUrl = "common-module-ui/resources10880725/common-module/views/NotSupported.html";
      var errorUrls = {
         OBJECT_NOT_FOUND: "resources/ui/views/objectnavigator/error/ObjectNotFound.html"
      };
      var cancellableRequest = httpCancellationService();

      var log = logService('navigationTreeService');

      // Public API
      return {
         /**
          * Fetch the NavigationTree for a given navigation route.
          *
          * @param {Object} searchParam
          * @param {boolean} cancellable
          * @returns {NavigationTree}
          */
         fetchNavigationTree: fetchNavigationTree,

         /**
          * Cancels previous navigation tree fetch.
          */
         cancelPrevious: cancellableRequest.cancel
      };

      function fetchNavigationTree(searchParam, cancellable) {
         var config = {
            method: 'get',
            url: 'navigation/data/' + searchParam.extensionId,
            params: {
               objectId: searchParam.objectId
            },
            // errorResponseInterceptor.js will intercept all 40x, 500, etc errors
            // and it will display a popup with an error message. We want to prevent
            // that code from executing and handle the error ourselves. The reason
            // is that it's possible to send a request for an invalid extension id,
            // because extension ids for tabs are cached in the local storage. Those extension ids
            // could be invalidated by renaming the extension, uninstalling the plugin providing
            // the extension, etc. In that case, we'll clear the local storage entry
            // and navigate the user to the 1st tab of the object.
            skipErrorInterceptor: true
         };

         var promise = cancellable ? cancellableRequest.fetch(config) : $http(config);

         return promise.then(function (resp) {
            if (!resp) {
               var reason = 'undefined response to navigation/data/' + searchParam.extensionId;
               log.error(reason);
               return  $q.reject(reason);
            }
            var tree = resp.data;
            NavigationTree.everyNode(tree, function (node, parent) {
               // Having a contentSpec but no contentSpec.url means it's a non supported Flex view
               var url = errorUrls[node.error] ||
                  (node.extensionObject.contentSpec && (node.extensionObject.contentSpec.url || notSupportedUrl)) ||
                  notImplementedUrl;

               angular.extend(node, {
                  $id: node.error || node.extensionObject.uid,
                  $children: node.children,
                  $parent: parent || null,
                  $selectedChildIndex: node.childIndexToActivate,
                  $templateUrl: url,
                  $viewRetentionPolicy: (node.extensionObject && node.extensionObject.contentSpec && node.extensionObject.contentSpec.viewRetentionPolicy) ?
                        node.extensionObject.contentSpec.viewRetentionPolicy : null
               }, node.extensionObject);
            }, 'children');

            return new NavigationTree(tree);
         }, function (err) {
            return $q.reject(err);
         });
      }
   }
})();

(function() {

   'use strict';

   angular.module('com.vmware.platform.ui')
         .service('actionConfirmationService', actionConfirmationService);

   actionConfirmationService.$inject = [ 'i18nService', 'jsUtils',
            'logService', 'defaultUriSchemeUtil', 'managedByMessageBuilderService', 'confirmationModalService'];

   function actionConfirmationService( i18nService, jsUtils,
         logService, defaultUriSchemeUtil, managedByMessageBuilderService, confirmationModalService) {

      var log = logService('actionConfirmationService');

      /**
       * Constant used to identify that a default confirmation message shouldn't be
       * displayed by the action framework.
       *
       * In multiple targets scenario if some of the confirmation messages
       * (confirmationTextNone, confirmationTextSome or confirmationTextAll) is not
       * defined we are displaying a default message. If you want to skip that default
       * message just set the corresponding confirmation text in plugin.xml to "CUSTOM".
       */
      var CUSTOM_CONFIRMATION = 'CUSTOM';

      var MANAGEDBY_PROPERTY = 'managedByExtensionKey';

      /**
       * All the actions that are defined by plugins have one of those invokers.
       * In case tha action is defined by a plugin, we do not display a managed by warning message
       */
      var pluginActionsInvokers = ['com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate',
         'com.vmware.vsphere.client.pluginActions', 'com.vmware.vsphere.client.remotePluginActions.navigation',
         'com.vmware.vsphere.client.HtmlPluginHeadlessAction', 'com.vmware.vsphere.client.HtmlPluginModalAction'];

      return {
         confirmIfRequired: confirmIfRequired
      };

      function confirmIfRequired(actionEval, confirmHandler, skipManagedByCheck) {

         if (jsUtils.isUndefinedOrNull(actionEval)) {
            log.error('ActionEval not found');
            return;
         }

         if (!actionEval.action) {
            log.error('ActionEval\'s action not found');
            return;
         }

         var actionId = actionEval.action.uid;

         var confirmationText;
         var showConfirmationFunc = confirmationModalService.showConfirmationDialog;
         var isMultipleTargets = false;

         if (actionEval.evaluationStatuses) {
            var totalTargetsCount = Object.keys(actionEval.evaluationStatuses).length;
            isMultipleTargets = totalTargetsCount > 1;

            if (!isMultipleTargets) {
               if (!actionEval.available) {
                  log.error('Unavailable action ' + actionId + ' for single object');
                  return;
               }

               // in case the text is empty or custom set the confirmationText to an empty string
               // - if the text is CUSTOM the confirmation will be handled by the action
               // - if it is just not set, if needed a warning for managed entity will be displayed
               confirmationText = getConfirmationText(actionEval.action.confirmationText, "");
            } else {
               if (!actionEval.available) {
                  // this is hit when the action is not available for any of the selected
                  // targets
                  confirmationText = getConfirmationText(
                        actionEval.action.confirmationTextNone,
                        i18nService.getString('Common', 'defaultConfirmation.noneOK'));

                  // in this case we need to display a warning dialog that has only OK button
                  // instead of Yes/No
                  showConfirmationFunc = confirmationModalService.showWarningDialog;
               } else {
                  var availableTargetsCount = 0;

                  _.each(actionEval.evaluationStatuses, function(evalStatus) {
                     if (evalStatus.available) {
                        availableTargetsCount++;
                     }
                  });

                  if (totalTargetsCount === availableTargetsCount) {
                     confirmationText = getConfirmationText(
                           i18nService.interpolate(actionEval.action.confirmationTextAll,
                                 [availableTargetsCount]),
                           i18nService.getString('Common', 'defaultConfirmation.allOK',
                                 availableTargetsCount));
                  } else {
                     confirmationText = getConfirmationText(
                           i18nService.interpolate(actionEval.action.confirmationTextSome,
                                 [availableTargetsCount, totalTargetsCount]),
                           i18nService.getString('Common', 'defaultConfirmation.someOK',
                                 availableTargetsCount, totalTargetsCount));
                  }
               }
            }
         }

         /**
          * Only check if the entity is managed in case skipManagedByCheck flag is false,
          * the action is available, the action is not defined by a plugin and the managed by property is set
          */
         var checkIfManaged = !skipManagedByCheck && actionEval.available &&
               actionEval.additionalProperties &&
               actionEval.additionalProperties[MANAGEDBY_PROPERTY] &&
               !_.contains(pluginActionsInvokers, actionEval.invoker);

         if (!!confirmationText) {
            var properties = getConfirmationDialogProperties(actionEval, confirmationText, confirmHandler);
            /**
             * In case the context object is managed by a solution, retrieve the name of the solution
             * and build the necessary text to be prepended to the confirmation text
             */
            if (checkIfManaged) {
               managedByMessageBuilderService.buildConfirmationText(actionEval.context.targetObjects, confirmationText)
                     .then(function(managedByConfirmationText) {
                        if (managedByConfirmationText) {
                           properties.message = managedByConfirmationText;
                        }
                        showConfirmationFunc(properties);
                     });
               return;
            }
            showConfirmationFunc(properties);
            return;
         }

         // we hit this case ONLY for managed VMs and vApps, for single target
         // that does not have custom handling of the confirmation logic
         // for all other cases of single objects, no matter if the confirmation text
         // is CUSTOM or not set at all confirmHandler will be called and
         // any confirmations defined in there will be shown
         if (!isMultipleTargets && checkIfManaged &&
               actionEval.action.confirmationText !== CUSTOM_CONFIRMATION) {
            managedByMessageBuilderService.buildConfirmationText(actionEval.context.targetObjects, "", true)
                  .then(function(managedByConfirmationText) {
                     if(managedByConfirmationText) {
                        var properties = getConfirmationDialogProperties(actionEval, confirmationText, confirmHandler);
                        properties.message = managedByConfirmationText;
                        showConfirmationFunc(properties);
                     } else {
                        // in case the managed by properties can not be retrieved invoke the action
                        if (confirmHandler && typeof confirmHandler === 'function') {
                           confirmHandler();
                        }
                     }
                  });
            return;
         }


         // we hit this call only for single target when there is no confirmationText
         // specified
         if (confirmHandler && typeof confirmHandler === 'function') {
            confirmHandler();
         }
      }

      /**
       * Gets confirmation text - if action confirmation text is not specified, we return
       * the default one. If the message is specified and is different than CUSTOM - we
       * return the message, otherwise - return null.
       */
      function getConfirmationText(actionConfirmationText, defaultConfirmationText) {
         if (!actionConfirmationText) {
            return defaultConfirmationText;
         }

         if (actionConfirmationText !== CUSTOM_CONFIRMATION) {
            return actionConfirmationText;
         }

         // if the confirmation is provided by the action definition and it's value is
         // CUSTOM - we don't have to show confirmation from this service
         return null;
      }

      function getConfirmationDialogProperties(actionEval, confirmationText, confirmHandler) {
         var confirmationTitle = !!actionEval.action.confirmationTitle ?
               actionEval.action.confirmationTitle :
               actionEval.action.label;
         var properties = {
            useClarity: true,
            title: confirmationTitle,
            message: confirmationText,
            yesHandler: confirmHandler,
            icon: null,
            clarityIcon: {
               shape: "warning",
               class: "is-warning",
               size: 48
            },
            showXIcon: false
         };

         if (actionEval.context && actionEval.context.targetObjects.length === 1) {
            _.extend(properties, {
               subTitle: {
                  objectId: defaultUriSchemeUtil.getVsphereObjectId(actionEval.context.targetObjects[0])
               }
            });
         }

         return properties;
      }
   }
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Service for opening dialogs and wizards (all popups) based on actions framework actions.
 * Can be extended to work for other non-action integrated actions later on. Also will be integrated with TIWO
 */
angular.module('com.vmware.platform.ui')
.factory('actionDialogService',['$q', '$rootScope', 'vuiDialogService', 'dataService', 'i18nService', function($q, $rootScope, vuiDialogService, dataService, i18nService) {

   //======================= Public Functions ==========================
   /**
    * Opens an OK/Cancel modal dialog in the application.
    *
    * @param actionEval {Object} ActionEval associated with the action that is being invoked.
    *
    * @param availableTargets {string[]} Identifiers for server objects on which the action will be performed.
    *
    * @param dialogData {Object} Additional data passed to the dialog/wizard from the source.
    *
    * @param contentUrl {string} Url of the html template of the dialog content.
    *
    * @param extraDialogOptions {Object} Additional data for vuiDialogService to use (height, width...)
    */
   var openActionDialog = function(actionEval, availableTargets, dialogData, contentUrl, extraDialogOptions, modalOptions) {
      var scope = $rootScope.$new();
      var dialogOptions = angular.extend({
         show: true,
         iconClass: actionEval.action.icon,
         contentUrl: contentUrl,
         actionDetails: {
            actionEval: actionEval,
            availableTargets: availableTargets,
            dialogData: dialogData
         },
         width: '400px',
         height: '200px'
      }, extraDialogOptions || {});

      if (extraDialogOptions) {
         // amarinov: Merge dialogOptions back to extraDialogOptions so that the caller would be given the ability to
         // modify the dialog options after the dialog is shown through the extraDialogOptions
         dialogOptions = angular.extend(extraDialogOptions, dialogOptions);
      }

      scope.dialogOptions = dialogOptions;

      scope.dialogOptions.title = getDialogTitle(actionEval, availableTargets, scope.dialogOptions);

      var options = angular.merge({}, modalOptions);
      options = angular.extend(options, {
         scope: scope,
         configObjectName: 'dialogOptions'
      });

      return vuiDialogService(options);
   };

   //======================= Private Functions ==========================
   /**
    * Immediately returns some title so that the dialog can be shown as soon as
    * possible.
    * If needed, schedules a request for the target object's name.
    */
   function getDialogTitle(actionEval, availableTargets, dialogOptions) {
      // we have a localized title without placeholders
      if (dialogOptions.title && dialogOptions.title.indexOf('{0}') === -1) {
         return dialogOptions.title;
      }
      if (!availableTargets) {
         return actionEval.action.label;
      }
      if (availableTargets.length === 1) {
         // Get the name of the object and make the new title.
         setTitleForSingleObject(availableTargets[0], dialogOptions, actionEval,
               dialogOptions.title);
         return actionEval.action.label;
      } else {
         return i18nService.getString('Common', 'dialogTitleFormatMultiple',
               availableTargets.length, actionEval.action.label);
      }
   }

   function setTitleForSingleObject(objectId, dialogOptions, actionEval, placeholderTitle) {
      return dataService.getProperties(objectId, ['name']).then(function(data) {
         if (!data.name) {
            return;
         }
         if (placeholderTitle) {
            // Remove the placeholder from the localized title if it exists
            dialogOptions.title = i18nService.interpolate(placeholderTitle,
                  [data.name]);
         } else {
            dialogOptions.title = i18nService.getString('Common',
                  'dialogTitleFormat', data.name, actionEval.action.label);
         }
      });
   }

   // ======================= Public API ==========================
   return {
      openActionDialog : openActionDialog
   };
}]);

/* Copyright 2020-2022 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for retrieving and invoking actions and showing menus.
 */
angular.module('com.vmware.platform.ui').factory('actionsService',
      ['$http', '$window', 'logService', 'i18nService', 'vuiActionsMenuService',
      'vuiConstants', '$q', 'actionConfirmationService', 'jsUtils', '$timeout',
      '$analytics', 'dataService', 'vscActionInvocationService',
      'focusTraceService', 'pluginDynamicViewService', '$injector', 'featureFlagsService',function($http, $window, logService, i18nService, vuiActionsMenuService,
            vuiConstants, $q, actionConfirmationService, jsUtils, $timeout, $analytics,
            dataService, vscActionInvocationService, focusTraceService, pluginDynamicViewService, $injector, featureFlagsService) {

   'use strict';
   var log = logService('actionsService');
   var menuItemTypes = {
      MENU : 'MENU',
      SEPARATOR: 'SEPARATOR',
      ACTION : 'ACTION'
   };
   var lastMenuItemId = 0;
   var menuContainerId = 'applicationMenuContainer';
   var solutionMenusExtensionPoint = 'vise.menus.context.solutionMenus';
   var kendoActionMenuSelector = "[role='menubar']";
   var kendoMenuItemContainerAttribute = "aria-haspopup";

   /**
    * Builds, stores the menu item in MenuStore if it is of type 'ACTION'
    * and returns a menu item.
    *
    * @param item Menu object.
    *
    * @param menuItemsByActionUid Menu object Store.
    *
    * @param callInvoker The menu click handler.
    *
    * @return Object representing a menu Item.
    */
   function buildMenuItem(item, menuItemsByActionUid, targets, callInvoker, focusTarget) {
      var menuItem = {
         id: item.id,
         label: item.label,
         iconClass: item.icon,
         enabled: true
      };
      if (item.type === menuItemTypes.SEPARATOR) {
         return vuiConstants.actions.SEPARATOR;
      } else if (item.type === menuItemTypes.MENU) {
         if (!item.id) {
            item.id = generateMenuItemId();
         }
         menuItem.items = item.children.map(function(item) {
            return buildMenuItem(item, menuItemsByActionUid, targets, callInvoker,
               focusTarget);
         });
      } else if (item.type === menuItemTypes.ACTION) {
         menuItem.onClick = function() {
            if (focusTarget) {
               focusTraceService.setFocusableElement(focusTarget);
            }
            callInvoker(item.id, targets);
         };
      }
      menuItemsByActionUid[menuItem.id] = menuItem;
      return menuItem;
   }

   /**
    * Extracts and returns the object ids from the given target objects.
    *
    * @param targets {Object[]} The target objects that have `id` properties inside.
    *
    * @return {string[]} Array of object ids. Null if null is passed in.
    */
   var extractObjectIds = function (targets) {
      return targets ? targets.map(function(value) { return value.id; }) : null;
   };

   /**
    * Creates and returns a menu Header object.
    *
    * @param targets Object[] The target objects.
    *
    * @returns Object The generic menu label.
    */
   var buildGenericMenu = function(targets) {
      var labelText, iconClass;
      if (targets && targets.length > 0) {

         var actionObjectsStr = '';
         if (targets.length > 1) {
            actionObjectsStr = i18nService.getString(
                  'Common', 'contextMenu.title.nObjects', targets.length);
         } else if (targets.length === 1) {
            var target = targets[0];
            actionObjectsStr = target.name ?
                  target.name :
                  i18nService.getString('Common', 'contextMenu.title.oneObject');
            if (target.primaryIconId) {
               iconClass = target.primaryIconId;
            }
         }

         labelText =
               i18nService.getString('Common', 'contextMenu.title', actionObjectsStr);
      }
      return buildHeaderItem(labelText, iconClass);
   };

   /**
    * Builds and returns menu header item given
    * label and iconClass.
    *
    * @param label Header item label.
    *
    * @param iconClass Header item iconClass (optional)
    */
   function buildHeaderItem(label, iconClass) {
      var item = {
         id: 'header_id',
         label: label,
         iconClass: iconClass
      };
      return item;
   }

   /**
    * Creates and returns a menu item containing
    * text like "No actions available".
    *
    * @returns Object The new "no actions" menu item.
    */
   function buildEmptyItem() {
      var noActionsStr = i18nService.getString(
            'Common', 'contextMenu.noActionsItem');
      var item = {
         id: generateMenuItemId(),
         label: noActionsStr,
         enabled: false
      };
      return item;
   }

   var generateMenuItemId = function () {
      return (lastMenuItemId++).toString();
   };

   /**
    * Creates and returns a disabled menu item containing
    * text like "Loading..".
    *
    * @returns Object The new "loading" menu item.
    */
   function buildLoadingItem() {
      var noActionsStr = i18nService.getString(
            'Common', 'contextMenu.loadingItem');
      var item = {
         id: generateMenuItemId(),
         label: noActionsStr,
         enabled: false
      };
      return item;
   }

   /**
    * Gets menu of the specified type and for specified target objects.
    *
    * @param type {string} Identifiers menu types eg. 'vise.menus.user',
    *  'vise.menus.help' or 'vise.menus.context,vise.menus.context.solutionMenus'
    *
    * @param targetIds {string[]} Identifiers for server objects to evaluate and
    * return actions menu for.
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the menu.
    */
   function getMenu(type, targetIds) {
      var url = 'actionsService/menu/';
      var params = {
         menuType: type
      };
      return getData(url, params, {}, targetIds, 'post');
   }

   function getEvaluatedMenus(menuIds, targetIds) {
      var url = 'actionsService/menus/' + menuIds.join(',');
      return getData(url, {}, {}, targetIds, 'post');
   }

   /**
    * Gets global toolbar actions of the specified list view.
    *
    * @param listViewId {string} Extension id of the object list view.
    *
    * @param(optional) objectId {string} the objectId that is used to evaluate the actions
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the toolbar actions.
    */
   function getToolbarActions(listViewId, objectId) {
      var url = 'actionsService/toolbar/';
      var params = {
         listViewId: listViewId
      };
      if (objectId) {
         params.targetUids = [objectId];
      }
      return getData(url, params);
   }

   //======================= Public Functions ==========================
   /**
    * Gets the specified action for the specified target objects.
    *
    * @param actionId {string} The unique identifier of an action registered
    * with the action service to fetch.
    *
    * @param targetIds {string[]} Identifiers for server objects to evaluate the
    * requested action against. It could be a single value.
    *
    * @param skipErrorInterceptor {boolean} (optional) if true sends the request with
    * skipErrorInterceptor property which determines if a notification message is shown
    * when an error occurs in the actions service backend
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the
    * evaluated action.
    */
   var getAction = function (actionId, targetIds, skipErrorInterceptor) {
      skipErrorInterceptor = (skipErrorInterceptor ? skipErrorInterceptor : false);
      // TODO mcritch: implement ability to send large array of targets with request.
      var url = 'actionsService/actions/evaluations/' + actionId;
      var params = {};
      if (targetIds && targetIds.length !== 0) {
         params.targetUids = targetIds;
      }
      var additionalParams = {};
      additionalParams.skipErrorInterceptor = skipErrorInterceptor;

      return getData(url, params, additionalParams);
   };

   /**
    * Gets actions with evaluations for the specified target objects.
    *showActionsMenuIds {string[]} Identifiers of actions registered with
    * the action service to fetch.
    *
    * @param targetIds {string[], string} Identifier/Identifiers for server objects to evaluate and
    * return actions for.
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the
    * evaluated actions.
    */
   var getActions = function (targetIds, actionIds, skipActionFilteringStage, params) {
      params = params === undefined  || params === null ? {} : params;
      if (!targetIds) {
         targetIds = [];
      }
      if (_.isString(targetIds)) {
         targetIds = [targetIds];
      }
      if (actionIds && actionIds.length !== 0) {
         params.actionUids =  actionIds;
      }
      if (skipActionFilteringStage) {
         params.skipActionFilteringStage = true;
      }
      return getData('actionsService/actions/evaluations', params, {}, targetIds, 'post');
   };

   /**
    * Gets data from a REST endpoint.
    *
    * @param url {string} Endpoint URL.
    *
    * @param params {object} Request parameters.
    *
    * @param additionalParams {object} Additional parameters that have to be passed to
    * the request
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the
    * requested data.
    *
    */
   var getData = function(url, params, additionalParams, data, method) {
      additionalParams = additionalParams ? additionalParams : {};
      method = method || 'get';
      return $http({
         method: method,
         url: url,
         params: params,
         data: data,
         skipLoadingNotification: true,
         skipErrorInterceptor: additionalParams.skipErrorInterceptor ? true : false
      }).then(function(resp) {
         // Extract the data from the $http response before resolving
         return resp.data;
      });
   };

   /**
    * Invokes the action specified in the action evaluation against the
    * available targets in the evaluation, if any.
    *
    * If the given action is not available, it is not invoked.
    *
    * In order to invoke the action, the actionEval should contain an "invoker"
    * property that names a function located in the h5.actions map. That
    * function should accept the actionEval and an array of available targets
    * as parameters.
    *
    * @param actionEval {Object} The evaluated action to invoke.
    * @param context {Object} Additional free-format data, that will be passed
    * to the action invoker.
    */
   var invokeAction = function (actionEval, context) {
      // Could check actionEval.timestamp here to determine whether
      // this eval is too stale.

      // Extract the available targets from the evaluation statuses.
      var targets = extractTargets(actionEval);

      // TODO: smarathe - Check if the analytics is enabled
      // Action, Category, Name/Label, Value
      $analytics.eventTrack(actionEval.action.uid, { category: 'h5.actions.trigger', label: targets });

      var confirmHandler = function() {
         vscActionInvocationService.getHandler(actionEval.invoker).subscribe( function(handler) {
            handler(actionEval, targets, context);
         });
      };
      actionConfirmationService.confirmIfRequired(actionEval, confirmHandler);
   };

   /**
    * Shows a custom menu of the given type that is applicable to the
    * given targetIds.
    *
    * <p>If more than one such custom menu is applicable to the given targets,
    * one is chosen to show arbitrarily.
    * Note that it is an error to introduce non-mutually exclusive menus to
    * the service in this way.</p>
    *
    * <p>If no custom menu exists for the given targets, but applicable actions
    * do exist, a generic menu is constructed from those actions and shown.
    * If no applicable actions exist either, nothing happens.</p>
    *
    * @param $event The click event that was raised to trigger the menu. Used
    * for getting the target element (event.target) on which the click was done
    * for anchoring the menu.
    *
    * @param menuType The type of the menu to show.
    *
    * @param scope The scope from which the function is invoked.
    *
    * @param targets The target objects to show the menu for. (Optional)
    *
    * @param x The left co-ordinate from where the menu should render. (Optional)
    *
    * @param y The top co-ordinate from where the menu should render. (Optional)
    *
    * @param targetElement Specifies the element on which the actions menu should open.
    * (Optional) If this is not specified $event.target is used. If $event is null or undefined,
    * the default element is document body.
    */
   var showActionsMenu = function($event, menuType, scope, targets, x, y, targetElement, focusable, focusTarget) {
      var deferred = $q.defer();
      if (!Array.isArray(targets)) {
         targets = jsUtils.isUndefinedOrNull(targets) ? [] : [targets];
      }

      // New scope object for the vuiActionsMenu two way binding
      var localScope = scope.$new();
      var target = targetElement;
      if (!target && $event) {
         target = $event.target;
      }
      // build Menu Data
      buildMenu(menuType, targets, focusable, focusTarget)
         .then(function(actionsMenu) {
            localScope.actionsMenu = actionsMenu;

            var menuOptions = {
               scope: localScope,
               configObjectName: 'actionsMenu',
               target: target,
               menuContainerId: menuContainerId
            };
            if (!jsUtils.isUndefinedOrNull(x) && !jsUtils.isUndefinedOrNull(y)) {
               menuOptions.coordinates = {
                  x: x,
                  y: y
               };
            }

            vuiActionsMenuService.showMenu(menuOptions);
            setTooltips();
            deferred.resolve(undefined);
         })

         .finally(function() {
            // TODO: smarathe - Check if the analytics is enabled
            // Action, Category, Name/Label, Value
            var targetIds = targets.map(function(currTarget) {
               return currTarget.id;
            });
            $analytics.eventTrack('h5.viewActions', { category: 'h5.actions.view', label: targetIds });
         });

      return deferred.promise;
   };

   var showObjectContextMenu = function($event, scope, targets, x, y, targetElement, focusable, focusTarget) {
      return $injector.get('vscActionService').showObjectContextMenu($event, scope, targets, x, y, targetElement, focusable, focusTarget);
   };

   /**
    * notification resolved whenever entire menu is closing down or one of the leaf (non-expanding) menu items is clicked
    * carefully unsubscribes to setup listeners upon catching close
    */
   var onCloseObjectContextMenu = function () {
      var deferred = $q.defer();
      var actionMenu = getApplicationMenuContainerElement().children(kendoActionMenuSelector);
      var kendoMenuImpl = actionMenu.data("kendoContextMenu");
      var observedEventList = ["close", "select"];

      observedEventList.forEach(function (eventType) {
         kendoMenuImpl.bind(eventType, function (e) {
            var isClickOutsideOrEscapeKey = (eventType === "close" && (e.event || e.isDefaultPrevented()));
            var isClickOnLeafMenuItem = (eventType === "select" && !e.item.hasAttribute(kendoMenuItemContainerAttribute));

            if (isClickOutsideOrEscapeKey || isClickOnLeafMenuItem) {
               if (isClickOutsideOrEscapeKey) {
                  deferred.resolve(true);
               }
               if (isClickOnLeafMenuItem) {
                  deferred.resolve(false);
               }
               observedEventList.forEach( function(eventType) { $(this).unbind(eventType); });
            }
         });
      });

      return deferred.promise;
   };

   // vuiActionMenu does not support tooltips like the docs say
   function setTooltips() {
      $('.k-menu.k-menu-vertical.k-context-menu span.k-link').each(function (index, menuItem) {
         // Set title attribute only if the contents of the menu item will overflow.
         if (menuItem.offsetWidth < menuItem.scrollWidth) {
            var $menuItem = $(menuItem);
            $menuItem.attr('title', $menuItem.text());
         }
      });
   }

   /**
    * Manager for preparation and invocation of actions.
    *
    * @returns {object} The public functions that can be called on the ActionInvoker.
    */
   function ActionInvoker(api) {
      var actionEvalsByActionUid = {};
      var pendingGetActionsCall = null;

      /**
       * Fetches all specified actions applicable to the specified targets and
       * evaluates their state.
       *
       * @param targets {object} All targets for which the actions are applicable.
       *
       * @param vuiMenuItemsByActionUid {object} All action items mapped to their IDs.
       *
       * @param options {object} Custom options for controlling the action evaluations.
       *
       * @returns {HttpPromise} An angularjs HttpPromise to return the
       * requested data.
       *
       */
      function evaluateActions(targets, vuiMenuItemsByActionUid, skipActionFilteringStage, options) {
         if (vuiMenuItemsByActionUid === null){
            return $q.when();
         }
         var actionIds = Object.keys(vuiMenuItemsByActionUid);
         var targetIds = extractObjectIds(targets);

         if (actionIds.length !== 0) {
            var getActionsCall =  api.getActions(targetIds, actionIds, skipActionFilteringStage);
            // There could be a case when the menu is displayed for a single object
            // and while its actions are being evaluated the user clicks and action.
            // This will cause the specific action to be evaluated before it gets invoked.
            // In this case we "race" the 2 promises (all action eval vs invoked action eval).
            // Whichever promise resolves first will be returned so that the pending
            // action invocation proceeds ASAP.
            pendingGetActionsCall = pendingGetActionsCall ?
                  $q.race([pendingGetActionsCall, getActionsCall]) : getActionsCall;

            return pendingGetActionsCall.then(function(actionEvals) {
               pendingGetActionsCall = null;
               if (actionEvals === null || !_.isArray(actionEvals)){
                  return;
               }
               if (targets && targets.length === 1) {
                  var targetName = targets[0]['name'];

                  actionEvals.forEach(function(actionEval) {
                     if (actionEval && actionEval.action &&
                        actionEval.action.confirmationText) {
                        actionEval.action.confirmationText = i18nService.interpolate(
                           actionEval.action.confirmationText, [targetName]);
                     }
                  });
               }
               setActionEvaluations(vuiMenuItemsByActionUid, actionEvals, options);
               $timeout(setTooltips, 0);
            }, function() {
               log.error('Get Actions call Failed for targets ' + targetIds + ' and actions ' + actionIds);
            });
         }
      }

      /**
       * Applies the action evaluations to the current list of actions.
       * In the case when a pending action exists (that is, when there are multiple
       * targets) the pending action is invoked.
       *
       * @param vuiMenuItemsByActionUid {object} Menu items mapped by their IDs.
       *
       * @param actionEvals {object} The action evaluations.
       *
       * @param options {object} Custom options for controlling the action evaluations.
       *
       * @returns {HttpPromise} An angularjs HttpPromise to return the
       * requested data.
       *
       */
      function setActionEvaluations(vuiMenuItemsByActionUid, actionEvals, options) {
         // update vuiMenuItemsByActionUid
         actionEvals.forEach(function(actionEval) {
            if (vuiMenuItemsByActionUid[actionEval.action.uid] &&
                  (!options || !options.skipSetMenuItemEnabled)) {
               vuiMenuItemsByActionUid[actionEval.action.uid].enabled =
                     actionEval.available;
            }
            actionEvalsByActionUid[actionEval.action.uid] = actionEval;
         });
      }

      /**
       * Invokes the specified action.
       *
       * @param actionId {object} The action to invoke.
       *
       * @param targets {object} All targets for which the action is applicable.
       *
       * @param eventInfo {object} Details about the event.
       *
       */
      function callInvoker(actionId, targets) {
         if (!actionEvalsByActionUid[actionId]) {
            var actionIdItems = {};
            actionIdItems[actionId] = {};
            evaluateActions(targets, actionIdItems, true /*skipActionsFilteringStage*/, { skipSetMenuItemEnabled: true }).then(function(){
               tryInvokeAction(actionId);
            });
         } else {
            tryInvokeAction(actionId);
         }
      }

      /**
       * Checks if the action evaluations are available and invokes action.
       * @param actionId
       *    Id of the action to be evaluated.
       */
      function tryInvokeAction(actionId) {
         if (!actionEvalsByActionUid[actionId]) {
            log.error('Cannot invoke action "' + actionId + '". Missing action evaluation.');
         }

         var actionEval = actionEvalsByActionUid[actionId];
         api.invokeAction(actionEval);
      }

      return {
         evaluateActions: evaluateActions,
         setActionEvaluations: setActionEvaluations,
         callInvoker: callInvoker
      };
   }

   function buildMenu(menuType, targets, focusable, focusTarget) {
      var targetIds = extractObjectIds(targets);
      // Map of the items in the menu. Used to enable/disable actions when
      // the evaluations arrive.
      var vuiMenuItemsByActionUid = {};
      // Map of the items in the menu that come from plugins.
      // Used to request plugin actions separately and later append them
      // to their corresponding parent menu item.
      var vuiPluginMenuItemsByActionUid = {};

      var actionInvoker = new ActionInvoker(api);
      var deferred = $q.defer();
      getMenu(menuType, targetIds).then(function(menuItem) {
         var vuiMenu;

         if (menuItem.label) {
            vuiMenu = buildHeaderItem(menuItem.label, menuItem.icon);
         } else {
            // Build Generic menu label
            vuiMenu = buildGenericMenu(targets);
         }

         if (!jsUtils.isEmpty(menuItem.children)) {
            vuiMenu.items = menuItem.children.map(function(menuItem) {
               if (menuItem.extendedPoint === solutionMenusExtensionPoint) {
                  return buildMenuItem(menuItem, vuiPluginMenuItemsByActionUid,
                        targets, actionInvoker.callInvoker, focusTarget);
               } else {
                  return buildMenuItem(menuItem, vuiMenuItemsByActionUid,
                        targets, actionInvoker.callInvoker, focusTarget);
               }
            });
         } else {
            vuiMenu.items = [buildEmptyItem()];
         }

         vuiMenu.focusable = focusable;

         // Evaluate actions only if there is no target (Help or User menu) or
         // it is a single target. For multiple targets all the relevant actions are
         // enabled by default and they are evaluated on action (menu item) click
         if (!targets || (targets.length <= 1)) {
            actionInvoker.evaluateActions(targets, vuiMenuItemsByActionUid,
                  true /*skipActionsFilteringStage since calling 2nd time*/);
         }

         if (!_.isEmpty(vuiPluginMenuItemsByActionUid)) {
            _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
               menuItem.items.push(buildLoadingItem());
            });
            getEvaluatedMenus(_.keys(vuiPluginMenuItemsByActionUid), targetIds)
                  .then(function (evaluatedMenuData) {
                     addPluginMenus(vuiPluginMenuItemsByActionUid, actionInvoker,
                           targets, evaluatedMenuData);
                  });
         }

         // Resolve the promise in the next frame to make the browser first to dispatch
         // http request for action evaluations and then render the menu
         $timeout(function() {
            deferred.resolve(vuiMenu);
         }, 0);
      }).catch(function() {
         log.error('Get menu call Failed');
         var vuiMenu = buildGenericMenu(targets);
         vuiMenu.items = [buildEmptyItem()];
         deferred.resolve(vuiMenu);
      });
      return deferred.promise;
   }

   /**
    * Appends plugin menu actions to their corresponding menu item.
    * @param vuiPluginMenuItemsByActionUid {object} Plugin menu items mapped to by IDs.
    * @param actionInvoker The action invoker of the menu instance.
    * @param targets Object[] The target objects.
    * @param evaluatedMenuData An object containing the plugin menus with actions
    *    and the evaluations of those actions.
    */
   function addPluginMenus(vuiPluginMenuItemsByActionUid, actionInvoker, targets, evaluatedMenuData) {
      var actionEvalsByActionUid = {};
      if (!targets || targets.length === 1) {
         _.each(evaluatedMenuData.evaluations, function (actionEval) {
            actionEvalsByActionUid[actionEval.action.uid] = actionEval;
         });
      }

      var evaluatedMenuIds = _.map(evaluatedMenuData.menus, function (menu) {
         return menu.id;
      });
      // Remove "Loading.." placeholder items from menu items that are not part
      // of the evaluated menu data i.e. ones that are filtered out
      // by the extension FW.
      _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
         if (evaluatedMenuIds.indexOf(menuItem.id) < 0) {
            menuItem.items = [buildEmptyItem()];
         }
      });

      // separate the static plugin menus and evaluations and the dynamic ones
      var staticPluginMenusAndEvaluations = [];
      var dynamicPluginMenusAndEvaluations = [];

      _.each(evaluatedMenuData.menus, function(menu) {
         var evaluations = [];
         var menuChildrenIds = [];
         _.each(menu.children, function(child) {
            menuChildrenIds.push(child.id);
         });
         _.each(evaluatedMenuData.evaluations, function(actionEval) {
            if (menuChildrenIds.includes(actionEval.action.uid)) {
               evaluations.push(actionEval);
            }
         });

         if (menu.remotePluginExtensionContext
               && menu.remotePluginExtensionContext.remotePluginFilterContext) {
            dynamicPluginMenusAndEvaluations.push({
               menu: menu,
               evaluations: evaluations
            });
         } else {
            staticPluginMenusAndEvaluations.push({
               menu: menu,
               evaluations: evaluations
            });
         }
      });

      var staticEvalsToBeProcessed = staticPluginMenusAndEvaluations.flatMap((function(item) {
         return item.evaluations;
      }));

      var staticMenusToBeProcessed = staticPluginMenusAndEvaluations.map(function(item) {
         return item.menu;
      });

      // process the static plugin menus
      processPluginMenus(vuiPluginMenuItemsByActionUid,
         staticEvalsToBeProcessed,
         actionInvoker,
         targets,
         staticMenusToBeProcessed,
         {}
      );

      // process the dynamic plugin menus. This includes making requests to the
      // respective plugin servers to evaluate the status of each dynamic menu item
      return processDynamicPluginMenus(dynamicPluginMenusAndEvaluations,
         targets,
         vuiPluginMenuItemsByActionUid,
         actionInvoker);
   }

   /**
    * Prepares all actions for list view toolbar.
    * @param listViewId {String} The extension ID of a list view.
    */
    function buildActionsToolbar(listViewId, objectId){
       var deferred = $q.defer();
       var itemsByActionUid = {};
       var actionInvoker = new ActionInvoker(api);
       getToolbarActions(listViewId, objectId).then(function(items) {
          if (items === null){
             $timeout(function() {
                deferred.resolve([]);
             }, 0);
             return;
          }
          $.each(items, function (index, item) {
             itemsByActionUid[item.id] = {
                id: item.id,
                label: item.label,
                iconClass: item.icon,
                enabled: true,
                onClick : function(eventInfo) {
                  actionInvoker.callInvoker(item.id, null);
               }
             };
          });
          var targets = null;
          if (objectId) {
             targets =[{ id: objectId }];
          }
          actionInvoker.evaluateActions(targets, itemsByActionUid);
          $timeout(function() {
             deferred.resolve(itemsByActionUid);
          }, 0);
       }).catch(function() {
          log.error('Build actions toolbar failed for list view: ' + listViewId);
          $timeout(function() {
             deferred.resolve([]);
          }, 0);
       });
       return deferred.promise;
    }

   /**
    * If the confirmationText for single object needs to be formatted,
    * the object name is retrieved and the text is changed.
    * Then invokeAction is invoked
    * @param actionEval {Object} The evaluated action to invoke.
    * @param context {Object} Additional free-format data, that will be passed
    * to the action invoker.
    * In Angular this method isn't implemented because ActionService.invokeAction fetches the name on demand.
    */
   function invokeActionWithConfirmation(actionEval, context, targets) {
      if (!actionEval) {
         return;
      }
      if (!targets) {
         targets = extractTargets(actionEval);
      }
      // if there is only one target and there is a defined message in
      // plugin xml, we need to take the name of the target and change the
      // confirmationText to contain that name
      if (shouldFormatConfirmationText(actionEval, targets)) {
         dataService.getProperties(targets[0], ['name'])
               .then(function(properties) {
                  actionEval.action.confirmationText = i18nService.interpolate(
                        actionEval.action.confirmationText, [properties.name]);
                  invokeAction(actionEval, context);
               });
      } else {
         if(targets.length > 1
               || (actionEval.available === true && targets.length === 1)) {
            invokeAction(actionEval, context);
         }
      }
   }

   function extractTargets(actionEval) {
      var targets = [];
      if(actionEval && actionEval.evaluationStatuses) {
         for (var targetId in actionEval.evaluationStatuses) {
            if (actionEval.evaluationStatuses[targetId].available) {
               targets.push(targetId);
            }
         }
      }
      return targets;
   }

   function shouldFormatConfirmationText(actionEval, targets){
      return actionEval.available === true
            && targets.length === 1
            && actionEval.action
            && actionEval.action.confirmationText
            && actionEval.action.confirmationText.includes('{0}');
   }

   function getApplicationMenuContainerElement(){
      return $("#" + menuContainerId);
   }

   /**
    * The method goes trough each pluginMenu, removes the "Loading" placeholder,
    * appends its children, if such exist, or appends "No actions available" item.
    *
    * @param vuiPluginMenuItemsByActionUid
    * @param actionEvaluations
    * @param actionInvoker
    * @param targets
    * @param pluginMenus
    * @param dynamicItemsMap
    */
   function processPluginMenus(vuiPluginMenuItemsByActionUid,
                               actionEvaluations,
                               actionInvoker,
                               targets,
                               pluginMenus,
                               dynamicItemsMap) {
      var pluginMenusIds = pluginMenus.map(function(menu) {
         return menu.id;
      });

      // Remove "Loading.." placeholder items.
      _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
         if (pluginMenusIds.includes(menuItem.id)) {
            menuItem.items = [];
         }
      });

      _.each(pluginMenus, function(menu) {
         var menuItem = vuiPluginMenuItemsByActionUid[menu.id];
         menuItem.items = menu.children.reduce(function(siblings, item) {
            if (targets) {
               // Omit the dynamic items that failed the relevance test
               var isMenuItemRelevant = !dynamicItemsMap[item.id] ||
                  dynamicItemsMap[item.id].relevant;
               if (isMenuItemRelevant) {
                  var menuItem = buildMenuItem(item,
                     vuiPluginMenuItemsByActionUid, targets,
                     actionInvoker.callInvoker);
                  siblings.push(menuItem);
               }
            }
            return siblings;
         }, []);
      });

      // Insert "No actions available" items into menus that are still empty.
      _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
         if (pluginMenusIds.includes(menuItem.id)) {
            if (menuItem.items && menuItem.items.length === 0) {
               menuItem.items.push(buildEmptyItem());
            }
         }
      });

      if (actionEvaluations && actionEvaluations.length > 0) {
         actionInvoker.setActionEvaluations(vuiPluginMenuItemsByActionUid,
            actionEvaluations, { skipSetMenuItemEnabled: false });
      }
   }

   /**
    * The method goes trough all dynamic plugin menus and makes requests to the
    * vSphere Client platform in order to retrieve information about which of the actions
    * will be available to the user.
    *
    * @param dynamicPluginMenusAndEvaluations
    * @param targets
    * @param vuiPluginMenuItemsByActionUid
    * @param actionInvoker
    */
   function processDynamicPluginMenus(dynamicPluginMenusAndEvaluations,
                                      targets,
                                      vuiPluginMenuItemsByActionUid,
                                      actionInvoker) {
      var targetsByTargetId = targets.map(function(target) {
         return target.id;
      });

      return $q.all(_.map(dynamicPluginMenusAndEvaluations, function(dynamicMenuAndEvaluations) {
         var remotePluginId = dynamicMenuAndEvaluations.menu.remotePluginExtensionContext.pluginRef.id;
         if (!remotePluginId) {
            return Promise.resolve();
         }
         return pluginDynamicViewService.retrievePluginDynamicViews([remotePluginId], dynamicMenuAndEvaluations.menu.id, targetsByTargetId, false)
               .toPromise()
               .then(function(result) {
            const dynamicItemsMap = {};
            _.each(result, function(resultItem) {
               dynamicItemsMap[resultItem.id] = resultItem;
            });
            processPluginMenus(vuiPluginMenuItemsByActionUid,
               dynamicMenuAndEvaluations.evaluations,
               actionInvoker,
               targets,
               [dynamicMenuAndEvaluations.menu],
               dynamicItemsMap);

            _.each(dynamicMenuAndEvaluations.menu.children, function(child) {
               var pluginMenuItem = vuiPluginMenuItemsByActionUid[child.id];
               if (!pluginMenuItem) {
                  return;
               }
               if (child.remotePluginExtensionContext.remotePluginFilterContext) {
                  pluginMenuItem.enabled = false;
               }
               _.each(dynamicItemsMap, function(dynamicItem) {
                  if (child.remotePluginExtensionContext.remotePluginFilterContext &&
                     child.id === dynamicItem.id) {
                     pluginMenuItem.enabled = dynamicItem.visible;
                  }
               });
            });
         });
      }));
   }

   var api = {
      getAction : getAction,
      getActions : getActions,
      getData: getData,
      invokeAction : invokeAction,
      showActionsMenu : showActionsMenu,
      showObjectContextMenu: showObjectContextMenu,
      onCloseObjectContextMenu: onCloseObjectContextMenu, // Angular code wants a teardown event
      buildActionsToolbar : buildActionsToolbar,
      invokeActionWithConfirmation : invokeActionWithConfirmation
   };

   return api;
}]);

/* Copyright 2015-2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 */
angular.module('com.vmware.platform.ui')
.factory('alertService',['$rootScope', '$compile', 'i18nService',
   function($rootScope, $compile, i18nService) {
      'use strict';

      var compiledAlertDialog;
      var scope;

      /**
       * Alert close reasons.
       *
       * Passed to the `closeHandler` callback in the `alertService.error` function.
       *
       * @property REJECTED
       *    Passed when the alert is closed by pressing escape.
       *
       * @property CONFIRMED
       *    Passed when the alert is closed by clicking the OK button.
       */
      var closeReasons = Object.freeze({
         REJECTED: 0,
         CONFIRMED: 1
      });

      /**
       * Show Alert.
       *
       * @param {string} alertOptions
       *    see vxAlert.
       */
      function showAlert(alertOptions) {
         scope = $rootScope.$new();
         scope.alertOptions = alertOptions;
         var alertDialog = angular.element('<div id="alert-popup" '
            + 'class="action-confirmation" '
            + 'vx-alert="alertOptions"></div>');

         compiledAlertDialog = $compile(alertDialog)(scope);
         angular.element("#main-app-div").append(compiledAlertDialog);
      }

      /**
       * Show Alert with the desired title and text
       *
       * @param {string} title
       *    Alert title.
       *
       * @param {string} text
       *    Alert message.
       *
       * @param {callback} closeHandler (optional)
       *    Invoked when the Alert is closed.
       *
       *    Format:
       *       function (reason) { ... }
       *
       *    Where `reason` is one of the close reasons above.
       */
      function error(title, text, closeHandler) {
         function closeWithReason(reason) {
            closeConfirmationDialog();
            if (_.isFunction(closeHandler)) {
               closeHandler(reason);
            }
         }

         var alertOptions = {
            title: title,
            text: text,
            icon: 'vui-icon32-error',
            visible: true,
            confirmOptions: {
               label: i18nService.getString('Common', 'alert.ok'),
               onClick: function () {
                  closeWithReason(closeReasons.CONFIRMED);
               }
            },
            rejectOptions: {
               visible: false,
               onClick: function() {
                  closeWithReason(closeReasons.REJECTED);
               }
            }
         };
         showAlert(alertOptions);
      }
      /**
       * Show warning Alert with OK and Cancel buttons.
       *
       * @param {string} title
       *    Alert title.
       *
       * @param {string} text
       *    Alert message.
       *
       * @param {callback} okHandler
       *    Invoked when the Alert is closed with OK.
       *
       * @param {callback} cancelHandler (optional)
       *    Invoked when the Alert is closed with Cancel.
       */
      function okCancel(title, text, okHandler, cancelHandler) {
         var alertOptions = {
            title: title,
            text: text,
            icon: 'icon-warning-32',
            visible: true,
            confirmOptions: {
               label: i18nService.getString('Common', 'alert.ok'),
               visible: true,
               disabled: false,
               onClick: function () {
                  closeConfirmationDialog();
                  okHandler();
               }
            },
            rejectOptions: {
               label: i18nService.getString('Common', 'alert.cancel'),
               visible: true,
               disabled: false,
               focused: true,
               onClick: function () {
                  closeConfirmationDialog();
                  cancelHandler();
               }
            }
         };
         showAlert(alertOptions);
      }

      function closeConfirmationDialog() {
         // Use evalAsync because when trying to remove the DOM element
         // `$apply already in progress` error occurs after which the next popup show
         // doesn't interpolate it's angular expressions immediately.
         $rootScope.$evalAsync(function() {
            scope.$destroy();
            compiledAlertDialog.remove();
         });
      }

      return {
         error: error,
         okCancel: okCancel,
         closeReasons: closeReasons
      };
   }]);

var platform;
(function (platform) {
    /***
     * The class wraps the ng-next-app/platform/services/authorization/authorization.service.proxy
     */
    var AuthorizationServiceWrapper = (function () {
        function AuthorizationServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(AuthorizationServiceWrapper.prototype, "ng2AuthorizationService", {
            get: function () {
                // Injecting authorization.proxy.service bridged from ng-next-app.
                // Using regular injection within .service('string',[...]) does not work,
                // due to race condition:
                // Downgraded NG2 modules are registered AFTER .service(..) injections are resolved
                // This way we're postponing injection till first call
                if (!this._ng2AuthorizationService) {
                    this._ng2AuthorizationService = this.$injector.get("vcAuthorizationService");
                }
                return this._ng2AuthorizationService;
            },
            enumerable: true,
            configurable: true
        });
        AuthorizationServiceWrapper.prototype.checkPrivilege = function (objectId, privilege) {
            return this.ng2AuthorizationService.checkPrivilege(objectId, privilege);
        };
        AuthorizationServiceWrapper.prototype.checkPrivileges = function (objectId, privileges) {
            return this.ng2AuthorizationService.checkPrivileges(objectId, privileges);
        };
        AuthorizationServiceWrapper.prototype.checkPrivilegesForMultipleObjects = function (objectIds, privileges) {
            return this.ng2AuthorizationService.checkPrivilegesForMultipleObjects(objectIds, privileges);
        };
        AuthorizationServiceWrapper.prototype.checkGrantedPrivilege = function (objectId, privilege) {
            return this.ng2AuthorizationService.checkGrantedPrivilege(objectId, privilege);
        };
        AuthorizationServiceWrapper.prototype.checkGrantedPrivileges = function (objectId, privileges) {
            return this.ng2AuthorizationService.checkGrantedPrivileges(objectId, privileges);
        };
        AuthorizationServiceWrapper.prototype.checkGrantedPrivilegesForMultipleObjects = function (objectIds, privileges) {
            return this.ng2AuthorizationService.checkGrantedPrivilegesForMultipleObjects(objectIds, privileges);
        };
        AuthorizationServiceWrapper.$inject = ["$injector"];
        return AuthorizationServiceWrapper;
    }());
    platform.AuthorizationServiceWrapper = AuthorizationServiceWrapper;
    angular.module("com.vmware.platform.ui")
        .service("authorizationService", AuthorizationServiceWrapper);
})(platform || (platform = {}));



var platform;
(function (platform) {
    var CapabilityService = (function () {
        function CapabilityService($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(CapabilityService.prototype, "vscCapabilityService", {
            get: function () {
                if (!this._vscCapabilityService) {
                    this._vscCapabilityService =
                        this.$injector.get("vscCapabilityService");
                }
                return this._vscCapabilityService;
            },
            enumerable: true,
            configurable: true
        });
        CapabilityService.prototype.getCapability = function (serverGuid, capability) {
            return this.vscCapabilityService.getCapability(serverGuid, capability);
        };
        CapabilityService.$inject = ["$injector"];
        return CapabilityService;
    }());
    platform.CapabilityService = CapabilityService;
    angular.module("com.vmware.platform.ui")
        .service("capabilityService", CapabilityService);
})(platform || (platform = {}));



/* Copyright 2019 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Wrapper over downgraded service \vim-clients\applications\h5\ng-next-app\src\app\platform\services\cis-id-converter\cis-id-converter.service.ts
     */
    var CisIdConverterWrapper = (function () {
        function CisIdConverterWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(CisIdConverterWrapper.prototype, "vcCisIdConverter", {
            get: function () {
                if (!this._vcCisIdConverter) {
                    this._vcCisIdConverter = this.$injector.get("vcCisIdConverter");
                }
                return this._vcCisIdConverter;
            },
            enumerable: true,
            configurable: true
        });
        CisIdConverterWrapper.prototype.toGlobalCisId = function (moRef, serverGuid) {
            return this.vcCisIdConverter.toGlobalCisId(moRef, serverGuid);
        };
        CisIdConverterWrapper.prototype.fromGlobalCisId = function (cisId, moType, serverGuid) {
            return this.vcCisIdConverter.fromGlobalCisId(cisId, moType, serverGuid);
        };
        CisIdConverterWrapper.prototype.toFullCisId = function (cisId, objectType, serverGuid) {
            return this.vcCisIdConverter.toFullCisId(cisId, objectType, serverGuid);
        };
        CisIdConverterWrapper.prototype.toManagedObjectReference = function (cisId, objectType, serverGuid) {
            return this.vcCisIdConverter.toManagedObjectReference(cisId, objectType, serverGuid);
        };
        CisIdConverterWrapper.prototype.getValue = function (cisId) {
            return this.vcCisIdConverter.getValue(cisId);
        };
        CisIdConverterWrapper.prototype.getType = function (cisId) {
            return this.vcCisIdConverter.getType(cisId);
        };
        CisIdConverterWrapper.prototype.getServerGuid = function (cisId) {
            return this.vcCisIdConverter.getServerGuid(cisId);
        };
        CisIdConverterWrapper.$inject = ["$injector"];
        return CisIdConverterWrapper;
    }());
    platform.CisIdConverterWrapper = CisIdConverterWrapper;
    angular.module("com.vmware.platform.ui").service("cisIdConverter", CisIdConverterWrapper);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   angular
      .module('com.vmware.platform.ui')
      .constant('clarityConstants', {
         notifications: {
            type: {
               INFO: 'info',
               SUCCESS: 'success',
               WARNING: 'warning',
               ERROR: 'error'
            }
         },
         keys: {
            ENTER: 13,
            ESC: 27,
            TAB: 9
         }
      });
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   /**
    * Provides modal dialogs based on Clarity Design.
    */
   angular
      .module('com.vmware.platform.ui')
      .service('clarityModalService', clarityModalService);

   clarityModalService.$inject = [
      '$document',
      '$rootScope',
      '$compile',
      '$templateRequest',
      'clarityConstants',
      'clarityModalServiceHelper',
      'dataService',
      '$q',
      'focusTraceService',
      'i18nService',
      'vxModalKeyService',
      '$timeout',
      'modalHelperService',
      'hideBackgroundContentService'
   ];


   function clarityModalService($document,
                                $rootScope,
                                $compile,
                                $templateRequest,
                                clarityConstants,
                                clarityModalHelper,
                                dataService,
                                $q,
                                focusTraceService,
                                i18nService,
                                vxModalKeyService,
                                $timeout,
                                modalHelperService,
                                hideBackgroundContentService) {

      return {
         openModal: openModal,
         openConfirmationModal: openConfirmationModal,
         openOkCancelModal: openOkCancelModal,
         openPopUp: openPopUp
      };

      function openModal(actionEval, availableTargets, dialogData, templateUrl) {
         var scope = clarityModalHelper.prepareModalScope(actionEval,
                                                          availableTargets,
                                                          dialogData,
                                                          templateUrl);

         scope.submitModal = function() {
            if (dialogData.submit) {
               if (dialogData.submit()) {
                  scope.destroyModal();
               }
            }
         };
         _openModal(scope, templateUrl);
         // This is done only to support the SDK use case, see HtmlBridgeService closeDialog.
         return scope;
      }

      /**
       * Creates modal dialog with OK and Cancel buttons.
       *
       * @param modalOptions
       *       title - title of the modal dialog.
       *       message - title of the modal dialog.
       *       contentTemplate - the path to template that is the warning content.
       *       submit - primary button callback
       *       onCancel - cancel button callback
       *
       *       OPTIONAL:
       *       subTitle: {
       *          text: subtitle of the modal dialog
       *          objectId: if text is not specified, you can fetch name for objectId
       *       }
       *       icon - icon class
       *       clarityIcon: configuration object for the clarityIcon according to their iconography
       *       saveButtonLabel - Text for primary button, OK is default text
       *       cancelButtonLabel - Text for the secondary button, Cancel is the default text
       *       preserveNewlines - default FALSE
       *       defaultButton - Specifies which button ('submit' or 'close') is highlighted. 'submit' by default.
       *       hideCancelButton - hide the cancel button from the footer, leaving the modal with only one button.
       *       modalClass - Specify wrapper class for the clarity modal
       *       contentTemplateContext - object to be injected into the scope of the contentTemplate.
       */
      function openConfirmationModal (modalOptions) {
         var templateUrl = 'resources/ui/views/dialogs/confirmationModal.html';
         var scope = $rootScope.$new();
         scope.modalOptions = modalOptions;
         scope.modalOptions.modalOpen = true;
         _.defaults(scope.modalOptions, {
            defaultButton: 'submit',
            showXIcon: true
         });

         var confirmationDefered = $q.defer();
         if (scope.modalOptions.submit === undefined) {
            scope.modalOptions.submit = function() {
               confirmationDefered.resolve(true);
            };
         }
         if (scope.modalOptions.onCancel === undefined) {
            scope.modalOptions.onCancel = function() {
               confirmationDefered.resolve(false);
            };
         }

         setSubtitle(modalOptions);

         scope.submitModal = submitModal;
         scope.onCancelModal = scope.modalOptions.onCancel;

         function submitModal() {

            var closePredicate = scope.modalOptions.submit();
            if (closePredicate || closePredicate === undefined) {
               scope.destroyModal();
            }
         }

         decorateScope(scope, modalOptions);
         _openModal(scope, templateUrl);
         return confirmationDefered.promise;
      }

      /**
       * Creates and opens a modal dialog with OK and Cancel buttons.
       *
       * @param modalOptions - Object containing the parameters used by the dialog.
       *
       *  Example:
       *
       * <pre><code>
       *
       *       var modalOptions = {
       *         title: "Modal Dialog Title",
       *         subTitle: {
       *           objectId: 'vmObjectId',
       *         },
       *         contentTemplate: '/featureFolder/someTemplate.html',
       *         onSubmit: function(){
       *           mutationService.apply(...)
       *         },
       *         dialogData: {
       *           vmName: "My VM",
       *           hostDetails: {
       *             hostName: ''
       *           }
       *         }
       *          ....
       *       }
       *
       * </pre></code>
       *
       *    The following properties are available:
       *
       *      Required:
       *
       *       - title - title of the modal dialog.
       *       - contentTemplate - the path to template that is a content of the modal.
       *          The template must be inside &lt;div class="modal-body"&gt;&lt;/div&gt; tag.
       *       - onSubmit - OK button callback
       *       - onCancel - Cancel button callback
       *
       *      Optional:
       *
       *       - dialogData - all additional data which will be used in the content template
       *       - subTitle.text - text string to display as subtitle
       *       - subTitle.objectId - if subTitle.text is not set, objectId can be provided instead. The objectId's name will be fetched and displayed as the subtitle
       *       - size - modal dialog's size. Values are 'sm', <none>, 'lg', 'xl
       *       - alerts - list of {text, type} notifications to be displayed in the dialog.
       *       - defaultButton - Specifies which button ('submit' or 'close') is highlighted.
       *       - modalClass - Specify wrapper class for the clarity modal
       *       - hideSubmitButton - hides the Submit button from the footer, leaving the modal with only one button.
       *       - closeButtonTitle - title of the close button
       *       - submitButtonTitle - title of the submit button
       *       - submitDisabled : flag to enable/disable the Ok/submit button
       *       - autoHierarchyContext: Whether or not to try to detect the already popup
       *          modals and convey this info to the user via strips attached to the
       *          dialog that is about to open with this call.
       */
      function openOkCancelModal(modalOptions) {
         // if this is a modal in hierarchy context, set the width and height
         // based on the original popup, so they cover each other completely
         if (modalOptions.autoHierarchyContext) {
            modalOptions.hierarchyContext =
                  modalHelperService.discoverHierarchyContext(true);
            const hrhyCtx = modalOptions.hierarchyContext;
            if (hrhyCtx) {
               modalOptions.width = hrhyCtx[hrhyCtx.length - 1].width;
               modalOptions.height = hrhyCtx[hrhyCtx.length - 1].height;
            }

         }

         const isUsingCrlModal = !modalOptions.hierarchyContext;

         // NOTE speev: The okCancelHierarchyModal.html re-invents the okCancelModal
         // by replacing the <clr-modal> tag with <div> and class="modal-xxx" set of
         // styles in order to allow for proper injection of the
         // hierarchical strips. Since we cannot immediately guarantee it is a complete
         // replacement for <clr-modal> and since there are way too much modal dialogs
         // to test for backward compatibility - we use it only when hierarchical
         // context is available assuming the dialog owner will test
         // it when using it as second/third level popup. For the other first level
         // dialogs we use the okCancelModal that pre-existed to maintain 100%
         // the backward compatible behavior.
         var templateUrl = isUsingCrlModal ?
               'resources/ui/views/dialogs/okCancelModal.html' :
               'resources/ui/views/dialogs/okCancelHierarchyModal.html';

         validateModalOptions(modalOptions);
         setSubtitle(modalOptions);

         // if the dialog is in hierarchy context
         // we set the styles based on the original popup
         // we also want to change them in case the original popup has been resized
         const hrhyCtx = modalOptions.hierarchyContext;
         if (hrhyCtx) {
            modalOptions.getStyle = function() {
               if (modalOptions.width && modalOptions.height) {
                  return {
                     width: modalOptions.width,
                     height: modalOptions.height,
                     margin: 0
                  };
               }

               return {};
            };
         }

         var scope = $rootScope.$new();
         scope.modalOptions = _.extend(
               modalOptions ? modalOptions : {}, {
               modalOpen: true,
               submitDisabled: _.has(modalOptions, "submitDisabled") ? modalOptions.submitDisabled : false
            });

         scope.instanceId = Math.random().toString().substring(2);
         scope.getHierarchyBlockWidth = function () {
            // The width is the parent height due to the rotation afterwards
            return $('#' + scope.instanceId).get(0).offsetHeight;
         };

         scope.onSubmitModal = onSubmitModal;
         scope.onCancelModal = scope.modalOptions.onCancel;

         scope.$watch(function() {
            return scope.modalOptions.alerts;
         }, function(alerts) {
            _.forEach(alerts, function(alert) {
               switch (alert.type) {
                   case clarityConstants.notifications.type.ERROR:
                       alert.className = 'danger';
                       alert.iconShape = 'exclamation-circle';
                       break;

                   case clarityConstants.notifications.type.WARNING:
                       alert.className = 'warning';
                       alert.iconShape = 'exclamation-triangle';
                       break;

                   case clarityConstants.notifications.type.INFO:
                       alert.className = 'info';
                       alert.iconShape = 'info-circle';
                       break;

                   case clarityConstants.notifications.type.SUCCESS:
                       alert.className = 'success';
                       alert.iconShape = 'check-circle';
                       break;

                   default:
                       alert.className = '';
                       alert.iconShape = null;
               }
            });
         });

         decorateScope(scope, modalOptions);
         _openModal(scope, templateUrl);

         function validateModalOptions(modalOptions) {
            if (!hasNonEmptyStringProperty(modalOptions, 'title')) {
               throw Error('modalOptions.title is not defined or is empty.');
            }

            if (!hasNonEmptyStringProperty(modalOptions, 'contentTemplate')) {
               throw Error('modalOptions.contentTemplate is not defined or is empty.');
            }
         }



         function onSubmitModal() {
            //prevent modal resubmission
            if(!scope.isSubmitInProgress) {
               if (typeof scope.modalOptions.onSubmit === 'function') {
                  var onSubmitResult = scope.modalOptions.onSubmit();
                  if (onSubmitResult === true) {
                     scope.destroyModal();
                  } else if (onSubmitResult !== false && onSubmitResult !== undefined) {
                     scope.isSubmitInProgress = true;
                     onSubmitResult.then(function(promiseResult) {
                        if (promiseResult === true) {
                           scope.destroyModal();
                        }
                        scope.isSubmitInProgress = false;
                     }, function() {
                        scope.isSubmitInProgress = false;
                     });
                  }
               }
            }
         }
      }

      /**
       * Creates pop-up dialog with a header.
       *
       * @param scope
       *    The pop-up's scope. It contains modalOptions property as it is described
       *    below.
       *
       *    scope.modalOptions
       *       title - title of the pop-up dialog.
       *       size - pop-up's size. Values are 'sm', <none>, 'lg'.
       *       contentUrl - the path to template that is a content of the pop-up.
       *          The template must be inside &lt;div class="modal-body"&gt;&lt;/div&gt; tag.
       */
      function openPopUp(scope) {
         //  Why does template need alerts, if none of the callers use it?
         var templateUrl = 'resources/ui/views/dialogs/popUpDialog.html';

         scope.modalOptions = angular.extend(
            scope.modalOptions || {}, {
               modalOpen: true
            });

         _openModal(scope, templateUrl);
      }

      function _openModal(scope, templateUrl) {
         var modal;

         scope.closeModal = closeModal;
         scope.destroyModal = destroyModal;
         if (!scope.modalOptions.focusTarget) {
            scope.modalOptions.focusTarget = focusTraceService.popFocusableElement();
         }

         var bodyElement = angular.element($document[0].body);
         var hiddenElements = hideBackgroundContentService.hideElements();
         $templateRequest(templateUrl).then(function(template) {
            // Attach our handlers before clarity's
            setKeyPressHandler('on');
            $(window).on('resize', resizeModal);

            modal = $compile(template)(scope);

            bodyElement.append(modal);

            scope.$watch('modalOptions.modalOpen', function(newValue, oldValue) {
               if (oldValue && !newValue) {
                  scope.$evalAsync("closeModal()");
               }
            });

            scope.$on('$destroy', function() {
               setKeyPressHandler('off');
               $(window).off('resize', resizeModal);
               hideBackgroundContentService.showElements(hiddenElements);
            });
         });

         var onKeydownHandler = function ($event) {
            vxModalKeyService.onKeydownHandler($event, closeModal.bind(this));
         };

         function resizeModal() {
            kendo.resize(modal, true);
            if (scope.modalOptions.hierarchyContext) {
               const resizedWindow = modalHelperService.retrieveFirstLevelPopupSizes();
               if (resizedWindow) {
                  scope.modalOptions.width = resizedWindow.width;
                  scope.modalOptions.height = resizedWindow.height;
               }
            }
         }

         function destroyModal() {
            setKeyPressHandler('off');
            $(window).off('resize', resizeModal);

            // move the focus back to the trigger element if there is any
            if (scope.modalOptions.focusTarget) {
               var focusElement = scope.modalOptions.focusTarget;
               // Without timeout the element is some time focused sometime
               // not
               $timeout(function () {
                  if (focusElement) {
                    focusElement.focus();
                    focusElement = null;
                  }

               },0);
            }
            delete scope['closeModal'];

            scope.$destroy();

            if(modal) {
               modal.remove();
               modal = null;
            }
         }

         function closeModal(result) {
            if (_.isFunction(scope.onCancelModal)) {
               scope.onCancelModal(result);
            }
            destroyModal();
         }

         // Turn the keypress handler on/off
         function setKeyPressHandler(state) {
            if (state === 'on') {
               $document.on('keydown', onKeydownHandler);
               // Shadow Clarity's keyup handler on the body.
               $document.find('body').on('keyup', onKeyUp);
            } else {
               $document.off('keydown', onKeydownHandler);
               $document.find('body').off('keyup', onKeyUp);
            }
         }

         function onKeyUp(event) {
            var keyCode = event.which || event.keyCode;

            if (keyCode === clarityConstants.keys.ENTER
                  || keyCode === clarityConstants.keys.ESC) {
               event.stopImmediatePropagation();
               event.preventDefault();
               return false;
            }

            return true;
         }
      }

      function setSubtitle(modalOptions) {
         if (_.has(modalOptions, 'subTitle') && _.isObject(modalOptions.subTitle)) {
            if (hasNonEmptyStringProperty(modalOptions.subTitle, 'text')) {
               modalOptions.subTitle = modalOptions.subTitle.text;
            }
            else if (hasNonEmptyStringProperty(modalOptions.subTitle, 'objectId')) {
               var objectId = modalOptions.subTitle.objectId;
               modalOptions.subTitle = '';
               dataService
                     .getProperties(objectId, ['name'])
                     .then(function(data) {
                        if (data && data.name) {
                           modalOptions.subTitle = data.name;
                        }
                     });
            } else {
               modalOptions.subTitle = '';
            }
         }
      }

      function hasNonEmptyStringProperty(object, property) {
         return _.has(object, property) && isNonEmptyString(object[property]);
      }

      function isNonEmptyString(string) {
         return !_.isUndefined(string) && !_.isNull(string) && _.isString(string) && !_.isEmpty(
                     string);
      }

      function decorateScope(scope, modalOptions) {
         scope.getOkBtnLabel = function () {
            return modalOptions.saveButtonLabel !== undefined ?
               modalOptions.saveButtonLabel :
               i18nService.getString("Common", "saveButtonLabel");
         };

         scope.getCancelBtnLabel = function () {
            return modalOptions.cancelButtonLabel !== undefined ?
               modalOptions.cancelButtonLabel :
               i18nService.getString("Common", "cancelButtonLabel");
         };
      }
   }
})();

(function() {
   'use strict';

   /**
    * Provides modal dialogs based on Clarity Design.
    */
   clarityModalServiceHelper.$inject = ['$rootScope', 'dataService', 'i18nService'];
   angular
         .module('com.vmware.platform.ui')
         .service('clarityModalServiceHelper', clarityModalServiceHelper);

   clarityModalServiceHelper.inject = [
      '$rootScope',
      'dataService',
      'i18nService'
   ];

   function clarityModalServiceHelper($rootScope, dataService, i18nService) {
      return {
         prepareModalScope: prepareModalScope
      };


      function prepareModalScope(actionEval, availableTargets, dialogData, templateUrl) {
         var scope = $rootScope.$new();

         scope.modalOptions = {
            modalOpen: true,
            iconClass: actionEval && actionEval.action ? actionEval.action.icon : '',
            contentUrl: templateUrl,
            actionEval: actionEval,
            availableTargets: availableTargets,
            dialogData: dialogData,
            defaultButton: dialogData ? dialogData.defaultButton : '',
            title: dialogData ? dialogData.title : '',
            size: dialogData ? dialogData.size : '',
            secondaryTitle: dialogData ? dialogData.secondaryTitle : '',
            focusTarget: dialogData && dialogData.focusTarget ? $(dialogData.focusTarget) : null
         };

         constructAndSetModalOptionsTitle(scope.modalOptions);

         return scope;
      }

      /**
       * Immediately returns some title so that the dialog can be shown as soon as
       * possible.
       * If needed, schedules a request for the target object's name.
       */
      function constructAndSetModalOptionsTitle(modalOptions) {
         var availableTargets = modalOptions.availableTargets;
         if (!availableTargets) {
            modalOptions.title = undefined;
         } else if (_.isEmpty(availableTargets) || availableTargets.length === 1) {
            setTitleForSingleEntity(modalOptions);
         } else {
            setTitleForMultipleEntities(modalOptions);
         }
      }

      function setTitleForSingleEntity(modalOptions) {
         var primaryTitle = modalOptions.title;
         if (primaryTitle && titleContainsPlaceholder(primaryTitle)) {
            setTitleToPlaceholderValue(modalOptions);
         } else if (primaryTitle && !titleContainsPlaceholder(primaryTitle)) {
            constructAndSetSecondaryTitle(modalOptions);
         } else if (!primaryTitle) {
            setPrimaryTitleToActionLabel(modalOptions);
            constructAndSetSecondaryTitle(modalOptions);
         }
      }

      function setTitleForMultipleEntities(modalOptions) {
         modalOptions.title = i18nService.getString('Common', 'dialogTitleFormatMultiple', modalOptions.availableTargets.length, "");
      }

      function titleContainsPlaceholder(title) {
         return title.indexOf('{0}') !== -1;
      }

      function setTitleToPlaceholderValue(modalOptions) {
         var availableTarget = modalOptions.availableTargets[0];
         if (availableTarget) {
            dataService
                  .getProperties(availableTarget, ['name'])
                  .then(function(data) {
                     if (data && data.name) {
                        modalOptions.title = i18nService.interpolate(modalOptions.title, [data.name]);
                        modalOptions.secondaryTitle = null;
                     }
                  });
         }
      }

      function setPrimaryTitleToActionLabel(modalOptions) {
         modalOptions.title = modalOptions.actionEval.action.label.replace(/\.+$/g, "");
      }

      function constructAndSetSecondaryTitle(modalOptions) {
         var secondaryTitle = modalOptions.secondaryTitle;
         if (!secondaryTitle) {
            fetchSecondaryTitleNameFromObjectId(modalOptions);
         }
      }

      function fetchSecondaryTitleNameFromObjectId(modalOptions) {
         var availableTarget = modalOptions.availableTargets[0];
         if (availableTarget) {
            dataService
                  .getProperties(availableTarget, ['name'])
                  .then(function(data) {
                     if (data && data.name) {
                        modalOptions.secondaryTitle = data.name;
                     }
                  });
         }
      }
   }
})();

/* Copyright 2019 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var ClientLocaleServiceWrapper = (function () {
        function ClientLocaleServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(ClientLocaleServiceWrapper.prototype, "vcClientLocaleService", {
            get: function () {
                if (!this._vcClientLocaleService) {
                    this._vcClientLocaleService = this.$injector.get('vcClientLocaleService');
                }
                return this._vcClientLocaleService;
            },
            enumerable: true,
            configurable: true
        });
        ClientLocaleServiceWrapper.prototype.get = function () {
            return this.vcClientLocaleService.get();
        };
        ClientLocaleServiceWrapper.$inject = ['$injector'];
        return ClientLocaleServiceWrapper;
    }());
    platform.ClientLocaleServiceWrapper = ClientLocaleServiceWrapper;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.clientLocale
     * @module com.vmware.platform.ui
     *
     * @description
     *    Client locale Service.
     */
    angular.module('com.vmware.platform.ui').service('clientLocale', ClientLocaleServiceWrapper);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   angular.module('com.vmware.platform.ui').service('commonActionBarService', CommonActionBarService);

   CommonActionBarService.$inject = ['actionsService', 'vuiConstants', '$q'];

   function CommonActionBarService(actionsService, vuiConstants, $q) {
      var pendingActionRequestsData = [];
      return {
         createActionBar: createActionBar,
         updateActionBar: updateActionBar
      };

      function updateActionBar(actionsWrapperObject,
                               actionsPropertyName,
                               targetIds,
                               actionSpecs,
                               commonActionBarServiceCacheObject) {
         if(actionsWrapperObject[actionsPropertyName] &&
             actionsWrapperObject[actionsPropertyName].length) {
            return refreshActionBar(actionsWrapperObject,
                actionsPropertyName,
                targetIds,
                actionSpecs,
                commonActionBarServiceCacheObject);
         } else {
            return createActionBar(actionsWrapperObject, actionsPropertyName,
                targetIds, actionSpecs, commonActionBarServiceCacheObject);
         }
      }

      function createActionBar(actionsWrapperObject, actionsPropertyName, targetIds,
            actionSpecs, commonActionBarServiceCacheObject) {
         // this is needed to prevent 'no actions passed' error when loading the action
         // bar for the very first time
         if (!actionsWrapperObject[actionsPropertyName]) {
            actionsWrapperObject[actionsPropertyName] = [];
         }

         var actionEvalsPromise = commonActionBarServiceCacheObject ?
               commonActionBarServiceCacheObject :
               requestActions(targetIds, actionSpecs);

         return $q.when(actionEvalsPromise).then(function(actionEvalsById) {
            var actionButtons = [];
            _.forEach(actionSpecs, function(actionSpec) {
               var button;
               if (actionSpec === vuiConstants.actions.SEPARATOR) {
                  button = createSeparator();
                  if (button) {
                     actionButtons.push(button);
                  }
                  return;
               }

               if (actionSpec && actionSpec.actionId) {
                  button = createActionButton(
                        actionEvalsById[actionSpec.actionId],
                        getOnActionInvocationFunction(actionSpec, actionEvalsById),
                        actionSpec);
                  if (button) {
                     actionButtons.push(button);
                  }
               }
            });

            // the action bar is updated at once when all the buttons are created to
            // prevent the UI from flickering - if you initially reset (remove all the
            // actions ) the actions bar and then update the actions one by one UI is
            // flickering
            actionsWrapperObject[actionsPropertyName] = actionButtons;
            return actionEvalsById;
         });
      }

      function refreshActionBar(actionsWrapperObject,
                                actionsPropertyName,
                                targetIds,
                                actionSpecs,
                                commonActionBarServiceCacheObject) {
         var actionEvalsPromise = null;
         if(commonActionBarServiceCacheObject) {
            actionEvalsPromise = commonActionBarServiceCacheObject;
         } else {
            actionEvalsPromise = requestActions(targetIds, actionSpecs);
         }

         return $q.when(actionEvalsPromise).then(function(actionEvalsById) {
            var actionSpecsById = {};
            _.forEach(actionSpecs, function(spec) {
               actionSpecsById[spec.actionId] = spec;
            });
            _.forEach(actionsWrapperObject[actionsPropertyName], function(actionButton) {
               if(actionButton === vuiConstants.actions.SEPARATOR) {
                  return;
               }
               var actionId = actionButton.actionId;
               var actionEval = actionEvalsById[actionId];
               actionButton.onClick = getOnActionInvocationFunction(actionSpecsById[actionId], actionEvalsById);
               updateActionButtonAvailability(actionButton, actionEval);
               updateActionButtonVisibility(actionButton, actionEval);
            });
            return actionEvalsById;
         });
      }

      function createSeparator() {
         return vuiConstants.actions.SEPARATOR;
      }

      function createActionButton(actionEval, onClickCallback, actionSpec) {
         if(!actionEval) {
            return;
         }
         var label = actionEval.action.label;
         var tooltipText = actionEval.action.description;

         if(actionSpec.noLabel) {
            label = null;
            tooltipText = actionEval.action.label;
         }

         if(actionSpec.customLabel) {
            label = actionSpec.customLabel;
         }

         var actionButton = {
            actionId: actionEval.action.uid,
            tooltipText: tooltipText,
            label: label,
            iconClass: actionSpec.hideIcon ? "" : actionEval.action.icon,
            onClick: onClickCallback,
            isAvailableCustomCallback: actionSpec.isActionAvailable,
            isVisibleCustomCallback: actionSpec.isActionVisible
         };

         updateActionButtonAvailability(actionButton, actionEval);
         updateActionButtonVisibility(actionButton, actionEval);

         return actionButton;
      }

      function updateActionButtonAvailability(actionButton, actionEval) {
         if(!actionButton) {
            return;
         }

         if(!actionEval) {
            actionButton.enabled = false;
            return;
         }

         if(actionButton.isAvailableCustomCallback) {
            actionButton.enabled = !!actionButton.isAvailableCustomCallback(actionEval);
         } else {
            actionButton.enabled = !!actionEval.available;
         }
      }

      function updateActionButtonVisibility(actionButton, actionEval) {
         if (!actionButton) {
            return;
         }
         if (!actionEval) {
            actionButton.visible = true;
         }

         if(actionButton.isVisibleCustomCallback) {
            actionButton.visible = !!actionButton.isVisibleCustomCallback(actionEval);
         } else {
            actionButton.visible = true;
         }
      }

      /**
       * Requests action definitions for all action IDs in actionSpec array
       * @return map with action's uid as keys and actionDefintions as values.
       */
      function requestActions(targetIds, actionSpecs) {
         if(!actionSpecs) {
            return $q.when({});
         }

         var actionIds = actionSpecs.filter(function(actionSpec) {
            return actionSpec && actionSpec.actionId;
         }).map(function(actionSpec) {
            return actionSpec.actionId;
         });

         if(!actionIds || !actionIds.length) {
            return $q.when({});
         }

         var pendingActionRequestId = actionIds.join('\n');
         var pendingActionRequestData = pendingActionRequestsData[pendingActionRequestId];
         if (!pendingActionRequestData) {
            pendingActionRequestData = {
               targetIds: targetIds
            };
            pendingActionRequestsData[pendingActionRequestId] = pendingActionRequestData;
            pendingActionRequestData.request =
                requestActionsFromActionsService(targetIds, actionIds, pendingActionRequestId);
         } else {
            pendingActionRequestData.targetIds = targetIds;
         }

         return pendingActionRequestData.request
             .then(function(actionEvals) {
                return angular.copy(actionEvals);
             });
      }

      function requestActionsFromActionsService(targetIds, actionIds, pendingActionRequestId) {
         return actionsService.getActions(targetIds, actionIds).then(function(actionEvals) {

            var pendingRequest = pendingActionRequestsData[pendingActionRequestId];
            if (!angular.equals(targetIds, pendingRequest.targetIds)) {
               return requestActionsFromActionsService(pendingRequest.targetIds, actionIds, pendingActionRequestId);
            }

            var actionEvalsById = {};
            _.forEach(actionEvals, function(actionEval) {
               actionEvalsById[actionEval.action.uid] = actionEval;
            });

            delete pendingActionRequestsData[pendingActionRequestId];

            return actionEvalsById;
         });
      }

      function getOnActionInvocationFunction(actionSpec, actionEvalsById) {
         return function($event) {
            var actionEval = actionEvalsById[actionSpec.actionId];
            if(actionSpec.onInvokeAction) {
               actionSpec.onInvokeAction(actionEval);
            }
            var actionInvocationContext = actionSpec.getActionInvocationContext ?
                actionSpec.getActionInvocationContext() : null;
            if ($event && $event.currentTarget) {
               actionInvocationContext = actionInvocationContext ? angular.copy(actionInvocationContext) : {};
               actionInvocationContext.focusTarget = $event.currentTarget;
            }
            actionsService.invokeAction(actionEval, actionInvocationContext);
         };
      }
   }
})();


/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Provides webclient.properties flags and feature states.
 * Returns true if feature is enabled or false otherwise.
 */
(function() {
   "use strict";
   angular.module("com.vmware.platform.ui")
         .factory("configurationService", configurationService);

   configurationService.$inject = ["$http","$q", "logService"];

   function configurationService($http, $q, logService) {

      var log = logService("configurationService");

      var getConfiguration = function() {
         return $q.when(h5.configuration);
      };

      var getProperty = function (propertyName) {
         return getConfiguration().then(function(configPayload) {
            if (configPayload && configPayload.configParams) {
               return configPayload.configParams[propertyName];
            }
            return undefined;
         });
      };

      var getFeatureState = _.memoize(function (featureName) {
         return getConfiguration().then(function(configPayload) {
            if (configPayload && configPayload.featureStates) {
               return configPayload.featureStates[featureName];
            }
            return undefined;
         });
      });

      var isFeatureEnabled = _.memoize(function (featureName) {
         return getFeatureState(featureName).then(function(featureState) {
            return !!(featureState && featureState === "ENABLED");
         });
      });

      return {
         getConfiguration: getConfiguration,
         getProperty: getProperty,
         isFeatureEnabled: isFeatureEnabled
      };
   }
})();

/*
 *  Copyright 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 */

(function() {

   'use strict';

   angular.module('com.vmware.platform.ui')
      .service('confirmationModalService', confirmationModalService);

   confirmationModalService.$inject = ['$compile', '$rootScope', 'i18nService', 'clarityModalService','defaultUriSchemeUtil'];

   function confirmationModalService($compile, $rootScope, i18nService, clarityModalService, defaultUriSchemeUtil ) {

      return {
         showConfirmationDialog: showConfirmationDialog,
         showWarningDialog: showWarningDialog
      };


      /**
       * Displays a confirmation dialog for an action.
       *
       * @static
       * @memberOf confirmationModalService
       * @param {Object} alertProperties An object with properties describing the dialog:
       *    title {string} - The title of the dialog.
       *    message {string} - The message in the dialog.
       *    yesHandler {Function} - A function called if the 'Yes' button is pressed.
       *    noHandler {Function} - A function called if the 'No' button is pressed.
       *
       *    OPTIONAL:
       *    useClarity {boolean} - Whether to use a clarity dialog or a vx one.
       *       Clarity is recommended, so set this to true.
       *    icon {string} - The icon to use. Its default value is "icon-warning-32".
       *       If null is used, there is no icon.
       *    yesIsDefaultButton {boolean} - The button focused by default is 'Yes' if this
       *       evaluates to true. This property works only if useClarity is set to true!
       * @returns {void}
       * @example
       * confirmationModalService.showConfirmationDialog({
       *    useClarity: true,
       *    title: 'Log "foo"',
       *    message: 'Press the "Yes" button to log "foo" in the console.',
       *    yesHandler: function() { console.log('foo') }
       * });
       */
      function showConfirmationDialog(alertProperties) {
         _.defaults(alertProperties, {
            icon: 'icon-warning-32',
            yesHandler: function () {},
            noHandler: function () {}
         });
         _.extend(alertProperties, {
            yesLabel: i18nService.getString('Common', 'yes.label'),
            noLabel: i18nService.getString('Common', 'no.label')
         });

         if (alertProperties.useClarity) {
            showClarityConfirmationDialog(alertProperties);
         } else {
            showVxConfirmationDialog(alertProperties);
         }
      }

      function showVxConfirmationDialog(alertProperties) {
         var scope = $rootScope.$new();

         scope.alertOptions = {
            title: alertProperties.title,
            text: alertProperties.message,
            icon: alertProperties.icon,
            visible: true,
            confirmOptions: {
               label: alertProperties.yesLabel,
               visible: true,
               disabled: false,
               onClick: function() {
                  alertProperties.yesHandler();
                  closeConfirmationDialog();
               }
            },
            rejectOptions: {
               label: alertProperties.noLabel,
               visible: true,
               disabled: false,
               focused: true,
               onClick: function() {
                  alertProperties.noHandler();
                  closeConfirmationDialog();
               }
            }
         };
         var alertTemplate = '<div id="action-confirmation" ' +
            'class="action-confirmation" vx-alert="alertOptions"></div>';
         var alertDialog = angular.element(alertTemplate);
         var compiledAlertDialog = $compile(alertDialog)(scope);

         var parentId = alertProperties.parent || "#main-app-div";
         angular.element(parentId).append(compiledAlertDialog);
      }

      function showClarityConfirmationDialog(alertProperties) {
         if (alertProperties.subTitle && alertProperties.subTitle.objectId &&
            !defaultUriSchemeUtil.isValidManagedObjectId(alertProperties.subTitle.objectId)) {
            alertProperties.subTitle.objectId = null;
         }
         var modalOptions = {
            title: alertProperties.title,
            subTitle: alertProperties.subTitle,
            message: alertProperties.message,
            icon: alertProperties.icon,
            preserveNewlines: true,
            saveButtonLabel: alertProperties.yesLabel,
            cancelButtonLabel: alertProperties.noLabel,
            showXIcon: alertProperties.showXIcon,
            submit: alertProperties.yesHandler,
            onCancel: alertProperties.noHandler,
            alertText: alertProperties.alertText,
            alertType: alertProperties.alertType || 'warning'
         };

         if (!_.isEmpty(alertProperties.clarityIcon)) {
            modalOptions.clarityIcon = alertProperties.clarityIcon;
         }

         if(!alertProperties.yesIsDefaultButton) {
            modalOptions.defaultButton = 'close';
         }

         clarityModalService.openConfirmationModal(modalOptions);
      }

      function closeConfirmationDialog() {
         angular.element("#action-confirmation").remove();
      }

      function showWarningDialog(alertProperties) {
         clarityModalService.openConfirmationModal({
            title: alertProperties.title,
            message: alertProperties.message,
            submit: function () {},
            preserveNewlines: true,
            saveButtonLabel: i18nService.getString('Common', 'alert.ok'),
            cancelButtonLabel: null,
            hideCancelButton: true,
            clarityIcon: {
               shape: "warning",
               class: "is-warning",
               size: 48
            },
            showXIcon: false,
            alertText: alertProperties.alertText,
            alertType: alertProperties.alertType || 'warning'
         });
      }
   }
})();

(function () {
   'use strict';
   angular
         .module('com.vmware.platform.ui')
         .factory('contextObjectService', contextObjectService);
   contextObjectService.$inject = ['navigation'];

   /**
    * @ngdoc service
    * @name contextObjectService
    * @module com.vmware.platform.ui
    *
    * @description
    *    Service to get the selected context objects
    * @param navigation
    * @returns {{
         getSelection: getSelection
      }}
    */
   function contextObjectService(navigation) {
      var service = {
         getSelection: getSelection
      };

      return service;

      /**
       * Returns the selected context objects
       * @returns [selectedElements]
       */
      function getSelection() {
         //used to check if a modal has been opened
         //this is the class of the modal background
         //if a modal exists with different class this check will not work.
         //The class should be added to the check as well
         var modalOpened = $('div[class*="modal-backdrop"]');

         var selection = [];
         if(modalOpened.length === 0) {
            var contentList = $('div[vx-extension-view-id="vsphere.core.inventory.serverObjectViewsExtension"] list-view div[kendo-grid]:first');
            if (contentList.length > 0) {
               var grid = contentList.data('kendoGrid');
               var selectedRows = grid.select();
               if (selectedRows.length > 0) {
                  for (var i = 0; i < selectedRows.length; i++) {
                     var data = grid.dataItem(selectedRows[i]);
                     selection.push(data.id);
                  }
               }
            } else {
               var objectId = navigation.getObjectId();
               if (objectId) {
                  selection.push(objectId);
               }
            }
         }
         return selection;
      }

   }
}());


/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var CurrentObjectService = (function () {
        function CurrentObjectService($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(CurrentObjectService.prototype, "vcCurrentObjectService", {
            // Using the late-binding pattern to get the service from the
            // injector only when its called for usage the first time.
            // Could have called this in the constructor to set up the class
            // but due to timing difference of ng1 and ng5, lets use this
            // late-binding pattern.
            get: function () {
                if (!this.service) {
                    this.service = this.$injector.get('vcCurrentObjectService');
                }
                return this.service;
            },
            enumerable: true,
            configurable: true
        });
        CurrentObjectService.prototype.getObjectId = function () {
            return this.vcCurrentObjectService.getObjectId();
        };
        CurrentObjectService.$inject = ["$injector"];
        return CurrentObjectService;
    }());
    platform.CurrentObjectService = CurrentObjectService;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.currentObjectService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Utility methods for fetching data from the /data endpoint.
     */
    angular.module("com.vmware.platform.ui").service("currentObjectService", CurrentObjectService);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').service('datagridActionBarService',
         ['commonActionBarService', function(commonActionBarService) {

            function updateActionBar(datagridOptions, targetIds, actionSpecs, datagridActionBarServiceCacheObject) {
               var actionBarOptions;
               if(datagridOptions.actionsOptions) {
                  actionBarOptions = datagridOptions.actionsOptions;
                  datagridOptions.toolbar = [{
                     template: "<action-bar options=\"datagridOptions.actionsOptions\"></action-bar>"
                  }];
               } else {
                  datagridOptions.actionBarOptions = datagridOptions.actionBarOptions || {};
                  actionBarOptions = datagridOptions.actionBarOptions;
               }

               return commonActionBarService.updateActionBar(
                     actionBarOptions,
                     'actions',
                     targetIds,
                     actionSpecs,
                     datagridActionBarServiceCacheObject
               );
            }

            return {
               updateActionBar: updateActionBar
            };
         }]);
})();

var platform;
(function (platform) {
    var DataService = (function () {
        function DataService($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(DataService.prototype, "vcDataService", {
            get: function () {
                if (!this._vcDataService) {
                    this._vcDataService = this.$injector.get("vcDataService");
                }
                return this._vcDataService;
            },
            enumerable: true,
            configurable: true
        });
        DataService.prototype.getData = function (objectId, modelClassName, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getData(objectId, modelClassName, options);
        };
        DataService.prototype.getProperties = function (objectId, properties, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getProperties(objectId, properties, options);
        };
        DataService.prototype.getPropertiesForObjects = function (objectIds, properties, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getPropertiesForObjects(objectIds, properties, options);
        };
        DataService.prototype.getPropertiesByRelation = function (objectId, relation, targetType, properties, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getPropertiesByRelation(objectId, relation, targetType, properties, options);
        };
        DataService.prototype.getPropertiesByFilter = function (filter, properties, resourceModels, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getPropertiesByFilter(filter, properties, resourceModels, options);
        };
        DataService.$inject = ["$injector"];
        return DataService;
    }());
    platform.DataService = DataService;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.dataService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Utility methods for fetching data from the /data endpoint.
     */
    angular.module("com.vmware.platform.ui").service("dataService", DataService);
})(platform || (platform = {}));



/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Utility method
 */
angular.module('com.vmware.platform.ui').factory('extensionCategoryUtil', [
function() {
   'use strict';
   return {
      /*
       * Given the categories(parentExtensions) and a list of childextensions, map the
       * children to a parent by matching the categoryUid of the child with the uid of the parent
       *
       */
      mergeCategories: function(categories, extensions) {
         if (!(extensions && extensions[0])) {
            return [];
         }
         //Add two empty categories to handle uncategorised extensions

         var UNCATEGORIZED_VSPHERE_EXT = "_Uncategorized_vSphere_Extensions_";
         var UNCATEGORIZED_PLUGIN_EXT = "_Uncategorized_Plugin_Extensions_";
         categories.push({uid: UNCATEGORIZED_VSPHERE_EXT});
         categories.push({uid: UNCATEGORIZED_PLUGIN_EXT});
         // [childSpecs] to {categoryId,[extensions]}
         var group = _(extensions).groupBy(function(extension) {
            if (!extension.categoryUid) {
               if (extension.contentSpec && extension.contentSpec.sandbox) {
                  extension.categoryUid = UNCATEGORIZED_PLUGIN_EXT;
               } else {
                  extension.categoryUid = UNCATEGORIZED_VSPHERE_EXT;
               }
            }
            return extension.categoryUid;
         });

         var combinedCategories = _.chain(categories)
               .map(function(category) {
                  if (!group[category.uid]) {
                      return null;
                  }
                  var extensions = group[category.uid];
                  var isExternalPlugin = extensions && extensions[0] &&
                        extensions[0].contentSpec && extensions[0].contentSpec.sandbox;
                  return {
                     title: category.label,
                     exts: group[category.uid],
                     categoryId: category.uid,
                     isExternalPlugin: isExternalPlugin
                  };
               })
               .compact()
               .partition(function (category) {
                  return category.isExternalPlugin;
               })
               .sortBy(function (partition) {
                  var isExternalPlugin = partition.length && partition[0].isExternalPlugin;
                  return isExternalPlugin ? 1 : 0;
               })
               .compact()
               .flatten(true).value();
         return combinedCategories;
      }
   };
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Defines extension framework related constants
 */
angular.module('com.vmware.platform.ui').constant('extensionFrameworkConstants', {
   ViewRetentionPolicy: {
      NONE: "NONE",
      INHERIT: "INHERIT",
      SELF_ONLY: "SELF_ONLY",
      DESCENDANTS_ONLY: "DESCENDANTS_ONLY",
      SELF_AND_DESCENDANTS: "SELF_AND_DESCENDANTS"
   }
});


/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Handles extension related logic.
 */
angular.module('com.vmware.platform.ui').factory('extensionService', ['$http',
function($http) {
   return {
      /**
       * Get a extensions array keyed by a pointId, the array content is filtered using the objectId.
       */
      getExtensions: function(pointId, objectId) {
         var params;
         if (angular.isDefined(objectId) && objectId !== null) {
            params = {
               objectId: objectId
            };
         }
         return $http({
            method: 'get',
            url: 'extensions/' + pointId,
            params: params
         }).then(function(resp){
            return resp.data;
         });
      },
      /**
       * Gets the list of the filtered extension infos hosted by the
       * extension point with the given ID.
       *
       * @param {string} pointId the ID of the extension point whose hosted
       * extension infos are to be retrieved
       * @returns {Promise<any[]>} a promise for the list of the
       * extension infos hosted by the extension point
       */
      getExtensionInfos: function(pointId) {
         return $http({
            method: 'get',
            url: 'extensionInfos/' + pointId
         }).then(function(resp){
            return resp.data;
         });
      },
      /**
       * Given a extension, determine the child pointId, and return the associated extensions array filtered by the objectId.
       *
       * Note: in plugin.xml, the child pointId is specified as the "hostedPoint" of a extension.
       */
      getHostedExtensions: function(extensionId, objectId) {
         var params;
         if (angular.isDefined(objectId) && objectId !== null) {
            params = {
               objectId: objectId
            };
         }
         return $http({
            method: 'get',
            url: 'hostedextensions/' + extensionId,
            params: params
         }).then(function(resp){
            return resp.data;
         });
      },

      /**
       * Check if new plugins have been registered after login
       */
      checkForNewPlugins: function() {
         return $http({
            method: 'get',
            url: 'checkForNewPlugins',
            skipLoadingNotification: true
         }).then(function(resp){
            return resp.data;
         });
      },
   };
}]);

(function () {
  "use strict";
  angular
    .module("com.vmware.platform.ui")
    .service("featureFlagsService", featureFlagsService);

  featureFlagsService.$inject = ["configurationService"];

  function featureFlagsService(configurationService) {
    var self = {};

    fetchFeatureFlag("h5uiVmLibraryActionAddFlag");
    fetchFeatureFlag("h5uiDirectIsoMountFromCL");
    fetchFeatureFlag("h5uiAddNetworkingBindToPnic");
    fetchFeatureFlag("h5uiNRP");
    fetchFeatureFlag("h5uiSmartSearch");
    fetchFeatureFlag("VMcrypt_OnlineVMEncryption");
    fetchFeatureFlag("PMem");
    fetchFeatureFlag("h5uiCreateClusterMigration");
    fetchFeatureFlag("h5uiNgMigrationVmClone");
    fetchFeatureFlag("h5uiNgMigrationVmTemplateClone");
    fetchFeatureFlag("h5uiNgMigrationTemplateToTemplateClone");
    fetchFeatureFlag("h5uiNgMigrationVmCreate");
    fetchFeatureFlag("h5uiQuerySearch");
    fetchFeatureFlag("h5uiClientConfig");

    function fetchFeatureFlag(flagName) {
      self[flagName + "Enabled"] = function () {
        return false;
      };

      configurationService
        .isFeatureEnabled(flagName)
        .then(function (featureIsEnabled) {
          self[flagName + "Enabled"] = function () {
            return featureIsEnabled;
          };
        });
    }

    return self;
  }

  window.featureFlagsService = featureFlagsService;
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Wraps $http to provide request cancellation logic.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .factory('httpCancellationService', httpCancellationService);

   httpCancellationService.$inject = ['$http', '$q'];

   function httpCancellationService($http, $q) {
      return function() {
         var deferred;

         function fetch(httpConfig) {
            cancel();

            deferred = $q.defer();

            httpConfig = httpConfig || {};
            httpConfig.timeout = deferred.promise;

            return $http(httpConfig);
         }

         function cancel() {
            if (deferred) {
               // $http timeout allows only promises created by $timeout to be
               // used as parameter. However we want to cancel the request not
               // based on elapsed time but rather based on the fact that a new
               // navigation request has been dispatched so we ser $$timeoutId to
               // imitate a promise created by $timeout.
               // https://github.com/angular/angular.js/blob/v1.7.x/src/ng/httpBackend.js#L173
               deferred.promise.$$timeoutId = -1;
               // Do not report error on rejected promise.
               // https://github.com/angular/angular.js/blob/v1.7.x/src/ng/q.js#L682
               deferred.promise.$$state.pur = true;
               // $timeout.cancel() internally calls promise.reject() so we do the same
               // https://github.com/angular/angular.js/blob/v1.7.x/src/ng/timeout.js#L102
               deferred.reject('canceled');
            }
         }

         // Public API
         return {
            /**
             * Wraps $http.
             *
             * Always cancels previous fetch.
             *
             * @param {Object} httpConfig Passed to $http.
             * @returns {Promise}
             */
            fetch: fetch,

            /**
             * Cancels the previously initiated fetch request.
             *
             * NOTES:
             * This does not resolve neither reject the $http promise.
             * Subsequent calls to cancel do nothing unless a fetch is in progress.
             */
            cancel: cancel
         };
      };
   }
}());


/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Wrapper over downgraded service \vim-clients\applications\h5\ng-next-app\src\app\platform\services\translation\i18n.service.ts
     */
    var I18nServiceWrapper = (function () {
        function I18nServiceWrapper($injector) {
            var _this = this;
            this.$injector = $injector;
            // Note: Using arrow functions instead of a regular class method because many users of this service
            // like to grab a handle to getString method from the service but doing so
            // losing the class context with regular class methods. Arrow functions maintains this functionality
            this.getString = function (bundle, key) {
                var interpolations = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    interpolations[_i - 2] = arguments[_i];
                }
                return (_a = _this.vcI18nService).getString.apply(_a, [bundle, key].concat(interpolations));
                var _a;
            };
            this.getEscapedString = function (bundle, key) {
                var interpolations = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    interpolations[_i - 2] = arguments[_i];
                }
                return (_a = _this.vcI18nService).getEscapedString.apply(_a, [bundle, key].concat(interpolations));
                var _a;
            };
            this.interpolate = function (localizedString, interpolations) {
                return _this.vcI18nService.interpolate(localizedString, interpolations);
            };
            this.interpolateAndEscape = function (localizedString, interpolations) {
                return _this.vcI18nService.interpolateAndEscape(localizedString, interpolations);
            };
            this.getLocale = function () {
                return _this.vcI18nService.getLocale();
            };
        }
        Object.defineProperty(I18nServiceWrapper.prototype, "vcI18nService", {
            get: function () {
                if (!this._vcI18nService) {
                    this._vcI18nService = this.$injector.get('vcI18nService');
                }
                return this._vcI18nService;
            },
            enumerable: true,
            configurable: true
        });
        I18nServiceWrapper.$inject = ['$injector'];
        return I18nServiceWrapper;
    }());
    platform.I18nServiceWrapper = I18nServiceWrapper;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.i18nService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Internationalization Service.
     */
    angular.module('com.vmware.platform.ui').service('i18nService', I18nServiceWrapper);
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service to save data to local storage.
 * There are two flavors for getting/setting data:
 * getData/setData & getUserData/setUserData
 *
 * The first one gets/sats the dada into the local storage directly,
 * while the second one modifies the key to include the username
 * (thus its usage is best for data manipulation specific to the currently logged user)
 * and that's why it uses promises, i.e. the result of getUserData is a primise
 * which when resolved will contain the actual data
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('localStorageService', localStorageService);

   localStorageService.$inject = ['$window', '$q', 'globalConfigurationService',
      'userSessionService', 'logService'];

   function localStorageService(
         $window, $q, globalConfigurationService, userSessionService, logService) {
      //deferred object used to optimise the process of retrieving the username,
      //i.e. when the username is retrieved this deferred object is being reused henceforth
      var _deferredUsername;

      //define and initialize the log
      var log = logService('localStorageService');

      //the real local storage object
      var localStorage = getLocalStorage();

      //Public API
      var service = {
         getData: getData,
         setData: setData,
         getUserData: getUserData,
         getUserDataSync: getUserDataSync,
         setUserData: setUserData,
         removeUserData: removeUserData
      };
      return service;

      /**
       * Retrieving data from the local storage.
       * @param key the key to the local storage data
       * @returns the object being saved in the local storage,
       *         Note that the stored data is converted through angular.fromJson()
       */
      function getData(key) {
         var data = (localStorage ? localStorage.getItem(key) : null);
         data = angular.fromJson(data);
         return data;
      }

      /**
       * Setting data into the local storage.
       * The data is stringified through angular.toJson() before being written
       * @param key the key to the local storage data
       * @param data to be stored
       */
      function setData(key, data) {
         data = angular.toJson(data);
         if (localStorage) {
            try {
               localStorage.setItem(key, data);
            } catch(e) {
               // ignore case of mobile browser or safari incognito mode where localStorage is not fully supported
               // see "QuotaExceededError: DOM Exception 22" in http://h5-feedbackportal.eng.vmware.com:3000/feedback?errlist=1
            }
         }
      }

      /**
       * Removing data from local storage
       * @param key the key to the local storage data
       */
      function removeData(key) {
         if (localStorage) {
            try {
               localStorage.removeItem(key);
            } catch(e) {
               // ignore case of mobile browser or safari incognito mode
               // where localStorage is not fully supported
               // see "QuotaExceededError: DOM Exception 22"
               // in http://h5-feedbackportal.eng.vmware.com:3000/feedback?errlist=1
            }
         }
      }

      /**
       * Retrieving user specific data from the local storage asynchronously and returns
       * a promise resolved with the retrieved data.
       * This method is similar to getData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       *
       * @param key the key to the local storage data
       * @returns a promise which when resolved will hold the object being saved in the local storage
       */
      function getUserData(key) {
         var deferred = $q.defer();
         getUsername().then(function (username) {
            var data = getData(key + username);
            deferred.resolve(data);
         });
         return deferred.promise;
      }

      /**
       * Retrieving synchronously user specific data from the local storage.
       * This method is similar to getData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       *
       * @param key the key to the local storage data
       * @returns a promise which when resolved will hold the object being saved in the local storage
       */
      function getUserDataSync(key) {
         return getData(key + getUsernameSync());
      }

      /**
       * Setting user specific data into the local storage.
       * This method is similar to setData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       */
      function setUserData(key, data) {
         setData(key + getUsernameSync(), data);
      }

      /**
       * Removing user specific data from the local storage
       * This method is similar to removeData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       */
      function removeUserData(key) {
         removeData(key + getUsernameSync());
      }

      /**
       * Retrieves the username from the userSessionService
       * @returns a promise which when resolved will hold the username converted to lowercase
       */
      function getUsername() {
         if (_deferredUsername) {
            return _deferredUsername.promise;
         }

         //this deferred object is used until the username is successfully retrieved
         var deferred = $q.defer();
         userSessionService.getUserSession().then(function (userSession) {
            if (userSession.userName) {
               //set the _deferredUsername so that it can be reused
               _deferredUsername = deferred;
               _deferredUsername.resolve(userSession.userName.toLowerCase());
            } else {
               log.error('Error getting username from userSessionService');
            }
         });
         return deferred.promise;
      }

      function getUsernameSync() {
         var username = globalConfigurationService.getUserName();
         if (username) {
            return username.toLowerCase();
         }
         log.error("Failed to retrieve username.");
         return "";
      }

      /**
       * Gets the local storage that this service is build upon
       * @returns the browser local storage if such exists, or a fake one
       */
      function getLocalStorage() {
         // Need a try/catch because IE may throw "access denied"
         try {
            if ($window.localStorage) {
               return $window.localStorage;
            }
         } catch(e) {
            log.error(e);
         }

         // fake storage returning always null data
         var dict = {};
         return {
            getItem: function (key) {
               return dict[key];
            },
            setItem: function (key, value) {
               dict[key] = value;
            }
         };
      }
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Logging service wrapper over angular $log
 * Example usage:
 * var log = logService('MyController');
 * var someObject = {key:'value'}
 * log.log('simple log');
 * log.warn('warning');
 * log.debug('debugging',);
 * log.info('some info',someObject);
 * log.error('bad error');
 */

angular.module('com.vmware.platform.ui').config(["$logProvider", function($logProvider){
   $logProvider.debugEnabled(true);  // to enable/disable debugging
}])
.value('logServiceWhiteList', /.*/)  // regex to control logs displayed
.factory('logService', ['$log','logServiceWhiteList','$location',
function($log,logServiceWhiteList,$location) {

   logServiceWhiteList = logServiceWhiteList || /.*/ ;
   var queryParam = $location.search();
   var logLevel = queryParam.logLevel ;
   logServiceWhiteList = logLevel ? new RegExp(logLevel,'i') : logServiceWhiteList;

   return function(caller){

      return{
         log: log('log'),
         debug: log('debug'),
         info: log('info'),
         warn: log('warn'),
         error: log('error'),
         setLogLevel: setWhiteList()
      };

   function setWhiteList(regex){
      return function(regex){
         logServiceWhiteList = new RegExp(regex);
      };

   }

   function log(level){

      var match = logServiceWhiteList ?
            caller.match(logServiceWhiteList) || level.match(logServiceWhiteList) : true;

      // ignore log/info/debug messages if we are not in debug mode
      if (!h5.debug && (
            level === 'log' ||
            level === 'info' ||
            level === 'debug')) {

         return angular.noop;
      }

      if (match){
         return function(){
            if (!$log[level]){
               level = 'log'; // workaround for debug in firefox
            }
            var args = Array.prototype.slice.call(arguments);
            if (caller){
               args.unshift('['+caller+']');
            }
            // NOTE: args.join returns a string containing the printed value.
            // We need this as the Selenium framework that captures the
            // console data in case of error, cannot obtain/get any argument
            // supplied to the $log call, besides the first one. So we join all
            // args into a single string value. As the log statements are most useful
            // for analysis of automated test runs using Selenium, we tailor our logging
            // to best fit the most useful use case.
            // Caveat: This means that if you are used to seeing live JS objects in
            // the browser console log - you will no longer see them as they will
            // be replaced with their string representation after the call to
            // args.join() below
            $log[level].apply($log, [args.join(" ")]);
         };
      }else {
         return angular.noop;
      }
   }

   /*
   * Returns the stack trace
   */
   function getStackTrace(){
      var err = new Error();
      return err.stack;
   }
};

}]);

/* Copyright 2022 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var ManagedByMessageBuilderService = (function () {
        function ManagedByMessageBuilderService($q, dataService, i18nService, defaultUriSchemeUtil) {
            this.$q = $q;
            this.dataService = dataService;
            this.i18nService = i18nService;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.MANAGED_BY_INFO_PROPERTY = "managedByInfo";
            this.TEMPLATE_PROPERTY = "template";
            this.IS_CLUSTER_VM_PROPERTY = "isClusterVM";
        }
        ManagedByMessageBuilderService.prototype.buildConfirmationText = function (targetsRefs, confirmationText, withProceedMsg) {
            var _this = this;
            if (confirmationText === void 0) { confirmationText = ""; }
            if (withProceedMsg === void 0) { withProceedMsg = false; }
            if (_.isEmpty(targetsRefs)) {
                return this.$q.when();
            }
            var targetIds = this.defaultUriSchemeUtil.getVsphereObjectIds(targetsRefs);
            var managedByPropertiesPromise = this.retrieveManagedByProperties(targetIds);
            return managedByPropertiesPromise.then(function (managedByProperties) {
                return _this.buildMessage(targetIds, managedByProperties, withProceedMsg, confirmationText);
            }, function () {
                // in case the data can not be retrieved return the confirmationText as if the entity is not managed
                return confirmationText;
            });
        };
        ManagedByMessageBuilderService.prototype.buildWarningMessage = function (targetIds, withProceedMsg, managedByProperties) {
            var _this = this;
            if (withProceedMsg === void 0) { withProceedMsg = false; }
            if (managedByProperties === void 0) { managedByProperties = {}; }
            if (_.isEmpty(targetIds)) {
                return this.$q.when();
            }
            var managedByPropertiesPromise;
            if (_.isEmpty(managedByProperties)) {
                managedByPropertiesPromise = this.retrieveManagedByProperties(targetIds);
            }
            else {
                managedByPropertiesPromise = this.$q.when(managedByProperties);
            }
            return managedByPropertiesPromise.then(function (managedByProperties) {
                return _this.buildMessage(targetIds, managedByProperties, withProceedMsg);
            }, function () {
                // in case the data can not be retrieved return an empty message as if the entity is not managed
                return;
            });
        };
        ManagedByMessageBuilderService.prototype.retrieveManagedByProperties = function (targetIds) {
            var properties = [this.MANAGED_BY_INFO_PROPERTY];
            if (this.defaultUriSchemeUtil.getEntityType(targetIds[0]) === "VirtualMachine") {
                properties.push(this.TEMPLATE_PROPERTY);
                properties.push(this.IS_CLUSTER_VM_PROPERTY);
            }
            return this.dataService.getPropertiesForObjects(targetIds, properties, { skipErrorInterceptor: true });
        };
        ManagedByMessageBuilderService.prototype.buildMessage = function (targetIds, managedByProperties, withProceedMsg, additionalMessage) {
            var _this = this;
            if (withProceedMsg === void 0) { withProceedMsg = false; }
            if (additionalMessage === void 0) { additionalMessage = ""; }
            var singleEntityManagedByWarning;
            var multiEntityManagedByWarning;
            switch (this.defaultUriSchemeUtil.getEntityType(targetIds[0])) {
                case "VirtualMachine":
                    var hasHadcsVms = _.find(targetIds, function (targetId) {
                        return managedByProperties[targetId][_this.IS_CLUSTER_VM_PROPERTY];
                    });
                    if (hasHadcsVms) {
                        singleEntityManagedByWarning = "hadcs.singleVmManagedByWarning";
                        multiEntityManagedByWarning = "hadcs.multiVmManagedByWarning";
                        break;
                    }
                    singleEntityManagedByWarning = "singleVmManagedByWarning";
                    multiEntityManagedByWarning = "multiVmManagedByWarning";
                    if (managedByProperties[targetIds[0]][this.TEMPLATE_PROPERTY]) {
                        singleEntityManagedByWarning = "singleTemplateManagedByWarning";
                        multiEntityManagedByWarning = "multiTemplateManagedByWarning";
                    }
                    break;
                case "VirtualApp":
                    singleEntityManagedByWarning = "singleVAppManagedByWarning";
                    multiEntityManagedByWarning = "multiVAppManagedByWarning";
                    break;
                default:
                    singleEntityManagedByWarning = "singleEntityManagedByWarning";
                    multiEntityManagedByWarning = "multiEntityManagedByWarning";
                    break;
            }
            var warning = "";
            var suffix = additionalMessage ? "\n\n" + additionalMessage : "";
            if (withProceedMsg) {
                suffix = this.i18nService.getString("Common", "managedByWarningProceed");
            }
            if (targetIds.length === 1) {
                var managedByInfo = managedByProperties[targetIds[0]][this.MANAGED_BY_INFO_PROPERTY];
                if (managedByInfo) {
                    warning = this.i18nService.getString("Common", singleEntityManagedByWarning, managedByInfo) + suffix;
                    return warning;
                }
                return warning;
            }
            _.each(targetIds, function (targetId) {
                var managedByInfo = managedByProperties[targetId][_this.MANAGED_BY_INFO_PROPERTY];
                if (managedByInfo) {
                    warning = _this.i18nService.getString("Common", multiEntityManagedByWarning) +
                        suffix;
                    return;
                }
            });
            return warning;
        };
        ManagedByMessageBuilderService.$inject = [
            "$q",
            "dataService",
            "i18nService",
            "defaultUriSchemeUtil",
        ];
        return ManagedByMessageBuilderService;
    }());
    platform.ManagedByMessageBuilderService = ManagedByMessageBuilderService;
    angular.module("com.vmware.platform.ui")
        .service("managedByMessageBuilderService", ManagedByMessageBuilderService);
})(platform || (platform = {}));



/* Copyright 2019 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Wrapper over downgraded service \vim-clients\applications\h5\ng-next-app\src\app\platform\services\managed-types-util\managed-types-util.service.ts
     */
    var ManagedTypesUtilWrapper = (function () {
        function ManagedTypesUtilWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(ManagedTypesUtilWrapper.prototype, "vcManagedTypesUtil", {
            get: function () {
                if (!this._vcManagedTypesUtil) {
                    this._vcManagedTypesUtil = this.$injector.get("vcManagedTypesUtil");
                }
                return this._vcManagedTypesUtil;
            },
            enumerable: true,
            configurable: true
        });
        ManagedTypesUtilWrapper.prototype.deductTypeFromGlobalCisId = function (cisId) {
            return this.vcManagedTypesUtil.deductTypeFromGlobalCisId(cisId);
        };
        ManagedTypesUtilWrapper.$inject = ["$injector"];
        return ManagedTypesUtilWrapper;
    }());
    platform.ManagedTypesUtilWrapper = ManagedTypesUtilWrapper;
    angular.module("com.vmware.platform.ui").service("managedTypesUtil", ManagedTypesUtilWrapper);
})(platform || (platform = {}));



/* Copyright 2019 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var ModalHelperService = (function () {
        function ModalHelperService() {
        }
        /**
         * @param bottomToTop
         *   Whether to return the context info from the  bottom most to the top-most or
         *   reversed. The latter also makes sense - as visualization rotation (needed
         *   due to vertical text) will then reverse the order of the elements representing
         *   the hierarchy.
         */
        ModalHelperService.prototype.discoverHierarchyContext = function (bottomToTop) {
            var _this = this;
            if (bottomToTop === void 0) { bottomToTop = true; }
            // NOTE: We need to collect all popups with a single
            // css selector to have them properly ordered.
            var modals = this.do$(".vui-wizard,clr-wizard,:not(clr-wizard)>clr-modal");
            if (!modals || (modals.length === 0)) {
                return undefined;
            }
            var hierarchyContext = modals.map(function (index, htmlElement) {
                var jqElement = _this.do$(htmlElement);
                var modalSize = _this.getModalSize(jqElement);
                return {
                    title: _this.getModalTitleText(jqElement),
                    subtitle: _this.getModalSubtitleText(jqElement),
                    width: modalSize.width,
                    height: modalSize.height
                };
            }).get();
            if (!hierarchyContext) {
                return undefined;
            }
            var result = hierarchyContext;
            return bottomToTop ? result : result.reverse();
        };
        /**
         * Finds the first vui wizard or clarity wizard/dialog and returns its current width and height
         */
        ModalHelperService.prototype.retrieveFirstLevelPopupSizes = function () {
            // NOTE: We need to collect all popups with a single
            // css selector to have them properly ordered.
            var modals = this.do$(".vui-wizard,clr-wizard,:not(clr-wizard)>clr-modal");
            if (!modals || (modals.length === 0)) {
                return undefined;
            }
            var jqElement = this.do$(modals[0]);
            var modalSize = this.getModalSize(jqElement);
            return {
                width: modalSize.width,
                height: modalSize.height
            };
        };
        ModalHelperService.prototype.getModalSize = function (jqElement) {
            if (jqElement.hasClass("vui-wizard")) {
                return this.getVuiWizardSize(jqElement);
            }
            if (jqElement.hasClass("clr-wizard")) {
                return this.getClrWizardSize(jqElement);
            }
            return this.getClrModalSize(jqElement);
        };
        ModalHelperService.prototype.getVuiWizardSize = function (jqVuiWizardElement) {
            return {
                width: jqVuiWizardElement.outerWidth() + "px",
                height: jqVuiWizardElement.outerHeight() + "px",
            };
        };
        ModalHelperService.prototype.getClrWizardSize = function (jqElement) {
            var modalContent = jqElement.find(".modal-content-wrapper");
            return {
                width: modalContent.outerWidth() + "px",
                height: modalContent.outerHeight() + "px",
            };
        };
        ModalHelperService.prototype.getClrModalSize = function (jqElement) {
            var modalContent = jqElement.find(".modal-content");
            return {
                width: modalContent.outerWidth() + "px",
                height: modalContent.outerHeight() + "px",
            };
        };
        ModalHelperService.prototype.getModalTitleText = function (jqElement) {
            if (jqElement.hasClass("vui-wizard")) {
                return this.getVuiWizardTitleText(jqElement);
            }
            if (jqElement.hasClass("clr-wizard")) {
                return this.getClrWizardTitleText(jqElement);
            }
            return this.getClrModalTitleText(jqElement);
        };
        ModalHelperService.prototype.getVuiWizardTitleText = function (jqVuiWizardElement) {
            var titleElement = jqVuiWizardElement.find(".titlebar-text");
            if (!titleElement) {
                return undefined;
            }
            return titleElement.text();
        };
        ModalHelperService.prototype.getClrWizardTitleText = function (jqElement) {
            var titleElement = jqElement.find("clr-wizard-title");
            if (!titleElement) {
                return undefined;
            }
            return titleElement.text();
        };
        ModalHelperService.prototype.getClrModalTitleText = function (jqElement) {
            var titleElement = jqElement.find(".primaryTitle");
            if (!titleElement) {
                return undefined;
            }
            return titleElement.text();
        };
        ModalHelperService.prototype.getModalSubtitleText = function (jqElement) {
            if (jqElement.hasClass("vui-wizard")) {
                return this.getVuiWizardCurrentStepText(jqElement);
            }
            if (jqElement.hasClass("clr-wizard")) {
                return this.getClrWizardCurrentStepText(jqElement);
            }
            return this.getClrModalSecondaryTitleText(jqElement);
        };
        ModalHelperService.prototype.getVuiWizardCurrentStepText = function (jqVuiWizardElement) {
            var stepElement = jqVuiWizardElement.find(".wizard-steps-current");
            if (!stepElement) {
                return undefined;
            }
            return stepElement.text();
        };
        ModalHelperService.prototype.getClrWizardCurrentStepText = function (jqElement) {
            var stepElement = jqElement.find(".modal-title-text");
            if (!stepElement) {
                return undefined;
            }
            return stepElement.text();
        };
        ModalHelperService.prototype.getClrModalSecondaryTitleText = function (jqElement) {
            var titleElement = jqElement.find(".secondaryTitle");
            if (!titleElement) {
                return undefined;
            }
            return titleElement.text();
        };
        /**
         * A helper method we can mock to simulate different results from jQuery calls.
         */
        ModalHelperService.prototype.do$ = function (selector) {
            return $(selector);
        };
        return ModalHelperService;
    }());
    platform.ModalHelperService = ModalHelperService; // class ModalHelperService
    angular.module("com.vmware.platform.ui")
        .service("modalHelperService", ModalHelperService);
})(platform || (platform = {})); // module



/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /***
     * The class wraps the ng-next-app/platform/services/mutation.service.proxy
     */
    var MutationServiceWrapper = (function () {
        function MutationServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(MutationServiceWrapper.prototype, "ng2MutationService", {
            get: function () {
                // Injecting mutation.proxy.service bridged from ng-next-app.
                // Using regular injection within .service('string',[...]) does not work,
                // due to race condition:
                // Downgraded NG2 modules are registered AFTER .service(..) injections are resolved
                // This way we're postponing injection till first call
                if (!this._ng2MutationService) {
                    this._ng2MutationService = this.$injector.get('vcMutationService');
                }
                return this._ng2MutationService;
            },
            enumerable: true,
            configurable: true
        });
        MutationServiceWrapper.prototype.add = function (propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.add(propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.addMulti = function (propertyObjectType, propertySpecs, operation) {
            return this.ng2MutationService.addMulti(propertyObjectType, propertySpecs, operation);
        };
        MutationServiceWrapper.prototype.apply = function (objectId, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.apply(objectId, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.applyByPropName = function (objectId, propertyName, data, operation) {
            return this.ng2MutationService.applyByPropName(objectId, propertyName, data, operation);
        };
        MutationServiceWrapper.prototype.applyOnMultiEntity = function (objectIds, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.applyOnMultiEntity(objectIds, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.applyMultiSpec = function (objectId, propertyObjectType, propertySpecs, operation) {
            return this.ng2MutationService.applyMultiSpec(objectId, propertyObjectType, propertySpecs, operation);
        };
        MutationServiceWrapper.prototype.applyMulti = function (propertyObjectType, entitySpecs, operation) {
            return this.ng2MutationService.applyMulti(propertyObjectType, entitySpecs, operation);
        };
        MutationServiceWrapper.prototype.remove = function (objectId, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.remove(objectId, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.removeOnMultiEntity = function (objectIds, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.removeOnMultiEntity(objectIds, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.validate = function (objectId, propertyObjectType, propertySpec) {
            return this.ng2MutationService.validate(objectId, propertyObjectType, propertySpec);
        };
        MutationServiceWrapper.prototype.validateSpec = function (propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.validateSpec(propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.validateMultiSpec = function (propertyObjectType, specObjects) {
            return this.ng2MutationService.validateMultiSpec(propertyObjectType, specObjects);
        };
        MutationServiceWrapper.prototype.validateOnMultiEntity = function (objectIds, propertyObjectType, propertySpec) {
            return this.ng2MutationService.validateOnMultiEntity(objectIds, propertyObjectType, propertySpec);
        };
        MutationServiceWrapper.$inject = ['$injector'];
        return MutationServiceWrapper;
    }());
    platform.MutationServiceWrapper = MutationServiceWrapper;
    angular.module('com.vmware.platform.ui')
        .service('mutationService', MutationServiceWrapper);
})(platform || (platform = {}));



var platform;
(function (platform) {
    var NotificationService = (function () {
        function NotificationService($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(NotificationService.prototype, "vscNotificationService", {
            get: function () {
                if (!this._vscNotificationService) {
                    this._vscNotificationService = this.$injector.get("vscNotificationService");
                }
                return this._vscNotificationService;
            },
            enumerable: true,
            configurable: true
        });
        NotificationService.prototype.notify = function (options) {
            return this.vscNotificationService.notify(options);
        };
        NotificationService.prototype.notifyError = function (title, message, stack, unhandledError) {
            return this.vscNotificationService.notifyError(title, message, stack, unhandledError);
        };
        NotificationService.prototype.notifyTaskError = function (taskInfo) {
            return this.vscNotificationService.notifyTaskError(taskInfo);
        };
        NotificationService.$inject = ["$injector"];
        return NotificationService;
    }());
    platform.NotificationService = NotificationService;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.notificationService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Service for displaying notifications.
     *
     */
    angular
        .module("com.vmware.platform.ui")
        .service("notificationService", NotificationService);
})(platform || (platform = {}));



var platform;
(function (platform) {
    /**
     * Wrapper over downgraded service \vim-clients\applications\h5\ng-next-app\src\app\platform\services\format\number-formatter.service.ts
     */
    var NumberFormatterServiceWrapper = (function () {
        function NumberFormatterServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(NumberFormatterServiceWrapper.prototype, "downgradedNumberFormatterService", {
            get: function () {
                if (!this._downgradedNumberFormatterService) {
                    this._downgradedNumberFormatterService = this.$injector.get('vcNumberFormatterService');
                }
                return this._downgradedNumberFormatterService;
            },
            enumerable: true,
            configurable: true
        });
        NumberFormatterServiceWrapper.prototype.format = function (num, options /*NumberOptions*/) {
            return this.downgradedNumberFormatterService.format(num, options);
        };
        NumberFormatterServiceWrapper.prototype.formatStorage = function (num, sourceUnit, targetUnit, fractionSize) {
            return this.downgradedNumberFormatterService.formatStorage(num, sourceUnit, targetUnit, fractionSize);
        };
        NumberFormatterServiceWrapper.prototype.formatBandwidth = function (num, sourceUnit, targetUnit, precision, trimTrailingZeroes) {
            return this.downgradedNumberFormatterService.formatBandwidth(num, sourceUnit, targetUnit, precision, trimTrailingZeroes);
        };
        NumberFormatterServiceWrapper.$inject = ['$injector'];
        return NumberFormatterServiceWrapper;
    }());
    platform.NumberFormatterServiceWrapper = NumberFormatterServiceWrapper;
    angular.module('com.vmware.platform.ui')
        .service('numberFormatterService', NumberFormatterServiceWrapper);
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   angular
         .module('com.vmware.platform.ui')
         .factory('objectTypesService', objectTypesService);

   objectTypesService.$inject = ['$http'];

   /*
    * Service for retrieving ObjectTypeSpec registered for the given object type.
    */
   function objectTypesService ($http) {

      // --------------- public APIs  ----------------
      var service = {
         getObjectTypeSpec: _.memoize(getObjectTypeSpec),
         getAllObjectTypeSpecs: _.memoize(getAllObjectTypeSpecs)
      };

      var URLS = {
         fetchObjectTypeSpec: function(objectType) {
            return 'objectTypes/' + objectType + '/';
         },
         fetchAllObjectTypeSpecs: function () {
            return 'objectTypes/';
         }
      };

      return service;

      // --------------- API implementation ----------------

      function get(url, params) {
         return $http.get(url, {params: params}).then(function(result) {
            return result.data;
         });
      }

      function getObjectTypeSpec(objectType) {
         var url = URLS.fetchObjectTypeSpec(objectType);
         var params = [];
         return get(url, params);
      }

      function getAllObjectTypeSpecs() {
         var url = URLS.fetchAllObjectTypeSpecs();
         return get(url);
      }
   }
})();
/* Copyright 2013-2021 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var StatusFormatterService = (function () {
        function StatusFormatterService($injector) {
            this.$injector = $injector;
            this._defaultStatus = "entityStatus.gray";
        }
        Object.defineProperty(StatusFormatterService.prototype, "statusFormatterService", {
            get: function () {
                if (!this._statusFormatterService) {
                    this._statusFormatterService = this.$injector.get("statusFormatterService");
                }
                return this._statusFormatterService;
            },
            enumerable: true,
            configurable: true
        });
        StatusFormatterService.prototype.format = function (status) {
            return this._statusFormatterService.format(status);
        };
        StatusFormatterService.$inject = ["$injector"];
        return StatusFormatterService;
    }());
    platform.StatusFormatterService = StatusFormatterService;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.StatusFormatterService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Service for converting status strings to icon/label object
     *
     */
    angular.module('com.vmware.platform.ui')
        .service('statusFormatterService', StatusFormatterService);
})(platform || (platform = {}));



/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Class representing the options that will configure additionally the CSS path creation:
     *       - cssClassBlacklist - list of element classes that should not be included in the CSS path
     */
    var CssPathOptions = (function () {
        function CssPathOptions(cssClassBlacklist) {
            this.cssClassBlacklist = cssClassBlacklist;
        }
        return CssPathOptions;
    }());
    platform.CssPathOptions = CssPathOptions;
    var TelemetryDomNodeWrapper = (function () {
        /**
         * Constructs a TelemetryDomNodeWrapper for a DOM Node.
         *
         * @param node to wrap
         * @param telemetryHelperService to use when calculating certain
         * properties.
         */
        function TelemetryDomNodeWrapper(node, telemetryHelperService) {
            this.node = node;
            this.telemetryHelperService = telemetryHelperService;
        }
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "id", {
            /**
             * @inheritDoc
             */
            get: function () {
                if (!this.telemetryHelperService.isElementNode(this.node)) {
                    return null;
                }
                return this.node.id;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "classList", {
            /**
             * @inheritDoc
             */
            get: function () {
                if (!this.telemetryHelperService.isElementNode(this.node)) {
                    return null;
                }
                return this.telemetryHelperService
                    .getElementClassList(this.node);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "index", {
            /**
             * @inheritDoc
             */
            get: function () {
                if (!this.telemetryHelperService.isElementNode(this.node)) {
                    return null;
                }
                return this.telemetryHelperService
                    .getElementIndex(this.node);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "nodeType", {
            /**
             * @inheritDoc
             */
            get: function () {
                return this.node.nodeType;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "nodeName", {
            /**
             * @inheritDoc
             */
            get: function () {
                return this.node.nodeName;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "textContents", {
            /**
             * @inheritDoc
             */
            get: function () {
                if (!this.telemetryHelperService.isElementNode(this.node)) {
                    return null;
                }
                return this.telemetryHelperService
                    .getElementDirectTextContents(this.node);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "isEmbeddedNodeWrapper", {
            /**
             * @inheritDoc
             */
            get: function () {
                return this.telemetryHelperService.isEmbeddedNode(this.node);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TelemetryDomNodeWrapper.prototype, "parentNodeWrapper", {
            /**
             * @inheritDoc
             */
            get: function () {
                var parentNode = this.telemetryHelperService.getParentNode(this.node);
                if (!parentNode) {
                    return null;
                }
                return new TelemetryDomNodeWrapper(parentNode, this.telemetryHelperService);
            },
            enumerable: true,
            configurable: true
        });
        return TelemetryDomNodeWrapper;
    }());
    platform.TelemetryDomNodeWrapper = TelemetryDomNodeWrapper;
})(platform || (platform = {}));



/* Copyright 2017-2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var TID = 'tid-';
    /**
     * Service that provides helper methods for telemetry
     */
    var TelemetryHelperService = (function () {
        function TelemetryHelperService() {
        }
        /**
         * Returns a unique CSS path of a node wrapper in the application.
         *
         * @param nodeWrapper whose path will be generated
         * @param options for configuring the CSS path generation
         * @returns {string} a unique CSS path of the node wrapper
         */
        TelemetryHelperService.prototype.getNodeWrapperCssPath = function (nodeWrapper, options) {
            if (options === void 0) { options = { cssClassBlacklist: [] }; }
            var cssSelectorParts = [];
            var currentNodeWrapper = nodeWrapper;
            while (currentNodeWrapper) {
                var normalizedNodeName = currentNodeWrapper.nodeName.toLowerCase();
                /*
                 The root of the current DOM sub-tree is reached and it's not
                 a Document node. This means that the sub-tree is detached or
                 something is very wrong, so skip this sub-tree
                 */
                if (!currentNodeWrapper.parentNodeWrapper &&
                    !this.isDocumentNode(currentNodeWrapper)) {
                    return "";
                }
                /*
                 Skip 'body', 'html' and non-element nodes when traversing the path
                 */
                if (currentNodeWrapper.isEmbeddedNodeWrapper) {
                    if (!this.isElementNode(currentNodeWrapper)) {
                        currentNodeWrapper = currentNodeWrapper.parentNodeWrapper;
                        continue;
                    }
                }
                else {
                    if (normalizedNodeName === 'body' ||
                        normalizedNodeName === 'html' ||
                        !this.isElementNode(currentNodeWrapper)) {
                        currentNodeWrapper = currentNodeWrapper.parentNodeWrapper;
                        continue;
                    }
                }
                var elementSelector = "";
                var cssSelectorData = this.getClassesSelector(currentNodeWrapper, options);
                // if element has an id, add them to selector
                if (currentNodeWrapper.id) {
                    elementSelector += "#" + this.escapeCssIdentifier(currentNodeWrapper.id);
                    elementSelector += cssSelectorData.classSelector;
                }
                else {
                    elementSelector += this.escapeCssIdentifier(normalizedNodeName);
                    elementSelector += cssSelectorData.classSelector;
                    if (!cssSelectorData.containsTid) {
                        elementSelector += this.getIndexSelector(currentNodeWrapper);
                    }
                }
                // add individual selector to paths array
                cssSelectorParts.push(elementSelector);
                currentNodeWrapper = currentNodeWrapper.parentNodeWrapper;
                if (cssSelectorData.containsTid) {
                    break;
                }
            }
            return cssSelectorParts.reverse().join(' > ');
        };
        /**
         * Method used for getting the trimmed text of a given node wrapper. An empty
         * string is returned if the node wrapper does not have text or its text
         * is empty (after trimming). The returned text is trimmed.
         *
         * @param nodeWrapper whose text will be returned
         * @returns {string} the text if such is present, or an empty string otherwise
         */
        TelemetryHelperService.prototype.getText = function (nodeWrapper) {
            if (!nodeWrapper.textContents || nodeWrapper.textContents.length === 0) {
                return "";
            }
            return nodeWrapper.textContents[0].trim();
        };
        /**
         * Method used for getting a SHA-256 encoded version of the trimmed text
         * of a given node wrapper. An empty string is returned if the node
         * wrapper does not have text or its text is empty (after trimming).
         *
         * @param nodeWrapper whose encoded text will be returned
         * @returns {string} the encoded text if such is present, or an empty string otherwise
         */
        TelemetryHelperService.prototype.getEncodedText = function (nodeWrapper) {
            var text = this.getText(nodeWrapper);
            if (!text) {
                return "";
            }
            var obfuscatedText;
            if (typeof CryptoJS !== typeof undefined) {
                obfuscatedText = CryptoJS.SHA256(text).toString();
            }
            else {
                obfuscatedText = "[Error: CryptoJS has not loaded properly]";
            }
            return obfuscatedText;
        };
        /**
         * Method used for generating telemetry id in the format of css class
         * e.g. tid-hosts-datastores.
         *
         * @param identifier to use as a base
         * @returns {string} a telemetry id generated based on the identifier
         */
        TelemetryHelperService.prototype.generateTelemetryIdClass = function (identifier) {
            if (identifier) {
                return TID + identifier.replace(/\s+|\./g, '-').toLowerCase();
            }
            return "";
        };
        /**
         * Returns the CSS class list of a DOM Element.
         *
         * @param element whose class list will be returned
         * @returns {string[]} the class list of the element as an array of
         * strings
         */
        TelemetryHelperService.prototype.getElementClassList = function (element) {
            var result = [];
            if (element && element.classList) {
                result = Array.prototype.slice.apply(element.classList);
            }
            return result;
        };
        /**
         * Returns the child index of a DOM Element within its parent Node.
         *
         * @param element whose index will be returned
         * @returns {number} the index of the element
         */
        TelemetryHelperService.prototype.getElementIndex = function (element) {
            var index = 0;
            var sibling = element.previousElementSibling;
            while (sibling) {
                index++;
                sibling = sibling.previousElementSibling;
            }
            return index;
        };
        /**
         * Returns the text contents of the direct child nodes of
         * type Node.TEXT_NODE of a DOM Element.
         *
         * @param element whose direct text contents to return
         * @returns {string[]} an array of strings containing the direct text
         * contents of the element
         */
        TelemetryHelperService.prototype.getElementDirectTextContents = function (element) {
            var textContents = [];
            for (var i = 0; i < element.childNodes.length; i++) {
                var currentNode = element.childNodes[i];
                if (this.isTextNode(currentNode) &&
                    typeof currentNode.textContent === "string") {
                    textContents.push(currentNode.textContent);
                }
            }
            return textContents;
        };
        /**
         * Returns the parent DOM Node of a DOM Node
         *
         * @param node whose parent DOM Node to return
         * @returns {Node | null} the node's parent DOM Node if such exists,
         * or null otherwise
         */
        TelemetryHelperService.prototype.getParentNode = function (node) {
            var parentNode = node.parentNode;
            /*
             If the node is an embedded Document node then its parent node is
             the frame element that contains the node's iframe window
             */
            if (this.isEmbeddedNode(node) && this.isDocumentNode(node)) {
                var documentNode = node;
                if (documentNode.defaultView && documentNode.defaultView.frameElement) {
                    parentNode = documentNode.defaultView.frameElement;
                }
            }
            /*
             If the node is a ShadowRoot Document fragment then its parent node
             is the ShadowRoot host DOM Node.
             */
            if (typeof window['ShadowRoot'] === 'function' &&
                node instanceof window['ShadowRoot']) {
                parentNode = node.host;
            }
            if (!parentNode) {
                return null;
            }
            return parentNode;
        };
        /**
         * Returns whether a Node is embedded in another Document.
         *
         * @param node whose state to determine
         * @returns {boolean} whether the node is embedded or not
         */
        TelemetryHelperService.prototype.isEmbeddedNode = function (node) {
            var nodeDocument = node.ownerDocument;
            if (this.isDocumentNode(node)) {
                nodeDocument = node;
            }
            return nodeDocument !== document;
        };
        /**
         * Returns whether a Node is an Element node.
         *
         * @param node to check
         * @returns {boolean} whether the node is an Element Node or not
         */
        TelemetryHelperService.prototype.isElementNode = function (node) {
            return node.nodeType === Node.ELEMENT_NODE;
        };
        /**
         * Returns whether a Node is a Text node.
         *
         * @param node to check
         * @returns {boolean} whether the node is a Text node or not
         */
        TelemetryHelperService.prototype.isTextNode = function (node) {
            return node.nodeType === Node.TEXT_NODE;
        };
        /**
         * Returns whether a Node is a Document node.
         *
         * @param node to check
         * @returns {boolean} whether the node is a Document node or not
         */
        TelemetryHelperService.prototype.isDocumentNode = function (node) {
            return node.nodeType === Node.DOCUMENT_NODE;
        };
        TelemetryHelperService.prototype.getClassesSelector = function (nodeWrapper, options) {
            var _this = this;
            var classList = [];
            var containsTid = false;
            var filteredClassList = [];
            if (nodeWrapper.classList) {
                classList = nodeWrapper.classList;
                if (nodeWrapper.id) {
                    filteredClassList = classList.filter(function (className) { return className.indexOf(TID) === 0; });
                    containsTid = filteredClassList.length > 0;
                }
                else {
                    var _loop_1 = function(index) {
                        var currentClass = classList[index];
                        if (currentClass.indexOf(TID) === 0) {
                            filteredClassList = [currentClass];
                            containsTid = true;
                        }
                        else {
                            var blacklistMatch = _.find(options.cssClassBlacklist, function (blacklistClass) {
                                return currentClass.indexOf(blacklistClass) !== -1;
                            });
                            if (!blacklistMatch) {
                                filteredClassList.push(currentClass);
                            }
                        }
                    };
                    for (var index = 0; index < classList.length && !containsTid; index++) {
                        _loop_1(index);
                    }
                }
            }
            filteredClassList = _.map(filteredClassList, function (cssClass) { return _this.escapeCssIdentifier(cssClass); });
            var classSelector = filteredClassList.reduce(function (result, el) { return result + ("." + el); }, "");
            return {
                classSelector: classSelector,
                containsTid: containsTid
            };
        };
        /**
         * Escapes the provided string so that it can be used as part of a
         * CSS selector.
         *
         * @param cssIdentifier
         *    The identifier to escape.
         */
        TelemetryHelperService.prototype.escapeCssIdentifier = function (cssIdentifier) {
            /* a css.escape polyfill has been used to ensure support on IE & Edge */
            return CSS.escape(cssIdentifier);
        };
        TelemetryHelperService.prototype.getIndexSelector = function (nodeWrapper) {
            var index = nodeWrapper.index;
            if (index === null || index <= 0) {
                return "";
            }
            return ":nth-child(" + (index + 1) + ")";
        };
        return TelemetryHelperService;
    }());
    platform.TelemetryHelperService = TelemetryHelperService;
    angular.module('com.vmware.platform.ui')
        .service('telemetryHelperService', TelemetryHelperService);
})(platform || (platform = {}));



/* Copyright 2017-2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var TelemetryDomNodeWrapper = platform.TelemetryDomNodeWrapper;
    /**
     * Telemetry service
     */
    var TelemetryService = (function () {
        function TelemetryService(rootScope, http, configurationService, telemetryHelperService, logService, userSessionService, vxZoneService, $location) {
            var _this = this;
            this.rootScope = rootScope;
            this.http = http;
            this.configurationService = configurationService;
            this.telemetryHelperService = telemetryHelperService;
            this.logService = logService;
            this.userSessionService = userSessionService;
            this.vxZoneService = vxZoneService;
            this.$location = $location;
            this.PLUGIN_DATA_COLLECTION_TIMEOUT = 15000;
            this.CONNECTION_STATE_CATEGORY = "connectionState";
            this.CONNECTION_STATE_ACTION = "connectionState";
            this.MOUSE_EVENT_TYPE_TO_ACTION = {
                'click': 'click',
                'contextmenu': 'right-click'
            };
            this.telemetryOptions = {
                // Adding the classes that won't be taken into account when generating the css
                // selector.
                cssClassBlacklist: ['ng-', 'fill-parent'],
            };
            /**
             * Track a telemetry related mouse event.
             *
             * @param mouseEventType e.g. 'click', 'contextmenu', etc.
             * Events with unsupported type are not tracked.
             * @param targetNodeWrapper a node wrapper of the node which is the target
             * of the mouse event.
             */
            this.trackMouseEvent = function (mouseEventType, targetNodeWrapper) {
                var action = _this.MOUSE_EVENT_TYPE_TO_ACTION[mouseEventType];
                if (!action) {
                    return;
                }
                var cssPath = _this.telemetryHelperService.getNodeWrapperCssPath(targetNodeWrapper, _this.telemetryOptions);
                if (cssPath.indexOf('tid-global-refresh-button') !== -1) {
                    action = "global-refresh";
                }
                var encodedText = _this.telemetryHelperService.getEncodedText(targetNodeWrapper);
                var absUrl = _this.$location.absUrl();
                if (absUrl.indexOf('debugTelemetry') > -1) {
                    // If this parameter is added to the URL the CSS selector will be dumped
                    // into the console.
                    _this.log.debug(cssPath);
                    if (encodedText) {
                        _this.log.debug("Obfuscated label: " + encodedText);
                        _this.log.debug("Unobfuscated label: " + _this.telemetryHelperService.getText(targetNodeWrapper));
                    }
                }
                if (h5.isTelemetryEnabled && cssPath !== "") {
                    _this.trackEvent(action, 'element', cssPath, encodedText);
                }
            };
            this.windowMouseEventHandler = function (event) {
                var targetNodeWrapper = new TelemetryDomNodeWrapper(event.target, _this.telemetryHelperService);
                var absUrl = _this.$location.absUrl();
                if ((event && event.isTrusted !== false) ||
                    absUrl.indexOf('allowUntrustedTelemetryEvents') > -1) {
                    // Track only trusted events (triggered by a user).
                    _this.trackMouseEvent(event.type, targetNodeWrapper);
                }
            };
            this.startTrackingMouseEvents = function (targetWindow) {
                for (var mouseEventType in _this.MOUSE_EVENT_TYPE_TO_ACTION) {
                    targetWindow.addEventListener(mouseEventType, _this.windowMouseEventHandler, true /*useCapture*/);
                }
            };
            this.stopTrackingMouseEvents = function (targetWindow) {
                for (var mouseEventType in _this.MOUSE_EVENT_TYPE_TO_ACTION) {
                    targetWindow.removeEventListener(mouseEventType, _this.windowMouseEventHandler, true /*useCapture*/);
                }
            };
            /**
             * Collects data about installed H5 plug-ins and sends it to VAC.
             * This should be done only once after the service is initialized.
             */
            this.collectPluginData = function () {
                _this.vxZoneService.runOutsideAngular(function () {
                    // Since this is (meant to be) called during the main template controller
                    // initialization, use a small timeout so we don't slow it down.
                    setTimeout(function () {
                        _this.http.get('plugins/deployed').then(function (response) {
                            if (response && response.data) {
                                _.each(response.data, function (plugin) {
                                    // Pick the keys explicitly; we don't want to send any
                                    // information that's not accounted for in case the plugin
                                    // request response format is changed.
                                    // Also, rename the 'id' property to pluginId to avoid
                                    // possible clashes with primary keys in the VAC database.
                                    var pluginData = _.extend({ pluginId: plugin.id }, _.pick(plugin, 'name', 'vendor', 'version', 'description'), { state: plugin.deploymentState.state }, { vmwareCertifiedMessage: plugin.vmwareCertifiedState });
                                    _paq.push(['trackCustom', 'h5_ui_plugin', pluginData]);
                                });
                            }
                        });
                    }, _this.PLUGIN_DATA_COLLECTION_TIMEOUT);
                });
            };
            this.sendConnectionEvent = function (state) {
                _this.trackEvent(_this.CONNECTION_STATE_CATEGORY, _this.CONNECTION_STATE_ACTION, state, "");
            };
            this.initTelemetry = function () {
                // adding explicit cast to `any` in order to avoid typescript errors
                // like: "Property '_paq' does not exist on type 'JQuery'."
                window._paq = window._paq || [];
                var installationId = h5.installationId;
                if (!installationId) {
                    installationId = 'internal_installation';
                }
                var version = "";
                var commonUiStrings = h5.i18n.languageResource["CommonUi"];
                if (commonUiStrings) {
                    version = commonUiStrings["client.version"];
                }
                _paq.push([
                    'initProduction',
                    true,
                    h5.telemetryCollectorId,
                    installationId,
                    'h5_ui',
                    version
                ]);
                _paq.push(['enableLinkTracking']);
                if (h5.telemetryCookieDomain) {
                    _paq.push(['setCookieDomain', h5.telemetryCookieDomain]);
                }
                // Sanitize the URL so that the domain name is not collected.
                _paq.push(['setUrlCallback', function (url) {
                        var parser = document.createElement('a');
                        parser.href = url;
                        // Collect pathname (i.e. "/ui/"), search (i.e. extensionId, objectId) and
                        // the fragment identifier (including the leading hash mark "#") if any.
                        return parser.pathname + parser.search + parser.hash;
                    }]);
                _this.userSessionService.getUserSession().then(function (userSession) {
                    _paq.push(['setCustomDimension', 'userSessionLocale', userSession.locale]);
                });
            };
            this.log = logService("telemetryService");
        }
        ;
        /**
         * Tracks a telemetry event by sending it to VAC (only if the feature is actively enabled)
         *
         * @param eventCategory
         *    The category of the event, e.g. "login". Populated in the e_c column in VAC DB.
         *
         * @param eventAction
         *    The specific action, e.g. "submit". Populated in the e_a column in VAC DB.
         *
         * @param eventName
         *    Name of the event. E.g. "country". Populated in the a_n column in VAC DB.
         *
         * @param eventValue
         *    The value of the event. E.g. "Australia". Populated in the e_v column in the VAC DB.
         */
        TelemetryService.prototype.trackEvent = function (eventCategory, eventAction, eventName, eventValue) {
            if (h5.isTelemetryEnabled && (typeof _paq !== "undefined")) {
                _paq.push(['trackEvent', eventCategory, eventAction, eventName, eventValue]);
            }
        };
        /**
         * @inheritDoc
         */
        TelemetryService.prototype.init = function () {
            var _this = this;
            this.configurationService.getProperty('ui.telemetry.enabled')
                .then(function (prop) {
                if (prop && prop.toUpperCase() !== "TRUE") {
                    h5.isTelemetryEnabled = false;
                }
                if (h5.isTelemetryEnabled) {
                    _this.initTelemetry();
                    _this.collectPluginData();
                    _this.startTrackingWindowEvents(window);
                    _this.rootScope.$on('$destroy', function () {
                        _this.stopTrackingWindowEvents(window);
                    });
                }
            });
        };
        /**
         * Starts tracking telemetry related events of a target Window object.
         *
         * @param targetWindow which telemetry related events to start tracking.
         */
        TelemetryService.prototype.startTrackingWindowEvents = function (targetWindow) {
            this.startTrackingMouseEvents(targetWindow);
        };
        /**
         * Stop tracking telemetry related events of a target Window object.
         *
         * @param targetWindow which telemetry related events to stop tracking.
         */
        TelemetryService.prototype.stopTrackingWindowEvents = function (targetWindow) {
            this.stopTrackingMouseEvents(targetWindow);
        };
        TelemetryService.$inject = [
            '$rootScope',
            '$http',
            'configurationService',
            'telemetryHelperService',
            'logService',
            'userSessionService',
            'vxZoneService',
            '$location'
        ];
        return TelemetryService;
    }());
    platform.TelemetryService = TelemetryService;
    angular.module('com.vmware.platform.ui')
        .service('telemetryService', TelemetryService);
})(platform || (platform = {}));



/**
 *  Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential
 */
var platform;
(function (platform) {
    /**
     * Noop class implementing TimeTracker
     */
    var NoOpTimeTracker = (function () {
        function NoOpTimeTracker() {
        }
        NoOpTimeTracker.prototype.startTimeTracking = function () {
        };
        ;
        NoOpTimeTracker.prototype.stopTimeTracking = function () {
        };
        ;
        return NoOpTimeTracker;
    }());
    platform.NoOpTimeTracker = NoOpTimeTracker;
    /**
     * Class handling measuring and buffering time and sending the buffered information after certain time to VAC
     */
    var TelemetryTimeTracker = (function () {
        function TelemetryTimeTracker($timeout, configurationService, telemetryService, telemetryParameterName, bufferTimeProp, vxZoneService) {
            this.$timeout = $timeout;
            this.configurationService = configurationService;
            this.telemetryService = telemetryService;
            this.telemetryParameterName = telemetryParameterName;
            this.bufferTimeProp = bufferTimeProp;
            this.vxZoneService = vxZoneService;
            this.MIN_NUMBER_OF_TIMES_TO_BUFFER = 3;
            this.startTime = 0;
            this.pendingTimeout = false;
            this.buffer = [];
        }
        ;
        /**
         * Start tracking the time
         */
        TelemetryTimeTracker.prototype.startTimeTracking = function () {
            this.currentBufferItem = {};
            this.currentBufferItem.start = Date.now();
        };
        /**
         * Stop time tracking
         */
        TelemetryTimeTracker.prototype.stopTimeTracking = function () {
            if (this.currentBufferItem) {
                this.currentBufferItem.duration = Date.now() - this.currentBufferItem.start;
                this.addItem(this.currentBufferItem);
            }
        };
        /**
         * Adds item to the buffer
         *
         * @param item
         */
        TelemetryTimeTracker.prototype.addItem = function (item) {
            if (h5.isTelemetryEnabled && this.telemetryParameterName) {
                this.buffer.push(item);
                if (!this.startTime) {
                    this.startTime = item.start;
                }
                if (this.buffer.length >= this.MIN_NUMBER_OF_TIMES_TO_BUFFER) {
                    this.sendTelemetry();
                }
            }
        };
        /**
         * Buffers the measured time. After the time set
         * elapses, send to the VAC only the median of the buffered time.
         */
        TelemetryTimeTracker.prototype.sendTelemetry = function () {
            var _this = this;
            this.configurationService.getProperty(this.bufferTimeProp).then(function (bufferTime) {
                if (_this.pendingTimeout) {
                    return;
                }
                var elapsed = Date.now() - _this.startTime;
                _this.pendingTimeout = true;
                var wait = Math.max(0, bufferTime - elapsed);
                _this.vxZoneService.runOutsideAngular(function () {
                    _this.$timeout(function () {
                        var median = _this.findMedian();
                        _this.telemetryService.trackEvent(_this.telemetryParameterName, median);
                        _this.buffer = [];
                        _this.startTime = 0;
                        _this.pendingTimeout = false;
                    }, wait);
                });
            });
        };
        /**
         * Finds the median of the buffered time
         *
         * @returns {number} - the median of the buffered times
         */
        TelemetryTimeTracker.prototype.findMedian = function () {
            var medianIndex = Math.floor(this.buffer.length / 2);
            var median = this.buffer.sort(function (item1, item2) {
                return item1.duration - item2.duration;
            })[medianIndex].duration;
            if (this.buffer.length % 2 !== 0) {
                median = (median + this.buffer[medianIndex - 1].duration) / 2;
            }
            return median;
        };
        TelemetryTimeTracker.$inject = [
            '$timeout',
            'telemetryService',
            'configurationService',
            'vxZoneService'
        ];
        return TelemetryTimeTracker;
    }());
    platform.TelemetryTimeTracker = TelemetryTimeTracker;
    /**
     * Service for getting instances of {@link TelemetryTimeTracker}
     */
    var TelemetryTimeTrackerFactory = (function () {
        TelemetryTimeTrackerFactory.$inject = ['$timeout', 'telemetryService', 'configurationService', 'vxZoneService'];
        function TelemetryTimeTrackerFactory($timeout, telemetryService, configurationService, vxZoneService) {
            this.$timeout = $timeout;
            this.telemetryService = telemetryService;
            this.configurationService = configurationService;
            this.vxZoneService = vxZoneService;
        }
        ;
        /**
         * Return new instance of {@link TelemetryTimeTracker}
         * @param telemetryParameterName - the name of the parameter for the tracked time, which will be stored in
         *                                  VAC tables.
         * @param bufferTimeProp - Name of the property which value marks the amount of time that the collected times
         *                      from the tracker will be buffered before sending to VAC
         * @returns {platform.TelemetryTimeTracker}
         */
        TelemetryTimeTrackerFactory.prototype.createTelemetryTracker = function (telemetryParameterName, bufferTimeProp) {
            if (!h5.isTelemetryEnabled) {
                return new NoOpTimeTracker();
            }
            return new TelemetryTimeTracker(this.$timeout, this.configurationService, this.telemetryService, telemetryParameterName, bufferTimeProp, this.vxZoneService);
        };
        return TelemetryTimeTrackerFactory;
    }());
    platform.TelemetryTimeTrackerFactory = TelemetryTimeTrackerFactory;
    angular.module('com.vmware.platform.ui')
        .service('telemetryTimeTrackerFactory', TelemetryTimeTrackerFactory);
})(platform || (platform = {}));



/* Copyright 2015-2019 VMware, Inc. All rights reserved. -- VMware Confidential */
angular.module('com.vmware.platform.ui')
   .service('timeFormatterService', ['i18nService', 'localStorageService', 'clientLocale', '$rootScope', 'vcH5ConstantsService',
      function(i18nService, localStorageService, clientLocale, $rootScope, vcH5ConstantsService) {
         'use strict';
         var BROWSER_DEFAULT =  {
            id: 'DateTimeBrowserDefault',
            displayName: i18nService.getString('Common', 'changeDateTimeFormat.LanguageDefault.label')
         };

         var FORMAT_12_HOUR =  {
            id: 'DateTimeFormat12',
            displayName: i18nService.getString('Common', 'changeDateTimeFormat.12Hour.label')
         };

         var FORMAT_24_HOUR = {
            id: 'DateTimeFormat24',
            displayName: i18nService.getString('Common', 'changeDateTimeFormat.24Hour.label')
         };

         var KNOWN_FORMATS = [BROWSER_DEFAULT, FORMAT_12_HOUR, FORMAT_24_HOUR];
         var DEFAULT_FORMAT = BROWSER_DEFAULT;
         var TIMEDATE_LOCALSTORAGE_KEY = 'timeFormat';

         var userTimeFormatPreference = function() {
            return localStorageService.getUserData(TIMEDATE_LOCALSTORAGE_KEY).then(function(savedFormatId) {
               return findDateTimeFormat(savedFormatId);
            });
         };

         var userTimeFormatPreferenceSync = function() {
            var savedFormatId = localStorageService.getUserDataSync(TIMEDATE_LOCALSTORAGE_KEY);
            return findDateTimeFormat(savedFormatId);
         };

         function findDateTimeFormat(format) {
            var foundFormat = _.find(KNOWN_FORMATS, function(knownFormat) {
               return knownFormat.id === format;
            });
            return foundFormat || DEFAULT_FORMAT;
         }

         function formatIsKnown(format) {
            return _.find(KNOWN_FORMATS, function(knownFormat) {
               return format && format.id && format.id === knownFormat.id;
            });
         }

         var dateOptions = {
            year: "numeric",
            month: "2-digit",
            day: "2-digit"
         };

         var timeOptions = {
            hour: "numeric",
            minute: "numeric",
            second: "numeric"
         };

         var dateTimeOptions = Object.assign({}, dateOptions, timeOptions);

         var language = clientLocale.get();

         var userDateTimeFormatIdToConfig = {};
         userDateTimeFormatIdToConfig[DEFAULT_FORMAT.id] = {
            formatter: Intl.DateTimeFormat(
               language, Object.assign({}, dateTimeOptions)),
            hour12: undefined
         };

         userDateTimeFormatIdToConfig[FORMAT_12_HOUR.id] = {
            formatter: Intl.DateTimeFormat(
               language, Object.assign({ hour12: true }, dateTimeOptions)),
            hour12: true
         };

         userDateTimeFormatIdToConfig[FORMAT_24_HOUR.id] = {
            formatter: Intl.DateTimeFormat(
               language, Object.assign({ hour12: false }, dateTimeOptions)),
            hour12: false
         };

         function timestamp2txt(timestamp, savedDateTimeFormat, options) {
            var date = new Date(timestamp);
            if (!timestamp || isNaN(date.getTime()) || !isFinite(date.getTime())) {
               return "";
            }

            if (!options) {
               var formatter = userDateTimeFormatIdToConfig[DEFAULT_FORMAT.id].formatter;
               if (savedDateTimeFormat && userDateTimeFormatIdToConfig[savedDateTimeFormat.id]) {
                  formatter = userDateTimeFormatIdToConfig[savedDateTimeFormat.id].formatter;
               }

               return formatter.format(date);
            }

            var hour12 = userDateTimeFormatIdToConfig[DEFAULT_FORMAT.id].hour12;
            if (savedDateTimeFormat && userDateTimeFormatIdToConfig[savedDateTimeFormat.id]) {
               hour12 = userDateTimeFormatIdToConfig[savedDateTimeFormat.id].hour12;
            }

            var finalOptions = Object.assign({hour12: hour12}, options);

            return date.toLocaleString(clientLocale.get(), finalOptions);
         }

         function formatDate(timestamp, options) {
            return userTimeFormatPreference().then(function(savedDateTimeFormat) {
               return timestamp2txt(timestamp, savedDateTimeFormat, options);
            });
         }

         function formatDateSync(timestamp, options) {
            return timestamp2txt(timestamp, userTimeFormatPreferenceSync(), options);
         }

         function getUserDateTimeFormatOptions(savedDateTimeFormat) {
            if (!savedDateTimeFormat || !savedDateTimeFormat.id) {
               throw new Error("Invalid format argument: " + JSON.stringify(savedDateTimeFormat));
            }

            if (!userDateTimeFormatIdToConfig.hasOwnProperty(savedDateTimeFormat.id)) {
               throw new Error("The specified format does not exist: " + JSON.stringify(savedDateTimeFormat));
            }

            var hour12 = userDateTimeFormatIdToConfig[savedDateTimeFormat.id].hour12;

            var result = {
               date: Object.assign({}, dateOptions),
               time: Object.assign({hour12: hour12}, timeOptions),
               dateAndTime: Object.assign({hour12: hour12}, dateTimeOptions)
            };

            return result;
         }

         return {
            formatDate: formatDate,
            formatDateSync: formatDateSync,
            timestampToText: timestamp2txt,
            setUserTimeFormatPreference: function(dateTimeFormat) {
               if (formatIsKnown(dateTimeFormat)) {
                  localStorageService.setUserData(TIMEDATE_LOCALSTORAGE_KEY, dateTimeFormat.id);
                  $rootScope.$broadcast(vcH5ConstantsService.USER_DATE_TIME_FORMAT_PREFERENCE_CHANGE, dateTimeFormat);
               }
            },
            getUserTimeFormatPreference: userTimeFormatPreference,
            getUserTimeFormatPreferenceSync: userTimeFormatPreferenceSync,
            getKnownFormats: function() {
               return KNOWN_FORMATS;
            },
            getUserDateTimeFormatOptions: getUserDateTimeFormatOptions
         };
      }
   ]);

/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Misc URL manipulation utilities.
     */
    var URLService = (function () {
        function URLService() {
            this.SCHEME = "scheme";
            this.AUTHORITY = "authority";
            this.PATH = "path";
            this.QUERY = "query";
            this.FRAGMENT = "fragment";
        }
        /**
         * Removes HTML tags from provided HTML string
         *
         * @param html
         */
        URLService.prototype.stripTags = function (html) {
            return html.replace(/<[^>]+>/ig, '');
        };
        /**
         * Remove the parameter with the given name from the fragment component
         * of the given URL. If the parameter name is not present, return the
         * given URL unmodified.
         */
        URLService.prototype.removeParameter = function (url, name) {
            var components = this.parse(url);
            var fragment = components["fragment"];
            if (fragment) {
                var parameterString = fragment.startsWith("?")
                    ? fragment.substring(1)
                    : fragment;
                var parameters = _.reject(parameterString.split("&"), function (param) {
                    return param.indexOf(name) >= 0;
                });
                var newFragment = parameters.join("&");
                if (newFragment) {
                    if (fragment.startsWith("?")) {
                        newFragment = "?" + newFragment;
                    }
                    components[this.FRAGMENT] = newFragment;
                }
                else {
                    components[this.FRAGMENT] = undefined;
                }
            }
            return this.recompose(components);
        };
        URLService.prototype.recompose = function (components) {
            // See rfc3986, section 5.3.
            var result = "";
            if (components[this.SCHEME]) {
                result += components[this.SCHEME] + ":";
            }
            if (components[this.AUTHORITY]) {
                result += "//" + components[this.AUTHORITY];
            }
            result += components[this.PATH];
            if (components[this.QUERY]) {
                result += "?" + components[this.QUERY];
            }
            if (components[this.FRAGMENT]) {
                result += "#" + components[this.FRAGMENT];
            }
            return result;
        };
        URLService.prototype.parse = function (url) {
            // See rfc3986, appendix B.
            var pattern = RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
            var components = url.match(pattern);
            return {
                "scheme": components[2],
                "authority": components[4],
                "path": components[5],
                "query": components[7],
                "fragment": components[9]
            };
        };
        return URLService;
    }());
    platform.URLService = URLService;
    angular.module('com.vmware.platform.ui').service('urlService', URLService);
})(platform || (platform = {}));



/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /***
     * The class wraps the ng-next-app/platform/services/vc-proxy.service
     */
    var VcServiceWrapper = (function () {
        function VcServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(VcServiceWrapper.prototype, "ng2VcService", {
            get: function () {
                if (!this._ng2VcService) {
                    this._ng2VcService = this.$injector.get("vcVcService");
                }
                return this._ng2VcService;
            },
            enumerable: true,
            configurable: true
        });
        VcServiceWrapper.prototype.isValidManagedEntityId = function (objectId) {
            return this.ng2VcService.isValidManagedEntityId(objectId);
        };
        VcServiceWrapper.prototype.is65VcOrLater = function (objectId) {
            return this.ng2VcService.is65VcOrLater(objectId);
        };
        VcServiceWrapper.prototype.is66VcOrLater = function (objectId) {
            return this.ng2VcService.is66VcOrLater(objectId);
        };
        VcServiceWrapper.prototype.is685VcOrLater = function (objectId) {
            return this.ng2VcService.is685VcOrLater(objectId);
        };
        VcServiceWrapper.$inject = ["$injector"];
        return VcServiceWrapper;
    }());
    platform.VcServiceWrapper = VcServiceWrapper;
    angular.module("com.vmware.platform.ui")
        .service("vcService", VcServiceWrapper);
})(platform || (platform = {}));



var platform;
(function (platform) {
    var VimEntityEscapingService = (function () {
        function VimEntityEscapingService() {
        }
        /**
         * @param value {string} containing special characters (%, \ or /)
         * retrieved from user input
         * @returns {string} value with converted/escaped special characters
         * or return the original value if it is not a string
         */
        VimEntityEscapingService.prototype.escapeSpecialCharacters = function (value) {
            if (!value || (typeof value !== "string")) {
                return value;
            }
            return value.replace(/%/g, "%25").replace(/\//g, "%2f").replace(/\\/g, "%5c");
        };
        /**
         * @param value {string} containing escaped special characters (%25, %2f or %5c)
         * retrieved from the backend
         * @returns {string} value with converted/unescaped special characters
         * or return the original value if it is not a string
         */
        VimEntityEscapingService.prototype.unescapeSpecialCharacters = function (value) {
            if (!value || (typeof value !== "string")) {
                return value;
            }
            return value.replace(/%25/g, "%")
                .replace(/%2f/g, "\/").replace(/%5c/g, "\\");
        };
        return VimEntityEscapingService;
    }());
    platform.VimEntityEscapingService = VimEntityEscapingService;
    angular.module("com.vmware.platform.ui")
        .service("vimEntityEscapingService", VimEntityEscapingService);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Provides the ability to create visibility-aware subscriptions for data update notifications.
 */
angular.module('com.vmware.platform.ui').factory('visibilityAwareDataUpdateNotificationService', [
   '$rootScope', 'visibilityMonitorService',
   function($rootScope, visibilityMonitorService) {

      var subscribers = {};
      var eventListenersInfo = {};
      var currentSubscriberId = 0;

      function eventHandler(event) {
         var args = arguments;

         var subscribersToNotify = _.values(subscribers);
         subscribersToNotify = _.filter(subscribersToNotify, function(data) {
            // Subscriber is already marked to be refreshed after its element becomes
            // visible - skip it.
            if (data.notifyOnShow) {
               return false;
            }

            var dataUpdateEventConfig = data.dataUpdateEventsConfig[event.name];
            // Subscriber is not subscribed for this event - skip it.
            if (!dataUpdateEventConfig) {
               return false;
            }

            var checker = dataUpdateEventConfig.checker;
            if (_.isFunction(checker)) {
               // Subscriber has a checker function for the specified event -
               // skip the subscriber if the checker function returns false.
               return checker.apply(undefined, args);
            }

            return true;
         });

         notifySubscribers(subscribersToNotify, event.name, args);
      }

      function notifySubscribers(subscribersToNotify, eventName, handlerArgs) {
         var subscribersRawElements = _.map(subscribersToNotify, function(data) {
            return data.element[0];
         });
         var subscribersVisibilityStatuses = visibilityMonitorService.getVisibilityStatus(
            subscribersRawElements
         );

         _.each(subscribersToNotify, function (data, index) {
            var isVisible = subscribersVisibilityStatuses[index];

            if (isVisible) {
               // If the subscriber's element is visible invoke the subscriber's handler
               // for the specified event
               var handler = data.dataUpdateEventsConfig[eventName].handler;
               handler.apply(undefined, handlerArgs);
            } else {
               // If the subscriber's element is invisible mark the subscriber
               // to be refreshed after its element becomes visible
               data.notifyOnShow = true;
            }
         });
      }

      function createSubscriberVisibilityChangeCallback(subscriberData) {
         return function(newValue, oldVlaue) {
            // If the subscriber's element has become visible and the subscriber is
            // marked to be refreshed after its element becomes visible - then
            // invoke the refreshHandler of the subscriber.
            if (newValue !== true || !subscriberData.notifyOnShow) {
               return;
            }

            subscriberData.notifyOnShow = false;
            subscriberData.refreshHandler();
         };
      }

      function updateEventsListenersOnSubscriberAdd(subscriberData) {
         _.each(subscriberData.dataUpdateEventsConfig, function(eventConfig, eventName) {
            // Check if the eventListenersInfo map contains the eventName as key
            // already - if not then we need to subscribe for that event
            // (on the root scope) and store the event removal function in the map
            // so that when there are 0 subscribers for that event we can remove the
            // listener from the root scope
            if (!eventListenersInfo[eventName]) {
               var removeFunction = $rootScope.$on(eventName, eventHandler);
               eventListenersInfo[eventName] = {
                  removeFunction: removeFunction,
                  subscribersCount: 0
               };
            }

            // Increment the subscribers count for the event with 1
            eventListenersInfo[eventName].subscribersCount++;
         });
      }

      function updateEventsListenersOnSubscriberRemove(subscriberData) {
         _.each(subscriberData.dataUpdateEventsConfig, function(eventConfig, eventName) {
            // Decrement the subscribers count for the event with 1
            eventListenersInfo[eventName].subscribersCount--;

            // If there are no more subscribers for that event remove the event listener
            // from the root scope and remove the event from the eventListenersInfo map
            if (eventListenersInfo[eventName].subscribersCount <= 0) {
               eventListenersInfo[eventName].removeFunction();
               delete eventListenersInfo[eventName];
            }
         });
      }

      /**
       * Creates a visibility-aware subscription for data update notifications i.e.
       * notifications to a subscriber that is bound to a invisible element will be
       * delayed until that element becomes visible.
       *
       * @param {Object} element - a DOM element or a jQuery object pointing to a single
       *    DOM element whose visibility determines when the subscriber will be notified
       *    about the data update.
       * @param {function()} refreshHandler - a callback function
       *    that is invoked when the following conditions are satisfied:
       *    1. the element was not visible
       *    2. data update event(s) occurred
       *    3. the element became visible
       * @param {Object} dataUpdateEventsConfig - an object describing which data update
       *    events to subscribe for and for each data update event what
       *    checker function (optional) to invoke and what handler to invoke if
       *    the check succeeds (if there is a checker function).
       *    The arguments passed to the 'checker' and 'handler' functions
       *    are the event and the event arguments (i.e. the arguments received by
       *    the listener for the event on the root scope). If the subscriber's element
       *    is not visible when a relevant data update occurs then respective handler
       *    is not invoked, instead when the element becomes visible the subscriber's
       *    refreshHandler is invoked.
       *
       *    An example dataUpdateEventsConfig object:
       *    {
       *       'update-event-1': {
       *          handler: function(event, arg_1, arg_1, ..., arg_<m>) {
       *          },
       *          checker: function(event, arg_1, arg_2, ..., arg_<m>) {
       *             return <event-is-relevant>;
       *          }
       *       },
       *       ...
       *       'update-event-2': {
       *          handler: function(event, arg_1, arg_2, ..., arg_<k>) {
       *          },
       *          checker: function(event, arg_1, arg_2, ..., arg_<k>) {
       *             return <event-is-relevant>;
       *          }
       *       },
       *    }
       *
       * @returns {Object} subscriber id used to unsubscribe
       */
      var subscribeForDataUpdate = function(element, refreshHandler, dataUpdateEventsConfig) {
         if (!element) {
            throw new Error(
               'element can not be null'
            );
         }

         if (!_.isNumber(element.length)) {
            element = [element];
         }

         if (element.length !== 1 || !_.isElement(element[0])) {
            throw new Error(
               'element must be a DOM element or' +
                  ' a jQuery object pointing to a single DOM element'
            );
         }

         if (!_.isFunction(refreshHandler)) {
            throw new Error('refreshHandler is required and must be a function');
         }

         if (!_.isObject(dataUpdateEventsConfig) || _.isEmpty(dataUpdateEventsConfig)) {
            throw new Error('dataUpdateEventsConfig must be a non-empty object');
         }

         _.each(dataUpdateEventsConfig, function(eventConfig, eventName) {
            if (!_.isObject(eventConfig)) {
               throw new Error('dataUpdateEventConfig for "' +
                  eventName + '" is not an object'
               );
            }

            if (!_.isFunction(eventConfig.handler)) {
               throw new Error('dataUpdateEventConfig.handler for "' +
                  eventName + '" is required and must be an function');
            }

            if (!_.isUndefined(eventConfig.checker) &&
                  !_.isNull(eventConfig.checker) &&
                  !_.isFunction(eventConfig.checker)) {
               throw new Error('dataUpdateEventConfig.checker for "' +
                  eventName + '" must be undefined, null or a function');
            }
         });

         element = $(element);

         currentSubscriberId++;

         var subscriberId = currentSubscriberId;
         var subscriberData = subscribers[subscriberId] = {
            id: subscriberId,
            element: element,
            refreshHandler: refreshHandler,
            dataUpdateEventsConfig: angular.copy(dataUpdateEventsConfig),
            notifyOnShow: false,
            visibilityMonitorServiceSubscriberId: null
         };

         subscriberData.visibilityMonitorServiceSubscriberId =
            visibilityMonitorService.subscribeForVisibilityChange(
               element,
               createSubscriberVisibilityChangeCallback(subscriberData)
            );

         updateEventsListenersOnSubscriberAdd(subscriberData);

         return subscriberId;
      };

      /**
       * Removes a subscription for data update notifications
       *
       * @param {Object} subscriberId - a subscriber id returned as a result
       *    of a call to the 'subscribeForDataUpdate' method
       */
      var unsubscribe = function(subscriberId) {
         if (!_.isNumber(subscriberId)) {
            throw new Error(
               'invalid subscriberId: ' + subscriberId
            );
         }

         if (!(subscriberId in subscribers)) {
            return;
         }

         var subscriberData = subscribers[subscriberId];

         visibilityMonitorService.unsubscribe(
            subscriberData.visibilityMonitorServiceSubscriberId
         );
         subscriberData.visibilityMonitorServiceSubscriberId = null;

         updateEventsListenersOnSubscriberRemove(subscriberData);

         delete subscribers[subscriberId];
      };

      // Cleanup on root scope destroy. Normally we wouldn't concern ourselves with
      // this, but during jasmine tests the service is instantiated multiple times
      // so to prevent memory leaks and memory spikes we need to do a proper clean up
      $rootScope.$on('$destroy', function() {
         _.each(_.keys(subscribers), function(subscriberId) {
            unsubscribe(Number(subscriberId));
         });

         // No need for special cleaning of eventListenersInfo as destroying the
         // root scope will remove the listeners, also we have unsubscribed all
         // subscribers which means this object should be empty.
         eventListenersInfo = {};
         currentSubscriberId = 0;
      });

      return {
         subscribeForDataUpdate: subscribeForDataUpdate,
         unsubscribe: unsubscribe
      };
   }]);
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Provides the ability to create subscriptions for element visibility change notifications.
 */
angular.module('com.vmware.platform.ui').factory('visibilityMonitorService', [
   '$rootScope', '$timeout', 'logService', 'vxZoneService',
   function($rootScope, $timeout, logService, vxZoneService) {
      var log = logService('visibilityMonitorService');

      var VISIBILITY_CHECK_TTL = 5;

      var subscribers = { };
      var currentSubscriberId = 0;
      var observer = null;

      function checkVisibilityAndSendNotifications() {
         var subscribersArray = _.values(subscribers);
         var subscribersElements = _.map(subscribersArray, function (data) {
            return data.element[0];
         });

         var callbacksToInvoke;
         var ttl = VISIBILITY_CHECK_TTL;

         do {
            callbacksToInvoke = [];

            var subscribersElementsVisibilityStatus =
               getVisibilityStatus(subscribersElements);

            /* Ignore jshint 'Don't make functions within a loop' warning*/
            /*jshint -W083 */
            _.each(subscribersArray, function (data, index) {
               var oldValue = data.oldVisibilityValue;
               var newValue = subscribersElementsVisibilityStatus[index];

               // If the subscriber's element visibility changed add the callback
               // with the correct arguments (new, old values) to the callbacksToInvoke
               // collection
               if (newValue !== oldValue) {
                  data.oldVisibilityValue = newValue;
                  callbacksToInvoke.push(
                     _.partial(data.callback, newValue, oldValue)
                  );
               }
            });

            // If there are subscribers to notify begin an $apply phase and invoke the
            // callbacks
            if (callbacksToInvoke.length > 0) {
               vxZoneService.runInsideAngular(function () {
                  $rootScope.$apply(function() {
                     /* Ignore jshint 'Don't make functions within a loop' warning*/
                     /*jshint -W083 */
                     _.each(callbacksToInvoke, function(callback) {
                        try {
                           callback();
                        } catch (error) {
                           log.error("Visibility change refresh callback failed with error: " + error);
                        }
                     });
                  });
               });
            }

            ttl--;
         } while (callbacksToInvoke.length > 0 && ttl >= 0);

         // Invoking a visibility callback might cause a different element to show
         // so after we invoke all the visibility change callbacks we need to
         // recheck the elements for visibility changes. We want to limit the max number
         // of iterations so for this we use the 'ttl' (time-to-live) var. If after the
         // visibility check cycle the 'ttl' var has value < 0 it means that the ttl
         // has expired i.e. some subscribers' callbacks might not have been invoked.
         // Log a warning to the console in this case.
         if (ttl < 0) {
            log.warn('TTL expired while performing checkVisibilityAndSendNotifications');
         }
      }

      /**
       * Creates a subscription for element visibility change notifications.
       *
       * @param {Object} element - a DOM element or a jQuery object pointing to a single
       *    DOM element whose visibility is to be observed
       * @param {function(boolean, boolean)} callback - a callback function
       *    that is invoked when the element visibility changes. The first argument
       *    passed to function is the new visibility value and the second argument is
       *    the old visibility value. It's guaranteed that the 2 arguments will have
       *    different values!
       * @returns {Object} subscriber id used to unsubscribe
       */
      var subscribeForVisibilityChange = function (element, callback) {
         if (!element) {
            throw new Error(
               'element can not be null'
            );
         }

         if (!_.isNumber(element.length)) {
            element = [element];
         }

         if (element.length !== 1 || !_.isElement(element[0])) {
            throw new Error(
               'element must be a DOM element or' +
               ' a jQuery object pointing to a single DOM element'
            );
         }

         if (!_.isFunction(callback)) {
            throw new Error('callback is required and must be a function');
         }

         element = $(element);

         currentSubscriberId++;

         var subscriberId = currentSubscriberId;
         subscribers[subscriberId] = {
            id: subscriberId,
            element: element,
            callback: callback,
            oldVisibilityValue: getVisibilityStatus(element)[0]
         };
         return subscriberId;
      };

      /**
       * Removes a subscription for element visibility change notifications
       *
       * @param {Object} subscriberId - a subscriber id returned as a result
       *    of a call to the 'subscribeForVisibilityChange' method
       */
      var unsubscribe = function (subscriberId) {
         if (!_.isNumber(subscriberId)) {
            throw new Error(
               'invalid subscriberId: ' + subscriberId
            );
         }

         if (!(subscriberId in subscribers)) {
            return;
         }

         delete subscribers[subscriberId];
      };

      /**
       * Calculates the visibility of elements. An element is considered visible
       * if $(element).is(':visible') returns true.
       * See https://api.jquery.com/visible-selector/ for more info about visibility
       *
       * @param {Array<Object>} elements - an array of DOM elements or a jQuery object
       * @returns {Array<boolean>} the calculated visibility of each element (in the
       * same order as the input array or jQuery object)
       */
      var getVisibilityStatus = function (elements) {
         if (!elements || !_.isNumber(elements.length)) {
            throw new Error(
               'elements is required and must be an array of DOM elements or a jQuery object'
            );
         }

         var i, rawElements = [];
         for (i = 0; i < elements.length; i++) {
            if (!_.isElement(elements[i])) {
               throw new Error(
                  'elements[' + i + ']' + ' is not a DOM element'
               );
            }

            rawElements.push(elements[i]);
         }

         return _.map(rawElements, function (rawElement) {
            return document.documentElement.contains(rawElement);
         });
      };

      /**
       * Subscribes document Root element for Mutations in childlist and subtree.
       * 
       * https://stackoverflow.com/questions/28598340/mutation-observer-fails-to-detect-elements-dom-removal
       * We cannot directly subscribe for the removal the dom element itself using mutation observer.
       * We can only subscribe to childlist of a dom element.
       * 
       */
      var subscribeToMutationObserver = function() {
         observer = new MutationObserver(function (mutationsList, observer) {
            checkVisibilityAndSendNotifications();
         });
         observer.observe(document.documentElement,
            { childList: true, subtree: true });
      };

      vxZoneService.runOutsideAngular(function() {
         subscribeToMutationObserver();
      });

      // Cleanup on root scope destroy. Normally we wouldn't concern ourselves with
      // this, but during jasmine tests the service is instantiated multiple times
      // so to prevent memory leaks and memory spikes we need to do a proper clean up
      $rootScope.$on('$destroy', function() {
         _.keys(subscribers).forEach(function(subscriberId) {
            unsubscribe(Number(subscriberId));
         });

         currentSubscriberId = 0;
         vxZoneService.runOutsideAngular(function() {
            if(observer) {
               observer.disconnect();
               observer = null;
            }
         });
      });

      return {
         subscribeForVisibilityChange: subscribeForVisibilityChange,
         unsubscribe: unsubscribe,
         getVisibilityStatus: getVisibilityStatus,
         // Used for testing purposes
         $$checkVisibilityAndSendNotifications: checkVisibilityAndSendNotifications
      };
   }]);
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Util service to create the nodes needed for use of vx-view
 */
angular.module('com.vmware.platform.ui').factory('vxViewUtil', [
function() {

   var id = 0;

   return {
     /**
       * Get navi data
       */
      getNode: function(src) {
         id++;

         var rawNode = angular.extend({
            $id: id,
            $selectedChildIndex: -1,
            $children: []
         }, src);

         return new NavigationTree(rawNode).getNodeAtLevel(0);
      },
   };
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Service containing helper methods related to the Zones API used by Angular 2
 * Zones library will be furnished by a special Angular Next generation bundle, not from h5's default AngularJS system
 * (https://github.com/angular/zone.js/)
 */
angular.module('com.vmware.platform.ui').factory('vxZoneService', [
   function() {
      var rootZone = null;
      var angularZone = null;
      if (window.Zone && window.Zone.current) {
         rootZone = window.Zone.current.parent || window.Zone.current;
         angularZone = window.Zone.current.name === "angular" ? window.Zone.current : null;
      }
      return {
         // Runs the method outside of the Angular 2 zone (NG Zone), this
         // allows us to have infinite timeouts and infinite setInterval methods
         // without interfering with the Testability provider
         runOutsideAngular: function(method) {
            if (rootZone) {
               return rootZone.run(method);
            } else {
               return method();
            }
         },

         runInsideAngular: function(method) {
            if (angularZone) {
               return angularZone.run(method);
            } else {
               return method();
            }
         }
      };
   }
]);

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * User Session Service Ex.
 */
angular.module('com.vmware.platform.ui').factory('userSessionExService', ['$http', '$q', 'logService',
function($http, $q, logService) {
   'use strict';
   var logger = logService('userSessionExService');

   return {
      /**
       * Makes a call to acquire a session-specific ticket string which can be used to clone the current session.
       *
       * @param {string} serverGuid
       *    Guid of the server for which cloned ticket is being requested
       *
       * @returns {promise}
       *    Promise to return the cloned ticket for the right server
       */
      acquireCloneTicket: function(serverGuid) {
         return $http({method: 'GET', url: 'usersessionex/acquireCloneTicket/' + serverGuid}).then(function(resp){
            if(!resp.data){
               logger.error('Null response for clone ticket');
            }
            return resp.data;
         });
      }
   };
}]);

/* Copyright 2013-2016 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var UserSessionService = (function () {
        function UserSessionService($injector) {
            this.$injector = $injector;
            this.WEB_CLIENT_SESSION_ID = 'webClientSessionId';
            this.VC_NO_ERROR_CODE = "noError";
        }
        Object.defineProperty(UserSessionService.prototype, "vcUserSessionService", {
            get: function () {
                if (!this._vcUserSessionService) {
                    this._vcUserSessionService = this.$injector.get('vcUserSessionService');
                }
                return this._vcUserSessionService;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(UserSessionService.prototype, "webClientSessionId", {
            get: function () {
                return this.vcUserSessionService.webClientSessionId;
            },
            enumerable: true,
            configurable: true
        });
        UserSessionService.prototype.getUserSession = function () {
            return this.vcUserSessionService.getUserSession();
        };
        UserSessionService.prototype.getServerInfo = function (serviceGuid) {
            return this.vcUserSessionService.getServerInfo(serviceGuid);
        };
        UserSessionService.prototype.getAllServersInfo = function () {
            return this.vcUserSessionService.getAllServersInfo();
        };
        UserSessionService.prototype.ping = function () {
            return this.vcUserSessionService.ping();
        };
        UserSessionService.prototype.sessionPing = function (requestTimeout) {
            if (requestTimeout === void 0) { requestTimeout = 5000; }
            return this.vcUserSessionService.sessionPing(requestTimeout);
        };
        UserSessionService.$inject = ['$injector'];
        return UserSessionService;
    }());
    platform.UserSessionService = UserSessionService;
    angular.module('com.vmware.platform.ui').service('userSessionService', UserSessionService);
})(platform || (platform = {}));



/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Used to provide aria attributes and appropriate roles to the confirmation modals
 * in H5 client to make it readable by the screen readers
 */
(function () {
    "use strict";
    angular.module("com.vmware.platform.ui").directive("alertDialogRole", alertDialogRole);
    alertDialogRole.$inject = ["$timeout"];
    function alertDialogRole($timeout) {
        var directive = {
            scope: {
                primaryTitle: "<?"
            },
            restrict: "A",
            compile: function () {
                return {
                    pre: function () { },
                    post: function (scope, element) {
                        $timeout(function () {
                            var $dialog = element.find("div[role=dialog]");
                            if (!$dialog.length) {
                                return;
                            }
                            var dialogTitleId = "dialog-title-" + Date.now();
                            var dialogDescriptionId = "dialog-description-" + Date.now();
                            $dialog.find(".modal-title").attr("id", dialogTitleId);
                            $dialog.find(".modal-body").attr("id", dialogDescriptionId);
                            $dialog.attr({
                                "role": "alertdialog",
                                "aria-labelledby": dialogTitleId,
                                "aria-modal": "true",
                                "aria-describedby": dialogDescriptionId,
                                "tabindex": 0
                            });
                        }, 0);
                    }
                };
            }
        };
        return directive;
    }
})();



/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
(function () {
    "use strict";
    angular.module("com.vmware.platform.ui").directive("focusPrimaryButton", focusPrimaryButton);
    focusPrimaryButton.$inject = ["$timeout"];
    function focusPrimaryButton($timeout) {
        var directive = {
            scope: {
                primaryTitle: "<?"
            },
            restrict: "A",
            compile: function compile(element, attributes) {
                return {
                    pre: function () { },
                    post: postLink
                };
            }
        };
        function postLink(scope, element, attributes) {
            $timeout(function () {
                var childElements = element.find("button.btn-primary");
                if (childElements.length > 0) {
                    childElements[0].focus();
                }
            }, 0);
        }
        return directive;
    }
})();



angular.module('com.vmware.platform.ui').directive('allowedCharacters', [function () {
   return {
      restrict: 'A',
      require: 'ngModel',
      link: function (scope, element, attrs, ctrl) {
         ctrl.$parsers.push(function (value) {
            var newValue = value.toString().replace(
               new RegExp('[^' + attrs.allowedCharacters + ']', 'g'), '');

            ctrl.$setViewValue(newValue);
            ctrl.$render();

            return newValue;
         });
      }
   };
}]);

/* Copyright 2014-2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Registers common action invokers in the h5.actions cache.
 *
 * We do this in the run block of the module so that invokers can take
 * advantage of angular services injected into a closure.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').run(registerCommonActionInvokers);

   registerCommonActionInvokers.$inject = [
      '$window',
      'configurationService',
      'clarityModalService',
      'helpService',
      'i18nService',
      'themeService',
      '$rootScope',
      '$q'
   ];

   function registerCommonActionInvokers(
      $window,
      configurationService,
      clarityModalService,
      helpService,
      i18nService,
      themeService,
      $rootScope,
      $q) {

      _.extend($window.h5.actions, {
         'vsphere.core.actions.openHelp': openHelpAction,
         'vsphere.core.actions.switchTheme': switchThemeAction,
         'vsphere.core.actions.openVmcOnAws': openVmcOnAwsAction,
         'vsphere.core.actions.openVSphereVideos': openVSphereVideosAction
      });

      /**
       * Action for opening a help page.
       */
      function openHelpAction() {
         helpService.showHelpPage();
      }

      /**
       * Action for opening a VMware Cloud on AWS page.
       */
      function openVmcOnAwsAction(){
         helpService.showVmcOnAwsPage();
      }

      /**
       * Action for opening a VMware vSphere videos page.
       */
      function openVSphereVideosAction(){
         helpService.showVSphereVideosPage();
      }

      /**
       * Action for changing the theme between light and dark.
       */
      function switchThemeAction() {
         themeService.changeTheme();
      }
   }
}());


//# sourceMappingURL=jsUiLib.js.map
