/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.model.VmodlObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ObjectRegistry {
    private static Map<String, VmodlObject> _objNameMap;
    private static boolean _finalized;

    public static void reset() {
        _objNameMap = new HashMap<String, VmodlObject>();
    }

    public static void registerObject(String fullName, VmodlObject obj) {
        _objNameMap.put(fullName, obj);
    }

    public static boolean hasObject(String name) {
        return _objNameMap.containsKey(name);
    }

    public static VmodlObject getObject(String name) {
        return _objNameMap.get(name);
    }

    public static Collection<VmodlObject> getAllObjects() {
        return _objNameMap.values();
    }

    public static void verifyWSDLNameConsistency() {
        if (_finalized) {
            return;
        }
        HashMap<String, VmodlObject> processedObjects = new HashMap<String, VmodlObject>();
        StringBuilder sb = new StringBuilder("Conflicting WSDL names:\n");
        boolean haveConflict = false;
        for (VmodlObject obj : _objNameMap.values()) {
            String wsdlName = obj.getWsdlName();
            if (processedObjects.containsKey(wsdlName)) {
                sb.append("\t-> ");
                sb.append(wsdlName + ": ");
                sb.append(((VmodlObject)processedObjects.get(wsdlName)).getQualifiedVmodlType());
                sb.append(" " + obj.getQualifiedVmodlType() + "\n");
                haveConflict = true;
                continue;
            }
            processedObjects.put(wsdlName, obj);
        }
        if (haveConflict) {
            throw new RuntimeException(sb.toString());
        }
        _finalized = true;
    }

    public static void print() {
        for (VmodlObject vmodlObject : _objNameMap.values()) {
            vmodlObject.print();
        }
    }

    public static void unregisterObject(String name) {
        _objNameMap.remove(name);
    }

    static {
        _finalized = false;
    }
}

