/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.EmitterFactory;
import emitters.ObjectRegistry;
import emitters.Services;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.core.Options;
import emitters.core.SyntaxException;
import emitters.core.VmodlProcessor;
import emitters.model.DataObject;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.wsdl.WSDLGenerator;
import emitters.wsdl.WSDLGenerator2;
import emitters.wsdl.XMLGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import vmodl.service;

public class Processor {
    private static Options _options;
    private static VmodlProcessor _processor;

    public static void computeVersions() {
        boolean versionSetForAll = false;
        while (!versionSetForAll) {
            versionSetForAll = true;
            for (VmodlObject obj : ObjectRegistry.getAllObjects()) {
                String name = obj.getQualifiedVmodlType();
                Version objVersion = obj.getVersion();
                VmodlObject baseObj = obj.getBaseObject();
                switch (obj.getKind()) {
                    case DataObject: 
                    case Enum: 
                    case ManagedObject: {
                        if (name.equals(Utils.ManagedObjectClassName) || name.equals(Utils.DataObjectClassName) || name.equals(Utils.DynamicDataClassName) || name.equals(Utils.DynamicPropertyClassName) || name.equals(Utils.DynamicArrayClassName)) {
                            if (objVersion == null) {
                                objVersion = Version._root;
                                break;
                            }
                            if (objVersion == Version._root) break;
                            throw new RuntimeException("Version of class " + name + " (" + obj.getVersion().getVmodlName() + ") should be version0");
                        }
                        if (baseObj != null) {
                            Version baseObjVersion = baseObj.getVersion();
                            if (baseObjVersion == null) break;
                            if (objVersion == null) {
                                String sanitizedName;
                                if (baseObjVersion == Version._root) {
                                    objVersion = Versions.onUnspecifiedReleaseTag(name);
                                    break;
                                }
                                String sourcePackage = baseObjVersion.getPackage();
                                int lastDotPos = sourcePackage.lastIndexOf(".");
                                sourcePackage = sourcePackage.substring(0, lastDotPos + 1);
                                String string = sanitizedName = name.startsWith("hostd.") ? "vim." + name.substring(6) : name;
                                if (sanitizedName.startsWith(sourcePackage)) {
                                    objVersion = baseObjVersion;
                                    break;
                                }
                                throw new RuntimeException("Cannot assign version of parent object '" + baseObjVersion.getVmodlName() + "' to object " + name + ". Please add an explicit version tag.");
                            }
                            if (objVersion.isAncestor(baseObjVersion)) break;
                            throw new RuntimeException("Version of type " + name + " (" + obj.getVersion().getVmodlName() + ") is not a child of the parent class " + baseObj.getQualifiedVmodlType() + " version (" + baseObjVersion.getVmodlName() + ")");
                        }
                        if (objVersion != null) break;
                        objVersion = Versions.onUnspecifiedReleaseTag(name);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Type " + name + " is not a MO/Data Object or Enum");
                    }
                }
                if (objVersion == null) {
                    versionSetForAll = false;
                    continue;
                }
                if (obj.getVersion() != null && !obj.getVersion().equals(objVersion)) {
                    throw new RuntimeException("Type " + name + " already has a version" + obj.getVersion() + " attempted to set" + objVersion);
                }
                if (obj.getVersion() != null) continue;
                obj.setVersion(objVersion);
                versionSetForAll = false;
            }
        }
        for (Version version : Versions.getVersions()) {
            String wireNs = version.getWireNs();
            if (wireNs != null && !wireNs.isEmpty()) continue;
            service svc = null;
            try {
                svc = Services.getService(version);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (svc != null) continue;
            throw new SyntaxException("Either @wsdlName or service information is required for version %s", version.getVmodlName());
        }
    }

    public static void validateLinkableFields(Map<String, DataObject> dataObjects) {
        for (DataObject dobj : dataObjects.values()) {
            for (Property prop : dobj.getPropertyList()) {
                if (!prop.getDecl().isLinkable()) continue;
                VmodlDecl ldecl = prop.getDecl();
                if (!ldecl.isData() || ldecl.getObject().getKind() != VmodlObject.Kind.DataObject) {
                    throw SyntaxException.at(ldecl.getObject(), "@linkable property %s of data object %s must refer to a data object", prop.getName(), dobj.getClassName());
                }
                DataObject lobj = (DataObject)ldecl.getObject();
                if (lobj.hasKey()) continue;
                throw SyntaxException.at(lobj, "@linkable property %s of data object %s must refer to a data object that contains a String key property", prop.getName(), dobj.getClassName());
            }
        }
    }

    public static void validateSubclassPrivileges(Map<String, ManagedObject> managedObjects) {
        for (ManagedObject mobj : managedObjects.values()) {
            List<Method> methods = mobj.getMethodList();
            for (int i = 0; i < methods.size(); ++i) {
                Map<String, String> subclassPrivs = methods.get(i).getSubclassPrivileges();
                if (subclassPrivs == null) continue;
                for (String subclass : subclassPrivs.keySet()) {
                    VmodlObject obj;
                    if (!managedObjects.containsKey(subclass)) {
                        throw SyntaxException.at(mobj, "%s: unknown subclass %s", mobj.getQualifiedVmodlType(), subclass);
                    }
                    for (obj = (VmodlObject)managedObjects.get(subclass); obj != null && obj != mobj; obj = obj.getBaseObject()) {
                    }
                    if (obj == mobj) continue;
                    throw SyntaxException.at(mobj, "%s: %s is not a subclass of this object", mobj.getQualifiedVmodlType(), subclass);
                }
            }
        }
    }

    public static void filterNestedObjects(VmodlObject obj) {
        ArrayList<VmodlObject> nestedList = new ArrayList<VmodlObject>();
        for (VmodlObject nestedObject : obj.getNestedList()) {
            if (!Versions.isTargetNewerThan(nestedObject.getVersion())) continue;
            Processor.filterNestedObjects(nestedObject);
            nestedList.add(nestedObject);
        }
        obj.setNestedList(nestedList);
    }

    private static void setupEmitterLists(Options options) {
        _options = options;
    }

    private static void vmodlMainImpl(VmodlProcessor processor, Options options) {
        Processor.setupEmitterLists(options);
        _processor = processor;
        processor.init();
        Versions.init(Processor._options.versionsOptions, Processor._options.verTarget);
        if (Processor._options.verTarget == null) {
            Processor.processList(options.unfilteredList, false);
            Processor.processList(options.unfilteredNonDynamicList, true);
        }
        if (Versions.getTargetVersion().getKind() == Version.Kind.DISABLED) {
            Versions.moveToDevVersion();
            Processor.processXmlEmitters(false);
        }
        Versions.moveToLtsVersion();
        Processor.processList(options.filteredList, false);
        Processor.processList(options.filteredNonDynamicList, true);
        if (Processor._options.verTarget != null) {
            Processor.processList(options.unfilteredList, false);
            Processor.processList(options.unfilteredNonDynamicList, true);
        }
        Processor.processXmlEmitters(true);
    }

    public static void vmodlMain(VmodlProcessor processor, Options options) {
        try {
            Processor.vmodlMainImpl(processor, options);
        }
        catch (Exception e) {
            String cmdLine = System.getProperty("sun.java.command");
            System.err.println("Caught top level emitter exception.");
            System.err.println("VMODL Emitter invocation context: " + cmdLine);
            throw e;
        }
    }

    private static void processXmlEmitters(final boolean ltsOnly) {
        if (Processor._options.xmlOptions.isEmpty() && !Processor._options.wsdl2Requested && !Processor._options.wsdlRequested) {
            return;
        }
        ArrayList<EmitterFactory> factoryList = new ArrayList<EmitterFactory>();
        if (!Processor._options.xmlOptions.isEmpty() && (ltsOnly || XMLGenerator.isDevRequested(Processor._options.xmlOptions))) {
            factoryList.add(new EmitterFactory(){

                @Override
                public VmodlEmitter newInstance() {
                    return new XMLGenerator(_options.xmlOptions, ltsOnly);
                }
            });
        }
        if (Processor._options.wsdl2Requested) {
            if (ltsOnly || WSDLGenerator2.isDevRequested(Processor._options.wsdlOptions)) {
                factoryList.add(new EmitterFactory(){

                    @Override
                    public VmodlEmitter newInstance() {
                        return new WSDLGenerator2(_options.wsdlOptions, ltsOnly);
                    }
                });
            }
        } else if (Processor._options.wsdlRequested && (ltsOnly || WSDLGenerator.isDevRequested(Processor._options.wsdlOptions))) {
            factoryList.add(new EmitterFactory(){

                @Override
                public VmodlEmitter newInstance() {
                    return new WSDLGenerator(_options.wsdlOptions, ltsOnly);
                }
            });
        }
        _processor.processEmitters(factoryList, true);
        _processor.reset();
    }

    private static void processList(Iterable<EmitterFactory> factories, boolean skipDynamic) {
        if (!factories.iterator().hasNext()) {
            return;
        }
        _processor.processEmitters(factories, skipDynamic);
        _processor.reset();
    }
}

