/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.generators.joap.OpenAPI3;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Property;
import java.util.Comparator;

class OperationId {
    private final String _hash;
    private final Method _method;
    private final ManagedProperty _managedProperty;

    OperationId(String hash, Method method) {
        this._hash = hash;
        this._method = method;
        this._managedProperty = null;
    }

    OperationId(String hash_, Property property) {
        this._hash = hash_;
        this._method = null;
        this._managedProperty = (ManagedProperty)property;
    }

    String getName() {
        return this._method != null ? this._method.getName() : this._managedProperty.getName();
    }

    void setName() {
        if (this._method != null) {
            this._method.setCustomName(OpenAPI3.getNameHashCombo(this._method.getName(), this._hash));
        } else {
            this._managedProperty.setCustomName(OpenAPI3.getNameHashCombo(this._managedProperty.getName(), this._hash));
        }
    }

    static Comparator<OperationId> getComparator() {
        return new Comparator<OperationId>(){

            @Override
            public int compare(OperationId o1, OperationId o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }
}

