/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.Entity;
import emitters.model.SourcePos;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;

public class Field
implements Entity {
    protected final String _name;
    protected final VmodlDecl _decl;
    protected final String _privId;
    protected final Version _version;
    protected final String _comment;
    protected SourcePos _sourcePos;

    Field(String name, VmodlDecl decl, String privId, Version version, String comment) {
        this._name = name;
        this._decl = decl;
        this._privId = privId;
        this._version = version;
        this._comment = comment;
    }

    public Field(String name, VmodlDecl decl) {
        this(name, decl, null, null, null);
    }

    @Override
    public void setSourcePos(SourcePos sourcePos) {
        this._sourcePos = sourcePos;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public VmodlDecl getDecl() {
        return this._decl;
    }

    public String getPrivilegeId() {
        return this._privId;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public SourcePos getSourcePos() {
        return this._sourcePos;
    }

    void enqueueDigest(VmodlApi vmodlApi) {
        if (this._version != vmodlApi.getVersion()) {
            this._version.enqueueDigestPartOf(vmodlApi);
        }
        this._decl.enqueDigestDefiniton(this._version);
        this._version.enqueueDigestField(this);
    }

    void print(String indent) {
        System.out.print(indent);
        this._decl.print();
        System.out.print(", Name: " + this._name);
        System.out.print(", Version: " + this._version.getVmodlName());
    }
}

