/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.configurables.replications;

import com.vmware.vim.binding.hms.Group;
import com.vmware.vim.binding.hms.remote.ServerInfo;
import com.vmware.vim.vmomi.core.util.StringUtil;
import com.vmware.vr.client.impex.configurables.Configurable;
import com.vmware.vr.client.impex.configurables.replications.IeReplicationRetentionPolicy;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"name", "rpo", "quiesceGuestEnabled", "networkCompressionEnabled", "targetHbrServerName", "lwdEncryptionEnabled", "retentionPolicy", "autoReplicateNewDisks"})
@XmlRootElement(name="Setting")
public class IeReplicationGroupSetting
extends Configurable {
    private static final long serialVersionUID = 1L;
    private String name;
    private long rpo;
    private boolean quiesceGuestEnabled;
    private boolean networkCompressionEnabled;
    private String targetHbrServerName;
    private Boolean lwdEncryptionEnabled;
    private IeReplicationRetentionPolicy retentionPolicy;
    private Boolean autoReplicateNewDisks;

    public IeReplicationGroupSetting() {
    }

    public IeReplicationGroupSetting(Group.Settings settings, ServerInfo hbrsrv) {
        this.name = settings.name;
        this.rpo = settings.rpo;
        this.quiesceGuestEnabled = settings.quiesceGuestEnabled;
        this.networkCompressionEnabled = settings.networkCompressionEnabled;
        this.targetHbrServerName = Objects.isNull(hbrsrv) ? null : hbrsrv.getName();
        this.lwdEncryptionEnabled = settings.getLwdEncryptionEnabled();
        this.retentionPolicy = new IeReplicationRetentionPolicy(settings.getRetentionPolicy());
        this.autoReplicateNewDisks = settings.getAutoReplicateNewDisks();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getRpo() {
        return this.rpo;
    }

    public void setRpo(long rpo) {
        this.rpo = rpo;
    }

    public boolean isQuiesceGuestEnabled() {
        return this.quiesceGuestEnabled;
    }

    public void setQuiesceGuestEnabled(boolean quiesceGuestEnabled) {
        this.quiesceGuestEnabled = quiesceGuestEnabled;
    }

    public boolean isNetworkCompressionEnabled() {
        return this.networkCompressionEnabled;
    }

    public void setNetworkCompressionEnabled(boolean networkCompressionEnabled) {
        this.networkCompressionEnabled = networkCompressionEnabled;
    }

    public String getTargetHbrServerName() {
        return this.targetHbrServerName;
    }

    public void setTargetHbrServerName(String targetHbrServerName) {
        this.targetHbrServerName = targetHbrServerName;
    }

    public Boolean getLwdEncryptionEnabled() {
        return this.lwdEncryptionEnabled;
    }

    public void setLwdEncryptionEnabled(Boolean lwdEncryptionEnabled) {
        this.lwdEncryptionEnabled = lwdEncryptionEnabled;
    }

    @XmlElementRef
    public IeReplicationRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(IeReplicationRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public Boolean getAutoReplicateNewDisks() {
        return this.autoReplicateNewDisks;
    }

    public void setAutoReplicateNewDisks(Boolean autoReplicateNewDisks) {
        this.autoReplicateNewDisks = autoReplicateNewDisks;
    }

    public String toString() {
        StringBuilder objString = new StringBuilder(400);
        objString.append("(vr.Settings) {\n");
        objString.append("   ");
        objString.append("name = ");
        objString.append(this.getName());
        objString.append(",\n");
        objString.append("   ");
        objString.append("rpo = ");
        objString.append(this.getRpo());
        objString.append(",\n");
        objString.append("   ");
        objString.append("quiesceGuestEnabled = ");
        objString.append(this.isQuiesceGuestEnabled());
        objString.append(",\n");
        objString.append("   ");
        objString.append("networkCompressionEnabled = ");
        objString.append(this.isNetworkCompressionEnabled());
        objString.append(",\n");
        objString.append("   ");
        objString.append("targetHbrServerName = ");
        if (this.getTargetHbrServerName() == null) {
            objString.append("null");
        } else {
            objString.append(StringUtil.indent((String)this.getTargetHbrServerName(), (boolean)false));
        }
        objString.append(",\n");
        objString.append("   ");
        objString.append("lwdEncryptionEnabled = ");
        objString.append(this.getLwdEncryptionEnabled());
        objString.append(",\n");
        objString.append("   ");
        objString.append("RetentionPolicy( = ");
        objString.append(this.getRetentionPolicy());
        objString.append(",\n");
        objString.append("   ");
        objString.append("autoReplicateNewDisks = ");
        objString.append(this.getAutoReplicateNewDisks());
        objString.append("\n");
        return objString.toString();
    }
}

