/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2VapiUtils;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.vapi.std.errors.OperationNotFound;
import com.vmware.vcenter.identity.ProvidersTypes;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Context {
    public static final String OAUTH2 = "oauth2";
    public static final String OAUTH2_LOGIN_RESPONSE_PATH = "authentication/oauth2/oauth2login";
    public static final String OAUTH2_REMOTE_LOGIN_RESPONSE_PATH = "remotelogin/oauth2/oauth2remotelogin";
    public static final String OAUTH2_REMOTE_LOGIN_REFRESH_PATH = "remotelogin/oauth2/refresh";
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2Context.class);
    private final LsppServiceEndpoint _vapiEndpoint;
    private final URI _appOAuth2RedirectUrl;
    private final URI _appOAuth2RemoteLoginRedirectUrl;
    private final URI _authEndpoint;
    private final URI _tokenEndpoint;
    private final String _clientId;
    private final String _clientSecret;
    private final Map<String, List<String>> _authQueryParams;
    private final LsppService _serverRegistration;

    public static Promise<OAuth2Context> create() {
        Promise config = Promises.from(Config::get);
        Promise<LsppServiceEndpoint> vApiEndpoint = OAuth2VapiUtils.getVapiLsppEndpoint();
        Promise<LsppService> serverRegistration = OAuth2VapiUtils.getServerRegistration();
        Promise idps = vApiEndpoint.thenCompose(ep -> {
            if (ep == null) {
                LOGGER.warn("No vAPI endpoint found");
                return Promises.resolve(Collections.emptyList());
            }
            return OAuth2VapiUtils.listIdentityProviders(ep);
        });
        idps = idps.materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)((List)pr.getResult()));
            }
            Exception exc = pr.getError();
            if (exc instanceof OperationNotFound) {
                LOGGER.warn("vApi operation not found", (Throwable)exc);
                return Promises.resolve(Collections.emptyList());
            }
            return Promises.reject((Exception)exc);
        });
        return config.thenCombineCompose(idps, (cfg, providers) -> {
            if (providers.isEmpty()) {
                LOGGER.info("No OAuth2 IDPs found.");
                return Promises.resolve(null);
            }
            ProvidersTypes.Summary idp = (ProvidersTypes.Summary)providers.get(0);
            LOGGER.info("Using OAuth2 IDP: {}", (Object)idp);
            return vApiEndpoint.thenCombine(serverRegistration, (ep, serverReg) -> {
                ProvidersTypes.ConfigType type = idp.getConfigTag();
                if (ProvidersTypes.ConfigType.Oauth2.equals((Object)type)) {
                    ProvidersTypes.Oauth2Summary oauth2Summary = idp.getOauth2();
                    return new OAuth2Context((LsppServiceEndpoint)ep, OAuth2Context.buildAppOAuth2RedirectUrl(), OAuth2Context.buildAppOAuth2RemoteLoginRedirectUrl(), oauth2Summary.getAuthEndpoint(), oauth2Summary.getTokenEndpoint(), cfg.getOauth2ClientId(), cfg.getOauth2ClientSecret(), oauth2Summary.getAuthQueryParams(), (LsppService)serverReg);
                }
                if (ProvidersTypes.ConfigType.Oidc.equals((Object)type)) {
                    ProvidersTypes.OidcSummary oidcSummary = idp.getOidc();
                    return new OAuth2Context((LsppServiceEndpoint)ep, OAuth2Context.buildAppOAuth2RedirectUrl(), OAuth2Context.buildAppOAuth2RemoteLoginRedirectUrl(), oidcSummary.getAuthEndpoint(), oidcSummary.getTokenEndpoint(), cfg.getOauth2ClientId(), cfg.getOauth2ClientSecret(), oidcSummary.getAuthQueryParams(), (LsppService)serverReg);
                }
                throw new RuntimeException("Unsupported identity provider type: " + type);
            });
        });
    }

    private static URI buildAppOAuth2RedirectUrl() {
        URI relativePath = URI.create("/dr/authentication/oauth2/oauth2login");
        return Config.get().getAppUrl().resolve(relativePath);
    }

    private static URI buildAppOAuth2RemoteLoginRedirectUrl() {
        URI relativePath = URI.create("/dr/remotelogin/oauth2/oauth2remotelogin");
        return Config.get().getAppUrl().resolve(relativePath);
    }

    private OAuth2Context(LsppServiceEndpoint vapiEndpoint, URI appOAuth2RedirectUrl, URI appOAuth2RemoteLoginRedirectUrl, URI authEndpoint, URI tokenEndpoint, String clientId, String clientSecret, Map<String, List<String>> authQueryParams, LsppService serverRegistration) {
        this._vapiEndpoint = vapiEndpoint;
        this._appOAuth2RedirectUrl = appOAuth2RedirectUrl;
        this._appOAuth2RemoteLoginRedirectUrl = appOAuth2RemoteLoginRedirectUrl;
        this._authEndpoint = authEndpoint;
        this._tokenEndpoint = tokenEndpoint;
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this._authQueryParams = authQueryParams == null ? Collections.emptyMap() : authQueryParams;
        this._serverRegistration = serverRegistration;
    }

    public LsppServiceEndpoint getVapiEndpoint() {
        return this._vapiEndpoint;
    }

    public URI getAuthEndpoint() {
        return this._authEndpoint;
    }

    public URI getTokenEndpoint() {
        return this._tokenEndpoint;
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getClientSecret() {
        return this._clientSecret;
    }

    public Map<String, List<String>> getAuthQueryParams() {
        return this._authQueryParams;
    }

    public URI getAppOAuth2RedirectUrl() {
        return this._appOAuth2RedirectUrl;
    }

    public URI getAppOAuth2RemoteLoginRedirectUrl() {
        return this._appOAuth2RemoteLoginRedirectUrl;
    }

    public LsppService getServerRegistration() {
        return this._serverRegistration;
    }
}

