/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks.adapt;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.infrastructure.tasks.TasksFacade;
import com.vmware.srm.client.infrastructure.tasks.create.TaskHandle;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiTaskAdapter {
    private static final long POLL_INTERVAL = 1000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTaskAdapter.class);

    public final <T> TaskHandle<T> start(ManagedObjectReference taskRef) {
        Validate.notNull((Object)taskRef, (String)"Task is null.");
        AtomicReference handleRef = new AtomicReference();
        Consumer consumer = taskHandle -> {
            handleRef.set(taskHandle);
            this.collectUpdates(Collections.singleton(taskRef), (TaskHandle<?>)taskHandle).reduce(taskHandle, (handle, taskInfo) -> {
                handle.setKey(taskInfo.getKey());
                if (TaskInfo.State.error.equals((Object)taskInfo.getState())) {
                    handle.fail(taskInfo.getError());
                } else if (TaskInfo.State.success.equals((Object)taskInfo.getState())) {
                    handle.complete(taskInfo.getResult());
                } else {
                    handle.setProgress(taskInfo.getProgress());
                }
                return handle;
            }).onError(exc -> {
                LOGGER.warn("Task '{}' failed: ", (Object)taskRef, exc);
                taskHandle.fail((Exception)exc);
            });
        };
        TasksFacade.createManagedTask(consumer);
        return (TaskHandle)handleRef.get();
    }

    public final TaskHandle<Void> start(Set<ManagedObjectReference> taskRefs) {
        AtomicReference handleRef = new AtomicReference();
        Consumer consumer = taskHandle -> {
            handleRef.set(taskHandle);
            if (CollectionUtils.isEmpty((Collection)taskRefs)) {
                taskHandle.complete(null);
                return;
            }
            this.collectUpdates(taskRefs, (TaskHandle<?>)taskHandle).reduce(new HashSet(), (completed, taskInfo) -> {
                if (taskInfo.getError() != null) {
                    LOGGER.warn("Received failed task update:\n{}", taskInfo);
                    throw Exceptions.getRuntimeException((Throwable)taskInfo.getError());
                }
                if (TaskUtil.isComplete(taskInfo) && completed.add(taskInfo.getTask())) {
                    taskHandle.setProgress(MultiTaskAdapter.computeProgress(completed.size(), taskRefs.size()));
                }
                return completed;
            }).onError(exc -> {
                LOGGER.warn("Composite task '{}' failed", (Object)taskHandle.getRef(), exc);
                taskHandle.fail((Exception)exc);
            }).onSuccess(completed -> {
                if (completed.size() < taskRefs.size()) {
                    LOGGER.warn("Number of completed task is less than all tasks: '{}'", (Object)taskHandle.getRef());
                }
                taskHandle.complete(null);
            });
        };
        TasksFacade.createManagedTask(consumer);
        return (TaskHandle)handleRef.get();
    }

    protected abstract Promise<Collection<TaskInfo>> getUpdates(Set<ManagedObjectReference> var1);

    private Stream<TaskInfo> collectUpdates(Set<ManagedObjectReference> tasks, TaskHandle<?> handle) {
        if (tasks.isEmpty()) {
            return Streams.empty();
        }
        try {
            return this.getUpdates(tasks).toStream().flatMap(taskInfos -> {
                HashSet unfinished;
                Set finished;
                if (!MultiTaskAdapter.validate(taskInfos, tasks)) {
                    LOGGER.warn("Incomplete response set: Requested:\n{}\nReceived:\n{}", taskInfos, (Object)tasks);
                }
                if ((finished = taskInfos.stream().filter(TaskUtil::isComplete).map(TaskInfo::getTask).collect(Collectors.toSet())).isEmpty()) {
                    unfinished = tasks;
                } else {
                    unfinished = new HashSet(tasks);
                    if (!unfinished.removeAll(finished)) {
                        LOGGER.warn("Received updates for unrelated tasks:\n{}", finished);
                    }
                }
                if (handle.isCancelled()) {
                    return handle.thenApply(ignored -> null);
                }
                Stream next = Promises.createDelayedPromise((long)1000L, unfinished).toStream().flatMap(nextTasks -> this.collectUpdates((Set<ManagedObjectReference>)nextTasks, handle));
                return Streams.from((Collection)taskInfos).merge(new Publisher[]{next});
            });
        }
        catch (Exception exc) {
            LOGGER.error("Failed to get task updates for '{}': ", tasks, (Object)exc);
            return Promises.reject((Exception)exc).toStream();
        }
    }

    private static int computeProgress(int completedTask, int allTasks) {
        return (int)((double)completedTask / (double)allTasks * 100.0);
    }

    private static boolean validate(Collection<TaskInfo> infos, Set<ManagedObjectReference> tasks) {
        Set<ManagedObjectReference> infoTasks = infos.stream().collect(Collectors.toMap(TaskInfo::getTask, Function.identity())).keySet();
        return infoTasks.equals(tasks);
    }
}

