/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ClientFactory;
import com.vmware.vim.vmomi.client.version.VersionProvider;
import com.vmware.vim.vmomi.client.version.impl.FallbackVersionProvider;
import com.vmware.vim.vmomi.client.version.impl.ServiceXmlVersionProvider;
import com.vmware.vim.vmomi.client.version.impl.StaticVersionProvider;
import com.vmware.vim.vmomi.client.version.impl.VmodlNsVersionProvider;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;

public interface Client {
    public <T extends ManagedObject> T createStub(Class<T> var1, ManagedObjectReference var2);

    public <T extends ManagedObject> T createStub(Class<T> var1, String var2);

    public ProtocolBinding getBinding();

    public void shutdown();

    default public VmodlVersion getVersion() {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        public static final Set<String> NAMESPACES_WITH_XML = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("vim", "nfc", "vpx", "vpxapi", "vsan", "dp")));
        private URI endpoint;
        private ClientConfiguration config;
        private Class<?> fallbackVersion;
        private Class<?> staticVersion;
        private String namespace;
        private boolean internal;
        private VmodlContext context;

        public Builder setEndpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setConfiguration(ClientConfiguration config) {
            this.config = config;
            return this;
        }

        public Builder setFallbackVersion(Class<?> fallbackVersion) {
            this.fallbackVersion = fallbackVersion;
            return this;
        }

        public Builder setStaticVersion(Class<?> staticVersion) {
            this.staticVersion = staticVersion;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setInternal(boolean internal2) {
            this.internal = internal2;
            return this;
        }

        public Builder setContext(VmodlContext context) {
            this.context = context;
            return this;
        }

        public Client build() {
            HttpClientConfiguration conf;
            if (this.config == null) {
                conf = HttpClientConfiguration.Factory.newInstance();
            } else if (this.config instanceof HttpClientConfiguration) {
                conf = (HttpClientConfiguration)this.config;
            } else {
                throw new IllegalArgumentException("Unknow client configuration type: " + this.config.getClass());
            }
            return ClientFactory.createClient(this.endpoint, this.getVersionProvider(conf), (ClientConfiguration)conf, this.context == null ? VmodlContext.getContext() : this.context);
        }

        private VersionProvider getVersionProvider(ClientConfiguration conf) {
            if (this.namespace != null) {
                if (this.staticVersion != null) {
                    throw new IllegalStateException("'namespace' and 'staticVersion' cannot be set both");
                }
                if (conf.getVersionProvider() != null) {
                    throw new IllegalStateException("'namespace' cannot be set when the specified 'configuration' sets a VersionProvider");
                }
                VersionProvider vp = new VmodlNsVersionProvider.Builder(this.namespace).setClientConfiguration(conf).setInternal(this.internal).build();
                boolean fallbackToServiceVersionXml = NAMESPACES_WITH_XML.contains(this.namespace);
                if (fallbackToServiceVersionXml || this.fallbackVersion != null) {
                    FallbackVersionProvider.Builder fallbackVp = new FallbackVersionProvider.Builder();
                    fallbackVp.addProvider(vp);
                    if (fallbackToServiceVersionXml) {
                        URI xmlUri = this.endpoint.resolve(String.format("/sdk/%sServiceVersions.xml", this.namespace));
                        fallbackVp.addProvider(new ServiceXmlVersionProvider.Builder(xmlUri).setInternal(this.internal).build());
                    }
                    if (this.fallbackVersion != null) {
                        fallbackVp.addProvider(new StaticVersionProvider(this.fallbackVersion, this.context));
                    }
                    vp = fallbackVp.build();
                }
                return vp;
            }
            if (this.staticVersion != null) {
                if (conf.getVersionProvider() != null) {
                    throw new IllegalStateException("'staticVersion' cannot be set when the specified 'configuration' sets a VersionProvider");
                }
                return new StaticVersionProvider(this.staticVersion, this.context);
            }
            return conf.getVersionProvider();
        }
    }

    public static class Factory {
        @Deprecated
        public static Client createClient(URI endpoint, Class<?> version, Executor threadPool) {
            return Factory.createClient(endpoint, version, threadPool, null);
        }

        @Deprecated
        public static Client createClient(URI endpoint, Class<?> version, Executor threadPool, HttpConfiguration config) {
            return Factory.createClient(endpoint, version, threadPool, config, null);
        }

        @Deprecated
        public static Client createClient(URI endpoint, Class<?> version, Executor threadPool, HttpConfiguration config, ResultInterceptor resultInterceptor) {
            HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
            clientConfig.setExecutor(threadPool);
            if (config != null) {
                clientConfig.setHttpConfiguration(config);
            }
            clientConfig.setResultInterceptor(resultInterceptor);
            return Factory.createClient(endpoint, version, clientConfig);
        }

        public static Client createClient(URI endpoint, Class<?> version, ClientConfiguration config) {
            return Factory.createClient(endpoint, version, null, config);
        }

        public static Client createClient(URI endpoint, Class<?> version, VmodlContext context, ClientConfiguration config) {
            return new Builder().setEndpoint(endpoint).setConfiguration(config).setContext(context).setStaticVersion(version).build();
        }

        public static Client createClient(URI endpoint, Class<?> version) {
            return Factory.createClient(endpoint, version, HttpClientConfiguration.Factory.newInstance());
        }
    }
}

