/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingFilterOutputStream
extends FilterOutputStream {
    private static AtomicInteger _suffix = new AtomicInteger();
    private static Log _logger = LogFactory.getLog(LoggingFilterOutputStream.class);
    private BufferedOutputStream _outputStream = null;

    public LoggingFilterOutputStream(OutputStream stream, String path) throws IOException {
        super(stream);
        path = String.format("%1$s-%2$04d.log", path, _suffix.getAndIncrement());
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Logging request to '%1$s'", path));
        }
        this._outputStream = new BufferedOutputStream(new FileOutputStream(path, true));
    }

    public void closeLog() throws IOException {
        this._outputStream.close();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closeLog();
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this._outputStream.write(b);
    }
}

