/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.token.impl;

import com.vmware.identity.token.impl.ValidateUtil;
import com.vmware.identity.token.impl.exception.ParserException;
import com.vmware.vim.sso.PrincipalId;
import java.util.regex.Pattern;

public final class PrincipalIdParser {
    public static PrincipalId parseUpn(String upn) throws ParserException {
        ValidateUtil.validateNotEmpty(upn, "upn");
        String[] parts = PrincipalIdParser.splitInTwo(upn, '@');
        return new PrincipalId(parts[0], parts[1]);
    }

    public static PrincipalId parseGroupId(String groupId) throws ParserException {
        PrincipalId group;
        ValidateUtil.validateNotEmpty(groupId, "groupId");
        if (groupId.contains("\\")) {
            String[] parts = PrincipalIdParser.splitInTwo(groupId, '\\');
            group = new PrincipalId(parts[1], parts[0]);
        } else {
            String[] parts = PrincipalIdParser.splitInTwo(groupId, '/');
            group = new PrincipalId(parts[0], parts[1]);
        }
        return group;
    }

    private static String[] splitInTwo(String value, char separator) throws ParserException {
        Pattern splitter = Pattern.compile(Pattern.quote(String.valueOf(separator)));
        String[] split = splitter.split(value, 3);
        if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
            throw new ParserException(String.format("Invalid principal value: `%s' (incorrect number of fields)", value));
        }
        return split;
    }
}

