/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.BundleMessageSource;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SamlTokenFactory;
import com.vmware.vim.sso.client.SecurIDHandler;
import com.vmware.vim.sso.client.SecurIDNegotiator;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SecurityTokenServiceEx;
import com.vmware.vim.sso.client.SsoAsyncHandler;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.UserCertificateHandler;
import com.vmware.vim.sso.client.exception.AccountLockedException;
import com.vmware.vim.sso.client.exception.AuthenticationFailedException;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.InvalidTokenRequestException;
import com.vmware.vim.sso.client.exception.MalformedResponseException;
import com.vmware.vim.sso.client.exception.MalformedTokenException;
import com.vmware.vim.sso.client.exception.PasswordExpiredException;
import com.vmware.vim.sso.client.exception.RequestExpiredException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.ServerSecurityException;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.sso.client.impl.GssNegotiationClientImpl;
import com.vmware.vim.sso.client.impl.RequestBuilder;
import com.vmware.vim.sso.client.impl.RequestBuilderFactory;
import com.vmware.vim.sso.client.impl.ResponseHandler;
import com.vmware.vim.sso.client.impl.ResponseHandlerFactory;
import com.vmware.vim.sso.client.impl.SecurIDNegotiatorImpl;
import com.vmware.vim.sso.client.impl.SoapBinding;
import com.vmware.vim.sso.client.impl.SoapFault;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.impl.WsSecuritySignature;
import com.vmware.vim.sso.client.impl.WsSecuritySignatureFactory;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.exception.SignatureException;
import com.vmware.vim.sso.client.impl.exception.SoapFaultException;
import com.vmware.vim.sso.client.tracer.GlobalTracer;
import com.vmware.vim.sso.client.tracer.TracingFeature;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityTokenServiceImpl
implements SecurityTokenServiceEx {
    private static final String AUTHENTICATION_FAULT = "FailedAuthentication";
    private static final String INVALID_TIME_RANGE_FAULT = "InvalidTimeRange";
    private static final String RENEW_NEEDED_FAULT = "RenewNeeded";
    private static final String UNABLE_TO_RENEW_FAULT = "UnableToRenew";
    private static final String MESSAGE_EXPIRED_FAULT = "MessageExpired";
    private static final String SIGNATURE_VALIDATION_FAULT = "FailedCheck";
    private static final String GENERAL_WSSE_FAULT = "InvalidSecurity";
    private static final String INVALID_REQUEST = "InvalidRequest";
    private static final String EXPIRED_DATA_FAULT = "ExpiredData";
    private static final String NULL_PARAMETER_ERR_MSG = "Input parameters cannot be null";
    private static final String NULL_LEG_ERR_MSG = "Unexpected \"null\" leg before negotiation completion";
    private static final String HOK_ERR_MSG = "Holder-of-key configuration is needed for this kind of request";
    private static final String BEARER_ERR_MSG = "Bearer tokens cannot be used for token exchange";
    private static final String DELEGATION_NOT_SUPPORTED_ERR_MSG = "Delegation is not supported for external tokens.";
    private static final String HOK_NOT_SUPPORTED_ERR_MSG = "Cannot acquire Holder-of-key token by Bearer token.";
    private final SoapBinding _binding;
    private final SecurityTokenServiceConfig _config;
    private final RequestBuilderFactory _requestBuilderFactory;
    private final ResponseHandlerFactory _responseHandlerFactory;
    private final SamlTokenFactory _tokenFactory = new DefaultTokenFactory();
    private final Logger _log = LoggerFactory.getLogger(SecurityTokenServiceImpl.class);
    private static final String THREAD_TAG_KEY = "Thread";

    public SecurityTokenServiceImpl(SoapBinding transport, SecurityTokenServiceConfig config, RequestBuilderFactory requestBuilderFactory, ResponseHandlerFactory responseHandlerFactory) {
        this.checkForNull(transport, config, requestBuilderFactory, responseHandlerFactory);
        this._binding = transport;
        this._config = config;
        this._requestBuilderFactory = requestBuilderFactory;
        this._responseHandlerFactory = responseHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireToken(String subject, String password, TokenSpec tokenProperties) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
        this.checkForNull(subject, password, tokenProperties);
        try (OperationFrame opFrame = new OperationFrame();){
            this._log.debug("Acquiring token for user: " + subject + " started.");
            Element tokenElement = new RequestResponseProcessor<Element>(this._requestBuilderFactory.getAcquireTokenByUserPassBuilder(subject, password, tokenProperties), this._responseHandlerFactory.getAcquireTokenByUserPassResponseHandler(), this.getWsSecuritySignature(tokenProperties), this._binding).executeRoundtrip();
            SamlToken token = this._config.getTrustedRootCertificates() != null ? this._tokenFactory.parseToken(tokenElement, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds()) : this._tokenFactory.parseToken(tokenElement);
            this._log.info("Successfully acquired token for user: " + subject);
            SamlToken samlToken = token;
            return samlToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenByGSS(TokenSpec tokenSpec, SecurityTokenService.NegotiationHandler handler) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
        try (OperationFrame opFrame = new OperationFrame();){
            byte[] leg;
            this.checkForNull(tokenSpec, handler);
            GssNegotiationClient context = this.obtainGssNegotiationClient(tokenSpec);
            GssNegotiationClient.GssNegotiationResult gssResult = null;
            do {
                if ((leg = handler.negotiate(gssResult == null ? null : gssResult.getLeg())) != null) continue;
                this._log.error("Incorrect SecurityTokenService.NegotiationHandler implementation " + handler.getClass().getSimpleName() + ": " + NULL_LEG_ERR_MSG);
                throw new IllegalArgumentException(NULL_LEG_ERR_MSG);
            } while ((gssResult = context.negotiateToken(leg)).getToken() == null);
            leg = gssResult.getLeg();
            if (leg != null && handler.negotiate(leg) != null) {
                this._log.warn("Possible incorrect behavior at client implementation " + handler.getClass().getSimpleName() + ": another leg returned after SAML token has been received");
            }
            SamlToken token = gssResult.getToken();
            this._log.info("Successfully acquired token for user: " + token.getSubject());
            SamlToken samlToken = token;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenByGSSAsync(final TokenSpec tokenSpec, final SecurityTokenService.NegotiationHandler handler, SsoAsyncHandler<SamlToken> asyncHandler) {
        this.checkForNull(tokenSpec, handler, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireTokenByGSS(tokenSpec, handler);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenByGSSAsync(TokenSpec tokenSpec, SecurityTokenService.NegotiationHandler handler) {
        return this.acquireTokenByGSSAsync(tokenSpec, handler, new NullSsoAsyncHanlder<SamlToken>());
    }

    @Override
    public GssNegotiationClient obtainGssNegotiationClient(TokenSpec tokenSpec) {
        this.checkForNull(tokenSpec);
        return new GssNegotiationClientImpl(this._binding, this._config, this._requestBuilderFactory, this._responseHandlerFactory, tokenSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateToken(SamlToken token) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, CertificateValidationException, TimeSynchronizationException {
        this.checkForNull(token);
        try (OperationFrame opFrame = new OperationFrame();){
            this._log.debug("Validating token for subject" + Util.getTokenSubjectForLog(token) + "started.");
            boolean isTokenConfirmedValid = new RequestResponseProcessor<Boolean>(this._requestBuilderFactory.getValidateTokenBuilder(token), this._responseHandlerFactory.getValidateTokenResponseHandler(), WsSecuritySignatureFactory.createNullWsSecuritySignature(), this._binding).executeRoundtrip();
            this._log.debug("Is token valid confimation result: " + isTokenConfirmedValid);
            boolean bl = isTokenConfirmedValid;
            return bl;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenAsync(final String subject, final String password, final TokenSpec tokenSpec, SsoAsyncHandler<SamlToken> asyncHandler) {
        this.checkForNull(subject, password, tokenSpec, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireToken(subject, password, tokenSpec);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenAsync(String subject, String password, TokenSpec tokenSpec) {
        this.checkForNull(subject, password, tokenSpec);
        return this.acquireTokenAsync(subject, password, tokenSpec, new NullSsoAsyncHanlder<SamlToken>());
    }

    @Override
    public Future<Boolean> validateTokenAsync(final SamlToken token, SsoAsyncHandler<Boolean> asyncHandler) {
        this.checkForNull(token, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<Boolean>(asyncHandler){

            @Override
            protected Boolean executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.validateToken(token);
            }
        });
    }

    @Override
    public Future<Boolean> validateTokenAsync(SamlToken token) {
        this.checkForNull(token);
        return this.validateTokenAsync(token, new NullSsoAsyncHanlder<Boolean>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenByToken(SamlToken token, TokenSpec tokenSpec) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
        this.checkForNull(token, tokenSpec);
        if (token.getConfirmationType() == ConfirmationType.BEARER) {
            this._log.error(BEARER_ERR_MSG);
            throw new IllegalArgumentException(BEARER_ERR_MSG);
        }
        this.checkHoKConfig();
        try (OperationFrame opFrame = new OperationFrame();){
            this._log.debug("Acquiring token for user: " + Util.getTokenSubjectForLog(token) + " started.");
            WsSecuritySignature wsSecuritySignature = WsSecuritySignatureFactory.createWsSecuritySignatureAssertion(this._config.getHolderOfKeyConfig(), token.getId());
            Element tokenElement = new RequestResponseProcessor<Element>(this._requestBuilderFactory.getAcquireTokenByTokenBuilder(token, tokenSpec), this._responseHandlerFactory.getAcquireTokenByTokenResponseHandler(), wsSecuritySignature, this._binding).executeRoundtrip();
            SamlToken newToken = this._config.getTrustedRootCertificates() != null ? this._tokenFactory.parseToken(tokenElement, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds()) : this._tokenFactory.parseToken(tokenElement);
            this._log.info("Successfully acquired token for user: " + newToken.getSubject());
            SamlToken samlToken = newToken;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenByTokenAsync(final SamlToken token, final TokenSpec tokenSpec, SsoAsyncHandler<SamlToken> asyncHandler) {
        this.checkForNull(token, tokenSpec, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireTokenByToken(token, tokenSpec);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenByTokenAsync(SamlToken token, TokenSpec tokenSpec) {
        this.checkForNull(token, tokenSpec);
        return this.acquireTokenByTokenAsync(token, tokenSpec, new NullSsoAsyncHanlder<SamlToken>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenByExternalToken(SamlToken token, TokenSpec tokenSpec) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
        this.checkForNull(token, tokenSpec);
        if (token.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY) {
            this.checkHoKConfig();
        } else if (tokenSpec.getConfirmation() != TokenSpec.Confirmation.NONE && this._config.getHolderOfKeyConfig() != null) {
            throw new IllegalArgumentException(HOK_NOT_SUPPORTED_ERR_MSG);
        }
        try (OperationFrame opFrame = new OperationFrame();){
            this._log.debug("Acquiring token for user: " + Util.getTokenSubjectForLog(token) + " started.");
            WsSecuritySignature wsSecuritySignature = null;
            wsSecuritySignature = token.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY ? WsSecuritySignatureFactory.createWsSecuritySignatureAssertion(this._config.getHolderOfKeyConfig(), token.getId()) : this.getWsSecuritySignature(tokenSpec);
            Element tokenElement = new RequestResponseProcessor<Element>(this._requestBuilderFactory.getAcquireTokenByTokenBuilder(token, tokenSpec), this._responseHandlerFactory.getAcquireTokenByTokenResponseHandler(), wsSecuritySignature, this._binding).executeRoundtrip();
            SamlToken newToken = this._config.getTrustedRootCertificates() != null ? this._tokenFactory.parseToken(tokenElement, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds()) : this._tokenFactory.parseToken(tokenElement);
            this._log.info("Successfully acquired token for user: " + Util.getTokenSubjectForLog(newToken));
            SamlToken samlToken = newToken;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenByExternalTokenAsync(final SamlToken token, final TokenSpec tokenSpec, SsoAsyncHandler<SamlToken> asyncHandler) {
        this.checkForNull(token, tokenSpec, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireTokenByExternalToken(token, tokenSpec);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenByExternalTokenAsync(SamlToken token, TokenSpec tokenSpec) {
        this.checkForNull(token, tokenSpec);
        return this.acquireTokenByExternalTokenAsync(token, tokenSpec, new NullSsoAsyncHanlder<SamlToken>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenByCertificate(TokenSpec tokenSpec) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
        this.checkForNull(tokenSpec);
        this.checkHoKConfig();
        try (OperationFrame opFrame = new OperationFrame();){
            this._log.debug("Acquiring solution token started.");
            Element tokenElement = new RequestResponseProcessor<Element>(this._requestBuilderFactory.getAcquireTokenByCertificateBuilder(tokenSpec), this._responseHandlerFactory.getAcquireTokenByCertificateResponseHandler(), this.getWsSecuritySignature(tokenSpec), this._binding).executeRoundtrip();
            SamlToken newToken = this._config.getTrustedRootCertificates() != null ? this._tokenFactory.parseToken(tokenElement, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds()) : this._tokenFactory.parseToken(tokenElement);
            this._log.info("Successfully acquired token for user: " + Util.getTokenSubjectForLog(newToken));
            SamlToken samlToken = newToken;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenByCertificateAsync(final TokenSpec tokenSpec, SsoAsyncHandler<SamlToken> asyncHandler) {
        this.checkForNull(tokenSpec, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireTokenByCertificate(tokenSpec);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenByCertificateAsync(TokenSpec tokenSpec) {
        this.checkForNull(tokenSpec);
        return this.acquireTokenByCertificateAsync(tokenSpec, new NullSsoAsyncHanlder<SamlToken>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenByUserCert(X509Certificate x509Certificate, UserCertificateHandler userCertificateHandler, TokenSpec tokenSpec) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        this.checkForNull(x509Certificate, userCertificateHandler, tokenSpec);
        try (OperationFrame opFrame = new OperationFrame();){
            String subjectDN = x509Certificate.getSubjectDN().getName();
            this._log.debug(String.format("Acquiring token by user certificate for subject DN %s started.", subjectDN));
            Element tokenElement = new RequestResponseProcessor<Element>(this._requestBuilderFactory.getAcquireTokenByUserCertBuilder(x509Certificate, userCertificateHandler, tokenSpec), this._responseHandlerFactory.getAcquireTokenByUserCertResponseHandler(), this.getWsSecuritySignature(tokenSpec), this._binding).executeRoundtrip();
            SamlToken newToken = this._config.getTrustedRootCertificates() != null ? this._tokenFactory.parseToken(tokenElement, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds()) : this._tokenFactory.parseToken(tokenElement);
            this._log.info(String.format("Successfully acquired token by user certificate for subject DN %s.", subjectDN));
            SamlToken samlToken = newToken;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenByUserCertAsync(final X509Certificate x509Certificate, final UserCertificateHandler userCertificateHandler, final TokenSpec tokenSpec, SsoAsyncHandler<SamlToken> asyncHandler) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        this.checkForNull(x509Certificate, tokenSpec, userCertificateHandler, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireTokenByUserCert(x509Certificate, userCertificateHandler, tokenSpec);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenByUserCertAsync(X509Certificate x509Certificate, UserCertificateHandler userCertificateHandler, TokenSpec tokenSpec) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireTokenByUserCertAsync(x509Certificate, userCertificateHandler, tokenSpec, new NullSsoAsyncHanlder<SamlToken>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenBySecurID(String userName, SecurIDHandler securIDHandler, TokenSpec tokenSpec) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        try (OperationFrame opFrame = new OperationFrame();){
            String sessionID;
            this._log.info(String.format("Acquiring token by SecurID for user %s started.", userName));
            this.checkForNull(tokenSpec, securIDHandler);
            SecurIDNegotiatorImpl securIDNegotiationClient = new SecurIDNegotiatorImpl(this._binding, this._config, this._requestBuilderFactory, this._responseHandlerFactory, tokenSpec);
            SecurIDNegotiator.SecurIDNegotiationResult securIDResult = null;
            while ((securIDResult = securIDNegotiationClient.negotiateToken(userName, sessionID = securIDResult == null ? null : securIDResult.getSessionID(), securIDHandler)).getToken() == null) {
            }
            SamlToken token = securIDResult.getToken();
            this._log.info(String.format("Successfully acquired token by SecurID for user: %s", token.getSubject()));
            SamlToken samlToken = token;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> acquireTokenBySecurIDAsync(final String userName, final SecurIDHandler securIDHandler, final TokenSpec tokenSpec, SsoAsyncHandler<SamlToken> asyncHandler) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        this.checkForNull(userName, securIDHandler, tokenSpec, asyncHandler);
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws SsoException {
                return SecurityTokenServiceImpl.this.acquireTokenBySecurID(userName, securIDHandler, tokenSpec);
            }
        });
    }

    @Override
    public Future<SamlToken> acquireTokenBySecurIDAsync(String userName, SecurIDHandler securIDHandler, TokenSpec tokenSpec) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireTokenBySecurIDAsync(userName, securIDHandler, tokenSpec, new NullSsoAsyncHanlder<SamlToken>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken renewToken(SamlToken token, long tokenLifetimeSec) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
        ValidateUtil.validateNotNull(token, "SAML token");
        ValidateUtil.validatePositiveNumber(tokenLifetimeSec, "token lifetime");
        ValidateUtil.validateNotNull(this._config.getHolderOfKeyConfig(), "holder of key config");
        try (OperationFrame opFrame = new OperationFrame();){
            if (this._log.isDebugEnabled()) {
                this._log.debug("Renewing token for user: " + Util.getTokenSubjectForLog(token) + " started.");
            }
            WsSecuritySignature wsSecuritySignature = WsSecuritySignatureFactory.createWsSecuritySignatureCertificate(this._config.getHolderOfKeyConfig());
            Element tokenElement = new RequestResponseProcessor<Element>(this._requestBuilderFactory.getRenewTokenBuilder(token, tokenLifetimeSec), this._responseHandlerFactory.getRenewTokenResponseHandler(), wsSecuritySignature, this._binding).executeRoundtrip();
            SamlToken renewedToken = this._config.getTrustedRootCertificates() != null ? this._tokenFactory.parseToken(tokenElement, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds()) : this._tokenFactory.parseToken(tokenElement);
            this._log.info("Successfully renewed token for user: " + Util.getTokenSubjectForLog(renewedToken));
            SamlToken samlToken = renewedToken;
            return samlToken;
        }
    }

    @Override
    public Future<SamlToken> renewTokenAsync(final SamlToken token, final long tokenLifetimeSec, SsoAsyncHandler<SamlToken> asyncHandler) {
        ValidateUtil.validateNotNull(token, "SAML token");
        ValidateUtil.validatePositiveNumber(tokenLifetimeSec, "token lifetime");
        ValidateUtil.validateNotNull(asyncHandler, "handler");
        return this._config.getExecutorService().submit(new AsyncCommand<SamlToken>(asyncHandler){

            @Override
            protected SamlToken executeAction() throws InternalError, ServerCommunicationException, CertificateValidationException, InvalidTokenException, TokenRequestRejectedException, TimeSynchronizationException {
                return SecurityTokenServiceImpl.this.renewToken(token, tokenLifetimeSec);
            }
        });
    }

    @Override
    public Future<SamlToken> renewTokenAsync(SamlToken token, long tokenLifetimeSec) {
        ValidateUtil.validateNotNull(token, "SAML token");
        ValidateUtil.validatePositiveNumber(tokenLifetimeSec, "token lifetime");
        return this.renewTokenAsync(token, tokenLifetimeSec, new NullSsoAsyncHanlder<SamlToken>());
    }

    private void checkForNull(Object ... inputParams) {
        for (Object param : inputParams) {
            if (param != null) continue;
            this._log.error(NULL_PARAMETER_ERR_MSG);
            throw new IllegalArgumentException(NULL_PARAMETER_ERR_MSG);
        }
    }

    private void checkHoKConfig() {
        if (this._config.getHolderOfKeyConfig() == null) {
            this._log.error(HOK_ERR_MSG);
            throw new IllegalArgumentException(HOK_ERR_MSG);
        }
    }

    private WsSecuritySignature getWsSecuritySignature(TokenSpec spec) {
        SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig = this._config.getHolderOfKeyConfig();
        return holderOfKeyConfig == null || spec.getConfirmation() == TokenSpec.Confirmation.NONE ? WsSecuritySignatureFactory.createNullWsSecuritySignature() : WsSecuritySignatureFactory.createWsSecuritySignatureCertificate(holderOfKeyConfig);
    }

    private class OperationFrame {
        private String _opId;

        public OperationFrame() {
            if (SecurityTokenServiceImpl.this._log.isDebugEnabled()) {
                this._opId = UUID.randomUUID().toString();
                SecurityTokenServiceImpl.this._log.debug(String.format("opId=%s START operation", this._opId));
            }
        }

        public void close() {
            if (SecurityTokenServiceImpl.this._log.isDebugEnabled()) {
                SecurityTokenServiceImpl.this._log.debug(String.format("opId=%s END operation", this._opId));
            }
        }
    }

    static abstract class AsyncCommand<T>
    implements Callable<T> {
        private final SsoAsyncHandler<T> _handler;
        private final Span _span;

        protected AsyncCommand(SsoAsyncHandler<T> handler) {
            this._handler = handler;
            this._span = TracingFeature.ON ? GlobalTracer.get().activeSpan() : null;
        }

        @Override
        public T call() throws Exception {
            T result = null;
            Scope scope = null;
            if (TracingFeature.ON && this._span != null) {
                scope = GlobalTracer.get().activateSpan(this._span);
            }
            try {
                result = this.executeAction();
            }
            catch (Exception e) {
                this._handler.handleException(e);
                throw e;
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
            }
            this._handler.handleResponse(result);
            return result;
        }

        protected abstract T executeAction() throws SsoException;
    }

    static final class NullSsoAsyncHanlder<T>
    implements SsoAsyncHandler<T> {
        NullSsoAsyncHanlder() {
        }

        @Override
        public void handleResponse(T response) {
        }

        @Override
        public void handleException(Exception exception) {
        }
    }

    static final class RequestResponseProcessor<T> {
        private final WsSecuritySignature _wsSecSignature;
        private final RequestBuilder _requestBuilder;
        private final ResponseHandler<T> _responseHandler;
        private final SoapBinding _binding;
        private final Logger _log = LoggerFactory.getLogger(RequestResponseProcessor.class);
        private static final String requestBuilderSuffix = "RequestBuilder";
        private static final int requestBuilderSuffixLen = "RequestBuilder".length();

        public RequestResponseProcessor(RequestBuilder requestBuilder, ResponseHandler<T> responseHandler, WsSecuritySignature wsSecSignature, SoapBinding binding) {
            assert (requestBuilder != null);
            assert (responseHandler != null);
            assert (wsSecSignature != null);
            assert (binding != null);
            this._wsSecSignature = wsSecSignature;
            this._requestBuilder = requestBuilder;
            this._responseHandler = responseHandler;
            this._binding = binding;
        }

        public T executeRoundtrip() throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException {
            SoapMessage request;
            long roundtripStart = System.currentTimeMillis();
            if (this._log.isTraceEnabled()) {
                this._log.trace(String.format("Executing roundtrip with %s, %s, %s", this._requestBuilder.getClass().getSimpleName(), this._responseHandler.getClass().getSimpleName(), this._wsSecSignature.getClass().getSimpleName()));
            }
            try {
                request = this._requestBuilder.createRequest();
                this._wsSecSignature.sign(request);
            }
            catch (ParserException e) {
                String message = "Error occured during serialization of the token request";
                this._log.info(message, (Throwable)((Object)e));
                throw new InternalError(message, BundleMessageSource.Key.INTERNAL_CLIENT_ERROR, (Throwable)((Object)e), BundleMessageSource.Key.PARSER_ERROR);
            }
            catch (SignatureException e) {
                String message = "Cannot sign request message";
                this._log.info(message, (Throwable)((Object)e));
                throw new InternalError(message, BundleMessageSource.Key.INTERNAL_CLIENT_ERROR, (Throwable)((Object)e), BundleMessageSource.Key.FAILED_TO_SIGN_REQUEST);
            }
            try {
                return this._responseHandler.parseResponse(this.sendRequest(request));
            }
            catch (RequestExpiredException e) {
                this.checkTimeSyncronization(roundtripStart);
                throw e;
            }
            catch (ParserException e) {
                String message = "Error occured during deserialization of response to the token request";
                this._log.info(message, (Throwable)((Object)e));
                throw new MalformedResponseException(message, BundleMessageSource.Key.UNEXPECTED_RESPONSE_FORMAT, (Throwable)((Object)e));
            }
            catch (InvalidTokenException e) {
                throw new MalformedTokenException(e.getMessage(), BundleMessageSource.Key.MALFORMED_SAML_TOKEN, (Throwable)e, new Object[0]);
            }
        }

        private void checkTimeSyncronization(long roundtripStart) throws TimeSynchronizationException {
            long roundtripEnd = System.currentTimeMillis();
            long roundtripEstimateSeconds = TimeUnit.MILLISECONDS.toSeconds(roundtripEnd - roundtripStart);
            if (roundtripEstimateSeconds < (long)this._requestBuilder.getRequestValidityInSeconds()) {
                String message = "Server returned 'request expired' less than " + roundtripEstimateSeconds + " seconds after request was issued, but it shouldn't have expired for at least " + this._requestBuilder.getRequestValidityInSeconds() + " seconds.";
                this._log.info(message);
                throw new TimeSynchronizationException(message, roundtripEstimateSeconds, this._requestBuilder.getRequestValidityInSeconds());
            }
        }

        private Node sendRequest(SoapMessage message) throws ParserException, TokenRequestRejectedException, ServerCommunicationException, InternalError, RequestExpiredException, ServerSecurityException, CertificateValidationException {
            SoapMessage response = null;
            try {
                long currentTime = System.currentTimeMillis();
                if (TracingFeature.ON) {
                    Tracer tracer = GlobalTracer.get();
                    Span span = tracer.buildSpan(this.getSpanName()).withTag(Tags.COMPONENT.getKey(), "wstClient").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(SecurityTokenServiceImpl.THREAD_TAG_KEY, Thread.currentThread().getName()).start();
                    tracer.activateSpan(span);
                }
                response = this._binding.sendMessage(message);
                this._log.debug("Message received in: " + (System.currentTimeMillis() - currentTime) + " milliseconds.");
            }
            catch (SoapFaultException e) {
                this.handleFaultCondition(e.getFault());
            }
            catch (CertificateValidationException e) {
                throw new CertificateValidationException(e.getMessage(), BundleMessageSource.Key.BAD_SERVER_SSL_CERTIFICATE, e.getCertificateChain(), e.getThumbprint());
            }
            catch (ServerCommunicationException e) {
                throw new ServerCommunicationException(e.getMessage(), BundleMessageSource.Key.FAILED_TO_CONNECT_TO_SERVER, (Throwable)((Object)e), new Object[0]);
            }
            this._log.debug("Message successfully transported to the STS server");
            return response.getBody();
        }

        private String getSpanName() {
            String spanName = this._requestBuilder.getClass().getSimpleName();
            if (spanName.endsWith(requestBuilderSuffix)) {
                spanName = spanName.substring(0, spanName.length() - requestBuilderSuffixLen);
            }
            return spanName;
        }

        private void handleFaultCondition(SoapFault fault) throws ParserException, TokenRequestRejectedException, InternalError, RequestExpiredException, ServerSecurityException {
            this._log.debug("Processing fault: " + fault.getFaultMessage());
            assert (fault.getFaultCode() != null);
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.AUTHENTICATION_FAULT)) {
                if (fault.getFaultMessage() != null && fault.getFaultMessage().contains("locked")) {
                    this._log.info(fault.getFaultMessage());
                    throw new AccountLockedException(fault.getFaultMessage());
                }
                if (fault.getFaultMessage() != null && fault.getFaultMessage().contains("expired")) {
                    this._log.info(fault.getFaultMessage());
                    throw new PasswordExpiredException(fault.getFaultMessage());
                }
                String logMessage = "Provided credentials are not valid.";
                this._log.info(logMessage);
                throw new AuthenticationFailedException(logMessage, BundleMessageSource.Key.INVALID_CREDENTIALS, new Object[0]);
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.INVALID_TIME_RANGE_FAULT)) {
                String logMessage = "Server rejected the provided time range. Cause:" + fault.getFaultMessage();
                this._log.error(logMessage);
                throw new TimeSynchronizationException(logMessage, BundleMessageSource.Key.REQUEST_AFFECTED_BY_TIME_SKEW);
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.EXPIRED_DATA_FAULT)) {
                String logMessage = "Server rejected the request because the WS-Trust data was invalidated by time skew. Cause:" + fault.getFaultMessage();
                this._log.info(logMessage);
                throw new TimeSynchronizationException(logMessage, BundleMessageSource.Key.REQUEST_AFFECTED_BY_TIME_SKEW);
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.RENEW_NEEDED_FAULT)) {
                String logMessage = "Token had expired. Renew is needed.";
                this._log.info(logMessage);
                throw new AuthenticationFailedException(logMessage, BundleMessageSource.Key.RENEW_NEEDED, new Object[0]);
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.UNABLE_TO_RENEW_FAULT)) {
                String logMessage = "Unable to renew the security token: " + fault.getFaultMessage();
                this._log.info(logMessage);
                throw new InvalidTokenRequestException(logMessage, fault.getFaultMessage());
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.GENERAL_WSSE_FAULT)) {
                String message = "Server found errors in the WS-Security envelope: " + fault.getFaultMessage();
                this._log.info(message);
                throw new ServerSecurityException(message, fault.getFaultMessage());
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.MESSAGE_EXPIRED_FAULT)) {
                String message = "Request message has expired. Server message: " + fault.getFaultMessage();
                this._log.info(message);
                throw new RequestExpiredException(message);
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.SIGNATURE_VALIDATION_FAULT)) {
                String message = "Request signature is not valid. Check if the confirmation certificate matches the given private key.";
                this._log.info(message);
                throw new AuthenticationFailedException(message, BundleMessageSource.Key.SIGNATURE_VALIDATION_FAULT, new Object[0]);
            }
            if (fault.getFaultCode().contains(SecurityTokenServiceImpl.INVALID_REQUEST)) {
                String message = "Request is invalid: " + fault.getFaultMessage();
                this._log.info(message);
                throw new InvalidTokenRequestException(message, fault.getFaultMessage());
            }
            String message = "Failed trying to retrieve token: " + fault.getFaultMessage();
            this._log.info(message);
            throw new InternalError(message, BundleMessageSource.Key.UNEXPECTED_SERVER_ERROR, null, fault.getFaultMessage());
        }
    }
}

