@echo off
title Veeam AutoPatch Script by DiGiBoY Ver(1.1)

:: ===============================
:: Check Admin
:: ===============================
NET SESSION >nul 2>&1
IF %ERRORLEVEL% NEQ 0 (
    echo Requesting administrator privileges...
    powershell -Command "Start-Process '%~nx0' -Verb RunAs"
    exit /b
)
 
:: ===============================
:: Check Veeam Installation
:: ===============================
if exist "%ProgramW6432%\Common Files\Veeam\" set FOUND=1
if exist "%ProgramW6432%\Common Files\Veeam\Backup and Replication\" set FOUND=1
if exist "%ProgramW6432%\Veeam\Backup and Replication\" set FOUND=1

if %FOUND%==0 (
    echo Veeam Backup & Replication not found!
    pause
    exit /b
)

:: ===============================
:: Add Veeam entries to hosts file
:: ===============================

set HOSTS_FILE=%SystemRoot%\System32\drivers\etc\hosts

echo.>> "%HOSTS_FILE%"
echo # Veeam Block Entries>> "%HOSTS_FILE%"
echo 127.0.0.1 vee.am veeam.com www.veeam.com my.veeam.com helpcenter.veeam.com>> "%HOSTS_FILE%"
echo 127.0.0.1 forums.veeam.com cloud.veeam.com redirect.veeam.com rest-ai.veeam.com>> "%HOSTS_FILE%"
echo 127.0.0.1 one.butler.veeam.com vbrad.butler.veeam.com vbr.butler.veeam.com>> "%HOSTS_FILE%"
echo 127.0.0.1 autolk.veeam.com avupdate.veeam.com dev.veeam.com>> "%HOSTS_FILE%"

echo Hosts file updated successfully.

:: ===============================
:: Set ServicesPipeTimeout to 60000
:: ===============================
reg add "HKLM\SYSTEM\CurrentControlSet\Control" ^
 /v ServicesPipeTimeout ^
 /t REG_DWORD ^
 /d 60000 ^
 /f
echo Set ServicesPipeTimeout updated successfully.

:: ===============================
:: Stop Veeam Services
:: ===============================
echo Stopping Veeam services and software ...
powershell -command "Stop-Service -Force -NoWait Veeam*"
taskkill /f /im Veeam*

:: ===============================
:: Patch DLLs
:: ===============================
echo Patching VeeamLicense.dll...

if exist "%ProgramW6432%\Common Files\Veeam\VeeamLicense.dll" (
    ren "%ProgramW6432%\Common Files\Veeam\VeeamLicense.dll" "VeeamLicense.dll.Original"
)
echo VeeamLicense.dll...

copy /Y "%~dp0Files\VeeamLicense.dll" "%ProgramW6432%\Common Files\Veeam\VeeamLicense.dll"
copy /Y "%~dp0Files\VeeamLicense.dll" "%ProgramW6432%\Common Files\Veeam\Backup and Replication\DBConfig\VeeamLicense.dll"
copy /Y "%~dp0Files\VeeamLicense.dll" "%ProgramW6432%\Veeam\Backup and Replication\Backup\VeeamLicense.dll"
copy /Y "%~dp0Files\VeeamLicense.dll" "%ProgramW6432%\Veeam\Backup and Replication\Backup\BackupClient\VeeamLicense.dll"
copy /Y "%~dp0Files\VeeamLicense.dll" "%ProgramW6432%\Veeam\Backup and Replication\Console\VeeamLicense.dll"

echo Veeam.Backup.LicenseLib.dll...

copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Common Files\Veeam\Backup and Replication\DBConfig\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Common Files\Veeam\Backup and Replication\Mount Service\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Veeam\Backup and Replication\Backup\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Veeam\Backup and Replication\Backup\BackupClient\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Veeam\Backup and Replication\Backup Catalog\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Veeam\Backup and Replication\Console\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Veeam\Backup and Replication\Threat Hunter\Veeam.Backup.LicenseLib.dll"
copy /Y "%~dp0Files\Veeam.Backup.LicenseLib.dll" "%ProgramW6432%\Veeam\Veeam Distribution Service\Veeam.Backup.LicenseLib.dll"

echo ClientUpdate.config...

copy /Y "%~dp0Files\ClientUpdate.config" "%ProgramW6432%\Veeam\Backup and Replication\Backup\ClientUpdate.config"
copy /Y "%~dp0Files\ClientUpdate.config" "%ProgramW6432%\Veeam\Backup and Replication\Backup\BackupClient\ClientUpdate.config"
copy /Y "%~dp0Files\ClientUpdate.config" "%ProgramW6432%\Veeam\Backup and Replication\Console\ClientUpdate.config"

echo ServerUpdate.config...

copy /Y "%~dp0Files\ServerUpdate.config" "%ProgramW6432%\Veeam\Backup and Replication\Backup\ServerUpdate.config"

:: ===============================
:: Start Veeam Services
:: ===============================
echo Starting Veeam services...
powershell -command "Start-Service Veeam*"

echo Veeam AutoPatch Done.
pause
exit /b